/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabCellRenderer;
import org.openide.awt.HtmlRenderer;

public final class WinClassicViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final boolean isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    private static final Color GTK_TABBED_PANE_BACKGROUND_1 = new Color(255, 255, 255);
    private static final int BUMP_X_PAD = isGenericUI ? 0 : 3;
    private static final int BUMP_WIDTH = isGenericUI ? 0 : 3;
    private static final int TXT_X_PAD = isGenericUI ? 3 : BUMP_X_PAD + BUMP_WIDTH + 5;
    private static final int TXT_Y_PAD = 3;
    private static final int ICON_X_PAD = 2;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinClassicViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinClassicViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 19 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 2;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ColorUtil.setupAntialiasing(graphics);
        Color color = jComponent.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paintOverallBorder(graphics, jComponent);
        super.paint(graphics, jComponent);
    }

    protected void paintOverallBorder(Graphics graphics, JComponent jComponent) {
        if (isGenericUI) {
            return;
        }
        Rectangle rectangle = jComponent.getBounds();
        graphics.setColor(UIManager.getColor("InternalFrame.borderDarkShadow"));
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    @Override
    protected Font getTxtFont() {
        Font font;
        if (isGenericUI && (font = UIManager.getFont("controlFont")) != null) {
            return font;
        }
        return super.getTxtFont();
    }

    @Override
    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        Object object;
        Object object2;
        --n5;
        n3 -= 2;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            Component component = this.getControlButtons();
            if (null != component) {
                object2 = component.getPreferredSize();
                if (n4 < ((Dimension)object2).width + 2) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                    n6 = n4 - (((Dimension)object2).width + 2 + TXT_X_PAD);
                    component.setLocation(n2 + n6 + TXT_X_PAD, n3 + (n5 - ((Dimension)object2).height) / 2 + 1);
                }
            }
        } else {
            n6 = n4 - 2 * TXT_X_PAD;
        }
        if (this.isUseStretchingTabs()) {
            this.drawBump(graphics, n, n2 + 4, n3 + 6, BUMP_WIDTH, n5 - 8);
        }
        boolean bl = false;
        object2 = this.displayer.getContainerWinsysInfo();
        if (null != object2 && ((WinsysInfoForTabbedContainer)object2).isSlidedOutContainer()) {
            bl = false;
        }
        if (this.isTabBusy(n) && !bl) {
            object = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(n));
            n6 -= object.getIconWidth() + 3 + TXT_X_PAD;
            object.paintIcon(this.displayer, graphics, n2 + TXT_X_PAD, n3 + (n5 - object.getIconHeight()) / 2 + 1);
            n2 += object.getIconWidth() + 3;
        }
        object = UIManager.getColor("TabbedPane.foreground");
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + TXT_X_PAD), (int)(n3 + fontMetrics.getAscent() + 3), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)object, (int)1, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        graphics.translate(n2, n3);
        graphics.setColor(UIManager.getColor("InternalFrame.borderShadow"));
        graphics.drawLine(0, --n5 - 1, n4 - 2, n5 - 1);
        graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 0);
        graphics.setColor(bl ? UIManager.getColor("InternalFrame.borderHighlight") : UIManager.getColor("InternalFrame.borderLight"));
        graphics.drawLine(0, 0, 0, n5 - 1);
        graphics.drawLine(1, 0, n4 - 2, 0);
        graphics.translate(-n2, -n3);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ((Graphics2D)graphics).setPaint(this.getBackgroundPaint(graphics, n, n2, n3, n4, --n5));
        if (this.isFocused(n)) {
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            graphics.fillRect(n2 + 1, n3 + 1, n4 - 2, n5 - 2);
        }
    }

    private Paint getBackgroundPaint(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        boolean bl2 = this.isFocused(n);
        boolean bl3 = this.isAttention(n);
        Paint paint = null;
        paint = bl2 && !bl3 ? ColorUtil.getGradientPaint(n2, n3, WinClassicViewTabDisplayerUI.getSelGradientColor(), n2 + n4, n3, WinClassicViewTabDisplayerUI.getSelGradientColor2()) : (bl && !bl3 ? UIManager.getColor("TabbedPane.background") : (bl3 ? WinClassicEditorTabCellRenderer.ATTENTION_COLOR : UIManager.getColor("tab_unsel_fill")));
        return paint;
    }

    private void drawBump(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color;
        Color color2;
        Color color3;
        if (isGenericUI) {
            return;
        }
        if (this.isFocused(n)) {
            color3 = new Color(210, 220, 243);
            color2 = color3.brighter();
            color = color3.darker();
        } else if (this.isSelected(n)) {
            color2 = UIManager.getColor("InternalFrame.borderHighlight");
            color3 = UIManager.getColor("InternalFrame.borderLight");
            color = UIManager.getColor("InternalFrame.borderShadow");
        } else {
            color2 = UIManager.getColor("InternalFrame.borderLight");
            color3 = UIManager.getColor("tab_unsel_fill");
            color = UIManager.getColor("InternalFrame.borderShadow");
        }
        int n6 = 0;
        while (n6 < n4 / 3) {
            graphics.setColor(color2);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 1);
            graphics.drawLine(n2, n3, n2 + 1, n3);
            graphics.setColor(color3);
            graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + n5 - 2);
            graphics.setColor(color);
            graphics.drawLine(n2 + 2, n3, n2 + 2, n3 + n5 - 1);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + 1, n3 + n5 - 1);
            ++n6;
            n2 += 3;
        }
    }

    private static Color getSelGradientColor() {
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            return GTK_TABBED_PANE_BACKGROUND_1;
        }
        return UIManager.getColor("winclassic_tab_sel_gradient");
    }

    private static Color getSelGradientColor2() {
        return UIManager.getColor("TabbedPane.background");
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[]{"org/openide/awt/resources/win_bigclose_enabled.png", "org/openide/awt/resources/win_bigclose_pressed.png", "org/openide/awt/resources/win_bigclose_disabled.png", "org/openide/awt/resources/win_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/win_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/win_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/win_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/win_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win_restore_group_enabled.png", "org/netbeans/swing/tabcontrol/resources/win_restore_group_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win_restore_group_rollover.png"};
            buttonIconPaths.put(11, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/win_minimize_enabled.png", "org/netbeans/swing/tabcontrol/resources/win_minimize_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/win_minimize_rollover.png"};
            buttonIconPaths.put(12, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        WinClassicViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }
}

