/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PluginStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PluginStats> {
    @Nonnull
    private final String classname;
    @Nullable
    private final String customFoldername;
    @Nonnull
    private final String description;
    @Nonnull
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;
    @Nonnull
    private final String javaVersion;
    @Nullable
    private final Boolean licensed;
    @Nonnull
    private final String name;
    @Nonnull
    private final String opensearchVersion;
    @Nonnull
    private final List<String> optionalExtendedPlugins;
    @Nonnull
    private final String version;
    public static final JsonpDeserializer<PluginStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PluginStats::setupPluginStatsDeserializer);

    private PluginStats(Builder builder) {
        this.classname = ApiTypeHelper.requireNonNull(builder.classname, this, "classname");
        this.customFoldername = builder.customFoldername;
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.extendedPlugins = ApiTypeHelper.unmodifiableRequired(builder.extendedPlugins, (Object)this, "extendedPlugins");
        this.hasNativeController = ApiTypeHelper.requireNonNull(builder.hasNativeController, this, "hasNativeController");
        this.javaVersion = ApiTypeHelper.requireNonNull(builder.javaVersion, this, "javaVersion");
        this.licensed = builder.licensed;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.opensearchVersion = ApiTypeHelper.requireNonNull(builder.opensearchVersion, this, "opensearchVersion");
        this.optionalExtendedPlugins = ApiTypeHelper.unmodifiable(builder.optionalExtendedPlugins);
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static PluginStats of(Function<Builder, ObjectBuilder<PluginStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String classname() {
        return this.classname;
    }

    @Nullable
    public final String customFoldername() {
        return this.customFoldername;
    }

    @Nonnull
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final List<String> extendedPlugins() {
        return this.extendedPlugins;
    }

    public final boolean hasNativeController() {
        return this.hasNativeController;
    }

    @Nonnull
    public final String javaVersion() {
        return this.javaVersion;
    }

    @Nullable
    public final Boolean licensed() {
        return this.licensed;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final String opensearchVersion() {
        return this.opensearchVersion;
    }

    @Nonnull
    public final List<String> optionalExtendedPlugins() {
        return this.optionalExtendedPlugins;
    }

    @Nonnull
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("classname");
        generator.write(this.classname);
        if (this.customFoldername != null) {
            generator.writeKey("custom_foldername");
            generator.write(this.customFoldername);
        }
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("extended_plugins");
        generator.writeStartArray();
        for (String item0 : this.extendedPlugins) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("has_native_controller");
        generator.write(this.hasNativeController);
        generator.writeKey("java_version");
        generator.write(this.javaVersion);
        if (this.licensed != null) {
            generator.writeKey("licensed");
            generator.write(this.licensed.booleanValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("opensearch_version");
        generator.write(this.opensearchVersion);
        if (ApiTypeHelper.isDefined(this.optionalExtendedPlugins)) {
            generator.writeKey("optional_extended_plugins");
            generator.writeStartArray();
            for (String item0 : this.optionalExtendedPlugins) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("version");
        generator.write(this.version);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPluginStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classname, JsonpDeserializer.stringDeserializer(), "classname");
        op.add(Builder::customFoldername, JsonpDeserializer.stringDeserializer(), "custom_foldername");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::extendedPlugins, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extended_plugins");
        op.add(Builder::hasNativeController, JsonpDeserializer.booleanDeserializer(), "has_native_controller");
        op.add(Builder::javaVersion, JsonpDeserializer.stringDeserializer(), "java_version");
        op.add(Builder::licensed, JsonpDeserializer.booleanDeserializer(), "licensed");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::opensearchVersion, JsonpDeserializer.stringDeserializer(), "opensearch_version");
        op.add(Builder::optionalExtendedPlugins, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "optional_extended_plugins");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.classname.hashCode();
        result = 31 * result + Objects.hashCode(this.customFoldername);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.extendedPlugins.hashCode();
        result = 31 * result + Boolean.hashCode(this.hasNativeController);
        result = 31 * result + this.javaVersion.hashCode();
        result = 31 * result + Objects.hashCode(this.licensed);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.opensearchVersion.hashCode();
        result = 31 * result + Objects.hashCode(this.optionalExtendedPlugins);
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginStats other = (PluginStats)o;
        return this.classname.equals(other.classname) && Objects.equals(this.customFoldername, other.customFoldername) && this.description.equals(other.description) && this.extendedPlugins.equals(other.extendedPlugins) && this.hasNativeController == other.hasNativeController && this.javaVersion.equals(other.javaVersion) && Objects.equals(this.licensed, other.licensed) && this.name.equals(other.name) && this.opensearchVersion.equals(other.opensearchVersion) && Objects.equals(this.optionalExtendedPlugins, other.optionalExtendedPlugins) && this.version.equals(other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PluginStats> {
        private String classname;
        @Nullable
        private String customFoldername;
        private String description;
        private List<String> extendedPlugins;
        private Boolean hasNativeController;
        private String javaVersion;
        @Nullable
        private Boolean licensed;
        private String name;
        private String opensearchVersion;
        @Nullable
        private List<String> optionalExtendedPlugins;
        private String version;

        public Builder() {
        }

        private Builder(PluginStats o) {
            this.classname = o.classname;
            this.customFoldername = o.customFoldername;
            this.description = o.description;
            this.extendedPlugins = Builder._listCopy(o.extendedPlugins);
            this.hasNativeController = o.hasNativeController;
            this.javaVersion = o.javaVersion;
            this.licensed = o.licensed;
            this.name = o.name;
            this.opensearchVersion = o.opensearchVersion;
            this.optionalExtendedPlugins = Builder._listCopy(o.optionalExtendedPlugins);
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.classname = o.classname;
            this.customFoldername = o.customFoldername;
            this.description = o.description;
            this.extendedPlugins = Builder._listCopy(o.extendedPlugins);
            this.hasNativeController = o.hasNativeController;
            this.javaVersion = o.javaVersion;
            this.licensed = o.licensed;
            this.name = o.name;
            this.opensearchVersion = o.opensearchVersion;
            this.optionalExtendedPlugins = Builder._listCopy(o.optionalExtendedPlugins);
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder classname(String value) {
            this.classname = value;
            return this;
        }

        @Nonnull
        public final Builder customFoldername(@Nullable String value) {
            this.customFoldername = value;
            return this;
        }

        @Nonnull
        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder extendedPlugins(List<String> list) {
            this.extendedPlugins = Builder._listAddAll(this.extendedPlugins, list);
            return this;
        }

        @Nonnull
        public final Builder extendedPlugins(String value, String ... values) {
            this.extendedPlugins = Builder._listAdd(this.extendedPlugins, value, values);
            return this;
        }

        @Nonnull
        public final Builder hasNativeController(boolean value) {
            this.hasNativeController = value;
            return this;
        }

        @Nonnull
        public final Builder javaVersion(String value) {
            this.javaVersion = value;
            return this;
        }

        @Nonnull
        public final Builder licensed(@Nullable Boolean value) {
            this.licensed = value;
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder opensearchVersion(String value) {
            this.opensearchVersion = value;
            return this;
        }

        @Nonnull
        public final Builder optionalExtendedPlugins(List<String> list) {
            this.optionalExtendedPlugins = Builder._listAddAll(this.optionalExtendedPlugins, list);
            return this;
        }

        @Nonnull
        public final Builder optionalExtendedPlugins(String value, String ... values) {
            this.optionalExtendedPlugins = Builder._listAdd(this.optionalExtendedPlugins, value, values);
            return this;
        }

        @Nonnull
        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public PluginStats build() {
            this._checkSingleUse();
            return new PluginStats(this);
        }
    }
}

