/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CompressBatch;
import com.zeroc.Ice.ConnectionClose;
import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectAdapterI;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.SocketException;
import com.zeroc.Ice.SyscallException;
import com.zeroc.IceInternal.Acceptor;
import com.zeroc.IceInternal.CommunicatorFlushBatch;
import com.zeroc.IceInternal.DefaultsAndOverrides;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.EventHandler;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.FactoryACMMonitor;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.ThreadPoolCurrent;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceUtilInternal.Assert;
import java.nio.channels.SelectableChannel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class IncomingConnectionFactory
extends EventHandler
implements ConnectionI.StartCallback {
    private static final int StateActive = 0;
    private static final int StateHolding = 1;
    private static final int StateClosed = 2;
    private static final int StateFinished = 3;
    private final Instance _instance;
    private final FactoryACMMonitor _monitor;
    private Acceptor _acceptor;
    private Transceiver _transceiver;
    private EndpointI _endpoint;
    private final EndpointI _publishedEndpoint;
    private ObjectAdapterI _adapter;
    private final boolean _warn;
    private Set<ConnectionI> _connections = new HashSet<ConnectionI>();
    private int _state;
    private boolean _acceptorStarted;

    public synchronized void startAcceptor() {
        if (this._state >= 2 || this._acceptorStarted) {
            return;
        }
        try {
            this.createAcceptor();
        }
        catch (Exception ex) {
            String s = "acceptor creation failed:\n" + ex.getCause().getMessage() + '\n' + this._acceptor.toString();
            this._instance.initializationData().logger.error(s);
            this._instance.timer().schedule(() -> this.startAcceptor(), 1L, TimeUnit.SECONDS);
        }
    }

    public synchronized void activate() {
        this.setState(0);
    }

    public synchronized void hold() {
        this.setState(1);
    }

    public synchronized void destroy() {
        this.setState(2);
    }

    public synchronized void updateConnectionObservers() {
        for (ConnectionI connection : this._connections) {
            connection.updateObserver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHolding() throws InterruptedException {
        LinkedList<ConnectionI> connections;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state < 1) {
                this.wait();
            }
            connections = new LinkedList<ConnectionI>(this._connections);
        }
        for (ConnectionI connection : connections) {
            connection.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() throws InterruptedException {
        LinkedList<ConnectionI> connections = null;
        Object object = this;
        synchronized (object) {
            while (this._state != 3) {
                this.wait();
            }
            this._adapter = null;
            connections = new LinkedList<ConnectionI>(this._connections);
        }
        if (connections != null) {
            for (ConnectionI connection : connections) {
                try {
                    connection.waitUntilFinished();
                }
                catch (InterruptedException e) {
                    for (ConnectionI c : connections) {
                        c.close(ConnectionClose.Forcefully);
                    }
                    throw e;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this._transceiver != null) {
                assert (this._connections.size() <= 1);
            } else {
                List<ConnectionI> cons = this._monitor.swapReapedConnections();
                assert ((cons == null ? 0 : cons.size()) == this._connections.size());
                if (cons != null) {
                    cons.clear();
                }
            }
            this._connections.clear();
        }
        this._monitor.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(EndpointI endpoint) {
        if (this._publishedEndpoint != null && endpoint.equivalent(this._publishedEndpoint)) {
            return true;
        }
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            return endpoint.equivalent(this._endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI endpoint() {
        if (this._publishedEndpoint != null) {
            return this._publishedEndpoint;
        }
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            return this._endpoint;
        }
    }

    public synchronized LinkedList<ConnectionI> connections() {
        LinkedList<ConnectionI> connections = new LinkedList<ConnectionI>();
        for (ConnectionI connection : this._connections) {
            if (!connection.isActiveOrHolding()) continue;
            connections.add(connection);
        }
        return connections;
    }

    public void flushAsyncBatchRequests(CompressBatch compressBatch, CommunicatorFlushBatch outAsync) {
        for (ConnectionI c : this.connections()) {
            try {
                outAsync.flushConnection(c, compressBatch);
            }
            catch (LocalException localException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent current) {
        ConnectionI connection = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            if (this._state >= 2) {
                return;
            }
            if (this._state == 1) {
                Thread.yield();
                return;
            }
            List<ConnectionI> cons = this._monitor.swapReapedConnections();
            if (cons != null) {
                for (ConnectionI c : cons) {
                    this._connections.remove(c);
                }
            }
            if (!this._acceptorStarted) {
                return;
            }
            Transceiver transceiver = null;
            try {
                transceiver = this._acceptor.accept();
                if (this._instance.traceLevels().network >= 2) {
                    StringBuffer s = new StringBuffer("trying to accept ");
                    s.append(this._endpoint.protocol());
                    s.append(" connection\n");
                    s.append(transceiver.toString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                }
            }
            catch (SocketException ex) {
                if (Network.noMoreFds(ex.getCause())) {
                    try {
                        String s = "can't accept more connections:\n" + ex.getCause().getMessage();
                        s = s + '\n' + this._acceptor.toString();
                        try {
                            this._instance.initializationData().logger.error(s);
                        }
                        catch (Throwable ex1) {
                            System.out.println(s);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    assert (this._acceptorStarted);
                    this._acceptorStarted = false;
                    if (this._adapter.getThreadPool().finish(this, true)) {
                        this.closeAcceptor();
                    }
                }
                return;
            }
            catch (LocalException ex) {
                if (this._warn) {
                    this.warning(ex);
                }
                return;
            }
            assert (transceiver != null);
            try {
                connection = new ConnectionI(this._adapter.getCommunicator(), this._instance, this._monitor, transceiver, null, this._endpoint, this._adapter);
            }
            catch (LocalException ex) {
                try {
                    transceiver.close();
                }
                catch (LocalException localException) {
                    // empty catch block
                }
                if (this._warn) {
                    this.warning(ex);
                }
                return;
            }
            this._connections.add(connection);
        }
        assert (connection != null);
        connection.start(this);
    }

    @Override
    public synchronized void finished(ThreadPoolCurrent current, boolean close) {
        if (this._state < 2) {
            if (close) {
                this.closeAcceptor();
            }
            this._instance.timer().schedule(() -> this.startAcceptor(), 1L, TimeUnit.SECONDS);
            return;
        }
        assert (this._state >= 2);
        this.setState(3);
        if (close) {
            this.closeAcceptor();
        }
    }

    @Override
    public synchronized String toString() {
        if (this._transceiver != null) {
            return this._transceiver.toString();
        }
        return this._acceptor.toString();
    }

    @Override
    public SelectableChannel fd() {
        assert (this._acceptor != null);
        return this._acceptor.fd();
    }

    @Override
    public void setReadyCallback(ReadyCallback readyCallback) {
        if (this._acceptor != null) {
            this._acceptor.setReadyCallback(readyCallback);
        }
    }

    @Override
    public synchronized void connectionStartCompleted(ConnectionI connection) {
        if (this._state == 0) {
            connection.activate();
        }
    }

    @Override
    public synchronized void connectionStartFailed(ConnectionI connection, LocalException ex) {
        if (this._state >= 2) {
            return;
        }
    }

    public IncomingConnectionFactory(Instance instance, EndpointI endpoint, EndpointI publish, ObjectAdapterI adapter) {
        this._instance = instance;
        this._endpoint = endpoint;
        this._publishedEndpoint = publish;
        this._adapter = adapter;
        this._warn = this._instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._state = 1;
        this._acceptorStarted = false;
        this._monitor = new FactoryACMMonitor(instance, adapter.getACM());
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        if (defaultsAndOverrides.overrideTimeout) {
            this._endpoint = this._endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
        }
        if (defaultsAndOverrides.overrideCompress) {
            this._endpoint = this._endpoint.compress(defaultsAndOverrides.overrideCompressValue);
        }
        try {
            this._transceiver = this._endpoint.transceiver();
            if (this._transceiver != null) {
                if (this._instance.traceLevels().network >= 2) {
                    StringBuffer s = new StringBuffer("attempting to bind to ");
                    s.append(this._endpoint.protocol());
                    s.append(" socket\n");
                    s.append(this._transceiver.toString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                }
                this._endpoint = this._transceiver.bind();
                ConnectionI connection = new ConnectionI(this._adapter.getCommunicator(), this._instance, null, this._transceiver, null, this._endpoint, this._adapter);
                connection.startAndWait();
                this._connections.add(connection);
            } else {
                this.createAcceptor();
            }
        }
        catch (Exception ex) {
            if (this._transceiver != null) {
                try {
                    this._transceiver.close();
                }
                catch (LocalException localException) {
                    // empty catch block
                }
            }
            this._state = 3;
            this._monitor.destroy();
            this._connections.clear();
            if (ex instanceof LocalException) {
                throw (LocalException)ex;
            }
            if (ex instanceof InterruptedException) {
                throw new OperationInterruptedException();
            }
            throw new SyscallException(ex);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._state == 3);
            Assert.FinalizerAssert(this._connections.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private void setState(int state) {
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                if (this._acceptor != null) {
                    if (this._instance.traceLevels().network >= 1) {
                        StringBuffer s = new StringBuffer("accepting ");
                        s.append(this._endpoint.protocol());
                        s.append(" connections at ");
                        s.append(this._acceptor.toString());
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                    }
                    this._adapter.getThreadPool().register(this, 1);
                }
                for (ConnectionI connection : this._connections) {
                    connection.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                if (this._acceptor != null) {
                    if (this._instance.traceLevels().network >= 1) {
                        StringBuffer s = new StringBuffer("holding ");
                        s.append(this._endpoint.protocol());
                        s.append(" connections at ");
                        s.append(this._acceptor.toString());
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
                    }
                    this._adapter.getThreadPool().unregister(this, 1);
                }
                for (ConnectionI connection : this._connections) {
                    connection.hold();
                }
                break;
            }
            case 2: {
                if (this._acceptorStarted) {
                    this._acceptorStarted = false;
                    if (this._adapter.getThreadPool().finish(this, true)) {
                        this.closeAcceptor();
                    }
                } else {
                    state = 3;
                }
                for (ConnectionI connection : this._connections) {
                    connection.destroy(0);
                }
                break;
            }
            case 3: {
                assert (this._state == 2);
                break;
            }
        }
        this._state = state;
        this.notifyAll();
    }

    private void createAcceptor() {
        try {
            StringBuffer s;
            assert (!this._acceptorStarted);
            this._acceptor = this._endpoint.acceptor(this._adapter.getName());
            assert (this._acceptor != null);
            if (this._instance.traceLevels().network >= 2) {
                s = new StringBuffer("attempting to bind to ");
                s.append(this._endpoint.protocol());
                s.append(" socket ");
                s.append(this._acceptor.toString());
                this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
            }
            this._endpoint = this._acceptor.listen();
            if (this._instance.traceLevels().network >= 1) {
                s = new StringBuffer("listening for ");
                s.append(this._endpoint.protocol());
                s.append(" connections\n");
                s.append(this._acceptor.toDetailedString());
                this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
            }
            this._adapter.getThreadPool().initialize(this);
            if (this._state == 0) {
                this._adapter.getThreadPool().register(this, 1);
            }
            this._acceptorStarted = true;
        }
        catch (Exception ex) {
            if (this._acceptor != null) {
                this._acceptor.close();
            }
            throw ex;
        }
    }

    private void closeAcceptor() {
        assert (this._acceptor != null);
        if (this._instance.traceLevels().network >= 1) {
            StringBuffer s = new StringBuffer("stopping to accept ");
            s.append(this._endpoint.protocol());
            s.append(" connections at ");
            s.append(this._acceptor.toString());
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
        }
        assert (!this._acceptorStarted);
        this._acceptor.close();
    }

    private void warning(LocalException ex) {
        String s = "connection exception:\n" + Ex.toString(ex) + '\n' + this._acceptor.toString();
        this._instance.initializationData().logger.warning(s);
    }
}

