# The PEP 484 type hints stub file for the QtCharts module.
#
# Generated by SIP 6.15.1
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-Charts.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui
from PyQt6 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QAbstractAxis(QtCore.QObject):

    class AxisType(enum.Flag):
        AxisTypeNoAxis = ... # type: QAbstractAxis.AxisType
        AxisTypeValue = ... # type: QAbstractAxis.AxisType
        AxisTypeBarCategory = ... # type: QAbstractAxis.AxisType
        AxisTypeCategory = ... # type: QAbstractAxis.AxisType
        AxisTypeDateTime = ... # type: QAbstractAxis.AxisType
        AxisTypeLogValue = ... # type: QAbstractAxis.AxisType
        AxisTypeColor = ... # type: QAbstractAxis.AxisType

    truncateLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsTruncatedChanged: typing.ClassVar[QtCore.pyqtSignal]
    def truncateLabels(self) -> bool: ...
    def setTruncateLabels(self, truncateLabels: bool = ...) -> None: ...
    def labelsTruncated(self) -> bool: ...
    labelsEditableChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelsEditable(self) -> bool: ...
    def setLabelsEditable(self, editable: bool = ...) -> None: ...
    reverseChanged: typing.ClassVar[QtCore.pyqtSignal]
    minorGridLineColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridLineColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    minorGridLinePenChanged: typing.ClassVar[QtCore.pyqtSignal]
    minorGridVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isReverse(self) -> bool: ...
    def setReverse(self, reverse: bool = ...) -> None: ...
    def minorGridLineColor(self) -> QtGui.QColor: ...
    def setMinorGridLineColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def gridLineColor(self) -> QtGui.QColor: ...
    def setGridLineColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def minorGridLinePen(self) -> QtGui.QPen: ...
    def setMinorGridLinePen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setMinorGridLineVisible(self, visible: bool = ...) -> None: ...
    def isMinorGridLineVisible(self) -> bool: ...
    shadesBrushChanged: typing.ClassVar[QtCore.pyqtSignal]
    shadesPenChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleBrushChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleTextChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridLinePenChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsBrushChanged: typing.ClassVar[QtCore.pyqtSignal]
    linePenChanged: typing.ClassVar[QtCore.pyqtSignal]
    def alignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def titleText(self) -> str: ...
    def setTitleText(self, title: str|None) -> None: ...
    def titleFont(self) -> QtGui.QFont: ...
    def setTitleFont(self, font: QtGui.QFont) -> None: ...
    def titleBrush(self) -> QtGui.QBrush: ...
    def setTitleBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def setTitleVisible(self, visible: bool = ...) -> None: ...
    def isTitleVisible(self) -> bool: ...
    shadesBorderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    shadesColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    shadesVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    lineVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def setRange(self, min: typing.Any, max: typing.Any) -> None: ...
    def setMax(self, max: typing.Any) -> None: ...
    def setMin(self, min: typing.Any) -> None: ...
    def shadesBorderColor(self) -> QtGui.QColor: ...
    def setShadesBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def shadesColor(self) -> QtGui.QColor: ...
    def setShadesColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def shadesBrush(self) -> QtGui.QBrush: ...
    def setShadesBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def shadesPen(self) -> QtGui.QPen: ...
    def setShadesPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setShadesVisible(self, visible: bool = ...) -> None: ...
    def shadesVisible(self) -> bool: ...
    def labelsColor(self) -> QtGui.QColor: ...
    def setLabelsColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelsAngle(self) -> int: ...
    def setLabelsAngle(self, angle: int) -> None: ...
    def labelsFont(self) -> QtGui.QFont: ...
    def setLabelsFont(self, font: QtGui.QFont) -> None: ...
    def labelsBrush(self) -> QtGui.QBrush: ...
    def setLabelsBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def setLabelsVisible(self, visible: bool = ...) -> None: ...
    def labelsVisible(self) -> bool: ...
    def gridLinePen(self) -> QtGui.QPen: ...
    def setGridLinePen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setGridLineVisible(self, visible: bool = ...) -> None: ...
    def isGridLineVisible(self) -> bool: ...
    def linePenColor(self) -> QtGui.QColor: ...
    def setLinePenColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def linePen(self) -> QtGui.QPen: ...
    def setLinePen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setLineVisible(self, visible: bool = ...) -> None: ...
    def isLineVisible(self) -> bool: ...
    def setVisible(self, visible: bool = ...) -> None: ...
    def isVisible(self) -> bool: ...
    def type(self) -> 'QAbstractAxis.AxisType': ...


class QAbstractSeries(QtCore.QObject):

    class SeriesType(enum.Enum):
        SeriesTypeLine = ... # type: QAbstractSeries.SeriesType
        SeriesTypeArea = ... # type: QAbstractSeries.SeriesType
        SeriesTypeBar = ... # type: QAbstractSeries.SeriesType
        SeriesTypeStackedBar = ... # type: QAbstractSeries.SeriesType
        SeriesTypePercentBar = ... # type: QAbstractSeries.SeriesType
        SeriesTypePie = ... # type: QAbstractSeries.SeriesType
        SeriesTypeScatter = ... # type: QAbstractSeries.SeriesType
        SeriesTypeSpline = ... # type: QAbstractSeries.SeriesType
        SeriesTypeHorizontalBar = ... # type: QAbstractSeries.SeriesType
        SeriesTypeHorizontalStackedBar = ... # type: QAbstractSeries.SeriesType
        SeriesTypeHorizontalPercentBar = ... # type: QAbstractSeries.SeriesType
        SeriesTypeBoxPlot = ... # type: QAbstractSeries.SeriesType
        SeriesTypeCandlestick = ... # type: QAbstractSeries.SeriesType

    useOpenGLChanged: typing.ClassVar[QtCore.pyqtSignal]
    def useOpenGL(self) -> bool: ...
    def setUseOpenGL(self, enable: bool = ...) -> None: ...
    opacityChanged: typing.ClassVar[QtCore.pyqtSignal]
    def attachedAxes(self) -> list[QAbstractAxis]: ...
    def detachAxis(self, axis: QAbstractAxis|None) -> bool: ...
    def attachAxis(self, axis: QAbstractAxis|None) -> bool: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacity(self) -> float: ...
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def chart(self) -> 'QChart|None': ...
    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool = ...) -> None: ...
    def name(self) -> str: ...
    def setName(self, name: str|None) -> None: ...
    def type(self) -> 'QAbstractSeries.SeriesType': ...


class QAbstractBarSeries(QAbstractSeries):

    class LabelsPosition(enum.Enum):
        LabelsCenter = ... # type: QAbstractBarSeries.LabelsPosition
        LabelsInsideEnd = ... # type: QAbstractBarSeries.LabelsPosition
        LabelsInsideBase = ... # type: QAbstractBarSeries.LabelsPosition
        LabelsOutsideEnd = ... # type: QAbstractBarSeries.LabelsPosition

    labelsPrecisionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelsPrecision(self) -> int: ...
    def setLabelsPrecision(self, precision: int) -> None: ...
    labelsAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelsAngle(self) -> float: ...
    def setLabelsAngle(self, angle: float) -> None: ...
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    labelsPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelsPosition(self) -> 'QAbstractBarSeries.LabelsPosition': ...
    def setLabelsPosition(self, position: 'QAbstractBarSeries.LabelsPosition') -> None: ...
    def labelsFormat(self) -> str: ...
    def setLabelsFormat(self, format: str|None) -> None: ...
    barsetsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    barsetsAdded: typing.ClassVar[QtCore.pyqtSignal]
    labelsVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    def take(self, set: 'QBarSet|None') -> bool: ...
    def isLabelsVisible(self) -> bool: ...
    def setLabelsVisible(self, visible: bool = ...) -> None: ...
    def clear(self) -> None: ...
    def barSets(self) -> list['QBarSet']: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def insert(self, index: int, set: 'QBarSet|None') -> bool: ...
    def remove(self, set: 'QBarSet|None') -> bool: ...
    @typing.overload
    def append(self, set: 'QBarSet|None') -> bool: ...
    @typing.overload
    def append(self, sets: collections.abc.Iterable['QBarSet']) -> bool: ...
    def barWidth(self) -> float: ...
    def setBarWidth(self, width: float) -> None: ...


class QLegendMarker(QtCore.QObject):

    class LegendMarkerType(enum.Enum):
        LegendMarkerTypeArea = ... # type: QLegendMarker.LegendMarkerType
        LegendMarkerTypeBar = ... # type: QLegendMarker.LegendMarkerType
        LegendMarkerTypePie = ... # type: QLegendMarker.LegendMarkerType
        LegendMarkerTypeXY = ... # type: QLegendMarker.LegendMarkerType
        LegendMarkerTypeBoxPlot = ... # type: QLegendMarker.LegendMarkerType
        LegendMarkerTypeCandlestick = ... # type: QLegendMarker.LegendMarkerType

    shapeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setShape(self, shape: 'QLegend.MarkerShape') -> None: ...
    def shape(self) -> 'QLegend.MarkerShape': ...
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    brushChanged: typing.ClassVar[QtCore.pyqtSignal]
    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    fontChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBrushChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelChanged: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    def series(self) -> QAbstractSeries|None: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setLabelBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def labelBrush(self) -> QtGui.QBrush: ...
    def setLabel(self, label: str|None) -> None: ...
    def label(self) -> str: ...
    def type(self) -> 'QLegendMarker.LegendMarkerType': ...


class QAreaLegendMarker(QLegendMarker):

    def __init__(self, series: 'QAreaSeries|None', legend: 'QLegend|None', parent: QtCore.QObject|None = ...) -> None: ...

    def series(self) -> 'QAreaSeries|None': ...
    def type(self) -> QLegendMarker.LegendMarkerType: ...


class QAreaSeries(QAbstractSeries):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, upperSeries: 'QLineSeries|None', lowerSeries: 'QLineSeries|None' = ...) -> None: ...

    pointLabelsClippingChanged: typing.ClassVar[QtCore.pyqtSignal]
    def pointLabelsClipping(self) -> bool: ...
    def setPointLabelsClipping(self, enable: bool = ...) -> None: ...
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def pointLabelsColor(self) -> QtGui.QColor: ...
    def setPointLabelsColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def pointLabelsFont(self) -> QtGui.QFont: ...
    def setPointLabelsFont(self, font: QtGui.QFont) -> None: ...
    def pointLabelsVisible(self) -> bool: ...
    def setPointLabelsVisible(self, visible: bool = ...) -> None: ...
    def pointLabelsFormat(self) -> str: ...
    def setPointLabelsFormat(self, format: str|None) -> None: ...
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    selected: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def borderColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def pointsVisible(self) -> bool: ...
    def setPointsVisible(self, visible: bool = ...) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def lowerSeries(self) -> 'QLineSeries|None': ...
    def setLowerSeries(self, series: 'QLineSeries|None') -> None: ...
    def upperSeries(self) -> 'QLineSeries|None': ...
    def setUpperSeries(self, series: 'QLineSeries|None') -> None: ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QBarCategoryAxis(QAbstractAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    categoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRange(self, minCategory: str|None, maxCategory: str|None) -> None: ...
    def max(self) -> str: ...
    def setMax(self, maxCategory: str|None) -> None: ...
    def min(self) -> str: ...
    def setMin(self, minCategory: str|None) -> None: ...
    def at(self, index: int) -> str: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def categories(self) -> list[str]: ...
    def setCategories(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    def clear(self) -> None: ...
    def replace(self, oldCategory: str|None, newCategory: str|None) -> None: ...
    def insert(self, index: int, category: str|None) -> None: ...
    def remove(self, category: str|None) -> None: ...
    @typing.overload
    def append(self, categories: collections.abc.Iterable[str|None]) -> None: ...
    @typing.overload
    def append(self, category: str|None) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QBarLegendMarker(QLegendMarker):

    def __init__(self, series: QAbstractBarSeries|None, barset: 'QBarSet|None', legend: 'QLegend|None', parent: QtCore.QObject|None = ...) -> None: ...

    def barset(self) -> 'QBarSet|None': ...
    def series(self) -> QAbstractBarSeries|None: ...
    def type(self) -> QLegendMarker.LegendMarkerType: ...


class QBarSeries(QAbstractBarSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QBarSet(QtCore.QObject):

    def __init__(self, name: str|None, parent: QtCore.QObject|None = ...) -> None: ...

    selectedBarsChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def selectedBars(self) -> list[int]: ...
    def toggleSelection(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectBars(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def selectBars(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectAllBars(self) -> None: ...
    def selectAllBars(self) -> None: ...
    def setBarSelected(self, index: int, selected: bool) -> None: ...
    def deselectBar(self, index: int) -> None: ...
    def selectBar(self, index: int) -> None: ...
    def isBarSelected(self, index: int) -> bool: ...
    def setSelectedColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def selectedColor(self) -> QtGui.QColor: ...
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    labelColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesRemoved: typing.ClassVar[QtCore.pyqtSignal]
    valuesAdded: typing.ClassVar[QtCore.pyqtSignal]
    labelFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBrushChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelChanged: typing.ClassVar[QtCore.pyqtSignal]
    brushChanged: typing.ClassVar[QtCore.pyqtSignal]
    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setLabelColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def __getitem__(self, index: int) -> float: ...
    def at(self, index: int) -> float: ...
    def remove(self, index: int, count: int = ...) -> None: ...
    def label(self) -> str: ...
    def setLabel(self, label: str|None) -> None: ...
    def labelFont(self) -> QtGui.QFont: ...
    def setLabelFont(self, font: QtGui.QFont) -> None: ...
    def labelBrush(self) -> QtGui.QBrush: ...
    def setLabelBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def sum(self) -> float: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def replace(self, index: int, value: float) -> None: ...
    def insert(self, index: int, value: float) -> None: ...
    def __lshift__(self, value: float) -> 'QBarSet': ...
    @typing.overload
    def append(self, values: collections.abc.Iterable[float]) -> None: ...
    @typing.overload
    def append(self, value: float) -> None: ...


class QBoxPlotLegendMarker(QLegendMarker):

    def __init__(self, series: 'QBoxPlotSeries|None', legend: 'QLegend|None', parent: QtCore.QObject|None = ...) -> None: ...

    def series(self) -> 'QBoxPlotSeries|None': ...
    def type(self) -> QLegendMarker.LegendMarkerType: ...


class QBoxPlotSeries(QAbstractSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    boxsetsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    boxsetsAdded: typing.ClassVar[QtCore.pyqtSignal]
    boxWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    boxOutlineVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    brushChanged: typing.ClassVar[QtCore.pyqtSignal]
    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def boxWidth(self) -> float: ...
    def setBoxWidth(self, width: float) -> None: ...
    def boxOutlineVisible(self) -> bool: ...
    def setBoxOutlineVisible(self, visible: bool) -> None: ...
    def type(self) -> QAbstractSeries.SeriesType: ...
    def clear(self) -> None: ...
    def boxSets(self) -> list['QBoxSet']: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def insert(self, index: int, box: 'QBoxSet|None') -> bool: ...
    def take(self, box: 'QBoxSet|None') -> bool: ...
    def remove(self, box: 'QBoxSet|None') -> bool: ...
    @typing.overload
    def append(self, box: 'QBoxSet|None') -> bool: ...
    @typing.overload
    def append(self, boxes: collections.abc.Iterable['QBoxSet']) -> bool: ...


class QBoxSet(QtCore.QObject):

    class ValuePositions(enum.IntEnum):
        LowerExtreme = ... # type: QBoxSet.ValuePositions
        LowerQuartile = ... # type: QBoxSet.ValuePositions
        Median = ... # type: QBoxSet.ValuePositions
        UpperQuartile = ... # type: QBoxSet.ValuePositions
        UpperExtreme = ... # type: QBoxSet.ValuePositions

    @typing.overload
    def __init__(self, label: str|None = ..., parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, le: float, lq: float, m: float, uq: float, ue: float, label: str|None = ..., parent: QtCore.QObject|None = ...) -> None: ...

    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    cleared: typing.ClassVar[QtCore.pyqtSignal]
    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesChanged: typing.ClassVar[QtCore.pyqtSignal]
    brushChanged: typing.ClassVar[QtCore.pyqtSignal]
    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def __getitem__(self, index: int) -> float: ...
    def at(self, index: int) -> float: ...
    def setValue(self, index: int, value: float) -> None: ...
    def __lshift__(self, value: float) -> 'QBoxSet': ...
    def label(self) -> str: ...
    def setLabel(self, label: str|None) -> None: ...
    def clear(self) -> None: ...
    @typing.overload
    def append(self, value: float) -> None: ...
    @typing.overload
    def append(self, values: collections.abc.Iterable[float]) -> None: ...


class QCandlestickLegendMarker(QLegendMarker):

    def __init__(self, series: 'QCandlestickSeries|None', legend: 'QLegend|None', parent: QtCore.QObject|None = ...) -> None: ...

    def series(self) -> 'QCandlestickSeries|None': ...
    def type(self) -> QLegendMarker.LegendMarkerType: ...


class QCandlestickModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def lastSetSection(self) -> int: ...
    def setLastSetSection(self, lastSetSection: int) -> None: ...
    def firstSetSection(self) -> int: ...
    def setFirstSetSection(self, firstSetSection: int) -> None: ...
    def close(self) -> int: ...
    def setClose(self, close: int) -> None: ...
    def low(self) -> int: ...
    def setLow(self, low: int) -> None: ...
    def high(self) -> int: ...
    def setHigh(self, high: int) -> None: ...
    def open(self) -> int: ...
    def setOpen(self, open: int) -> None: ...
    def timestamp(self) -> int: ...
    def setTimestamp(self, timestamp: int) -> None: ...
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def series(self) -> 'QCandlestickSeries|None': ...
    def setSeries(self, series: 'QCandlestickSeries|None') -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...


class QCandlestickSeries(QAbstractSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    brushChanged: typing.ClassVar[QtCore.pyqtSignal]
    decreasingColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    increasingColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    capsVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    capsWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    bodyOutlineVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    bodyWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    minimumColumnWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    maximumColumnWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    candlestickSetsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    candlestickSetsAdded: typing.ClassVar[QtCore.pyqtSignal]
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def decreasingColor(self) -> QtGui.QColor: ...
    def setDecreasingColor(self, decreasingColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def increasingColor(self) -> QtGui.QColor: ...
    def setIncreasingColor(self, increasingColor: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def capsVisible(self) -> bool: ...
    def setCapsVisible(self, capsVisible: bool) -> None: ...
    def capsWidth(self) -> float: ...
    def setCapsWidth(self, capsWidth: float) -> None: ...
    def bodyOutlineVisible(self) -> bool: ...
    def setBodyOutlineVisible(self, bodyOutlineVisible: bool) -> None: ...
    def bodyWidth(self) -> float: ...
    def setBodyWidth(self, bodyWidth: float) -> None: ...
    def minimumColumnWidth(self) -> float: ...
    def setMinimumColumnWidth(self, minimumColumnWidth: float) -> None: ...
    def maximumColumnWidth(self) -> float: ...
    def setMaximumColumnWidth(self, maximumColumnWidth: float) -> None: ...
    def type(self) -> QAbstractSeries.SeriesType: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def sets(self) -> list['QCandlestickSet']: ...
    def clear(self) -> None: ...
    def take(self, set: 'QCandlestickSet|None') -> bool: ...
    def insert(self, index: int, set: 'QCandlestickSet|None') -> bool: ...
    @typing.overload
    def remove(self, set: 'QCandlestickSet|None') -> bool: ...
    @typing.overload
    def remove(self, sets: collections.abc.Iterable['QCandlestickSet']) -> bool: ...
    @typing.overload
    def append(self, set: 'QCandlestickSet|None') -> bool: ...
    @typing.overload
    def append(self, sets: collections.abc.Iterable['QCandlestickSet']) -> bool: ...


class QCandlestickSet(QtCore.QObject):

    @typing.overload
    def __init__(self, timestamp: float = ..., parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, open: float, high: float, low: float, close: float, timestamp: float = ..., parent: QtCore.QObject|None = ...) -> None: ...

    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    brushChanged: typing.ClassVar[QtCore.pyqtSignal]
    closeChanged: typing.ClassVar[QtCore.pyqtSignal]
    lowChanged: typing.ClassVar[QtCore.pyqtSignal]
    highChanged: typing.ClassVar[QtCore.pyqtSignal]
    openChanged: typing.ClassVar[QtCore.pyqtSignal]
    timestampChanged: typing.ClassVar[QtCore.pyqtSignal]
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def close(self) -> float: ...
    def setClose(self, close: float) -> None: ...
    def low(self) -> float: ...
    def setLow(self, low: float) -> None: ...
    def high(self) -> float: ...
    def setHigh(self, high: float) -> None: ...
    def open(self) -> float: ...
    def setOpen(self, open: float) -> None: ...
    def timestamp(self) -> float: ...
    def setTimestamp(self, timestamp: float) -> None: ...


class QValueAxis(QAbstractAxis):

    class TickType(enum.Enum):
        TicksDynamic = ... # type: QValueAxis.TickType
        TicksFixed = ... # type: QValueAxis.TickType

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    tickTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    tickAnchorChanged: typing.ClassVar[QtCore.pyqtSignal]
    tickIntervalChanged: typing.ClassVar[QtCore.pyqtSignal]
    def tickType(self) -> 'QValueAxis.TickType': ...
    def setTickType(self, type: 'QValueAxis.TickType') -> None: ...
    def tickInterval(self) -> float: ...
    def setTickInterval(self, insterval: float) -> None: ...
    def tickAnchor(self) -> float: ...
    def setTickAnchor(self, anchor: float) -> None: ...
    minorTickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def minorTickCount(self) -> int: ...
    def setMinorTickCount(self, count: int) -> None: ...
    labelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    tickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    def applyNiceNumbers(self) -> None: ...
    def labelFormat(self) -> str: ...
    def setLabelFormat(self, format: str|None) -> None: ...
    def tickCount(self) -> int: ...
    def setTickCount(self, count: int) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def max(self) -> float: ...
    def setMax(self, max: float) -> None: ...
    def min(self) -> float: ...
    def setMin(self, min: float) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QCategoryAxis(QValueAxis):

    class AxisLabelsPosition(enum.Enum):
        AxisLabelsPositionCenter = ... # type: QCategoryAxis.AxisLabelsPosition
        AxisLabelsPositionOnValue = ... # type: QCategoryAxis.AxisLabelsPosition

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    labelsPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setLabelsPosition(self, position: 'QCategoryAxis.AxisLabelsPosition') -> None: ...
    def labelsPosition(self) -> 'QCategoryAxis.AxisLabelsPosition': ...
    categoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def categoriesLabels(self) -> list[str]: ...
    def endValue(self, categoryLabel: str|None) -> float: ...
    def setStartValue(self, min: float) -> None: ...
    def startValue(self, categoryLabel: str|None = ...) -> float: ...
    def replaceLabel(self, oldLabel: str|None, newLabel: str|None) -> None: ...
    def remove(self, label: str|None) -> None: ...
    def append(self, label: str|None, categoryEndValue: float) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QChart(QtWidgets.QGraphicsWidget):

    class ChartType(enum.Enum):
        ChartTypeUndefined = ... # type: QChart.ChartType
        ChartTypeCartesian = ... # type: QChart.ChartType
        ChartTypePolar = ... # type: QChart.ChartType

    class AnimationOption(enum.Flag):
        NoAnimation = ... # type: QChart.AnimationOption
        GridAxisAnimations = ... # type: QChart.AnimationOption
        SeriesAnimations = ... # type: QChart.AnimationOption
        AllAnimations = ... # type: QChart.AnimationOption

    class ChartTheme(enum.Enum):
        ChartThemeLight = ... # type: QChart.ChartTheme
        ChartThemeBlueCerulean = ... # type: QChart.ChartTheme
        ChartThemeDark = ... # type: QChart.ChartTheme
        ChartThemeBrownSand = ... # type: QChart.ChartTheme
        ChartThemeBlueNcs = ... # type: QChart.ChartTheme
        ChartThemeHighContrast = ... # type: QChart.ChartTheme
        ChartThemeBlueIcy = ... # type: QChart.ChartTheme
        ChartThemeQt = ... # type: QChart.ChartTheme

    def __init__(self, parent: QtWidgets.QGraphicsItem|None = ..., flags: QtCore.Qt.WindowType = ...) -> None: ...

    def animationEasingCurve(self) -> QtCore.QEasingCurve: ...
    def setAnimationEasingCurve(self, curve: QtCore.QEasingCurve|QtCore.QEasingCurve.Type) -> None: ...
    def animationDuration(self) -> int: ...
    def setAnimationDuration(self, msecs: int) -> None: ...
    plotAreaChanged: typing.ClassVar[QtCore.pyqtSignal]
    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def localizeNumbers(self) -> bool: ...
    def setLocalizeNumbers(self, localize: bool) -> None: ...
    def chartType(self) -> 'QChart.ChartType': ...
    def isPlotAreaBackgroundVisible(self) -> bool: ...
    def setPlotAreaBackgroundVisible(self, visible: bool = ...) -> None: ...
    def plotAreaBackgroundPen(self) -> QtGui.QPen: ...
    def setPlotAreaBackgroundPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def plotAreaBackgroundBrush(self) -> QtGui.QBrush: ...
    def setPlotAreaBackgroundBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def setPlotArea(self, rect: QtCore.QRectF) -> None: ...
    def isZoomed(self) -> bool: ...
    def zoomReset(self) -> None: ...
    def backgroundRoundness(self) -> float: ...
    def setBackgroundRoundness(self, diameter: float) -> None: ...
    def mapToPosition(self, value: QtCore.QPointF, series: QAbstractSeries|None = ...) -> QtCore.QPointF: ...
    def mapToValue(self, position: QtCore.QPointF, series: QAbstractSeries|None = ...) -> QtCore.QPointF: ...
    def margins(self) -> QtCore.QMargins: ...
    def setMargins(self, margins: QtCore.QMargins) -> None: ...
    def axes(self, orientation: QtCore.Qt.Orientation = ..., series: QAbstractSeries|None = ...) -> list[QAbstractAxis]: ...
    def removeAxis(self, axis: QAbstractAxis|None) -> None: ...
    def addAxis(self, axis: QAbstractAxis|None, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def plotArea(self) -> QtCore.QRectF: ...
    def scroll(self, dx: float, dy: float) -> None: ...
    def isDropShadowEnabled(self) -> bool: ...
    def setDropShadowEnabled(self, enabled: bool = ...) -> None: ...
    def createDefaultAxes(self) -> None: ...
    def legend(self) -> 'QLegend|None': ...
    def zoom(self, factor: float) -> None: ...
    def zoomOut(self) -> None: ...
    @typing.overload
    def zoomIn(self) -> None: ...
    @typing.overload
    def zoomIn(self, rect: QtCore.QRectF) -> None: ...
    def animationOptions(self) -> 'QChart.AnimationOption': ...
    def setAnimationOptions(self, options: 'QChart.AnimationOption') -> None: ...
    def isBackgroundVisible(self) -> bool: ...
    def setBackgroundVisible(self, visible: bool = ...) -> None: ...
    def backgroundPen(self) -> QtGui.QPen: ...
    def setBackgroundPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def backgroundBrush(self) -> QtGui.QBrush: ...
    def setBackgroundBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def titleBrush(self) -> QtGui.QBrush: ...
    def setTitleBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def titleFont(self) -> QtGui.QFont: ...
    def setTitleFont(self, font: QtGui.QFont) -> None: ...
    def title(self) -> str: ...
    def setTitle(self, title: str|None) -> None: ...
    def theme(self) -> 'QChart.ChartTheme': ...
    def setTheme(self, theme: 'QChart.ChartTheme') -> None: ...
    def series(self) -> list[QAbstractSeries]: ...
    def removeAllSeries(self) -> None: ...
    def removeSeries(self, series: QAbstractSeries|None) -> None: ...
    def addSeries(self, series: QAbstractSeries|None) -> None: ...


class QChartView(QtWidgets.QGraphicsView):

    class RubberBand(enum.Flag):
        NoRubberBand = ... # type: QChartView.RubberBand
        VerticalRubberBand = ... # type: QChartView.RubberBand
        HorizontalRubberBand = ... # type: QChartView.RubberBand
        RectangleRubberBand = ... # type: QChartView.RubberBand
        ClickThroughRubberBand = ... # type: QChartView.RubberBand

    @typing.overload
    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...
    @typing.overload
    def __init__(self, chart: QChart|None, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def wheelEvent(self, event: QtGui.QWheelEvent|None) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent|None) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent|None) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent|None) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent|None) -> None: ...
    def chart(self) -> QChart|None: ...
    def setChart(self, chart: QChart|None) -> None: ...
    def rubberBand(self) -> 'QChartView.RubberBand': ...
    def setRubberBand(self, rubberBands: 'QChartView.RubberBand') -> None: ...


class QColorAxis(QAbstractAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    autoRangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    sizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    gradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    tickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    def autoRange(self) -> bool: ...
    def setAutoRange(self, autoRange: bool) -> None: ...
    def gradient(self) -> QtGui.QLinearGradient: ...
    def setGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def size(self) -> float: ...
    def setSize(self, size: float) -> None: ...
    def tickCount(self) -> int: ...
    def setTickCount(self, count: int) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def max(self) -> float: ...
    def setMax(self, max: float) -> None: ...
    def min(self) -> float: ...
    def setMin(self, min: float) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QDateTimeAxis(QAbstractAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    tickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    formatChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    def tickCount(self) -> int: ...
    def setTickCount(self, count: int) -> None: ...
    def format(self) -> str: ...
    def setFormat(self, format: str|None) -> None: ...
    def setRange(self, min: QtCore.QDateTime|datetime.datetime, max: QtCore.QDateTime|datetime.datetime) -> None: ...
    def max(self) -> QtCore.QDateTime: ...
    def setMax(self, max: QtCore.QDateTime|datetime.datetime) -> None: ...
    def min(self) -> QtCore.QDateTime: ...
    def setMin(self, min: QtCore.QDateTime|datetime.datetime) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QHBarModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    columnCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    lastBarSetRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstBarSetRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setColumnCount(self, columnCount: int) -> None: ...
    def columnCount(self) -> int: ...
    def setFirstColumn(self, firstColumn: int) -> None: ...
    def firstColumn(self) -> int: ...
    def setSeries(self, series: QAbstractBarSeries|None) -> None: ...
    def series(self) -> QAbstractBarSeries|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setLastBarSetRow(self, lastBarSetRow: int) -> None: ...
    def lastBarSetRow(self) -> int: ...
    def setFirstBarSetRow(self, firstBarSetRow: int) -> None: ...
    def firstBarSetRow(self) -> int: ...


class QHBoxPlotModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    columnCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    lastBoxSetRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstBoxSetRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setColumnCount(self, rowCount: int) -> None: ...
    def columnCount(self) -> int: ...
    def setFirstColumn(self, firstColumn: int) -> None: ...
    def firstColumn(self) -> int: ...
    def setLastBoxSetRow(self, lastBoxSetRow: int) -> None: ...
    def lastBoxSetRow(self) -> int: ...
    def setFirstBoxSetRow(self, firstBoxSetRow: int) -> None: ...
    def firstBoxSetRow(self) -> int: ...
    def setSeries(self, series: QBoxPlotSeries|None) -> None: ...
    def series(self) -> QBoxPlotSeries|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...


class QHCandlestickModelMapper(QCandlestickModelMapper):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    lastSetRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstSetRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    closeColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    lowColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    highColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    openColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    timestampColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    def lastSetRow(self) -> int: ...
    def setLastSetRow(self, lastSetRow: int) -> None: ...
    def firstSetRow(self) -> int: ...
    def setFirstSetRow(self, firstSetRow: int) -> None: ...
    def closeColumn(self) -> int: ...
    def setCloseColumn(self, closeColumn: int) -> None: ...
    def lowColumn(self) -> int: ...
    def setLowColumn(self, lowColumn: int) -> None: ...
    def highColumn(self) -> int: ...
    def setHighColumn(self, highColumn: int) -> None: ...
    def openColumn(self) -> int: ...
    def setOpenColumn(self, openColumn: int) -> None: ...
    def timestampColumn(self) -> int: ...
    def setTimestampColumn(self, timestampColumn: int) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...


class QHorizontalBarSeries(QAbstractBarSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QHorizontalPercentBarSeries(QAbstractBarSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QHorizontalStackedBarSeries(QAbstractBarSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QHPieModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    columnCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setColumnCount(self, columnCount: int) -> None: ...
    def columnCount(self) -> int: ...
    def setFirstColumn(self, firstColumn: int) -> None: ...
    def firstColumn(self) -> int: ...
    def setSeries(self, series: 'QPieSeries|None') -> None: ...
    def series(self) -> 'QPieSeries|None': ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setLabelsRow(self, labelsRow: int) -> None: ...
    def labelsRow(self) -> int: ...
    def setValuesRow(self, valuesRow: int) -> None: ...
    def valuesRow(self) -> int: ...


class QHXYModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    columnCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    yRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    xRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setColumnCount(self, columnCount: int) -> None: ...
    def columnCount(self) -> int: ...
    def setFirstColumn(self, firstColumn: int) -> None: ...
    def firstColumn(self) -> int: ...
    def setSeries(self, series: 'QXYSeries|None') -> None: ...
    def series(self) -> 'QXYSeries|None': ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setYRow(self, yRow: int) -> None: ...
    def yRow(self) -> int: ...
    def setXRow(self, xRow: int) -> None: ...
    def xRow(self) -> int: ...


class QLegend(QtWidgets.QGraphicsWidget):

    class MarkerShape(enum.Enum):
        MarkerShapeDefault = ... # type: QLegend.MarkerShape
        MarkerShapeRectangle = ... # type: QLegend.MarkerShape
        MarkerShapeCircle = ... # type: QLegend.MarkerShape
        MarkerShapeFromSeries = ... # type: QLegend.MarkerShape
        MarkerShapeRotatedRectangle = ... # type: QLegend.MarkerShape
        MarkerShapeTriangle = ... # type: QLegend.MarkerShape
        MarkerShapeStar = ... # type: QLegend.MarkerShape
        MarkerShapePentagon = ... # type: QLegend.MarkerShape

    interactiveChanged: typing.ClassVar[QtCore.pyqtSignal]
    attachedToChartChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setInteractive(self, interactive: bool) -> None: ...
    def isInteractive(self) -> bool: ...
    markerShapeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMarkerShape(self, shape: 'QLegend.MarkerShape') -> None: ...
    def markerShape(self) -> 'QLegend.MarkerShape': ...
    showToolTipsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setShowToolTips(self, show: bool) -> None: ...
    def showToolTips(self) -> bool: ...
    reverseMarkersChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setReverseMarkers(self, reverseMarkers: bool = ...) -> None: ...
    def reverseMarkers(self) -> bool: ...
    def showEvent(self, event: QtGui.QShowEvent|None) -> None: ...
    def hideEvent(self, event: QtGui.QHideEvent|None) -> None: ...
    labelColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    fontChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def markers(self, series: QAbstractSeries|None = ...) -> list[QLegendMarker]: ...
    def labelColor(self) -> QtGui.QColor: ...
    def setLabelColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelBrush(self) -> QtGui.QBrush: ...
    def setLabelBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def isBackgroundVisible(self) -> bool: ...
    def setBackgroundVisible(self, visible: bool = ...) -> None: ...
    def isAttachedToChart(self) -> bool: ...
    def attachToChart(self) -> None: ...
    def detachFromChart(self) -> None: ...
    def alignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def paint(self, painter: QtGui.QPainter|None, option: QtWidgets.QStyleOptionGraphicsItem|None, widget: QtWidgets.QWidget|None = ...) -> None: ...


class QXYSeries(QAbstractSeries):

    class PointConfiguration(enum.Enum):
        Color = ... # type: QXYSeries.PointConfiguration
        Size = ... # type: QXYSeries.PointConfiguration
        Visibility = ... # type: QXYSeries.PointConfiguration
        LabelVisibility = ... # type: QXYSeries.PointConfiguration
        LabelFormat = ... # type: QXYSeries.PointConfiguration

    markerSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointsConfigurationChanged: typing.ClassVar[QtCore.pyqtSignal]
    bestFitLineColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    bestFitLinePenChanged: typing.ClassVar[QtCore.pyqtSignal]
    bestFitLineVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedLightMarkerChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightMarkerChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedPointsChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def colorBy(self, sourceData: collections.abc.Iterable[float], gradient: QtGui.QLinearGradient = ...) -> None: ...
    def sizeBy(self, sourceData: collections.abc.Iterable[float], minSize: float, maxSize: float) -> None: ...
    def pointsConfiguration(self) -> dict[int, dict['QXYSeries.PointConfiguration', typing.Any]]: ...
    def pointConfiguration(self, index: int) -> dict['QXYSeries.PointConfiguration', typing.Any]: ...
    def setPointsConfiguration(self, pointsConfiguration: dict[int, dict['QXYSeries.PointConfiguration', typing.Any]]) -> None: ...
    @typing.overload
    def setPointConfiguration(self, index: int, key: 'QXYSeries.PointConfiguration', value: typing.Any) -> None: ...
    @typing.overload
    def setPointConfiguration(self, index: int, configuration: dict['QXYSeries.PointConfiguration', typing.Any]) -> None: ...
    @typing.overload
    def clearPointsConfiguration(self, key: 'QXYSeries.PointConfiguration') -> None: ...
    @typing.overload
    def clearPointsConfiguration(self) -> None: ...
    @typing.overload
    def clearPointConfiguration(self, index: int, key: 'QXYSeries.PointConfiguration') -> None: ...
    @typing.overload
    def clearPointConfiguration(self, index: int) -> None: ...
    def bestFitLineColor(self) -> QtGui.QColor: ...
    def setBestFitLineColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def bestFitLinePen(self) -> QtGui.QPen: ...
    def setBestFitLinePen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def bestFitLineEquation(self) -> typing.Tuple[tuple[float, float], bool]: ...
    def bestFitLineVisible(self) -> bool: ...
    def setBestFitLineVisible(self, visible: bool = ...) -> None: ...
    def markerSize(self) -> float: ...
    def setMarkerSize(self, size: float) -> None: ...
    def selectedLightMarker(self) -> QtGui.QImage: ...
    def setSelectedLightMarker(self, selectedLightMarker: QtGui.QImage) -> None: ...
    def lightMarker(self) -> QtGui.QImage: ...
    def setLightMarker(self, lightMarker: QtGui.QImage) -> None: ...
    def selectedPoints(self) -> list[int]: ...
    def toggleSelection(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectPoints(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def selectPoints(self, indexes: collections.abc.Iterable[int]) -> None: ...
    def deselectAllPoints(self) -> None: ...
    def selectAllPoints(self) -> None: ...
    def setPointSelected(self, index: int, selected: bool) -> None: ...
    def deselectPoint(self, index: int) -> None: ...
    def selectPoint(self, index: int) -> None: ...
    def isPointSelected(self, index: int) -> bool: ...
    def selectedColor(self) -> QtGui.QColor: ...
    def setSelectedColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsClippingChanged: typing.ClassVar[QtCore.pyqtSignal]
    def pointLabelsClipping(self) -> bool: ...
    def setPointLabelsClipping(self, enable: bool = ...) -> None: ...
    def removePoints(self, index: int, count: int) -> None: ...
    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    pointLabelsFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def pointLabelsColor(self) -> QtGui.QColor: ...
    def setPointLabelsColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def pointLabelsFont(self) -> QtGui.QFont: ...
    def setPointLabelsFont(self, font: QtGui.QFont) -> None: ...
    def pointLabelsVisible(self) -> bool: ...
    def setPointLabelsVisible(self, visible: bool = ...) -> None: ...
    def pointLabelsFormat(self) -> str: ...
    def setPointLabelsFormat(self, format: str|None) -> None: ...
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    pointsReplaced: typing.ClassVar[QtCore.pyqtSignal]
    pointAdded: typing.ClassVar[QtCore.pyqtSignal]
    pointRemoved: typing.ClassVar[QtCore.pyqtSignal]
    pointReplaced: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    def at(self, index: int) -> QtCore.QPointF: ...
    def pointsVisible(self) -> bool: ...
    def setPointsVisible(self, visible: bool = ...) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    @typing.overload
    def __lshift__(self, point: QtCore.QPointF) -> 'QXYSeries': ...
    @typing.overload
    def __lshift__(self, points: collections.abc.Iterable[QtCore.QPointF]) -> 'QXYSeries': ...
    def points(self) -> list[QtCore.QPointF]: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def clear(self) -> None: ...
    def insert(self, index: int, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def remove(self, x: float, y: float) -> None: ...
    @typing.overload
    def remove(self, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def remove(self, index: int) -> None: ...
    @typing.overload
    def replace(self, oldX: float, oldY: float, newX: float, newY: float) -> None: ...
    @typing.overload
    def replace(self, oldPoint: QtCore.QPointF, newPoint: QtCore.QPointF) -> None: ...
    @typing.overload
    def replace(self, points: collections.abc.Iterable[QtCore.QPointF]) -> None: ...
    @typing.overload
    def replace(self, index: int, newX: float, newY: float) -> None: ...
    @typing.overload
    def replace(self, index: int, newPoint: QtCore.QPointF) -> None: ...
    @typing.overload
    def append(self, x: float, y: float) -> None: ...
    @typing.overload
    def append(self, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def append(self, points: collections.abc.Iterable[QtCore.QPointF]) -> None: ...


class QLineSeries(QXYSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QLogValueAxis(QAbstractAxis):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    minorTickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    tickCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def minorTickCount(self) -> int: ...
    def setMinorTickCount(self, minorTickCount: int) -> None: ...
    def tickCount(self) -> int: ...
    baseChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    def base(self) -> float: ...
    def setBase(self, base: float) -> None: ...
    def labelFormat(self) -> str: ...
    def setLabelFormat(self, format: str|None) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def max(self) -> float: ...
    def setMax(self, max: float) -> None: ...
    def min(self) -> float: ...
    def setMin(self, min: float) -> None: ...
    def type(self) -> QAbstractAxis.AxisType: ...


class QPercentBarSeries(QAbstractBarSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QPieLegendMarker(QLegendMarker):

    def __init__(self, series: 'QPieSeries|None', slice: 'QPieSlice|None', legend: QLegend|None, parent: QtCore.QObject|None = ...) -> None: ...

    def slice(self) -> 'QPieSlice|None': ...
    def series(self) -> 'QPieSeries|None': ...
    def type(self) -> QLegendMarker.LegendMarkerType: ...


class QPieSeries(QAbstractSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    def setLabelsPosition(self, position: 'QPieSlice.LabelPosition') -> None: ...
    def holeSize(self) -> float: ...
    def setHoleSize(self, holeSize: float) -> None: ...
    def take(self, slice: 'QPieSlice|None') -> bool: ...
    sumChanged: typing.ClassVar[QtCore.pyqtSignal]
    countChanged: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    removed: typing.ClassVar[QtCore.pyqtSignal]
    added: typing.ClassVar[QtCore.pyqtSignal]
    def setLabelsVisible(self, visible: bool = ...) -> None: ...
    def pieEndAngle(self) -> float: ...
    def setPieEndAngle(self, endAngle: float) -> None: ...
    def pieStartAngle(self) -> float: ...
    def setPieStartAngle(self, startAngle: float) -> None: ...
    def pieSize(self) -> float: ...
    def setPieSize(self, relativeSize: float) -> None: ...
    def verticalPosition(self) -> float: ...
    def setVerticalPosition(self, relativePosition: float) -> None: ...
    def horizontalPosition(self) -> float: ...
    def setHorizontalPosition(self, relativePosition: float) -> None: ...
    def sum(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def slices(self) -> list['QPieSlice']: ...
    def clear(self) -> None: ...
    def remove(self, slice: 'QPieSlice|None') -> bool: ...
    def insert(self, index: int, slice: 'QPieSlice|None') -> bool: ...
    def __lshift__(self, slice: 'QPieSlice|None') -> 'QPieSeries': ...
    @typing.overload
    def append(self, slice: 'QPieSlice|None') -> bool: ...
    @typing.overload
    def append(self, slices: collections.abc.Iterable['QPieSlice']) -> bool: ...
    @typing.overload
    def append(self, label: str|None, value: float) -> 'QPieSlice|None': ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QPieSlice(QtCore.QObject):

    class LabelPosition(enum.Enum):
        LabelOutside = ... # type: QPieSlice.LabelPosition
        LabelInsideHorizontal = ... # type: QPieSlice.LabelPosition
        LabelInsideTangential = ... # type: QPieSlice.LabelPosition
        LabelInsideNormal = ... # type: QPieSlice.LabelPosition

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, label: str|None, value: float, parent: QtCore.QObject|None = ...) -> None: ...

    doubleClicked: typing.ClassVar[QtCore.pyqtSignal]
    released: typing.ClassVar[QtCore.pyqtSignal]
    pressed: typing.ClassVar[QtCore.pyqtSignal]
    hovered: typing.ClassVar[QtCore.pyqtSignal]
    clicked: typing.ClassVar[QtCore.pyqtSignal]
    labelColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    angleSpanChanged: typing.ClassVar[QtCore.pyqtSignal]
    startAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    percentageChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelFontChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBrushChanged: typing.ClassVar[QtCore.pyqtSignal]
    brushChanged: typing.ClassVar[QtCore.pyqtSignal]
    penChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelVisibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setLabelPosition(self, position: 'QPieSlice.LabelPosition') -> None: ...
    def labelPosition(self) -> 'QPieSlice.LabelPosition': ...
    def series(self) -> QPieSeries|None: ...
    def angleSpan(self) -> float: ...
    def startAngle(self) -> float: ...
    def percentage(self) -> float: ...
    def explodeDistanceFactor(self) -> float: ...
    def setExplodeDistanceFactor(self, factor: float) -> None: ...
    def labelArmLengthFactor(self) -> float: ...
    def setLabelArmLengthFactor(self, factor: float) -> None: ...
    def labelFont(self) -> QtGui.QFont: ...
    def setLabelFont(self, font: QtGui.QFont) -> None: ...
    def setLabelColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def labelColor(self) -> QtGui.QColor: ...
    def labelBrush(self) -> QtGui.QBrush: ...
    def setLabelBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def setBorderWidth(self, width: int) -> None: ...
    def borderWidth(self) -> int: ...
    def setBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def isExploded(self) -> bool: ...
    def setExploded(self, exploded: bool = ...) -> None: ...
    def isLabelVisible(self) -> bool: ...
    def setLabelVisible(self, visible: bool = ...) -> None: ...
    def value(self) -> float: ...
    def setValue(self, value: float) -> None: ...
    def label(self) -> str: ...
    def setLabel(self, label: str|None) -> None: ...


class QPolarChart(QChart):

    class PolarOrientation(enum.Flag):
        PolarOrientationRadial = ... # type: QPolarChart.PolarOrientation
        PolarOrientationAngular = ... # type: QPolarChart.PolarOrientation

    def __init__(self, parent: QtWidgets.QGraphicsItem|None = ..., flags: QtCore.Qt.WindowType = ...) -> None: ...

    @staticmethod
    def axisPolarOrientation(axis: QAbstractAxis|None) -> 'QPolarChart.PolarOrientation': ...
    def axes(self, polarOrientation: 'QPolarChart.PolarOrientation' = ..., series: QAbstractSeries|None = ...) -> list[QAbstractAxis]: ...
    def addAxis(self, axis: QAbstractAxis|None, polarOrientation: 'QPolarChart.PolarOrientation') -> None: ...


class QScatterSeries(QXYSeries):

    class MarkerShape(enum.Enum):
        MarkerShapeCircle = ... # type: QScatterSeries.MarkerShape
        MarkerShapeRectangle = ... # type: QScatterSeries.MarkerShape
        MarkerShapeRotatedRectangle = ... # type: QScatterSeries.MarkerShape
        MarkerShapeTriangle = ... # type: QScatterSeries.MarkerShape
        MarkerShapeStar = ... # type: QScatterSeries.MarkerShape
        MarkerShapePentagon = ... # type: QScatterSeries.MarkerShape

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    markerSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    markerShapeChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorChanged: typing.ClassVar[QtCore.pyqtSignal]
    def borderColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setBrush(self, brush: QtGui.QBrush|QtGui.QColor|QtCore.Qt.GlobalColor|int|QtGui.QGradient) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setPen(self, pen: QtGui.QPen|QtGui.QColor|QtCore.Qt.GlobalColor|int) -> None: ...
    def setMarkerSize(self, size: float) -> None: ...
    def markerSize(self) -> float: ...
    def setMarkerShape(self, shape: 'QScatterSeries.MarkerShape') -> None: ...
    def markerShape(self) -> 'QScatterSeries.MarkerShape': ...
    def type(self) -> QAbstractSeries.SeriesType: ...


class QSplineSeries(QLineSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QStackedBarSeries(QAbstractBarSeries):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def type(self) -> QAbstractSeries.SeriesType: ...


class QVBarModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    lastBarSetColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstBarSetColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setRowCount(self, rowCount: int) -> None: ...
    def rowCount(self) -> int: ...
    def setFirstRow(self, firstRow: int) -> None: ...
    def firstRow(self) -> int: ...
    def setSeries(self, series: QAbstractBarSeries|None) -> None: ...
    def series(self) -> QAbstractBarSeries|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setLastBarSetColumn(self, lastBarSetColumn: int) -> None: ...
    def lastBarSetColumn(self) -> int: ...
    def setFirstBarSetColumn(self, firstBarSetColumn: int) -> None: ...
    def firstBarSetColumn(self) -> int: ...


class QVBoxPlotModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    lastBoxSetColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstBoxSetColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setRowCount(self, rowCount: int) -> None: ...
    def rowCount(self) -> int: ...
    def setFirstRow(self, firstRow: int) -> None: ...
    def firstRow(self) -> int: ...
    def setLastBoxSetColumn(self, lastBoxSetColumn: int) -> None: ...
    def lastBoxSetColumn(self) -> int: ...
    def setFirstBoxSetColumn(self, firstBoxSetColumn: int) -> None: ...
    def firstBoxSetColumn(self) -> int: ...
    def setSeries(self, series: QBoxPlotSeries|None) -> None: ...
    def series(self) -> QBoxPlotSeries|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...


class QVCandlestickModelMapper(QCandlestickModelMapper):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    lastSetColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstSetColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    closeRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    lowRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    highRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    openRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    timestampRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    def lastSetColumn(self) -> int: ...
    def setLastSetColumn(self, lastSetColumn: int) -> None: ...
    def firstSetColumn(self) -> int: ...
    def setFirstSetColumn(self, firstSetColumn: int) -> None: ...
    def closeRow(self) -> int: ...
    def setCloseRow(self, closeRow: int) -> None: ...
    def lowRow(self) -> int: ...
    def setLowRow(self, lowRow: int) -> None: ...
    def highRow(self) -> int: ...
    def setHighRow(self, highRow: int) -> None: ...
    def openRow(self) -> int: ...
    def setOpenRow(self, openRow: int) -> None: ...
    def timestampRow(self) -> int: ...
    def setTimestampRow(self, timestampRow: int) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...


class QVPieModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    valuesColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setRowCount(self, rowCount: int) -> None: ...
    def rowCount(self) -> int: ...
    def setFirstRow(self, firstRow: int) -> None: ...
    def firstRow(self) -> int: ...
    def setSeries(self, series: QPieSeries|None) -> None: ...
    def series(self) -> QPieSeries|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setLabelsColumn(self, labelsColumn: int) -> None: ...
    def labelsColumn(self) -> int: ...
    def setValuesColumn(self, valuesColumn: int) -> None: ...
    def valuesColumn(self) -> int: ...


class QVXYModelMapper(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    firstRowChanged: typing.ClassVar[QtCore.pyqtSignal]
    yColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    xColumnChanged: typing.ClassVar[QtCore.pyqtSignal]
    modelReplaced: typing.ClassVar[QtCore.pyqtSignal]
    seriesReplaced: typing.ClassVar[QtCore.pyqtSignal]
    def setRowCount(self, rowCount: int) -> None: ...
    def rowCount(self) -> int: ...
    def setFirstRow(self, firstRow: int) -> None: ...
    def firstRow(self) -> int: ...
    def setSeries(self, series: QXYSeries|None) -> None: ...
    def series(self) -> QXYSeries|None: ...
    def setModel(self, model: QtCore.QAbstractItemModel|None) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel|None: ...
    def setYColumn(self, yColumn: int) -> None: ...
    def yColumn(self) -> int: ...
    def setXColumn(self, xColumn: int) -> None: ...
    def xColumn(self) -> int: ...


class QXYLegendMarker(QLegendMarker):

    def __init__(self, series: QXYSeries|None, legend: QLegend|None, parent: QtCore.QObject|None = ...) -> None: ...

    def series(self) -> QXYSeries|None: ...
    def type(self) -> QLegendMarker.LegendMarkerType: ...


PYQT_CHART_VERSION = ... # type: int
PYQT_CHART_VERSION_STR = ... # type: str
