/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.streaming;

import org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public record StreamingCostMetrics(boolean streamable, long topNSize, long estimatedBucketCount, int segmentCount, long estimatedDocCount) {
    public StreamingCostMetrics {
        assert (topNSize >= 0L) : "topNSize must be non-negative";
        assert (estimatedBucketCount >= 0L) : "estimatedBucketCount must be non-negative";
        assert (segmentCount >= 0) : "segmentCount must be non-negative";
        assert (estimatedDocCount >= 0L) : "estimatedDocCount must be non-negative";
    }

    public static StreamingCostMetrics nonStreamable() {
        return new StreamingCostMetrics(false, 0L, 0L, 0, 0L);
    }

    public StreamingCostMetrics combineWithSubAggregation(StreamingCostMetrics subAggMetrics) {
        long combinedEstimatedBucketCount;
        long combinedTopNSize;
        if (!this.streamable || subAggMetrics == null || !subAggMetrics.streamable) {
            return StreamingCostMetrics.nonStreamable();
        }
        try {
            combinedTopNSize = Math.multiplyExact(this.topNSize, subAggMetrics.topNSize);
        }
        catch (ArithmeticException e) {
            return StreamingCostMetrics.nonStreamable();
        }
        try {
            combinedEstimatedBucketCount = Math.multiplyExact(this.estimatedBucketCount, subAggMetrics.estimatedBucketCount);
        }
        catch (ArithmeticException e) {
            return StreamingCostMetrics.nonStreamable();
        }
        return new StreamingCostMetrics(true, combinedTopNSize, combinedEstimatedBucketCount, Math.max(this.segmentCount, subAggMetrics.segmentCount), Math.max(this.estimatedDocCount, subAggMetrics.estimatedDocCount));
    }

    public StreamingCostMetrics combineWithSibling(StreamingCostMetrics siblingMetrics) {
        long combinedEstimatedBucketCount;
        long combinedTopNSize;
        if (!this.streamable || siblingMetrics == null || !siblingMetrics.streamable) {
            return StreamingCostMetrics.nonStreamable();
        }
        try {
            combinedTopNSize = Math.addExact(this.topNSize, siblingMetrics.topNSize);
        }
        catch (ArithmeticException e) {
            return StreamingCostMetrics.nonStreamable();
        }
        try {
            combinedEstimatedBucketCount = Math.addExact(this.estimatedBucketCount, siblingMetrics.estimatedBucketCount);
        }
        catch (ArithmeticException e) {
            return StreamingCostMetrics.nonStreamable();
        }
        return new StreamingCostMetrics(true, combinedTopNSize, combinedEstimatedBucketCount, Math.max(this.segmentCount, siblingMetrics.segmentCount), this.estimatedDocCount + siblingMetrics.estimatedDocCount);
    }

    public boolean isStreamable() {
        return this.streamable;
    }
}

