{$IFDEF FPC}{$MODE DELPHI}{$ENDIF}
(*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-develop.

Abstract: This is an autogenerated Pascal Header file in order to allow an easy
 use of the 3MF Library

Interface version: 2.3.2

*)

unit Unit_Lib3MF;

interface

uses
	{$IFDEF WINDOWS}
		Windows,
	{$ELSE}
		dynlibs,
	{$ENDIF}
	Types,
	Classes,
	SysUtils;

(*************************************************************************************************************************
 Version definition for Lib3MF
**************************************************************************************************************************)

const
	LIB3MF_VERSION_MAJOR = 2;
	LIB3MF_VERSION_MINOR = 3;
	LIB3MF_VERSION_MICRO = 2;
	LIB3MF_VERSION_PRERELEASEINFO = '';
	LIB3MF_VERSION_BUILDINFO = '';


(*************************************************************************************************************************
 General type definitions
**************************************************************************************************************************)

type
	TLib3MFResult = Cardinal;
	TLib3MFHandle = Pointer;

	PLib3MFResult = ^TLib3MFResult;
	PLib3MFHandle = ^TLib3MFHandle;

(*************************************************************************************************************************
 Error Constants for Lib3MF
**************************************************************************************************************************)

const
	LIB3MF_SUCCESS = 0;
	LIB3MF_ERROR_NOTIMPLEMENTED = 1;
	LIB3MF_ERROR_INVALIDPARAM = 2;
	LIB3MF_ERROR_INVALIDCAST = 3;
	LIB3MF_ERROR_BUFFERTOOSMALL = 4;
	LIB3MF_ERROR_GENERICEXCEPTION = 5;
	LIB3MF_ERROR_COULDNOTLOADLIBRARY = 6;
	LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT = 7;
	LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION = 8;
	LIB3MF_ERROR_CALCULATIONABORTED = 10;
	LIB3MF_ERROR_SHOULDNOTBECALLED = 11;
	LIB3MF_ERROR_READERCLASSUNKNOWN = 100;
	LIB3MF_ERROR_WRITERCLASSUNKNOWN = 101;
	LIB3MF_ERROR_ITERATORINVALIDINDEX = 102;
	LIB3MF_ERROR_INVALIDMODELRESOURCE = 103;
	LIB3MF_ERROR_RESOURCENOTFOUND = 104;
	LIB3MF_ERROR_INVALIDMODEL = 105;
	LIB3MF_ERROR_INVALIDOBJECT = 106;
	LIB3MF_ERROR_INVALIDMESHOBJECT = 107;
	LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT = 108;
	LIB3MF_ERROR_INVALIDCOMPONENT = 109;
	LIB3MF_ERROR_INVALIDBUILDITEM = 110;
	LIB3MF_ERROR_INVALIDBASEMATERIALGROUP = 111;
	LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE = 112;
	LIB3MF_ERROR_INVALIDTEXTURERESOURCE = 113;
	LIB3MF_ERROR_INVALIDCOLORGROUP = 114;
	LIB3MF_ERROR_INVALIDTEXTURE2DGROUP = 115;
	LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS = 116;
	LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP = 117;
	LIB3MF_ERROR_INVALIDRESOURCEINDEX = 120;
	LIB3MF_ERROR_ATTACHMENTNOTFOUND = 121;
	LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE = 130;
	LIB3MF_ERROR_INVALIDATTACHMENTSTREAM = 131;
	LIB3MF_ERROR_INVALIDPROPERTYCOUNT = 132;
	LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER = 140;
	LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT = 141;
	LIB3MF_ERROR_INVALIDRESOURCE = 142;
	LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE = 2000;
	LIB3MF_ERROR_INVALIDKEYSTORE = 3000;
	LIB3MF_ERROR_INVALIDKEYSTORECONSUMER = 3001;
	LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND = 3002;
	LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND = 3003;
	LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED = 3004;
	LIB3MF_ERROR_INVALIDKEYSIZE = 3005;

(*************************************************************************************************************************
 Declaration of enums
**************************************************************************************************************************)

type

	TLib3MFPropertyType = (
		ePropertyTypeNoPropertyType,
		ePropertyTypeBaseMaterial,
		ePropertyTypeTexCoord,
		ePropertyTypeColors,
		ePropertyTypeComposite,
		ePropertyTypeMulti
	);

	TLib3MFSlicesMeshResolution = (
		eSlicesMeshResolutionFullres,
		eSlicesMeshResolutionLowres
	);

	TLib3MFModelUnit = (
		eModelUnitMicroMeter,
		eModelUnitMilliMeter,
		eModelUnitCentiMeter,
		eModelUnitInch,
		eModelUnitFoot,
		eModelUnitMeter
	);

	TLib3MFObjectType = (
		eObjectTypeOther,
		eObjectTypeModel,
		eObjectTypeSupport,
		eObjectTypeSolidSupport
	);

	TLib3MFTextureType = (
		eTextureTypeUnknown,
		eTextureTypePNG,
		eTextureTypeJPEG
	);

	TLib3MFTextureTileStyle = (
		eTextureTileStyleWrap,
		eTextureTileStyleMirror,
		eTextureTileStyleClamp,
		eTextureTileStyleNoTileStyle
	);

	TLib3MFTextureFilter = (
		eTextureFilterAuto,
		eTextureFilterLinear,
		eTextureFilterNearest
	);

	TLib3MFBeamLatticeCapMode = (
		eBeamLatticeCapModeSphere,
		eBeamLatticeCapModeHemiSphere,
		eBeamLatticeCapModeButt
	);

	TLib3MFBeamLatticeClipMode = (
		eBeamLatticeClipModeNoClipMode,
		eBeamLatticeClipModeInside,
		eBeamLatticeClipModeOutside
	);

	TLib3MFBeamLatticeBallMode = (
		eBeamLatticeBallModeNone,
		eBeamLatticeBallModeMixed,
		eBeamLatticeBallModeAll
	);

	TLib3MFProgressIdentifier = (
		eProgressIdentifierQUERYCANCELED,
		eProgressIdentifierDONE,
		eProgressIdentifierCLEANUP,
		eProgressIdentifierREADSTREAM,
		eProgressIdentifierEXTRACTOPCPACKAGE,
		eProgressIdentifierREADNONROOTMODELS,
		eProgressIdentifierREADROOTMODEL,
		eProgressIdentifierREADRESOURCES,
		eProgressIdentifierREADMESH,
		eProgressIdentifierREADSLICES,
		eProgressIdentifierREADBUILD,
		eProgressIdentifierREADCUSTOMATTACHMENT,
		eProgressIdentifierREADTEXTURETACHMENTS,
		eProgressIdentifierCREATEOPCPACKAGE,
		eProgressIdentifierWRITEMODELSTOSTREAM,
		eProgressIdentifierWRITEROOTMODEL,
		eProgressIdentifierWRITENONROOTMODELS,
		eProgressIdentifierWRITEATTACHMENTS,
		eProgressIdentifierWRITECONTENTTYPES,
		eProgressIdentifierWRITENOBJECTS,
		eProgressIdentifierWRITENODES,
		eProgressIdentifierWRITETRIANGLES,
		eProgressIdentifierWRITESLICES,
		eProgressIdentifierWRITEKEYSTORE
	);

	TLib3MFBlendMethod = (
		eBlendMethodNoBlendMethod,
		eBlendMethodMix,
		eBlendMethodMultiply
	);

	TLib3MFEncryptionAlgorithm = (
		eEncryptionAlgorithmAES256_GCM
	);

	TLib3MFWrappingAlgorithm = (
		eWrappingAlgorithmRSA_OAEP
	);

	TLib3MFMgfAlgorithm = (
		eMgfAlgorithmMGF1_SHA1,
		eMgfAlgorithmMGF1_SHA224,
		eMgfAlgorithmMGF1_SHA256,
		eMgfAlgorithmMGF1_SHA384,
		eMgfAlgorithmMGF1_SHA512
	);

	TLib3MFDigestMethod = (
		eDigestMethodSHA1,
		eDigestMethodSHA256
	);

	TLib3MFCompression = (
		eCompressionNoCompression,
		eCompressionDeflate
	);

(*************************************************************************************************************************
 Declaration of structs
**************************************************************************************************************************)

type

	PLib3MFTriangle = ^TLib3MFTriangle;
	TLib3MFTriangle = packed record
		FIndices: array [0..2] of Cardinal;
	end;

	PLib3MFTriangleProperties = ^TLib3MFTriangleProperties;
	TLib3MFTriangleProperties = packed record
		FResourceID: Cardinal;
		FPropertyIDs: array [0..2] of Cardinal;
	end;

	PLib3MFPosition = ^TLib3MFPosition;
	TLib3MFPosition = packed record
		FCoordinates: array [0..2] of Single;
	end;

	PLib3MFPosition2D = ^TLib3MFPosition2D;
	TLib3MFPosition2D = packed record
		FCoordinates: array [0..1] of Single;
	end;

	PLib3MFCompositeConstituent = ^TLib3MFCompositeConstituent;
	TLib3MFCompositeConstituent = packed record
		FPropertyID: Cardinal;
		FMixingRatio: Double;
	end;

	PLib3MFMultiPropertyLayer = ^TLib3MFMultiPropertyLayer;
	TLib3MFMultiPropertyLayer = packed record
		FResourceID: Cardinal;
		FTheBlendMethod: Integer;
	end;

	PLib3MFTex2Coord = ^TLib3MFTex2Coord;
	TLib3MFTex2Coord = packed record
		FU: Double;
		FV: Double;
	end;

	PLib3MFTransform = ^TLib3MFTransform;
	TLib3MFTransform = packed record
		FFields: array [0..3, 0..2] of Single;
	end;

	PLib3MFBox = ^TLib3MFBox;
	TLib3MFBox = packed record
		FMinCoordinate: array [0..2] of Single;
		FMaxCoordinate: array [0..2] of Single;
	end;

	PLib3MFColor = ^TLib3MFColor;
	TLib3MFColor = packed record
		FRed: Byte;
		FGreen: Byte;
		FBlue: Byte;
		FAlpha: Byte;
	end;

	PLib3MFBeam = ^TLib3MFBeam;
	TLib3MFBeam = packed record
		FIndices: array [0..1] of Cardinal;
		FRadii: array [0..1] of Double;
		FCapModes: array [0..1] of Integer;
	end;

	PLib3MFBall = ^TLib3MFBall;
	TLib3MFBall = packed record
		FIndex: Cardinal;
		FRadius: Double;
	end;


(*************************************************************************************************************************
 Declaration of struct arrays
**************************************************************************************************************************)

	ArrayOfLib3MFTriangle = array of TLib3MFTriangle;
	ArrayOfLib3MFTriangleProperties = array of TLib3MFTriangleProperties;
	ArrayOfLib3MFPosition = array of TLib3MFPosition;
	ArrayOfLib3MFPosition2D = array of TLib3MFPosition2D;
	ArrayOfLib3MFCompositeConstituent = array of TLib3MFCompositeConstituent;
	ArrayOfLib3MFMultiPropertyLayer = array of TLib3MFMultiPropertyLayer;
	ArrayOfLib3MFTex2Coord = array of TLib3MFTex2Coord;
	ArrayOfLib3MFTransform = array of TLib3MFTransform;
	ArrayOfLib3MFBox = array of TLib3MFBox;
	ArrayOfLib3MFColor = array of TLib3MFColor;
	ArrayOfLib3MFBeam = array of TLib3MFBeam;
	ArrayOfLib3MFBall = array of TLib3MFBall;

(*************************************************************************************************************************
 Declaration of function types
**************************************************************************************************************************)

type

	PLib3MF_ProgressCallback = function(out pAbort: Byte; const dProgressValue: Double; const eProgressIdentifier: Integer; const pUserData: Pointer): Integer; cdecl;
	PLib3MF_WriteCallback = function(const nByteData: QWord; const nNumBytes: QWord; const pUserData: Pointer): Integer; cdecl;
	PLib3MF_ReadCallback = function(const nByteData: QWord; const nNumBytes: QWord; const pUserData: Pointer): Integer; cdecl;
	PLib3MF_SeekCallback = function(const nPosition: QWord; const pUserData: Pointer): Integer; cdecl;
	PLib3MF_RandomNumberCallback = function(const nByteData: QWord; const nNumBytes: QWord; const pUserData: Pointer; out pBytesWritten: QWord): Integer; cdecl;
	PLib3MF_KeyWrappingCallback = function(const pKEKParams: TLib3MFHandle; const nInBufferCount: QWord; const nOutBufferCount: QWord; const pUserData: Pointer; out pStatus: QWord): Integer; cdecl;
	PLib3MF_ContentEncryptionCallback = function(const pCEKParams: TLib3MFHandle; const nInputCount: QWord; const nOutputCount: QWord; const pUserData: Pointer; out pStatus: QWord): Integer; cdecl;

(*************************************************************************************************************************
 Declaration of handle classes 
**************************************************************************************************************************)

type
	TLib3MFWrapper = class;
	TLib3MFBase = class;
	TLib3MFWriter = class;
	TLib3MFReader = class;
	TLib3MFPackagePart = class;
	TLib3MFResource = class;
	TLib3MFResourceIterator = class;
	TLib3MFSliceStackIterator = class;
	TLib3MFObjectIterator = class;
	TLib3MFMeshObjectIterator = class;
	TLib3MFComponentsObjectIterator = class;
	TLib3MFTexture2DIterator = class;
	TLib3MFBaseMaterialGroupIterator = class;
	TLib3MFColorGroupIterator = class;
	TLib3MFTexture2DGroupIterator = class;
	TLib3MFCompositeMaterialsIterator = class;
	TLib3MFMultiPropertyGroupIterator = class;
	TLib3MFMetaData = class;
	TLib3MFMetaDataGroup = class;
	TLib3MFObject = class;
	TLib3MFMeshObject = class;
	TLib3MFBeamLattice = class;
	TLib3MFComponent = class;
	TLib3MFComponentsObject = class;
	TLib3MFBeamSet = class;
	TLib3MFBaseMaterialGroup = class;
	TLib3MFColorGroup = class;
	TLib3MFTexture2DGroup = class;
	TLib3MFCompositeMaterials = class;
	TLib3MFMultiPropertyGroup = class;
	TLib3MFAttachment = class;
	TLib3MFTexture2D = class;
	TLib3MFBuildItem = class;
	TLib3MFBuildItemIterator = class;
	TLib3MFSlice = class;
	TLib3MFSliceStack = class;
	TLib3MFConsumer = class;
	TLib3MFAccessRight = class;
	TLib3MFContentEncryptionParams = class;
	TLib3MFResourceData = class;
	TLib3MFResourceDataGroup = class;
	TLib3MFKeyStore = class;
	TLib3MFModel = class;


(*************************************************************************************************************************
 Function type definitions for Base
**************************************************************************************************************************)

	(**
	* Get Class Type Id
	*
	* @param[in] pBase - Base instance.
	* @param[out] pClassTypeId - Class type as a 64 bits integer
	* @return error code or 0 (success)
	*)
	TLib3MFBase_ClassTypeIdFunc = function(pBase: TLib3MFHandle; out pClassTypeId: QWord): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Writer
**************************************************************************************************************************)

	(**
	* Writes out the model as file. The file type is specified by the Model Writer class.
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] pFilename - Filename to write into
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_WriteToFileFunc = function(pWriter: TLib3MFHandle; const pFilename: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the size of the full 3MF file stream.
	*
	* @param[in] pWriter - Writer instance.
	* @param[out] pStreamSize - the stream size
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_GetStreamSizeFunc = function(pWriter: TLib3MFHandle; out pStreamSize: QWord): TLib3MFResult; cdecl;
	
	(**
	* Writes out the 3MF file into a memory buffer
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] nBufferCount - Number of elements in buffer
	* @param[out] pBufferNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pBufferBuffer - uint8 buffer of buffer to write into
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_WriteToBufferFunc = function(pWriter: TLib3MFHandle; const nBufferCount: QWord; out pBufferNeededCount: QWord; pBufferBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] pTheWriteCallback - Callback to call for writing a data chunk
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream
	* @param[in] pUserData - Userdata that is passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_WriteToCallbackFunc = function(pWriter: TLib3MFHandle; const pTheWriteCallback: PLib3MF_WriteCallback; const pTheSeekCallback: PLib3MF_SeekCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Set the progress callback for calls to this writer
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] pProgressCallback - pointer to the callback function.
	* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_SetProgressCallbackFunc = function(pWriter: TLib3MFHandle; const pProgressCallback: PLib3MF_ProgressCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
	*
	* @param[in] pWriter - Writer instance.
	* @param[out] pDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_GetDecimalPrecisionFunc = function(pWriter: TLib3MFHandle; out pDecimalPrecision: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] nDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_SetDecimalPrecisionFunc = function(pWriter: TLib3MFHandle; const nDecimalPrecision: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Activates (deactivates) the strict mode of the reader.
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_SetStrictModeActiveFunc = function(pWriter: TLib3MFHandle; const bStrictModeActive: Byte): TLib3MFResult; cdecl;
	
	(**
	* Queries whether the strict mode of the reader is active or not
	*
	* @param[in] pWriter - Writer instance.
	* @param[out] pStrictModeActive - returns flag whether strict mode is active or not.
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_GetStrictModeActiveFunc = function(pWriter: TLib3MFHandle; out pStrictModeActive: Byte): TLib3MFResult; cdecl;
	
	(**
	* Returns Warning and Error Information of the read process
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] pErrorCode - filled with the error code of the warning
	* @param[in] nWarningBufferSize - size of the buffer (including trailing 0)
	* @param[out] pWarningNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pWarningBuffer -  buffer of the message of the warning, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_GetWarningFunc = function(pWriter: TLib3MFHandle; const nIndex: Cardinal; out pErrorCode: Cardinal; const nWarningBufferSize: Cardinal; out pWarningNeededChars: Cardinal; pWarningBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Returns Warning and Error Count of the read process
	*
	* @param[in] pWriter - Writer instance.
	* @param[out] pCount - filled with the count of the occurred warnings.
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_GetWarningCountFunc = function(pWriter: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Registers a callback to deal with data key encryption/decryption from keystore
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] pConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - The callback to be callede for wrapping and encryption key
	* @param[in] pUserData - Userdata that is passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_AddKeyWrappingCallbackFunc = function(pWriter: TLib3MFHandle; const pConsumerID: PAnsiChar; const pTheCallback: PLib3MF_KeyWrappingCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Registers a callback to deal with encryption of content
	*
	* @param[in] pWriter - Writer instance.
	* @param[in] pTheCallback - The callback used to encrypt content
	* @param[in] pUserData - Userdata that is passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFWriter_SetContentEncryptionCallbackFunc = function(pWriter: TLib3MFHandle; const pTheCallback: PLib3MF_ContentEncryptionCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Reader
**************************************************************************************************************************)

	(**
	* Reads a model from a file. The file type is specified by the Model Reader class
	*
	* @param[in] pReader - Reader instance.
	* @param[in] pFilename - Filename to read from
	* @return error code or 0 (success)
	*)
	TLib3MFReader_ReadFromFileFunc = function(pReader: TLib3MFHandle; const pFilename: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Reads a model from a memory buffer.
	*
	* @param[in] pReader - Reader instance.
	* @param[in] nBufferCount - Number of elements in buffer
	* @param[in] pBufferBuffer - uint8 buffer of Buffer to read from
	* @return error code or 0 (success)
	*)
	TLib3MFReader_ReadFromBufferFunc = function(pReader: TLib3MFHandle; const nBufferCount: QWord; const pBufferBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* Reads a model and from the data provided by a callback function
	*
	* @param[in] pReader - Reader instance.
	* @param[in] pTheReadCallback - Callback to call for reading a data chunk
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
	* @param[in] pUserData - Userdata that is passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFReader_ReadFromCallbackFunc = function(pReader: TLib3MFHandle; const pTheReadCallback: PLib3MF_ReadCallback; const nStreamSize: QWord; const pTheSeekCallback: PLib3MF_SeekCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Set the progress callback for calls to this writer
	*
	* @param[in] pReader - Reader instance.
	* @param[in] pProgressCallback - pointer to the callback function.
	* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
	* @return error code or 0 (success)
	*)
	TLib3MFReader_SetProgressCallbackFunc = function(pReader: TLib3MFHandle; const pProgressCallback: PLib3MF_ProgressCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Adds a relationship type which shall be read as attachment in memory while loading
	*
	* @param[in] pReader - Reader instance.
	* @param[in] pRelationShipType - String of the relationship type
	* @return error code or 0 (success)
	*)
	TLib3MFReader_AddRelationToReadFunc = function(pReader: TLib3MFHandle; const pRelationShipType: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Removes a relationship type which shall be read as attachment in memory while loading
	*
	* @param[in] pReader - Reader instance.
	* @param[in] pRelationShipType - String of the relationship type
	* @return error code or 0 (success)
	*)
	TLib3MFReader_RemoveRelationToReadFunc = function(pReader: TLib3MFHandle; const pRelationShipType: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Activates (deactivates) the strict mode of the reader.
	*
	* @param[in] pReader - Reader instance.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	* @return error code or 0 (success)
	*)
	TLib3MFReader_SetStrictModeActiveFunc = function(pReader: TLib3MFHandle; const bStrictModeActive: Byte): TLib3MFResult; cdecl;
	
	(**
	* Queries whether the strict mode of the reader is active or not
	*
	* @param[in] pReader - Reader instance.
	* @param[out] pStrictModeActive - returns flag whether strict mode is active or not.
	* @return error code or 0 (success)
	*)
	TLib3MFReader_GetStrictModeActiveFunc = function(pReader: TLib3MFHandle; out pStrictModeActive: Byte): TLib3MFResult; cdecl;
	
	(**
	* Returns Warning and Error Information of the read process
	*
	* @param[in] pReader - Reader instance.
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] pErrorCode - filled with the error code of the warning
	* @param[in] nWarningBufferSize - size of the buffer (including trailing 0)
	* @param[out] pWarningNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pWarningBuffer -  buffer of the message of the warning, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFReader_GetWarningFunc = function(pReader: TLib3MFHandle; const nIndex: Cardinal; out pErrorCode: Cardinal; const nWarningBufferSize: Cardinal; out pWarningNeededChars: Cardinal; pWarningBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Returns Warning and Error Count of the read process
	*
	* @param[in] pReader - Reader instance.
	* @param[out] pCount - filled with the count of the occurred warnings.
	* @return error code or 0 (success)
	*)
	TLib3MFReader_GetWarningCountFunc = function(pReader: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Registers a callback to deal with key wrapping mechanism from keystore
	*
	* @param[in] pReader - Reader instance.
	* @param[in] pConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - The callback used to decrypt data key
	* @param[in] pUserData - Userdata that is passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFReader_AddKeyWrappingCallbackFunc = function(pReader: TLib3MFHandle; const pConsumerID: PAnsiChar; const pTheCallback: PLib3MF_KeyWrappingCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Registers a callback to deal with encryption of content
	*
	* @param[in] pReader - Reader instance.
	* @param[in] pTheCallback - The callback used to encrypt content
	* @param[in] pUserData - Userdata that is passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFReader_SetContentEncryptionCallbackFunc = function(pReader: TLib3MFHandle; const pTheCallback: PLib3MF_ContentEncryptionCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for PackagePart
**************************************************************************************************************************)

	(**
	* Returns the absolute path of this PackagePart.
	*
	* @param[in] pPackagePart - PackagePart instance.
	* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
	* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pPathBuffer -  buffer of Returns the absolute path of this PackagePart, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFPackagePart_GetPathFunc = function(pPackagePart: TLib3MFHandle; const nPathBufferSize: Cardinal; out pPathNeededChars: Cardinal; pPathBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets the absolute path of this PackagePart.
	*
	* @param[in] pPackagePart - PackagePart instance.
	* @param[in] pPath - Sets the absolute path of this PackagePart.
	* @return error code or 0 (success)
	*)
	TLib3MFPackagePart_SetPathFunc = function(pPackagePart: TLib3MFHandle; const pPath: PAnsiChar): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Resource
**************************************************************************************************************************)

	(**
	* Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
	*
	* @param[in] pResource - Resource instance.
	* @param[out] pUniqueResourceID - Retrieves the unique id of this resource within a package.
	* @return error code or 0 (success)
	*)
	TLib3MFResource_GetResourceIDFunc = function(pResource: TLib3MFHandle; out pUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the unique id of this resource within a package.
	*
	* @param[in] pResource - Resource instance.
	* @param[out] pUniqueResourceID - Retrieves the unique id of this resource within a package.
	* @return error code or 0 (success)
	*)
	TLib3MFResource_GetUniqueResourceIDFunc = function(pResource: TLib3MFHandle; out pUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns the PackagePart within which this resource resides
	*
	* @param[in] pResource - Resource instance.
	* @param[out] pPackagePart - the PackagePart within which this resource resides.
	* @return error code or 0 (success)
	*)
	TLib3MFResource_PackagePartFunc = function(pResource: TLib3MFHandle; out pPackagePart: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Sets the new PackagePart within which this resource resides
	*
	* @param[in] pResource - Resource instance.
	* @param[in] pPackagePart - the new PackagePart within which this resource resides.
	* @return error code or 0 (success)
	*)
	TLib3MFResource_SetPackagePartFunc = function(pResource: TLib3MFHandle; const pPackagePart: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the id of this resource within a model.
	*
	* @param[in] pResource - Resource instance.
	* @param[out] pModelResourceId - Retrieves the id of this resource within a model.
	* @return error code or 0 (success)
	*)
	TLib3MFResource_GetModelResourceIDFunc = function(pResource: TLib3MFHandle; out pModelResourceId: Cardinal): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ResourceIterator
**************************************************************************************************************************)

	(**
	* Iterates to the next resource in the list.
	*
	* @param[in] pResourceIterator - ResourceIterator instance.
	* @param[out] pHasNext - Iterates to the next resource in the list.
	* @return error code or 0 (success)
	*)
	TLib3MFResourceIterator_MoveNextFunc = function(pResourceIterator: TLib3MFHandle; out pHasNext: Byte): TLib3MFResult; cdecl;
	
	(**
	* Iterates to the previous resource in the list.
	*
	* @param[in] pResourceIterator - ResourceIterator instance.
	* @param[out] pHasPrevious - Iterates to the previous resource in the list.
	* @return error code or 0 (success)
	*)
	TLib3MFResourceIterator_MovePreviousFunc = function(pResourceIterator: TLib3MFHandle; out pHasPrevious: Byte): TLib3MFResult; cdecl;
	
	(**
	* Returns the resource the iterator points at.
	*
	* @param[in] pResourceIterator - ResourceIterator instance.
	* @param[out] pResource - returns the resource instance.
	* @return error code or 0 (success)
	*)
	TLib3MFResourceIterator_GetCurrentFunc = function(pResourceIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Creates a new resource iterator with the same resource list.
	*
	* @param[in] pResourceIterator - ResourceIterator instance.
	* @param[out] pOutResourceIterator - returns the cloned Iterator instance
	* @return error code or 0 (success)
	*)
	TLib3MFResourceIterator_CloneFunc = function(pResourceIterator: TLib3MFHandle; out pOutResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the number of resoucres the iterator captures.
	*
	* @param[in] pResourceIterator - ResourceIterator instance.
	* @param[out] pCount - returns the number of resoucres the iterator captures.
	* @return error code or 0 (success)
	*)
	TLib3MFResourceIterator_CountFunc = function(pResourceIterator: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for SliceStackIterator
**************************************************************************************************************************)

	(**
	* Returns the SliceStack the iterator points at.
	*
	* @param[in] pSliceStackIterator - SliceStackIterator instance.
	* @param[out] pResource - returns the SliceStack instance.
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStackIterator_GetCurrentSliceStackFunc = function(pSliceStackIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ObjectIterator
**************************************************************************************************************************)

	(**
	* Returns the Object the iterator points at.
	*
	* @param[in] pObjectIterator - ObjectIterator instance.
	* @param[out] pResource - returns the Object instance.
	* @return error code or 0 (success)
	*)
	TLib3MFObjectIterator_GetCurrentObjectFunc = function(pObjectIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for MeshObjectIterator
**************************************************************************************************************************)

	(**
	* Returns the MeshObject the iterator points at.
	*
	* @param[in] pMeshObjectIterator - MeshObjectIterator instance.
	* @param[out] pResource - returns the MeshObject instance.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObjectIterator_GetCurrentMeshObjectFunc = function(pMeshObjectIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ComponentsObjectIterator
**************************************************************************************************************************)

	(**
	* Returns the ComponentsObject the iterator points at.
	*
	* @param[in] pComponentsObjectIterator - ComponentsObjectIterator instance.
	* @param[out] pResource - returns the ComponentsObject instance.
	* @return error code or 0 (success)
	*)
	TLib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc = function(pComponentsObjectIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Texture2DIterator
**************************************************************************************************************************)

	(**
	* Returns the Texture2D the iterator points at.
	*
	* @param[in] pTexture2DIterator - Texture2DIterator instance.
	* @param[out] pResource - returns the Texture2D instance.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DIterator_GetCurrentTexture2DFunc = function(pTexture2DIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for BaseMaterialGroupIterator
**************************************************************************************************************************)

	(**
	* Returns the MaterialGroup the iterator points at.
	*
	* @param[in] pBaseMaterialGroupIterator - BaseMaterialGroupIterator instance.
	* @param[out] pResource - returns the BaseMaterialGroup instance.
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc = function(pBaseMaterialGroupIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ColorGroupIterator
**************************************************************************************************************************)

	(**
	* Returns the ColorGroup the iterator points at.
	*
	* @param[in] pColorGroupIterator - ColorGroupIterator instance.
	* @param[out] pResource - returns the ColorGroup instance.
	* @return error code or 0 (success)
	*)
	TLib3MFColorGroupIterator_GetCurrentColorGroupFunc = function(pColorGroupIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Texture2DGroupIterator
**************************************************************************************************************************)

	(**
	* Returns the Texture2DGroup the iterator points at.
	*
	* @param[in] pTexture2DGroupIterator - Texture2DGroupIterator instance.
	* @param[out] pResource - returns the Texture2DGroup instance.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc = function(pTexture2DGroupIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for CompositeMaterialsIterator
**************************************************************************************************************************)

	(**
	* Returns the CompositeMaterials the iterator points at.
	*
	* @param[in] pCompositeMaterialsIterator - CompositeMaterialsIterator instance.
	* @param[out] pResource - returns the CompositeMaterials instance.
	* @return error code or 0 (success)
	*)
	TLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc = function(pCompositeMaterialsIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for MultiPropertyGroupIterator
**************************************************************************************************************************)

	(**
	* Returns the MultiPropertyGroup the iterator points at.
	*
	* @param[in] pMultiPropertyGroupIterator - MultiPropertyGroupIterator instance.
	* @param[out] pResource - returns the MultiPropertyGroup instance.
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc = function(pMultiPropertyGroupIterator: TLib3MFHandle; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for MetaData
**************************************************************************************************************************)

	(**
	* returns the namespace URL of the metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] nNameSpaceBufferSize - size of the buffer (including trailing 0)
	* @param[out] pNameSpaceNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pNameSpaceBuffer -  buffer of the namespace URL of the metadata, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_GetNameSpaceFunc = function(pMetaData: TLib3MFHandle; const nNameSpaceBufferSize: Cardinal; out pNameSpaceNeededChars: Cardinal; pNameSpaceBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets a new namespace URL of the metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] pNameSpace - the new namespace URL of the metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_SetNameSpaceFunc = function(pMetaData: TLib3MFHandle; const pNameSpace: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* returns the name of a metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
	* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pNameBuffer -  buffer of the name of the metadata, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_GetNameFunc = function(pMetaData: TLib3MFHandle; const nNameBufferSize: Cardinal; out pNameNeededChars: Cardinal; pNameBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets a new name of a metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] pName - the new name of the metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_SetNameFunc = function(pMetaData: TLib3MFHandle; const pName: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* returns the (namespace+name) of a metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] nKeyBufferSize - size of the buffer (including trailing 0)
	* @param[out] pKeyNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pKeyBuffer -  buffer of the key (namespace+name) of the metadata, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_GetKeyFunc = function(pMetaData: TLib3MFHandle; const nKeyBufferSize: Cardinal; out pKeyNeededChars: Cardinal; pKeyBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* returns, whether a metadata must be preserved
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[out] pMustPreserve - returns, whether a metadata must be preserved
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_GetMustPreserveFunc = function(pMetaData: TLib3MFHandle; out pMustPreserve: Byte): TLib3MFResult; cdecl;
	
	(**
	* sets whether a metadata must be preserved
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] bMustPreserve - a new value whether a metadata must be preserved
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_SetMustPreserveFunc = function(pMetaData: TLib3MFHandle; const bMustPreserve: Byte): TLib3MFResult; cdecl;
	
	(**
	* returns the type of a metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] nTypeBufferSize - size of the buffer (including trailing 0)
	* @param[out] pTypeNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pTypeBuffer -  buffer of the type of the metadata, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_GetTypeFunc = function(pMetaData: TLib3MFHandle; const nTypeBufferSize: Cardinal; out pTypeNeededChars: Cardinal; pTypeBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets a new type of a metadata. This must be a simple XML type
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] pType - a new type of the metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_SetTypeFunc = function(pMetaData: TLib3MFHandle; const pType: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* returns the value of the metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] nValueBufferSize - size of the buffer (including trailing 0)
	* @param[out] pValueNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pValueBuffer -  buffer of the value of the metadata, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_GetValueFunc = function(pMetaData: TLib3MFHandle; const nValueBufferSize: Cardinal; out pValueNeededChars: Cardinal; pValueBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets a new value of the metadata
	*
	* @param[in] pMetaData - MetaData instance.
	* @param[in] pValue - a new value of the metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaData_SetValueFunc = function(pMetaData: TLib3MFHandle; const pValue: PAnsiChar): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for MetaDataGroup
**************************************************************************************************************************)

	(**
	* returns the number of metadata in this metadatagroup
	*
	* @param[in] pMetaDataGroup - MetaDataGroup instance.
	* @param[out] pCount - returns the number metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaDataGroup_GetMetaDataCountFunc = function(pMetaDataGroup: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* returns a metadata value within this metadatagroup
	*
	* @param[in] pMetaDataGroup - MetaDataGroup instance.
	* @param[in] nIndex - Index of the Metadata.
	* @param[out] pMetaData - an instance of the metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaDataGroup_GetMetaDataFunc = function(pMetaDataGroup: TLib3MFHandle; const nIndex: Cardinal; out pMetaData: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* returns a metadata value within this metadatagroup
	*
	* @param[in] pMetaDataGroup - MetaDataGroup instance.
	* @param[in] pNameSpace - the namespace of the metadata
	* @param[in] pName - the name of the Metadata
	* @param[out] pMetaData - an instance of the metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaDataGroup_GetMetaDataByKeyFunc = function(pMetaDataGroup: TLib3MFHandle; const pNameSpace: PAnsiChar; const pName: PAnsiChar; out pMetaData: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* removes metadata by index from the model.
	*
	* @param[in] pMetaDataGroup - MetaDataGroup instance.
	* @param[in] nIndex -  Index of the metadata to remove
	* @return error code or 0 (success)
	*)
	TLib3MFMetaDataGroup_RemoveMetaDataByIndexFunc = function(pMetaDataGroup: TLib3MFHandle; const nIndex: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* removes metadata from the model.
	*
	* @param[in] pMetaDataGroup - MetaDataGroup instance.
	* @param[in] pTheMetaData - The metadata to remove
	* @return error code or 0 (success)
	*)
	TLib3MFMetaDataGroup_RemoveMetaDataFunc = function(pMetaDataGroup: TLib3MFHandle; const pTheMetaData: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds a new metadata to this metadatagroup
	*
	* @param[in] pMetaDataGroup - MetaDataGroup instance.
	* @param[in] pNameSpace - the namespace of the metadata
	* @param[in] pName - the name of the metadata
	* @param[in] pValue - the value of the metadata
	* @param[in] pType - the type of the metadata
	* @param[in] bMustPreserve - shuold the metadata be preserved
	* @param[out] pMetaData - a new instance of the metadata
	* @return error code or 0 (success)
	*)
	TLib3MFMetaDataGroup_AddMetaDataFunc = function(pMetaDataGroup: TLib3MFHandle; const pNameSpace: PAnsiChar; const pName: PAnsiChar; const pValue: PAnsiChar; const pType: PAnsiChar; const bMustPreserve: Byte; out pMetaData: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Object
**************************************************************************************************************************)

	(**
	* Retrieves an object's type
	*
	* @param[in] pObject - Object instance.
	* @param[out] pObjectType - returns object type enum.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetTypeFunc = function(pObject: TLib3MFHandle; out pObjectType: Integer): TLib3MFResult; cdecl;
	
	(**
	* Sets an object's type
	*
	* @param[in] pObject - Object instance.
	* @param[in] eObjectType - object type enum.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_SetTypeFunc = function(pObject: TLib3MFHandle; const eObjectType: Integer): TLib3MFResult; cdecl;
	
	(**
	* Retrieves an object's name
	*
	* @param[in] pObject - Object instance.
	* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
	* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pNameBuffer -  buffer of returns object name., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetNameFunc = function(pObject: TLib3MFHandle; const nNameBufferSize: Cardinal; out pNameNeededChars: Cardinal; pNameBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets an object's name string
	*
	* @param[in] pObject - Object instance.
	* @param[in] pName - new object name.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_SetNameFunc = function(pObject: TLib3MFHandle; const pName: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves an object's part number
	*
	* @param[in] pObject - Object instance.
	* @param[in] nPartNumberBufferSize - size of the buffer (including trailing 0)
	* @param[out] pPartNumberNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pPartNumberBuffer -  buffer of returns object part number., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetPartNumberFunc = function(pObject: TLib3MFHandle; const nPartNumberBufferSize: Cardinal; out pPartNumberNeededChars: Cardinal; pPartNumberBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets an objects partnumber string
	*
	* @param[in] pObject - Object instance.
	* @param[in] pPartNumber - new object part number.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_SetPartNumberFunc = function(pObject: TLib3MFHandle; const pPartNumber: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves, if an object is a mesh object
	*
	* @param[in] pObject - Object instance.
	* @param[out] pIsMeshObject - returns, whether the object is a mesh object
	* @return error code or 0 (success)
	*)
	TLib3MFObject_IsMeshObjectFunc = function(pObject: TLib3MFHandle; out pIsMeshObject: Byte): TLib3MFResult; cdecl;
	
	(**
	* Retrieves, if an object is a components object
	*
	* @param[in] pObject - Object instance.
	* @param[out] pIsComponentsObject - returns, whether the object is a components object
	* @return error code or 0 (success)
	*)
	TLib3MFObject_IsComponentsObjectFunc = function(pObject: TLib3MFHandle; out pIsComponentsObject: Byte): TLib3MFResult; cdecl;
	
	(**
	* Retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
	*
	* @param[in] pObject - Object instance.
	* @param[out] pIsValid - returns whether the object is a valid object description
	* @return error code or 0 (success)
	*)
	TLib3MFObject_IsValidFunc = function(pObject: TLib3MFHandle; out pIsValid: Byte): TLib3MFResult; cdecl;
	
	(**
	* Use an existing attachment as thumbnail for this object
	*
	* @param[in] pObject - Object instance.
	* @param[in] pAttachment - Instance of a new or the existing thumbnailattachment object.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_SetAttachmentAsThumbnailFunc = function(pObject: TLib3MFHandle; const pAttachment: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Get the attachment containing the object thumbnail.
	*
	* @param[in] pObject - Object instance.
	* @param[out] pAttachment - Instance of the thumbnailattachment object or NULL.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetThumbnailAttachmentFunc = function(pObject: TLib3MFHandle; out pAttachment: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Clears the attachment. The attachment instance is not removed from the package.
	*
	* @param[in] pObject - Object instance.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_ClearThumbnailAttachmentFunc = function(pObject: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the outbox of a build item
	*
	* @param[in] pObject - Object instance.
	* @param[out] pOutbox - Outbox of this build item
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetOutboxFunc = function(pObject: TLib3MFHandle; pOutbox: PLib3MFBox): TLib3MFResult; cdecl;
	
	(**
	* Retrieves an object's uuid string (see production extension specification)
	*
	* @param[in] pObject - Object instance.
	* @param[out] pHasUUID - flag whether the build item has a UUID
	* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pUUIDBuffer -  buffer of returns object uuid., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetUUIDFunc = function(pObject: TLib3MFHandle; out pHasUUID: Byte; const nUUIDBufferSize: Cardinal; out pUUIDNeededChars: Cardinal; pUUIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets a build object's uuid string (see production extension specification)
	*
	* @param[in] pObject - Object instance.
	* @param[in] pUUID - new object uuid string.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_SetUUIDFunc = function(pObject: TLib3MFHandle; const pUUID: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Returns the metadatagroup of this object
	*
	* @param[in] pObject - Object instance.
	* @param[out] pMetaDataGroup - returns an Instance of the metadatagroup of this object
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetMetaDataGroupFunc = function(pObject: TLib3MFHandle; out pMetaDataGroup: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* set the meshresolution of the mesh object
	*
	* @param[in] pObject - Object instance.
	* @param[in] eMeshResolution - meshresolution of this object
	* @return error code or 0 (success)
	*)
	TLib3MFObject_SetSlicesMeshResolutionFunc = function(pObject: TLib3MFHandle; const eMeshResolution: Integer): TLib3MFResult; cdecl;
	
	(**
	* get the meshresolution of the mesh object
	*
	* @param[in] pObject - Object instance.
	* @param[out] pMeshResolution - meshresolution of this object
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetSlicesMeshResolutionFunc = function(pObject: TLib3MFHandle; out pMeshResolution: Integer): TLib3MFResult; cdecl;
	
	(**
	* returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack
	*
	* @param[in] pObject - Object instance.
	* @param[in] bRecursive - check also all referenced objects?
	* @param[out] pHasSlices - does the object have a slice stack?
	* @return error code or 0 (success)
	*)
	TLib3MFObject_HasSlicesFunc = function(pObject: TLib3MFHandle; const bRecursive: Byte; out pHasSlices: Byte): TLib3MFResult; cdecl;
	
	(**
	* unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
	*
	* @param[in] pObject - Object instance.
	* @return error code or 0 (success)
	*)
	TLib3MFObject_ClearSliceStackFunc = function(pObject: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* get the Slicestack attached to the object
	*
	* @param[in] pObject - Object instance.
	* @param[out] pSliceStackInstance - returns the slicestack instance
	* @return error code or 0 (success)
	*)
	TLib3MFObject_GetSliceStackFunc = function(pObject: TLib3MFHandle; out pSliceStackInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* assigns a slicestack to the object
	*
	* @param[in] pObject - Object instance.
	* @param[in] pSliceStackInstance - the new slice stack of this Object
	* @return error code or 0 (success)
	*)
	TLib3MFObject_AssignSliceStackFunc = function(pObject: TLib3MFHandle; const pSliceStackInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for MeshObject
**************************************************************************************************************************)

	(**
	* Returns the vertex count of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[out] pVertexCount - filled with the vertex count.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetVertexCountFunc = function(pMeshObject: TLib3MFHandle; out pVertexCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns the triangle count of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[out] pVertexCount - filled with the triangle count.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetTriangleCountFunc = function(pMeshObject: TLib3MFHandle; out pVertexCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns the vertex count of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @param[out] pCoordinates - filled with the vertex coordinates.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetVertexFunc = function(pMeshObject: TLib3MFHandle; const nIndex: Cardinal; pCoordinates: PLib3MFPosition): TLib3MFResult; cdecl;
	
	(**
	* Sets the coordinates of a single vertex of a mesh object
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @param[in] pCoordinates - contains the vertex coordinates.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_SetVertexFunc = function(pMeshObject: TLib3MFHandle; const nIndex: Cardinal; const pCoordinates: PLib3MFPosition): TLib3MFResult; cdecl;
	
	(**
	* Adds a single vertex to a mesh object
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] pCoordinates - contains the vertex coordinates.
	* @param[out] pNewIndex - Index of the new vertex
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_AddVertexFunc = function(pMeshObject: TLib3MFHandle; const pCoordinates: PLib3MFPosition; out pNewIndex: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Obtains all vertex positions of a mesh object
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nVerticesCount - Number of elements in buffer
	* @param[out] pVerticesNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pVerticesBuffer - Position buffer of contains the vertex coordinates.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetVerticesFunc = function(pMeshObject: TLib3MFHandle; const nVerticesCount: QWord; out pVerticesNeededCount: QWord; pVerticesBuffer: PLib3MFPosition): TLib3MFResult; cdecl;
	
	(**
	* Returns indices of a single triangle of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[out] pIndices - filled with the triangle indices.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetTriangleFunc = function(pMeshObject: TLib3MFHandle; const nIndex: Cardinal; pIndices: PLib3MFTriangle): TLib3MFResult; cdecl;
	
	(**
	* Sets the indices of a single triangle of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] pIndices - contains the triangle indices.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_SetTriangleFunc = function(pMeshObject: TLib3MFHandle; const nIndex: Cardinal; const pIndices: PLib3MFTriangle): TLib3MFResult; cdecl;
	
	(**
	* Adds a single triangle to a mesh object
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] pIndices - contains the triangle indices.
	* @param[out] pNewIndex - Index of the new triangle
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_AddTriangleFunc = function(pMeshObject: TLib3MFHandle; const pIndices: PLib3MFTriangle; out pNewIndex: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Get all triangles of a mesh object
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nIndicesCount - Number of elements in buffer
	* @param[out] pIndicesNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pIndicesBuffer - Triangle buffer of contains the triangle indices.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetTriangleIndicesFunc = function(pMeshObject: TLib3MFHandle; const nIndicesCount: QWord; out pIndicesNeededCount: QWord; pIndicesBuffer: PLib3MFTriangle): TLib3MFResult; cdecl;
	
	(**
	* Sets the property at the object-level of the mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[in] nPropertyID - the object-level PropertyID.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_SetObjectLevelPropertyFunc = function(pMeshObject: TLib3MFHandle; const nUniqueResourceID: Cardinal; const nPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Gets the property at the object-level of the mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[out] pUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[out] pPropertyID - the object-level PropertyID.
	* @param[out] pHasObjectLevelProperty - Has an object-level property been specified?
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetObjectLevelPropertyFunc = function(pMeshObject: TLib3MFHandle; out pUniqueResourceID: Cardinal; out pPropertyID: Cardinal; out pHasObjectLevelProperty: Byte): TLib3MFResult; cdecl;
	
	(**
	* Sets the properties of a single triangle of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] pProperties - contains the triangle properties.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_SetTrianglePropertiesFunc = function(pMeshObject: TLib3MFHandle; const nIndex: Cardinal; const pProperties: PLib3MFTriangleProperties): TLib3MFResult; cdecl;
	
	(**
	* Gets the properties of a single triangle of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[out] pProperty - returns the triangle properties.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetTrianglePropertiesFunc = function(pMeshObject: TLib3MFHandle; const nIndex: Cardinal; pProperty: PLib3MFTriangleProperties): TLib3MFResult; cdecl;
	
	(**
	* Sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nPropertiesArrayCount - Number of elements in buffer
	* @param[in] pPropertiesArrayBuffer - TriangleProperties buffer of contains the triangle properties array. Must have trianglecount elements.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_SetAllTrianglePropertiesFunc = function(pMeshObject: TLib3MFHandle; const nPropertiesArrayCount: QWord; const pPropertiesArrayBuffer: PLib3MFTriangleProperties): TLib3MFResult; cdecl;
	
	(**
	* Gets the properties of all triangles of a mesh object.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nPropertiesArrayCount - Number of elements in buffer
	* @param[out] pPropertiesArrayNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pPropertiesArrayBuffer - TriangleProperties buffer of returns the triangle properties array. Must have trianglecount elements.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_GetAllTrianglePropertiesFunc = function(pMeshObject: TLib3MFHandle; const nPropertiesArrayCount: QWord; out pPropertiesArrayNeededCount: QWord; pPropertiesArrayBuffer: PLib3MFTriangleProperties): TLib3MFResult; cdecl;
	
	(**
	* Clears all properties of this mesh object (triangle and object-level).
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_ClearAllPropertiesFunc = function(pMeshObject: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Set all triangles of a mesh object
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[in] nVerticesCount - Number of elements in buffer
	* @param[in] pVerticesBuffer - Position buffer of contains the positions.
	* @param[in] nIndicesCount - Number of elements in buffer
	* @param[in] pIndicesBuffer - Triangle buffer of contains the triangle indices.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_SetGeometryFunc = function(pMeshObject: TLib3MFHandle; const nVerticesCount: QWord; const pVerticesBuffer: PLib3MFPosition; const nIndicesCount: QWord; const pIndicesBuffer: PLib3MFTriangle): TLib3MFResult; cdecl;
	
	(**
	* Retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[out] pIsManifoldAndOriented - returns, if the object is oriented and manifold.
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_IsManifoldAndOrientedFunc = function(pMeshObject: TLib3MFHandle; out pIsManifoldAndOriented: Byte): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the BeamLattice within this MeshObject.
	*
	* @param[in] pMeshObject - MeshObject instance.
	* @param[out] pTheBeamLattice - the BeamLattice within this MeshObject
	* @return error code or 0 (success)
	*)
	TLib3MFMeshObject_BeamLatticeFunc = function(pMeshObject: TLib3MFHandle; out pTheBeamLattice: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for BeamLattice
**************************************************************************************************************************)

	(**
	* Returns the minimal length of beams for the beamlattice.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pMinLength - minimal length of beams for the beamlattice
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetMinLengthFunc = function(pBeamLattice: TLib3MFHandle; out pMinLength: Double): TLib3MFResult; cdecl;
	
	(**
	* Sets the minimal length of beams for the beamlattice.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] dMinLength - minimal length of beams for the beamlattice
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetMinLengthFunc = function(pBeamLattice: TLib3MFHandle; const dMinLength: Double): TLib3MFResult; cdecl;
	
	(**
	* Returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pClipMode - contains the clip mode of this mesh
	* @param[out] pUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object or an undefined value if pClipMode is MODELBEAMLATTICECLIPMODE_NONE
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetClippingFunc = function(pBeamLattice: TLib3MFHandle; out pClipMode: Integer; out pUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] eClipMode - contains the clip mode of this mesh
	* @param[in] nUniqueResourceID - the UniqueResourceID of the clipping mesh-object. This mesh-object has to be defined before setting the Clipping.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetClippingFunc = function(pBeamLattice: TLib3MFHandle; const eClipMode: Integer; const nUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns the representation-mesh for the beamlattice of this mesh.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pHasRepresentation - flag whether the beamlattice has a representation mesh.
	* @param[out] pUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetRepresentationFunc = function(pBeamLattice: TLib3MFHandle; out pHasRepresentation: Byte; out pUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the representation-mesh for the beamlattice of this mesh.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nUniqueResourceID - the UniqueResourceID of the representation mesh-object. This mesh-object has to be defined before setting the representation.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetRepresentationFunc = function(pBeamLattice: TLib3MFHandle; const nUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns the ball mode and the default ball radius for the beamlattice of this mesh.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pBallMode - contains the ball mode of this mesh
	* @param[out] pBallRadius - default ball radius of balls for the beamlattice
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBallOptionsFunc = function(pBeamLattice: TLib3MFHandle; out pBallMode: Integer; out pBallRadius: Double): TLib3MFResult; cdecl;
	
	(**
	* Sets the ball mode and thedefault ball radius for the beamlattice.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] eBallMode - contains the ball mode of this mesh
	* @param[in] dBallRadius - default ball radius of balls for the beamlattice
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetBallOptionsFunc = function(pBeamLattice: TLib3MFHandle; const eBallMode: Integer; const dBallRadius: Double): TLib3MFResult; cdecl;
	
	(**
	* Returns the beam count of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pCount - filled with the beam count.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBeamCountFunc = function(pBeamLattice: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns indices, radii and capmodes of a single beam of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @param[out] pBeamInfo - filled with the beam indices, radii and capmodes.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBeamFunc = function(pBeamLattice: TLib3MFHandle; const nIndex: Cardinal; pBeamInfo: PLib3MFBeam): TLib3MFResult; cdecl;
	
	(**
	* Adds a single beam to a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] pBeamInfo - contains the node indices, radii and capmodes.
	* @param[out] pIndex - filled with the new Index of the beam.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_AddBeamFunc = function(pBeamLattice: TLib3MFHandle; const pBeamInfo: PLib3MFBeam; out pIndex: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the indices, radii and capmodes of a single beam of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @param[in] pBeamInfo - filled with the beam indices, radii and capmodes.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetBeamFunc = function(pBeamLattice: TLib3MFHandle; const nIndex: Cardinal; const pBeamInfo: PLib3MFBeam): TLib3MFResult; cdecl;
	
	(**
	* Sets all beam indices, radii and capmodes of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nBeamInfoCount - Number of elements in buffer
	* @param[in] pBeamInfoBuffer - Beam buffer of contains information of a number of  beams
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetBeamsFunc = function(pBeamLattice: TLib3MFHandle; const nBeamInfoCount: QWord; const pBeamInfoBuffer: PLib3MFBeam): TLib3MFResult; cdecl;
	
	(**
	* obtains all beam indices, radii and capmodes of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nBeamInfoCount - Number of elements in buffer
	* @param[out] pBeamInfoNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pBeamInfoBuffer - Beam buffer of contains information of all beams
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBeamsFunc = function(pBeamLattice: TLib3MFHandle; const nBeamInfoCount: QWord; out pBeamInfoNeededCount: QWord; pBeamInfoBuffer: PLib3MFBeam): TLib3MFResult; cdecl;
	
	(**
	* Returns the ball count of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pCount - filled with the ball count.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBallCountFunc = function(pBeamLattice: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns index and radius of a single ball of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @param[out] pBallInfo - filled with the ball node index and radius.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBallFunc = function(pBeamLattice: TLib3MFHandle; const nIndex: Cardinal; pBallInfo: PLib3MFBall): TLib3MFResult; cdecl;
	
	(**
	* Adds a single ball to a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] pBallInfo - contains the node index and radius.
	* @param[out] pIndex - filled with the new Index of the ball.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_AddBallFunc = function(pBeamLattice: TLib3MFHandle; const pBallInfo: PLib3MFBall; out pIndex: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the index and radius of a single ball of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @param[in] pBallInfo - filled with the ball node index and radius.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetBallFunc = function(pBeamLattice: TLib3MFHandle; const nIndex: Cardinal; const pBallInfo: PLib3MFBall): TLib3MFResult; cdecl;
	
	(**
	* Sets all ball indices and radii of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nBallInfoCount - Number of elements in buffer
	* @param[in] pBallInfoBuffer - Ball buffer of contains information of a number of  balls
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_SetBallsFunc = function(pBeamLattice: TLib3MFHandle; const nBallInfoCount: QWord; const pBallInfoBuffer: PLib3MFBall): TLib3MFResult; cdecl;
	
	(**
	* obtains all ball indices and radii of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nBallInfoCount - Number of elements in buffer
	* @param[out] pBallInfoNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pBallInfoBuffer - Ball buffer of contains information of all balls
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBallsFunc = function(pBeamLattice: TLib3MFHandle; const nBallInfoCount: QWord; out pBallInfoNeededCount: QWord; pBallInfoBuffer: PLib3MFBall): TLib3MFResult; cdecl;
	
	(**
	* Returns the number of beamsets of a mesh object.
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pCount - filled with the beamset count.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBeamSetCountFunc = function(pBeamLattice: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Adds an empty beamset to a mesh object
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[out] pBeamSet - the new beamset
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_AddBeamSetFunc = function(pBeamLattice: TLib3MFHandle; out pBeamSet: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns a beamset of a mesh object
	*
	* @param[in] pBeamLattice - BeamLattice instance.
	* @param[in] nIndex - index of the requested beamset (0 ... beamsetcount-1).
	* @param[out] pBeamSet - the requested beamset
	* @return error code or 0 (success)
	*)
	TLib3MFBeamLattice_GetBeamSetFunc = function(pBeamLattice: TLib3MFHandle; const nIndex: Cardinal; out pBeamSet: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Component
**************************************************************************************************************************)

	(**
	* Returns the Resource Instance of the component.
	*
	* @param[in] pComponent - Component instance.
	* @param[out] pObjectResource - filled with the Resource Instance.
	* @return error code or 0 (success)
	*)
	TLib3MFComponent_GetObjectResourceFunc = function(pComponent: TLib3MFHandle; out pObjectResource: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the UniqueResourceID of the component.
	*
	* @param[in] pComponent - Component instance.
	* @param[out] pUniqueResourceID - returns the UniqueResourceID.
	* @return error code or 0 (success)
	*)
	TLib3MFComponent_GetObjectResourceIDFunc = function(pComponent: TLib3MFHandle; out pUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* returns, whether a component has a UUID and, if true, the component's UUID
	*
	* @param[in] pComponent - Component instance.
	* @param[out] pHasUUID - flag whether the component has a UUID
	* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFComponent_GetUUIDFunc = function(pComponent: TLib3MFHandle; out pHasUUID: Byte; const nUUIDBufferSize: Cardinal; out pUUIDNeededChars: Cardinal; pUUIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets the component's UUID
	*
	* @param[in] pComponent - Component instance.
	* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	* @return error code or 0 (success)
	*)
	TLib3MFComponent_SetUUIDFunc = function(pComponent: TLib3MFHandle; const pUUID: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Returns, if the component has a different transformation than the identity matrix
	*
	* @param[in] pComponent - Component instance.
	* @param[out] pHasTransform - if true is returned, the transformation is not equal than the identity
	* @return error code or 0 (success)
	*)
	TLib3MFComponent_HasTransformFunc = function(pComponent: TLib3MFHandle; out pHasTransform: Byte): TLib3MFResult; cdecl;
	
	(**
	* Returns the transformation matrix of the component.
	*
	* @param[in] pComponent - Component instance.
	* @param[out] pTransform - filled with the component transformation matrix
	* @return error code or 0 (success)
	*)
	TLib3MFComponent_GetTransformFunc = function(pComponent: TLib3MFHandle; pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	
	(**
	* Sets the transformation matrix of the component.
	*
	* @param[in] pComponent - Component instance.
	* @param[in] pTransform - new transformation matrix
	* @return error code or 0 (success)
	*)
	TLib3MFComponent_SetTransformFunc = function(pComponent: TLib3MFHandle; const pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ComponentsObject
**************************************************************************************************************************)

	(**
	* Adds a new component to a components object.
	*
	* @param[in] pComponentsObject - ComponentsObject instance.
	* @param[in] pObjectResource - object to add as component. Must not lead to circular references!
	* @param[in] pTransform - optional transform matrix for the component.
	* @param[out] pComponentInstance - new component instance
	* @return error code or 0 (success)
	*)
	TLib3MFComponentsObject_AddComponentFunc = function(pComponentsObject: TLib3MFHandle; const pObjectResource: TLib3MFHandle; const pTransform: PLib3MFTransform; out pComponentInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a component from a component object.
	*
	* @param[in] pComponentsObject - ComponentsObject instance.
	* @param[in] nIndex - index of the component to retrieve (0 to componentcount - 1)
	* @param[out] pComponentInstance - component instance
	* @return error code or 0 (success)
	*)
	TLib3MFComponentsObject_GetComponentFunc = function(pComponentsObject: TLib3MFHandle; const nIndex: Cardinal; out pComponentInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a component count of a component object.
	*
	* @param[in] pComponentsObject - ComponentsObject instance.
	* @param[out] pCount - returns the component count
	* @return error code or 0 (success)
	*)
	TLib3MFComponentsObject_GetComponentCountFunc = function(pComponentsObject: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for BeamSet
**************************************************************************************************************************)

	(**
	* Sets a beamset's name string
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] pName - new name of the beamset.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_SetNameFunc = function(pBeamSet: TLib3MFHandle; const pName: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a beamset's name string
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
	* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pNameBuffer -  buffer of returns the name of the beamset., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_GetNameFunc = function(pBeamSet: TLib3MFHandle; const nNameBufferSize: Cardinal; out pNameNeededChars: Cardinal; pNameBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets a beamset's identifier string
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] pIdentifier - new name of the beamset.
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_SetIdentifierFunc = function(pBeamSet: TLib3MFHandle; const pIdentifier: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a beamset's identifier string
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] nIdentifierBufferSize - size of the buffer (including trailing 0)
	* @param[out] pIdentifierNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pIdentifierBuffer -  buffer of returns the identifier of the beamset., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_GetIdentifierFunc = function(pBeamSet: TLib3MFHandle; const nIdentifierBufferSize: Cardinal; out pIdentifierNeededChars: Cardinal; pIdentifierBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the reference count of a beamset
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[out] pCount - returns the reference count
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_GetReferenceCountFunc = function(pBeamSet: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the references of a beamset
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] nReferencesCount - Number of elements in buffer
	* @param[in] pReferencesBuffer - uint32 buffer of the new indices of all beams in this beamset
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_SetReferencesFunc = function(pBeamSet: TLib3MFHandle; const nReferencesCount: QWord; const pReferencesBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the references of a beamset
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] nReferencesCount - Number of elements in buffer
	* @param[out] pReferencesNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pReferencesBuffer - uint32 buffer of retrieves the indices of all beams in this beamset
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_GetReferencesFunc = function(pBeamSet: TLib3MFHandle; const nReferencesCount: QWord; out pReferencesNeededCount: QWord; pReferencesBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the ball reference count of a beamset
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[out] pCount - returns the ball reference count
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_GetBallReferenceCountFunc = function(pBeamSet: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the ball references of a beamset
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] nBallReferencesCount - Number of elements in buffer
	* @param[in] pBallReferencesBuffer - uint32 buffer of the new indices of all balls in this beamset
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_SetBallReferencesFunc = function(pBeamSet: TLib3MFHandle; const nBallReferencesCount: QWord; const pBallReferencesBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the ball references of a beamset
	*
	* @param[in] pBeamSet - BeamSet instance.
	* @param[in] nBallReferencesCount - Number of elements in buffer
	* @param[out] pBallReferencesNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pBallReferencesBuffer - uint32 buffer of retrieves the indices of all balls in this beamset
	* @return error code or 0 (success)
	*)
	TLib3MFBeamSet_GetBallReferencesFunc = function(pBeamSet: TLib3MFHandle; const nBallReferencesCount: QWord; out pBallReferencesNeededCount: QWord; pBallReferencesBuffer: PCardinal): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for BaseMaterialGroup
**************************************************************************************************************************)

	(**
	* Retrieves the count of base materials in the material group.
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[out] pCount - returns the count of base materials.
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_GetCountFunc = function(pBaseMaterialGroup: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* returns all the PropertyIDs of all materials in this group
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the material in the material group.
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_GetAllPropertyIDsFunc = function(pBaseMaterialGroup: TLib3MFHandle; const nPropertyIDsCount: QWord; out pPropertyIDsNeededCount: QWord; pPropertyIDsBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Adds a new material to the material group
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] pName - new name of the base material.
	* @param[in] pDisplayColor - Display color of the material
	* @param[out] pPropertyID - returns new PropertyID of the new material in the material group.
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_AddMaterialFunc = function(pBaseMaterialGroup: TLib3MFHandle; const pName: PAnsiChar; const pDisplayColor: PLib3MFColor; out pPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Removes a material from the material group.
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_RemoveMaterialFunc = function(pBaseMaterialGroup: TLib3MFHandle; const nPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Returns the base material's name
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] nNameBufferSize - size of the buffer (including trailing 0)
	* @param[out] pNameNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pNameBuffer -  buffer of returns the name of the base material., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_GetNameFunc = function(pBaseMaterialGroup: TLib3MFHandle; const nPropertyID: Cardinal; const nNameBufferSize: Cardinal; out pNameNeededChars: Cardinal; pNameBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets a base material's name
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] pName - new name of the base material.
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_SetNameFunc = function(pBaseMaterialGroup: TLib3MFHandle; const nPropertyID: Cardinal; const pName: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets a base material's display color.
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] pTheColor - The base material's display color
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_SetDisplayColorFunc = function(pBaseMaterialGroup: TLib3MFHandle; const nPropertyID: Cardinal; const pTheColor: PLib3MFColor): TLib3MFResult; cdecl;
	
	(**
	* Returns a base material's display color.
	*
	* @param[in] pBaseMaterialGroup - BaseMaterialGroup instance.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[out] pTheColor - The base material's display color
	* @return error code or 0 (success)
	*)
	TLib3MFBaseMaterialGroup_GetDisplayColorFunc = function(pBaseMaterialGroup: TLib3MFHandle; const nPropertyID: Cardinal; pTheColor: PLib3MFColor): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ColorGroup
**************************************************************************************************************************)

	(**
	* Retrieves the count of base materials in this Color Group.
	*
	* @param[in] pColorGroup - ColorGroup instance.
	* @param[out] pCount - returns the count of colors within this color group.
	* @return error code or 0 (success)
	*)
	TLib3MFColorGroup_GetCountFunc = function(pColorGroup: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* returns all the PropertyIDs of all colors within this group
	*
	* @param[in] pColorGroup - ColorGroup instance.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the color in the color group.
	* @return error code or 0 (success)
	*)
	TLib3MFColorGroup_GetAllPropertyIDsFunc = function(pColorGroup: TLib3MFHandle; const nPropertyIDsCount: QWord; out pPropertyIDsNeededCount: QWord; pPropertyIDsBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Adds a new value.
	*
	* @param[in] pColorGroup - ColorGroup instance.
	* @param[in] pTheColor - The new color
	* @param[out] pPropertyID - PropertyID of the new color within this color group.
	* @return error code or 0 (success)
	*)
	TLib3MFColorGroup_AddColorFunc = function(pColorGroup: TLib3MFHandle; const pTheColor: PLib3MFColor; out pPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Removes a color from the color group.
	*
	* @param[in] pColorGroup - ColorGroup instance.
	* @param[in] nPropertyID - PropertyID of the color to be removed from the color group.
	* @return error code or 0 (success)
	*)
	TLib3MFColorGroup_RemoveColorFunc = function(pColorGroup: TLib3MFHandle; const nPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets a color value.
	*
	* @param[in] pColorGroup - ColorGroup instance.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @param[in] pTheColor - The color
	* @return error code or 0 (success)
	*)
	TLib3MFColorGroup_SetColorFunc = function(pColorGroup: TLib3MFHandle; const nPropertyID: Cardinal; const pTheColor: PLib3MFColor): TLib3MFResult; cdecl;
	
	(**
	* Sets a color value.
	*
	* @param[in] pColorGroup - ColorGroup instance.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @param[out] pTheColor - The color
	* @return error code or 0 (success)
	*)
	TLib3MFColorGroup_GetColorFunc = function(pColorGroup: TLib3MFHandle; const nPropertyID: Cardinal; pTheColor: PLib3MFColor): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Texture2DGroup
**************************************************************************************************************************)

	(**
	* Retrieves the count of tex2coords in the Texture2DGroup.
	*
	* @param[in] pTexture2DGroup - Texture2DGroup instance.
	* @param[out] pCount - returns the count of tex2coords.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DGroup_GetCountFunc = function(pTexture2DGroup: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* returns all the PropertyIDs of all tex2coords in this Texture2DGroup
	*
	* @param[in] pTexture2DGroup - Texture2DGroup instance.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the tex2coords in the Texture2DGroup.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DGroup_GetAllPropertyIDsFunc = function(pTexture2DGroup: TLib3MFHandle; const nPropertyIDsCount: QWord; out pPropertyIDsNeededCount: QWord; pPropertyIDsBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Adds a new tex2coord to the Texture2DGroup
	*
	* @param[in] pTexture2DGroup - Texture2DGroup instance.
	* @param[in] pUVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	* @param[out] pPropertyID - returns new PropertyID of the new tex2coord in the Texture2DGroup.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DGroup_AddTex2CoordFunc = function(pTexture2DGroup: TLib3MFHandle; const pUVCoordinate: PLib3MFTex2Coord; out pPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Obtains a tex2coord to the Texture2DGroup
	*
	* @param[in] pTexture2DGroup - Texture2DGroup instance.
	* @param[in] nPropertyID - the PropertyID of the tex2coord in the Texture2DGroup.
	* @param[out] pUVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DGroup_GetTex2CoordFunc = function(pTexture2DGroup: TLib3MFHandle; const nPropertyID: Cardinal; pUVCoordinate: PLib3MFTex2Coord): TLib3MFResult; cdecl;
	
	(**
	* Removes a tex2coords from the Texture2DGroup.
	*
	* @param[in] pTexture2DGroup - Texture2DGroup instance.
	* @param[in] nPropertyID - PropertyID of the tex2coords in the Texture2DGroup.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DGroup_RemoveTex2CoordFunc = function(pTexture2DGroup: TLib3MFHandle; const nPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Obtains the texture2D instance of this group.
	*
	* @param[in] pTexture2DGroup - Texture2DGroup instance.
	* @param[out] pTexture2DInstance - the texture2D instance of this group.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2DGroup_GetTexture2DFunc = function(pTexture2DGroup: TLib3MFHandle; out pTexture2DInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for CompositeMaterials
**************************************************************************************************************************)

	(**
	* Retrieves the count of Composite-s in the CompositeMaterials.
	*
	* @param[in] pCompositeMaterials - CompositeMaterials instance.
	* @param[out] pCount - returns the count of Composite-s
	* @return error code or 0 (success)
	*)
	TLib3MFCompositeMaterials_GetCountFunc = function(pCompositeMaterials: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
	*
	* @param[in] pCompositeMaterials - CompositeMaterials instance.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the Composite-Mixing Values in the CompositeMaterials.
	* @return error code or 0 (success)
	*)
	TLib3MFCompositeMaterials_GetAllPropertyIDsFunc = function(pCompositeMaterials: TLib3MFHandle; const nPropertyIDsCount: QWord; out pPropertyIDsNeededCount: QWord; pPropertyIDsBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Obtains the BaseMaterialGroup instance of this CompositeMaterials.
	*
	* @param[in] pCompositeMaterials - CompositeMaterials instance.
	* @param[out] pBaseMaterialGroupInstance - returns the BaseMaterialGroup instance of this CompositeMaterials
	* @return error code or 0 (success)
	*)
	TLib3MFCompositeMaterials_GetBaseMaterialGroupFunc = function(pCompositeMaterials: TLib3MFHandle; out pBaseMaterialGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Adds a new Composite-Mixing Values to the CompositeMaterials.
	*
	* @param[in] pCompositeMaterials - CompositeMaterials instance.
	* @param[in] nCompositeCount - Number of elements in buffer
	* @param[in] pCompositeBuffer - CompositeConstituent buffer of The Composite Constituents to be added as composite
	* @param[out] pPropertyID - returns new PropertyID of the new Composite in the CompositeMaterials.
	* @return error code or 0 (success)
	*)
	TLib3MFCompositeMaterials_AddCompositeFunc = function(pCompositeMaterials: TLib3MFHandle; const nCompositeCount: QWord; const pCompositeBuffer: PLib3MFCompositeConstituent; out pPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Removes a Composite-Maxing Ratio from the CompositeMaterials.
	*
	* @param[in] pCompositeMaterials - CompositeMaterials instance.
	* @param[in] nPropertyID - PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
	* @return error code or 0 (success)
	*)
	TLib3MFCompositeMaterials_RemoveCompositeFunc = function(pCompositeMaterials: TLib3MFHandle; const nPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Obtains a Composite-Maxing Ratio of this CompositeMaterials.
	*
	* @param[in] pCompositeMaterials - CompositeMaterials instance.
	* @param[in] nPropertyID - the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
	* @param[in] nCompositeCount - Number of elements in buffer
	* @param[out] pCompositeNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pCompositeBuffer - CompositeConstituent buffer of The Composite-Mixing Values with the given PropertyID
	* @return error code or 0 (success)
	*)
	TLib3MFCompositeMaterials_GetCompositeFunc = function(pCompositeMaterials: TLib3MFHandle; const nPropertyID: Cardinal; const nCompositeCount: QWord; out pCompositeNeededCount: QWord; pCompositeBuffer: PLib3MFCompositeConstituent): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for MultiPropertyGroup
**************************************************************************************************************************)

	(**
	* Retrieves the count of MultiProperty-s in the MultiPropertyGroup.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[out] pCount - returns the count of MultiProperty-s
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_GetCountFunc = function(pMultiPropertyGroup: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the MultiProperty-s in the MultiPropertyGroup.
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_GetAllPropertyIDsFunc = function(pMultiPropertyGroup: TLib3MFHandle; const nPropertyIDsCount: QWord; out pPropertyIDsNeededCount: QWord; pPropertyIDsBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Adds a new MultiProperty to the MultiPropertyGroup.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[in] pPropertyIDsBuffer - uint32 buffer of The PropertyIDs of the new MultiProperty.
	* @param[out] pPropertyID - returns the PropertyID of the new MultiProperty in the MultiPropertyGroup.
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_AddMultiPropertyFunc = function(pMultiPropertyGroup: TLib3MFHandle; const nPropertyIDsCount: QWord; const pPropertyIDsBuffer: PCardinal; out pPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Sets the PropertyIDs of a MultiProperty.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be changed.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[in] pPropertyIDsBuffer - uint32 buffer of The new PropertyIDs of the MultiProperty
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_SetMultiPropertyFunc = function(pMultiPropertyGroup: TLib3MFHandle; const nPropertyID: Cardinal; const nPropertyIDsCount: QWord; const pPropertyIDsBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Obtains the PropertyIDs of a MultiProperty.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be queried.
	* @param[in] nPropertyIDsCount - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of The PropertyIDs of the MultiProperty
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_GetMultiPropertyFunc = function(pMultiPropertyGroup: TLib3MFHandle; const nPropertyID: Cardinal; const nPropertyIDsCount: QWord; out pPropertyIDsNeededCount: QWord; pPropertyIDsBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Removes a MultiProperty from this MultiPropertyGroup.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be removed.
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_RemoveMultiPropertyFunc = function(pMultiPropertyGroup: TLib3MFHandle; const nPropertyID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the number of layers of this MultiPropertyGroup.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[out] pCount - returns the number of layers
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_GetLayerCountFunc = function(pMultiPropertyGroup: TLib3MFHandle; out pCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Adds a MultiPropertyLayer to this MultiPropertyGroup.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] pTheLayer - The MultiPropertyLayer to add to this MultiPropertyGroup
	* @param[out] pLayerIndex - returns the index of this MultiPropertyLayer
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_AddLayerFunc = function(pMultiPropertyGroup: TLib3MFHandle; const pTheLayer: PLib3MFMultiPropertyLayer; out pLayerIndex: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Obtains a MultiPropertyLayer of this MultiPropertyGroup.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer queried
	* @param[out] pTheLayer - The MultiPropertyLayer with index LayerIndex within MultiPropertyGroup
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_GetLayerFunc = function(pMultiPropertyGroup: TLib3MFHandle; const nLayerIndex: Cardinal; pTheLayer: PLib3MFMultiPropertyLayer): TLib3MFResult; cdecl;
	
	(**
	* Removes a MultiPropertyLayer from this MultiPropertyGroup.
	*
	* @param[in] pMultiPropertyGroup - MultiPropertyGroup instance.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer to be removed
	* @return error code or 0 (success)
	*)
	TLib3MFMultiPropertyGroup_RemoveLayerFunc = function(pMultiPropertyGroup: TLib3MFHandle; const nLayerIndex: Cardinal): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Attachment
**************************************************************************************************************************)

	(**
	* Retrieves an attachment's package path. This function will be removed in a later release.
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
	* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pPathBuffer -  buffer of returns the attachment's package path string, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_GetPathFunc = function(pAttachment: TLib3MFHandle; const nPathBufferSize: Cardinal; out pPathNeededChars: Cardinal; pPathBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets an attachment's package path. This function will be removed in a later release.
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] pPath - new path of the attachment.
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_SetPathFunc = function(pAttachment: TLib3MFHandle; const pPath: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Returns the PackagePart that is this attachment.
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[out] pPackagePart - The PackagePart of this attachment.
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_PackagePartFunc = function(pAttachment: TLib3MFHandle; out pPackagePart: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Retrieves an attachment's relationship type
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
	* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pPathBuffer -  buffer of returns the attachment's package relationship type string, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_GetRelationShipTypeFunc = function(pAttachment: TLib3MFHandle; const nPathBufferSize: Cardinal; out pPathNeededChars: Cardinal; pPathBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets an attachment's relationship type.
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] pPath - new relationship type string.
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_SetRelationShipTypeFunc = function(pAttachment: TLib3MFHandle; const pPath: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Writes out the attachment as file.
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] pFileName - file to write into.
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_WriteToFileFunc = function(pAttachment: TLib3MFHandle; const pFileName: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Reads an attachment from a file. The path of this file is only read when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] pFileName - file to read from.
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_ReadFromFileFunc = function(pAttachment: TLib3MFHandle; const pFileName: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Reads an attachment from the data provided by a callback function. This callback function is only invoked when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] pTheReadCallback - Callback to call for reading a data chunk
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
	* @param[in] pUserData - Userdata that is passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_ReadFromCallbackFunc = function(pAttachment: TLib3MFHandle; const pTheReadCallback: PLib3MF_ReadCallback; const nStreamSize: QWord; const pTheSeekCallback: PLib3MF_SeekCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the size of the attachment stream
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[out] pStreamSize - the stream size
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_GetStreamSizeFunc = function(pAttachment: TLib3MFHandle; out pStreamSize: QWord): TLib3MFResult; cdecl;
	
	(**
	* Writes out the attachment into a buffer
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] nBufferCount - Number of elements in buffer
	* @param[out] pBufferNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pBufferBuffer - uint8 buffer of Buffer to write into
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_WriteToBufferFunc = function(pAttachment: TLib3MFHandle; const nBufferCount: QWord; out pBufferNeededCount: QWord; pBufferBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* Reads an attachment from a memory buffer. This buffer is immediatly read (in contrast to the ReadFromCallback and ReadFromFile-methods).
	*
	* @param[in] pAttachment - Attachment instance.
	* @param[in] nBufferCount - Number of elements in buffer
	* @param[in] pBufferBuffer - uint8 buffer of Buffer to read from
	* @return error code or 0 (success)
	*)
	TLib3MFAttachment_ReadFromBufferFunc = function(pAttachment: TLib3MFHandle; const nBufferCount: QWord; const pBufferBuffer: PByte): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Texture2D
**************************************************************************************************************************)

	(**
	* Retrieves the attachment located at the path of the texture.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[out] pAttachment - attachment that holds the texture's image information.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_GetAttachmentFunc = function(pTexture2D: TLib3MFHandle; out pAttachment: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Sets the texture's package path to the path of the attachment.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[in] pAttachment - attachment that holds the texture's image information.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_SetAttachmentFunc = function(pTexture2D: TLib3MFHandle; const pAttachment: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a texture's content type.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[out] pContentType - returns content type enum.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_GetContentTypeFunc = function(pTexture2D: TLib3MFHandle; out pContentType: Integer): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a texture's content type.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[in] eContentType - new Content Type
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_SetContentTypeFunc = function(pTexture2D: TLib3MFHandle; const eContentType: Integer): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a texture's tilestyle type.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[out] pTileStyleU - returns tilestyle type enum.
	* @param[out] pTileStyleV - returns tilestyle type enum.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_GetTileStyleUVFunc = function(pTexture2D: TLib3MFHandle; out pTileStyleU: Integer; out pTileStyleV: Integer): TLib3MFResult; cdecl;
	
	(**
	* Sets a texture's tilestyle type.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[in] eTileStyleU - new tilestyle type enum.
	* @param[in] eTileStyleV - new tilestyle type enum.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_SetTileStyleUVFunc = function(pTexture2D: TLib3MFHandle; const eTileStyleU: Integer; const eTileStyleV: Integer): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a texture's filter type.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[out] pFilter - returns filter type enum.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_GetFilterFunc = function(pTexture2D: TLib3MFHandle; out pFilter: Integer): TLib3MFResult; cdecl;
	
	(**
	* Sets a texture's filter type.
	*
	* @param[in] pTexture2D - Texture2D instance.
	* @param[in] eFilter - sets new filter type enum.
	* @return error code or 0 (success)
	*)
	TLib3MFTexture2D_SetFilterFunc = function(pTexture2D: TLib3MFHandle; const eFilter: Integer): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for BuildItem
**************************************************************************************************************************)

	(**
	* Retrieves the object resource associated to a build item
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[out] pObjectResource - returns the associated resource instance
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_GetObjectResourceFunc = function(pBuildItem: TLib3MFHandle; out pObjectResource: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* returns, whether a build item has a UUID and, if true, the build item's UUID
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[out] pHasUUID - flag whether the build item has a UUID
	* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_GetUUIDFunc = function(pBuildItem: TLib3MFHandle; out pHasUUID: Byte; const nUUIDBufferSize: Cardinal; out pUUIDNeededChars: Cardinal; pUUIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets the build item's UUID
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_SetUUIDFunc = function(pBuildItem: TLib3MFHandle; const pUUID: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the object UniqueResourceID associated to a build item
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[out] pUniqueResourceID - returns the UniqueResourceID of the object
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_GetObjectResourceIDFunc = function(pBuildItem: TLib3MFHandle; out pUniqueResourceID: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Checks, if a build item has a non-identity transformation matrix
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[out] pHasTransform - returns true, if the transformation matrix is not the identity
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_HasObjectTransformFunc = function(pBuildItem: TLib3MFHandle; out pHasTransform: Byte): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a build item's transformation matrix.
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[out] pTransform - returns the transformation matrix
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_GetObjectTransformFunc = function(pBuildItem: TLib3MFHandle; pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	
	(**
	* Sets a build item's transformation matrix.
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[in] pTransform - new transformation matrix
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_SetObjectTransformFunc = function(pBuildItem: TLib3MFHandle; const pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	
	(**
	* Retrieves a build item's part number string
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[in] nPartNumberBufferSize - size of the buffer (including trailing 0)
	* @param[out] pPartNumberNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pPartNumberBuffer -  buffer of Returns a build item's part number string, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_GetPartNumberFunc = function(pBuildItem: TLib3MFHandle; const nPartNumberBufferSize: Cardinal; out pPartNumberNeededChars: Cardinal; pPartNumberBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets a build item's part number string
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[in] pSetPartnumber - new part number string for referencing parts from the outside world
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_SetPartNumberFunc = function(pBuildItem: TLib3MFHandle; const pSetPartnumber: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Returns the metadatagroup of this build item
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[out] pMetaDataGroup - returns an Instance of the metadatagroup of this build item
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_GetMetaDataGroupFunc = function(pBuildItem: TLib3MFHandle; out pMetaDataGroup: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the outbox of a build item
	*
	* @param[in] pBuildItem - BuildItem instance.
	* @param[out] pOutbox - Outbox of this build item
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItem_GetOutboxFunc = function(pBuildItem: TLib3MFHandle; pOutbox: PLib3MFBox): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for BuildItemIterator
**************************************************************************************************************************)

	(**
	* Iterates to the next build item in the list.
	*
	* @param[in] pBuildItemIterator - BuildItemIterator instance.
	* @param[out] pHasNext - Iterates to the next build item in the list.
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItemIterator_MoveNextFunc = function(pBuildItemIterator: TLib3MFHandle; out pHasNext: Byte): TLib3MFResult; cdecl;
	
	(**
	* Iterates to the previous build item in the list.
	*
	* @param[in] pBuildItemIterator - BuildItemIterator instance.
	* @param[out] pHasPrevious - Iterates to the previous build item in the list.
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItemIterator_MovePreviousFunc = function(pBuildItemIterator: TLib3MFHandle; out pHasPrevious: Byte): TLib3MFResult; cdecl;
	
	(**
	* Returns the build item the iterator points at.
	*
	* @param[in] pBuildItemIterator - BuildItemIterator instance.
	* @param[out] pBuildItem - returns the build item instance.
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItemIterator_GetCurrentFunc = function(pBuildItemIterator: TLib3MFHandle; out pBuildItem: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Creates a new build item iterator with the same build item list.
	*
	* @param[in] pBuildItemIterator - BuildItemIterator instance.
	* @param[out] pOutBuildItemIterator - returns the cloned Iterator instance
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItemIterator_CloneFunc = function(pBuildItemIterator: TLib3MFHandle; out pOutBuildItemIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the number of build items the iterator captures.
	*
	* @param[in] pBuildItemIterator - BuildItemIterator instance.
	* @param[out] pCount - returns the number of build items the iterator captures.
	* @return error code or 0 (success)
	*)
	TLib3MFBuildItemIterator_CountFunc = function(pBuildItemIterator: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Slice
**************************************************************************************************************************)

	(**
	* Set all vertices of a slice. All polygons will be cleared.
	*
	* @param[in] pSlice - Slice instance.
	* @param[in] nVerticesCount - Number of elements in buffer
	* @param[in] pVerticesBuffer - Position2D buffer of contains the positions.
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_SetVerticesFunc = function(pSlice: TLib3MFHandle; const nVerticesCount: QWord; const pVerticesBuffer: PLib3MFPosition2D): TLib3MFResult; cdecl;
	
	(**
	* Get all vertices of a slice
	*
	* @param[in] pSlice - Slice instance.
	* @param[in] nVerticesCount - Number of elements in buffer
	* @param[out] pVerticesNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pVerticesBuffer - Position2D buffer of contains the positions.
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_GetVerticesFunc = function(pSlice: TLib3MFHandle; const nVerticesCount: QWord; out pVerticesNeededCount: QWord; pVerticesBuffer: PLib3MFPosition2D): TLib3MFResult; cdecl;
	
	(**
	* Get the number of vertices in a slice
	*
	* @param[in] pSlice - Slice instance.
	* @param[out] pCount - the number of vertices in the slice
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_GetVertexCountFunc = function(pSlice: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Add a new polygon to this slice
	*
	* @param[in] pSlice - Slice instance.
	* @param[in] nIndicesCount - Number of elements in buffer
	* @param[in] pIndicesBuffer - uint32 buffer of the new indices of the new polygon
	* @param[out] pIndex - the index of the new polygon
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_AddPolygonFunc = function(pSlice: TLib3MFHandle; const nIndicesCount: QWord; const pIndicesBuffer: PCardinal; out pIndex: QWord): TLib3MFResult; cdecl;
	
	(**
	* Get the number of polygons in the slice
	*
	* @param[in] pSlice - Slice instance.
	* @param[out] pCount - the number of polygons in the slice
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_GetPolygonCountFunc = function(pSlice: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Set all indices of a polygon
	*
	* @param[in] pSlice - Slice instance.
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] nIndicesCount - Number of elements in buffer
	* @param[in] pIndicesBuffer - uint32 buffer of the new indices of the index-th polygon
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_SetPolygonIndicesFunc = function(pSlice: TLib3MFHandle; const nIndex: QWord; const nIndicesCount: QWord; const pIndicesBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Get all vertices of a slice
	*
	* @param[in] pSlice - Slice instance.
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] nIndicesCount - Number of elements in buffer
	* @param[out] pIndicesNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pIndicesBuffer - uint32 buffer of the indices of the index-th polygon 
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_GetPolygonIndicesFunc = function(pSlice: TLib3MFHandle; const nIndex: QWord; const nIndicesCount: QWord; out pIndicesNeededCount: QWord; pIndicesBuffer: PCardinal): TLib3MFResult; cdecl;
	
	(**
	* Get the number of vertices in a slice
	*
	* @param[in] pSlice - Slice instance.
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[out] pCount - the number of indices of the index-th polygon
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_GetPolygonIndexCountFunc = function(pSlice: TLib3MFHandle; const nIndex: QWord; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Get the upper Z-Coordinate of this slice.
	*
	* @param[in] pSlice - Slice instance.
	* @param[out] pZTop - the upper Z-Coordinate of this slice
	* @return error code or 0 (success)
	*)
	TLib3MFSlice_GetZTopFunc = function(pSlice: TLib3MFHandle; out pZTop: Double): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for SliceStack
**************************************************************************************************************************)

	(**
	* Get the lower Z-Coordinate of the slice stack.
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[out] pZBottom - the lower Z-Coordinate the slice stack
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_GetBottomZFunc = function(pSliceStack: TLib3MFHandle; out pZBottom: Double): TLib3MFResult; cdecl;
	
	(**
	* Returns the number of slices
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[out] pCount - the number of slices
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_GetSliceCountFunc = function(pSliceStack: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Query a slice from the slice stack
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[in] nSliceIndex - the index of the slice
	* @param[out] pTheSlice - the Slice instance
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_GetSliceFunc = function(pSliceStack: TLib3MFHandle; const nSliceIndex: QWord; out pTheSlice: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the number of slices
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[in] dZTop - upper Z coordinate of the slice
	* @param[out] pTheSlice - a new Slice instance
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_AddSliceFunc = function(pSliceStack: TLib3MFHandle; const dZTop: Double; out pTheSlice: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the number of slice refs
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[out] pCount - the number of slicereferences
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_GetSliceRefCountFunc = function(pSliceStack: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Adds another existing slicestack as sliceref in this slicestack
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[in] pTheSliceStack - the slicestack to use as sliceref
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_AddSliceStackReferenceFunc = function(pSliceStack: TLib3MFHandle; const pTheSliceStack: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Adds another existing slicestack as sliceref in this slicestack
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[in] nSliceRefIndex - the index of the slice ref
	* @param[out] pTheSliceStack - the slicestack that is used as sliceref
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_GetSliceStackReferenceFunc = function(pSliceStack: TLib3MFHandle; const nSliceRefIndex: QWord; out pTheSliceStack: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_CollapseSliceReferencesFunc = function(pSliceStack: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Sets the package path where this Slice should be stored. Input an empty string to reset the path
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[in] pPath - the package path where this Slice should be stored
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_SetOwnPathFunc = function(pSliceStack: TLib3MFHandle; const pPath: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
	*
	* @param[in] pSliceStack - SliceStack instance.
	* @param[in] nPathBufferSize - size of the buffer (including trailing 0)
	* @param[out] pPathNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pPathBuffer -  buffer of the package path where this Slice will be stored, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFSliceStack_GetOwnPathFunc = function(pSliceStack: TLib3MFHandle; const nPathBufferSize: Cardinal; out pPathNeededChars: Cardinal; pPathBuffer: PAnsiChar): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Consumer
**************************************************************************************************************************)

	(**
	* Gets the consumerid
	*
	* @param[in] pConsumer - Consumer instance.
	* @param[in] nConsumerIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pConsumerIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pConsumerIDBuffer -  buffer of A unique identifier for the consumers, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFConsumer_GetConsumerIDFunc = function(pConsumer: TLib3MFHandle; const nConsumerIDBufferSize: Cardinal; out pConsumerIDNeededChars: Cardinal; pConsumerIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Getts the keyid
	*
	* @param[in] pConsumer - Consumer instance.
	* @param[in] nKeyIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pKeyIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pKeyIDBuffer -  buffer of The identifier for the key of this consumer, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFConsumer_GetKeyIDFunc = function(pConsumer: TLib3MFHandle; const nKeyIDBufferSize: Cardinal; out pKeyIDNeededChars: Cardinal; pKeyIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Gets the keyvalue associated with this consumer
	*
	* @param[in] pConsumer - Consumer instance.
	* @param[in] nKeyValueBufferSize - size of the buffer (including trailing 0)
	* @param[out] pKeyValueNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pKeyValueBuffer -  buffer of The public key, when available, of this consumer, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFConsumer_GetKeyValueFunc = function(pConsumer: TLib3MFHandle; const nKeyValueBufferSize: Cardinal; out pKeyValueNeededChars: Cardinal; pKeyValueBuffer: PAnsiChar): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for AccessRight
**************************************************************************************************************************)

	(**
	* Gets the consumer associated with this access right
	*
	* @param[in] pAccessRight - AccessRight instance.
	* @param[out] pConsumer - The consumer instance
	* @return error code or 0 (success)
	*)
	TLib3MFAccessRight_GetConsumerFunc = function(pAccessRight: TLib3MFHandle; out pConsumer: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Gets the associated encryption algorithm
	*
	* @param[in] pAccessRight - AccessRight instance.
	* @param[out] pAlgorithm - The algorithm used for the key in this accessright
	* @return error code or 0 (success)
	*)
	TLib3MFAccessRight_GetWrappingAlgorithmFunc = function(pAccessRight: TLib3MFHandle; out pAlgorithm: Integer): TLib3MFResult; cdecl;
	
	(**
	* Gets the associated mask generation function algorithm
	*
	* @param[in] pAccessRight - AccessRight instance.
	* @param[out] pAlgorithm - The MFG1 algorithm
	* @return error code or 0 (success)
	*)
	TLib3MFAccessRight_GetMgfAlgorithmFunc = function(pAccessRight: TLib3MFHandle; out pAlgorithm: Integer): TLib3MFResult; cdecl;
	
	(**
	* Gets the digest method assoicated
	*
	* @param[in] pAccessRight - AccessRight instance.
	* @param[out] pAlgorithm - The digest method for this accessright
	* @return error code or 0 (success)
	*)
	TLib3MFAccessRight_GetDigestMethodFunc = function(pAccessRight: TLib3MFHandle; out pAlgorithm: Integer): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ContentEncryptionParams
**************************************************************************************************************************)

	(**
	* Returns the encryption method to be used in this encryption process
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[out] pAlgorithm - 
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc = function(pContentEncryptionParams: TLib3MFHandle; out pAlgorithm: Integer): TLib3MFResult; cdecl;
	
	(**
	* Gets the key for the resource associated
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[in] nByteDataCount - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the key.
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_GetKeyFunc = function(pContentEncryptionParams: TLib3MFHandle; const nByteDataCount: QWord; out pByteDataNeededCount: QWord; pByteDataBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* Gets the IV data
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[in] nByteDataCount - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the data.
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_GetInitializationVectorFunc = function(pContentEncryptionParams: TLib3MFHandle; const nByteDataCount: QWord; out pByteDataNeededCount: QWord; pByteDataBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[in] nByteDataCount - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the data.
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_GetAuthenticationTagFunc = function(pContentEncryptionParams: TLib3MFHandle; const nByteDataCount: QWord; out pByteDataNeededCount: QWord; pByteDataBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* Sets the authentication tag
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[in] nByteDataCount - Number of elements in buffer
	* @param[in] pByteDataBuffer - uint8 buffer of The authentication tag size
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_SetAuthenticationTagFunc = function(pContentEncryptionParams: TLib3MFHandle; const nByteDataCount: QWord; const pByteDataBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[in] nByteDataCount - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Buffer where the data will be placed
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc = function(pContentEncryptionParams: TLib3MFHandle; const nByteDataCount: QWord; out pByteDataNeededCount: QWord; pByteDataBuffer: PByte): TLib3MFResult; cdecl;
	
	(**
	* A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[out] pDescriptor - 
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_GetDescriptorFunc = function(pContentEncryptionParams: TLib3MFHandle; out pDescriptor: QWord): TLib3MFResult; cdecl;
	
	(**
	* Gets the resourcedatagroup keyuuid
	*
	* @param[in] pContentEncryptionParams - ContentEncryptionParams instance.
	* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pUUIDBuffer -  buffer of The resourcedatagroup keyuuid that may be use to reference an external key, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFContentEncryptionParams_GetKeyUUIDFunc = function(pContentEncryptionParams: TLib3MFHandle; const nUUIDBufferSize: Cardinal; out pUUIDNeededChars: Cardinal; pUUIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ResourceData
**************************************************************************************************************************)

	(**
	* Gets the encrypted part path
	*
	* @param[in] pResourceData - ResourceData instance.
	* @param[out] pPath - The part path
	* @return error code or 0 (success)
	*)
	TLib3MFResourceData_GetPathFunc = function(pResourceData: TLib3MFHandle; out pPath: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Gets the encryption algorithm used to encrypt this ResourceData
	*
	* @param[in] pResourceData - ResourceData instance.
	* @param[out] pEncryptionAlgorithm - The encryption algorithm
	* @return error code or 0 (success)
	*)
	TLib3MFResourceData_GetEncryptionAlgorithmFunc = function(pResourceData: TLib3MFHandle; out pEncryptionAlgorithm: Integer): TLib3MFResult; cdecl;
	
	(**
	* Tells whether this ResourceData is compressed or not
	*
	* @param[in] pResourceData - ResourceData instance.
	* @param[out] pCompression - The compression method
	* @return error code or 0 (success)
	*)
	TLib3MFResourceData_GetCompressionFunc = function(pResourceData: TLib3MFHandle; out pCompression: Integer): TLib3MFResult; cdecl;
	
	(**
	* Tells whether this ResourceData is compressed or not
	*
	* @param[in] pResourceData - ResourceData instance.
	* @param[in] nByteDataCount - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written elements, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of The compression method
	* @return error code or 0 (success)
	*)
	TLib3MFResourceData_GetAdditionalAuthenticationDataFunc = function(pResourceData: TLib3MFHandle; const nByteDataCount: QWord; out pByteDataNeededCount: QWord; pByteDataBuffer: PByte): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for ResourceDataGroup
**************************************************************************************************************************)

	(**
	* Sets the resourcedatagroup keyuuid
	*
	* @param[in] pResourceDataGroup - ResourceDataGroup instance.
	* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pUUIDBuffer -  buffer of The new resourcedatagroup keyuuid., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFResourceDataGroup_GetKeyUUIDFunc = function(pResourceDataGroup: TLib3MFHandle; const nUUIDBufferSize: Cardinal; out pUUIDNeededChars: Cardinal; pUUIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Add accessright to resourcedatagroup element
	*
	* @param[in] pResourceDataGroup - ResourceDataGroup instance.
	* @param[in] pConsumer - The Consumer reference
	* @param[in] eWrappingAlgorithm - The key wrapping algorithm to be used
	* @param[in] eMgfAlgorithm - The mask generation function to be used
	* @param[in] eDigestMethod - The digest mechanism to be used
	* @param[out] pTheAccessRight - The acess right instance
	* @return error code or 0 (success)
	*)
	TLib3MFResourceDataGroup_AddAccessRightFunc = function(pResourceDataGroup: TLib3MFHandle; const pConsumer: TLib3MFHandle; const eWrappingAlgorithm: Integer; const eMgfAlgorithm: Integer; const eDigestMethod: Integer; out pTheAccessRight: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Finds the AccessRight associated with a Consumer
	*
	* @param[in] pResourceDataGroup - ResourceDataGroup instance.
	* @param[in] pConsumer - The Consumer instance
	* @param[out] pTheAccessRight - The AcessRight instance
	* @return error code or 0 (success)
	*)
	TLib3MFResourceDataGroup_FindAccessRightByConsumerFunc = function(pResourceDataGroup: TLib3MFHandle; const pConsumer: TLib3MFHandle; out pTheAccessRight: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Removes access from a Consumer on this resource data group
	*
	* @param[in] pResourceDataGroup - ResourceDataGroup instance.
	* @param[in] pConsumer - The Consumer instance
	* @return error code or 0 (success)
	*)
	TLib3MFResourceDataGroup_RemoveAccessRightFunc = function(pResourceDataGroup: TLib3MFHandle; const pConsumer: TLib3MFHandle): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for KeyStore
**************************************************************************************************************************)

	(**
	* Adds a consumer to the keystore
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pConsumerID - A unique identifier for the consumer
	* @param[in] pKeyID - The id of the key of the consumer
	* @param[in] pKeyValue - The public key for this consumer in PEM format
	* @param[out] pConsumer - The consumer instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_AddConsumerFunc = function(pKeyStore: TLib3MFHandle; const pConsumerID: PAnsiChar; const pKeyID: PAnsiChar; const pKeyValue: PAnsiChar; out pConsumer: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Gets the number of consumers in the keystore
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[out] pCount - The consumer count
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_GetConsumerCountFunc = function(pKeyStore: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Get a consumer from the keystore
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] nConsumerIndex - The index of the consumer
	* @param[out] pConsumer - The consumer instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_GetConsumerFunc = function(pKeyStore: TLib3MFHandle; const nConsumerIndex: QWord; out pConsumer: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Removes a consumer from the keystore
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pConsumer - The consumer instance to remove
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_RemoveConsumerFunc = function(pKeyStore: TLib3MFHandle; const pConsumer: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Finds a consumer by ID
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pConsumerID - The ID of the consumer
	* @param[out] pConsumer - The consumer instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_FindConsumerFunc = function(pKeyStore: TLib3MFHandle; const pConsumerID: PAnsiChar; out pConsumer: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Gets the number of resource data group in the keysore
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[out] pCount - The number of resource data available
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_GetResourceDataGroupCountFunc = function(pKeyStore: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Adds a resource data group into the keystore.
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[out] pResourceDataGroup - The resource data group instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_AddResourceDataGroupFunc = function(pKeyStore: TLib3MFHandle; out pResourceDataGroup: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Gets a resource data group
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] nResourceDataIndex - The index of the resource data
	* @param[out] pResourceDataGroup - The resource data group instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_GetResourceDataGroupFunc = function(pKeyStore: TLib3MFHandle; const nResourceDataIndex: QWord; out pResourceDataGroup: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Removes a resource data group
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pResourceDataGroup - The resource data group instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_RemoveResourceDataGroupFunc = function(pKeyStore: TLib3MFHandle; const pResourceDataGroup: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Finds a resource data group that contains a particular resourcedata
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pPartPath - The target path for the resourcedata hold by the resource data group
	* @param[out] pResourceDataGroup - The data resource instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_FindResourceDataGroupFunc = function(pKeyStore: TLib3MFHandle; const pPartPath: TLib3MFHandle; out pResourceDataGroup: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Add resourcedata to resourcedatagroup element
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pResourceDataGroup - The resource data group where to add this resource data
	* @param[in] pPartPath - The path of the part to be encrypted
	* @param[in] eAlgorithm - The encryption algorithm to be used to encrypt this resource
	* @param[in] eCompression - Whether compression should be used prior to encryption
	* @param[in] nAdditionalAuthenticationDataCount - Number of elements in buffer
	* @param[in] pAdditionalAuthenticationDataBuffer - uint8 buffer of Additional data to be encrypted along the contents for better security
	* @param[out] pResourceData - The data resource instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_AddResourceDataFunc = function(pKeyStore: TLib3MFHandle; const pResourceDataGroup: TLib3MFHandle; const pPartPath: TLib3MFHandle; const eAlgorithm: Integer; const eCompression: Integer; const nAdditionalAuthenticationDataCount: QWord; const pAdditionalAuthenticationDataBuffer: PByte; out pResourceData: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Removes a resource data
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pResourceData - The resource data to be removed
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_RemoveResourceDataFunc = function(pKeyStore: TLib3MFHandle; const pResourceData: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Finds a resource data on this resource group
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pResourcePath - The target path for the resourcedata
	* @param[out] pResourceData - The resource data instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_FindResourceDataFunc = function(pKeyStore: TLib3MFHandle; const pResourcePath: TLib3MFHandle; out pResourceData: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Gets the number of resource data in the keysore
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[out] pCount - The number of resource data available
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_GetResourceDataCountFunc = function(pKeyStore: TLib3MFHandle; out pCount: QWord): TLib3MFResult; cdecl;
	
	(**
	* Gets a resource data
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] nResourceDataIndex - The index of the resource data
	* @param[out] pResourceData - The data resource instance
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_GetResourceDataFunc = function(pKeyStore: TLib3MFHandle; const nResourceDataIndex: QWord; out pResourceData: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Gets the keystore UUID
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[out] pHasUUID - flag whether the keystore has a UUID
	* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pUUIDBuffer -  buffer of returns the keystore uuid., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_GetUUIDFunc = function(pKeyStore: TLib3MFHandle; out pHasUUID: Byte; const nUUIDBufferSize: Cardinal; out pUUIDNeededChars: Cardinal; pUUIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets the keystore UUID
	*
	* @param[in] pKeyStore - KeyStore instance.
	* @param[in] pUUID - The new keystore uuid.
	* @return error code or 0 (success)
	*)
	TLib3MFKeyStore_SetUUIDFunc = function(pKeyStore: TLib3MFHandle; const pUUID: PAnsiChar): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Function type definitions for Model
**************************************************************************************************************************)

	(**
	* Returns the PackagePart within the OPC package that holds the root model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pRootModelPart - the PackagePart within the OPC package that holds the model-file
	* @return error code or 0 (success)
	*)
	TLib3MFModel_RootModelPartFunc = function(pModel: TLib3MFHandle; out pRootModelPart: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns a new PackagePart for use within the OPC package.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pAbsolutePath - the absolute Path (physical location) within the OPC package
	* @param[out] pModelPart - the new PackagePart within the OPC package
	* @return error code or 0 (success)
	*)
	TLib3MFModel_FindOrCreatePackagePartFunc = function(pModel: TLib3MFHandle; const pAbsolutePath: PAnsiChar; out pModelPart: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* sets the units of a model.
	*
	* @param[in] pModel - Model instance.
	* @param[in] eUnit - Unit enum value for the model unit
	* @return error code or 0 (success)
	*)
	TLib3MFModel_SetUnitFunc = function(pModel: TLib3MFHandle; const eUnit: Integer): TLib3MFResult; cdecl;
	
	(**
	* returns the units of a model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pUnit - Unit enum value for the model unit
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetUnitFunc = function(pModel: TLib3MFHandle; out pUnit: Integer): TLib3MFResult; cdecl;
	
	(**
	* retrieves the language of a model
	*
	* @param[in] pModel - Model instance.
	* @param[in] nLanguageBufferSize - size of the buffer (including trailing 0)
	* @param[out] pLanguageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pLanguageBuffer -  buffer of language identifier, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetLanguageFunc = function(pModel: TLib3MFHandle; const nLanguageBufferSize: Cardinal; out pLanguageNeededChars: Cardinal; pLanguageBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets the language of a model
	*
	* @param[in] pModel - Model instance.
	* @param[in] pLanguage - language identifier
	* @return error code or 0 (success)
	*)
	TLib3MFModel_SetLanguageFunc = function(pModel: TLib3MFHandle; const pLanguage: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* creates a model writer instance for a specific file type
	*
	* @param[in] pModel - Model instance.
	* @param[in] pWriterClass -  string identifier for the file type
	* @param[out] pWriterInstance -  string identifier for the file type
	* @return error code or 0 (success)
	*)
	TLib3MFModel_QueryWriterFunc = function(pModel: TLib3MFHandle; const pWriterClass: PAnsiChar; out pWriterInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a model reader instance for a specific file type
	*
	* @param[in] pModel - Model instance.
	* @param[in] pReaderClass -  string identifier for the file type
	* @param[out] pReaderInstance -  string identifier for the file type
	* @return error code or 0 (success)
	*)
	TLib3MFModel_QueryReaderFunc = function(pModel: TLib3MFHandle; const pReaderClass: PAnsiChar; out pReaderInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a model resource by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pResource - returns the resource instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetResourceByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pResource: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a model texture by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pTextureInstance - returns the texture2d instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetTexture2DByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pTextureInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* returns a Property's type
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - Resource ID of the Property to Query
	* @param[out] pThePropertyType - returns a Property's type
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetPropertyTypeByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pThePropertyType: Integer): TLib3MFResult; cdecl;
	
	(**
	* finds a model base material group by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pBaseMaterialGroupInstance - returns the BaseMaterialGroup instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetBaseMaterialGroupByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pBaseMaterialGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a model texture2d group by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pTexture2DGroupInstance - returns the Texture2DGroup instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetTexture2DGroupByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pTexture2DGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a model CompositeMaterials by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pCompositeMaterialsInstance - returns the CompositeMaterials instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetCompositeMaterialsByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pCompositeMaterialsInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a model MultiPropertyGroup by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pMultiPropertyGroupInstance - returns the MultiPropertyGroup instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetMultiPropertyGroupByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pMultiPropertyGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a mesh object by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pMeshObjectInstance - returns the mesh object instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetMeshObjectByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pMeshObjectInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a components object by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pComponentsObjectInstance - returns the components object instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetComponentsObjectByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pComponentsObjectInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a model color group by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pColorGroupInstance - returns the ColorGroup instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetColorGroupByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pColorGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* finds a model slicestack by its UniqueResourceID
	*
	* @param[in] pModel - Model instance.
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @param[out] pSliceStacInstance - returns the slicestack instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetSliceStackByIDFunc = function(pModel: TLib3MFHandle; const nUniqueResourceID: Cardinal; out pSliceStacInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* returns, whether a build has a UUID and, if true, the build's UUID
	*
	* @param[in] pModel - Model instance.
	* @param[out] pHasUUID - flag whether the build has a UUID
	* @param[in] nUUIDBufferSize - size of the buffer (including trailing 0)
	* @param[out] pUUIDNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pUUIDBuffer -  buffer of the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx', may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetBuildUUIDFunc = function(pModel: TLib3MFHandle; out pHasUUID: Byte; const nUUIDBufferSize: Cardinal; out pUUIDNeededChars: Cardinal; pUUIDBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* sets the build's UUID
	*
	* @param[in] pModel - Model instance.
	* @param[in] pUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	* @return error code or 0 (success)
	*)
	TLib3MFModel_SetBuildUUIDFunc = function(pModel: TLib3MFHandle; const pUUID: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* creates a build item iterator instance with all build items.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pBuildItemIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetBuildItemsFunc = function(pModel: TLib3MFHandle; out pBuildItemIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the outbox of a Model
	*
	* @param[in] pModel - Model instance.
	* @param[out] pOutbox - Outbox of this Model
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetOutboxFunc = function(pModel: TLib3MFHandle; pOutbox: PLib3MFBox): TLib3MFResult; cdecl;
	
	(**
	* creates a resource iterator instance with all resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetResourcesFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a resource iterator instance with all object resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetObjectsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a resource iterator instance with all mesh object resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetMeshObjectsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a resource iterator instance with all components object resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetComponentsObjectsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a Texture2DIterator instance with all texture2d resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetTexture2DsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a BaseMaterialGroupIterator instance with all base material resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetBaseMaterialGroupsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a ColorGroupIterator instance with all ColorGroup resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetColorGroupsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a Texture2DGroupIterator instance with all base material resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetTexture2DGroupsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetCompositeMaterialsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetMultiPropertyGroupsFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a resource iterator instance with all slice stack resources.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pResourceIterator - returns the iterator instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetSliceStacksFunc = function(pModel: TLib3MFHandle; out pResourceIterator: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pMergedModelInstance - returns the merged model instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_MergeToModelFunc = function(pModel: TLib3MFHandle; out pMergedModelInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an empty mesh object to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pMeshObjectInstance -  returns the mesh object instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddMeshObjectFunc = function(pModel: TLib3MFHandle; out pMeshObjectInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an empty component object to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pComponentsObjectInstance -  returns the components object instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddComponentsObjectFunc = function(pModel: TLib3MFHandle; out pComponentsObjectInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* creates a new model slicestack by its id
	*
	* @param[in] pModel - Model instance.
	* @param[in] dZBottom - Bottom Z value of the slicestack
	* @param[out] pSliceStackInstance - returns the new slicestack instance
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddSliceStackFunc = function(pModel: TLib3MFHandle; const dZBottom: Double; out pSliceStackInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds a texture2d resource to the model. Its path is given by that of an existing attachment.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pTextureAttachment - attachment containing the image data.
	* @param[out] pTexture2DInstance - returns the new texture instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddTexture2DFromAttachmentFunc = function(pModel: TLib3MFHandle; const pTextureAttachment: TLib3MFHandle; out pTexture2DInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an empty BaseMaterialGroup resource to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pBaseMaterialGroupInstance - returns the new base material instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddBaseMaterialGroupFunc = function(pModel: TLib3MFHandle; out pBaseMaterialGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an empty ColorGroup resource to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pColorGroupInstance - returns the new ColorGroup instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddColorGroupFunc = function(pModel: TLib3MFHandle; out pColorGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an empty Texture2DGroup resource to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pTexture2DInstance - The texture2D instance of the created Texture2DGroup.
	* @param[out] pTexture2DGroupInstance - returns the new Texture2DGroup instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddTexture2DGroupFunc = function(pModel: TLib3MFHandle; const pTexture2DInstance: TLib3MFHandle; out pTexture2DGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an empty CompositeMaterials resource to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pBaseMaterialGroupInstance - The BaseMaterialGroup instance of the created CompositeMaterials.
	* @param[out] pCompositeMaterialsInstance - returns the new CompositeMaterials instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddCompositeMaterialsFunc = function(pModel: TLib3MFHandle; const pBaseMaterialGroupInstance: TLib3MFHandle; out pCompositeMaterialsInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an empty MultiPropertyGroup resource to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pMultiPropertyGroupInstance - returns the new MultiPropertyGroup instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddMultiPropertyGroupFunc = function(pModel: TLib3MFHandle; out pMultiPropertyGroupInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds a build item to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pObject - Object instance.
	* @param[in] pTransform - Transformation matrix.
	* @param[out] pBuildItemInstance - returns the build item instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddBuildItemFunc = function(pModel: TLib3MFHandle; const pObject: TLib3MFHandle; const pTransform: PLib3MFTransform; out pBuildItemInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* removes a build item from the model
	*
	* @param[in] pModel - Model instance.
	* @param[in] pBuildItemInstance - Build item to remove.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_RemoveBuildItemFunc = function(pModel: TLib3MFHandle; const pBuildItemInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Returns the metadata of the model as MetaDataGroup
	*
	* @param[in] pModel - Model instance.
	* @param[out] pTheMetaDataGroup - returns an Instance of the metadatagroup of the model
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetMetaDataGroupFunc = function(pModel: TLib3MFHandle; out pTheMetaDataGroup: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pURI - Path of the attachment
	* @param[in] pRelationShipType - Relationship type of the attachment
	* @param[out] pAttachmentInstance - Instance of the attachment object
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddAttachmentFunc = function(pModel: TLib3MFHandle; const pURI: PAnsiChar; const pRelationShipType: PAnsiChar; out pAttachmentInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Removes attachment from the model.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pAttachmentInstance - Attachment instance to remove
	* @return error code or 0 (success)
	*)
	TLib3MFModel_RemoveAttachmentFunc = function(pModel: TLib3MFHandle; const pAttachmentInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* retrieves an attachment stream object from the model..
	*
	* @param[in] pModel - Model instance.
	* @param[in] nIndex - Index of the attachment stream
	* @param[out] pAttachmentInstance - Instance of the attachment object
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetAttachmentFunc = function(pModel: TLib3MFHandle; const nIndex: Cardinal; out pAttachmentInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* retrieves an attachment stream object from the model.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pURI - Path URI in the package
	* @param[out] pAttachmentInstance - Instance of the attachment object
	* @return error code or 0 (success)
	*)
	TLib3MFModel_FindAttachmentFunc = function(pModel: TLib3MFHandle; const pURI: PAnsiChar; out pAttachmentInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* retrieves the number of attachments of the model.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pAttachmentCount - Returns the number of attachments.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetAttachmentCountFunc = function(pModel: TLib3MFHandle; out pAttachmentCount: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* Retrieve whether the OPC package contains a package thumbnail.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pHasThumbnail - returns whether the OPC package contains a package thumbnail
	* @return error code or 0 (success)
	*)
	TLib3MFModel_HasPackageThumbnailAttachmentFunc = function(pModel: TLib3MFHandle; out pHasThumbnail: Byte): TLib3MFResult; cdecl;
	
	(**
	* Create a new or the existing package thumbnail for the OPC package.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pAttachment - Instance of a new or the existing thumbnailattachment object.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_CreatePackageThumbnailAttachmentFunc = function(pModel: TLib3MFHandle; out pAttachment: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Get the attachment to the OPC package containing the package thumbnail.
	*
	* @param[in] pModel - Model instance.
	* @param[out] pAttachment - Instance of the thumbnailattachment object or NULL.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetPackageThumbnailAttachmentFunc = function(pModel: TLib3MFHandle; out pAttachment: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Remove the attachment to the OPC package containing the package thumbnail.
	*
	* @param[in] pModel - Model instance.
	* @return error code or 0 (success)
	*)
	TLib3MFModel_RemovePackageThumbnailAttachmentFunc = function(pModel: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Adds a new Content Type to the model.
	*
	* @param[in] pModel - Model instance.
	* @param[in] pExtension - File Extension
	* @param[in] pContentType - Content Type Identifier
	* @return error code or 0 (success)
	*)
	TLib3MFModel_AddCustomContentTypeFunc = function(pModel: TLib3MFHandle; const pExtension: PAnsiChar; const pContentType: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Removes a custom Content Type from the model (UTF8 version).
	*
	* @param[in] pModel - Model instance.
	* @param[in] pExtension - File Extension
	* @return error code or 0 (success)
	*)
	TLib3MFModel_RemoveCustomContentTypeFunc = function(pModel: TLib3MFHandle; const pExtension: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Sets the random number generator callback for use in the library
	*
	* @param[in] pModel - Model instance.
	* @param[in] pTheCallback - The callback used to generate random numbers
	* @param[in] pUserData - Userdata to be passed to the callback function
	* @return error code or 0 (success)
	*)
	TLib3MFModel_SetRandomNumberCallbackFunc = function(pModel: TLib3MFHandle; const pTheCallback: PLib3MF_RandomNumberCallback; const pUserData: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Gets the keystore associated with this model
	*
	* @param[in] pModel - Model instance.
	* @param[out] pKeyStore - The package keystore
	* @return error code or 0 (success)
	*)
	TLib3MFModel_GetKeyStoreFunc = function(pModel: TLib3MFHandle; out pKeyStore: TLib3MFHandle): TLib3MFResult; cdecl;
	
(*************************************************************************************************************************
 Global function definitions 
**************************************************************************************************************************)

	(**
	* retrieves the binary version of this library.
	*
	* @param[out] pMajor - returns the major version of this library
	* @param[out] pMinor - returns the minor version of this library
	* @param[out] pMicro - returns the micro version of this library
	* @return error code or 0 (success)
	*)
	TLib3MFGetLibraryVersionFunc = function(out pMajor: Cardinal; out pMinor: Cardinal; out pMicro: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* retrieves prerelease information of this library.
	*
	* @param[out] pHasPrereleaseInfo - Does the library provide prerelease version?
	* @param[in] nPrereleaseInfoBufferSize - size of the buffer (including trailing 0)
	* @param[out] pPrereleaseInfoNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pPrereleaseInfoBuffer -  buffer of retrieves prerelease information of this library., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFGetPrereleaseInformationFunc = function(out pHasPrereleaseInfo: Byte; const nPrereleaseInfoBufferSize: Cardinal; out pPrereleaseInfoNeededChars: Cardinal; pPrereleaseInfoBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* retrieves build information of this library.
	*
	* @param[out] pHasBuildInfo - Does the library provide build version?
	* @param[in] nBuildInformationBufferSize - size of the buffer (including trailing 0)
	* @param[out] pBuildInformationNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pBuildInformationBuffer -  buffer of retrieves build information of this library., may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFGetBuildInformationFunc = function(out pHasBuildInfo: Byte; const nBuildInformationBufferSize: Cardinal; out pBuildInformationNeededChars: Cardinal; pBuildInformationBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* retrieves whether a specification is supported, and if so, which version.
	*
	* @param[in] pSpecificationURL - URL of extension to check
	* @param[out] pIsSupported - returns whether this specification is supported
	* @param[out] pMajor - returns the major version of the extension (if IsSupported)
	* @param[out] pMinor - returns the minor version of the extension (if IsSupported)
	* @param[out] pMicro - returns the micro version of the extension (if IsSupported)
	* @return error code or 0 (success)
	*)
	TLib3MFGetSpecificationVersionFunc = function(const pSpecificationURL: PAnsiChar; out pIsSupported: Byte; out pMajor: Cardinal; out pMinor: Cardinal; out pMicro: Cardinal): TLib3MFResult; cdecl;
	
	(**
	* creates an empty model instance.
	*
	* @param[out] pModel - returns an empty model instance
	* @return error code or 0 (success)
	*)
	TLib3MFCreateModelFunc = function(out pModel: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* releases shared ownership of an object instance
	*
	* @param[in] pInstance - the object instance to release
	* @return error code or 0 (success)
	*)
	TLib3MFReleaseFunc = function(const pInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* acquires shared ownership of an object instance
	*
	* @param[in] pInstance - the object instance to acquire
	* @return error code or 0 (success)
	*)
	TLib3MFAcquireFunc = function(const pInstance: TLib3MFHandle): TLib3MFResult; cdecl;
	
	(**
	* Sets the journal file path
	*
	* @param[in] pJournalPath - File name of the journal file
	* @return error code or 0 (success)
	*)
	TLib3MFSetJournalFunc = function(const pJournalPath: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Retrieves the last error string of an instance
	*
	* @param[in] pInstance - Object where the error occured.
	* @param[in] nLastErrorStringBufferSize - size of the buffer (including trailing 0)
	* @param[out] pLastErrorStringNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pLastErrorStringBuffer -  buffer of Last Error String, may be NULL
	* @param[out] pHasLastError - Returns if the instance has a last error.
	* @return error code or 0 (success)
	*)
	TLib3MFGetLastErrorFunc = function(const pInstance: TLib3MFHandle; const nLastErrorStringBufferSize: Cardinal; out pLastErrorStringNeededChars: Cardinal; pLastErrorStringBuffer: PAnsiChar; out pHasLastError: Byte): TLib3MFResult; cdecl;
	
	(**
	* Returns the address of the SymbolLookupMethod
	*
	* @param[out] pSymbolLookupMethod - Address of the SymbolAddressMethod
	* @return error code or 0 (success)
	*)
	TLib3MFGetSymbolLookupMethodFunc = function(out pSymbolLookupMethod: Pointer): TLib3MFResult; cdecl;
	
	(**
	* Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
	*
	* @param[in] eTheProgressIdentifier - the progress identifier that is passed to the callback function
	* @param[in] nProgressMessageBufferSize - size of the buffer (including trailing 0)
	* @param[out] pProgressMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
	* @param[out] pProgressMessageBuffer -  buffer of English text for the progress identifier, may be NULL
	* @return error code or 0 (success)
	*)
	TLib3MFRetrieveProgressMessageFunc = function(const eTheProgressIdentifier: Integer; const nProgressMessageBufferSize: Cardinal; out pProgressMessageNeededChars: Cardinal; pProgressMessageBuffer: PAnsiChar): TLib3MFResult; cdecl;
	
	(**
	* Creates a Color from uint8 RGBA values
	*
	* @param[in] nRed - Red value of color (0-255)
	* @param[in] nGreen - Green value of color (0-255)
	* @param[in] nBlue - Blue value of color (0-255)
	* @param[in] nAlpha - Alpha value of color (0-255)
	* @param[out] pTheColor - Assembled color
	* @return error code or 0 (success)
	*)
	TLib3MFRGBAToColorFunc = function(const nRed: Byte; const nGreen: Byte; const nBlue: Byte; const nAlpha: Byte; pTheColor: PLib3MFColor): TLib3MFResult; cdecl;
	
	(**
	* Creates a Color from uint8 RGBA values
	*
	* @param[in] fRed - Red value of color (0-1)
	* @param[in] fGreen - Green value of color (0-1)
	* @param[in] fBlue - Blue value of color (0-1)
	* @param[in] fAlpha - Alpha value of color (0-1)
	* @param[out] pTheColor - Assembled color
	* @return error code or 0 (success)
	*)
	TLib3MFFloatRGBAToColorFunc = function(const fRed: Single; const fGreen: Single; const fBlue: Single; const fAlpha: Single; pTheColor: PLib3MFColor): TLib3MFResult; cdecl;
	
	(**
	* Calculates uint8-RGBA-values from a Color
	*
	* @param[in] pTheColor - Color to handle
	* @param[out] pRed - Red value of color (0-255)
	* @param[out] pGreen - Green value of color (0-255)
	* @param[out] pBlue - Blue value of color (0-255)
	* @param[out] pAlpha - Alpha value of color (0-255)
	* @return error code or 0 (success)
	*)
	TLib3MFColorToRGBAFunc = function(const pTheColor: PLib3MFColor; out pRed: Byte; out pGreen: Byte; out pBlue: Byte; out pAlpha: Byte): TLib3MFResult; cdecl;
	
	(**
	* Calculates float-RGBA-values from a Color
	*
	* @param[in] pTheColor - Color to handle
	* @param[out] pRed - Red value of color (0-1)
	* @param[out] pGreen - Green value of color (0-1)
	* @param[out] pBlue - Blue value of color (0-1)
	* @param[out] pAlpha - Alpha value of color (0-1)
	* @return error code or 0 (success)
	*)
	TLib3MFColorToFloatRGBAFunc = function(const pTheColor: PLib3MFColor; out pRed: Single; out pGreen: Single; out pBlue: Single; out pAlpha: Single): TLib3MFResult; cdecl;
	
	(**
	* Creates an identity transform
	*
	* @param[out] pTransform - Transformation matrix.
	* @return error code or 0 (success)
	*)
	TLib3MFGetIdentityTransformFunc = function(pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	
	(**
	* Creates a uniform scale transform
	*
	* @param[in] fFactor - Factor in X, Y and Z
	* @param[out] pTransform - Transformation matrix.
	* @return error code or 0 (success)
	*)
	TLib3MFGetUniformScaleTransformFunc = function(const fFactor: Single; pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	
	(**
	* Creates a scale transform
	*
	* @param[in] fFactorX - Factor in X
	* @param[in] fFactorY - Factor in Y
	* @param[in] fFactorZ - Factor in Z
	* @param[out] pTransform - Transformation matrix.
	* @return error code or 0 (success)
	*)
	TLib3MFGetScaleTransformFunc = function(const fFactorX: Single; const fFactorY: Single; const fFactorZ: Single; pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	
	(**
	* Creates an translation transform
	*
	* @param[in] fVectorX - Translation in X
	* @param[in] fVectorY - Translation in Y
	* @param[in] fVectorZ - Translation in Z
	* @param[out] pTransform - Transformation matrix.
	* @return error code or 0 (success)
	*)
	TLib3MFGetTranslationTransformFunc = function(const fVectorX: Single; const fVectorY: Single; const fVectorZ: Single; pTransform: PLib3MFTransform): TLib3MFResult; cdecl;
	

(*************************************************************************************************************************
 Helper function pointer definitions 
**************************************************************************************************************************)
TLib3MFSymbolLookupMethod = function(const pSymbolName: PAnsiChar; out pValue: Pointer): TLib3MFResult; cdecl;

(*************************************************************************************************************************
 Exception definition
**************************************************************************************************************************)

	ELib3MFException = class(Exception)
	private
		FErrorCode: TLib3MFResult;
		FCustomMessage: String;
	public
		property ErrorCode: TLib3MFResult read FErrorCode;
		property CustomMessage: String read FCustomMessage;
		constructor Create(AErrorCode: TLib3MFResult; AMessage: String);
		constructor CreateCustomMessage(AErrorCode: TLib3MFResult; AMessage: String);
	end;


(*************************************************************************************************************************
 Class definition for Base
**************************************************************************************************************************)

 TLib3MFBase = class(TObject)
	private
		FWrapper: TLib3MFWrapper;
		FHandle: TLib3MFHandle;
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		property TheHandle: TLib3MFHandle read FHandle;
		function ClassTypeId(): QWord;
	end;


(*************************************************************************************************************************
 Class definition for Writer
**************************************************************************************************************************)

	TLib3MFWriter = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		procedure WriteToFile(const AFilename: String);
		function GetStreamSize(): QWord;
		procedure WriteToBuffer(out ABuffer: TByteDynArray);
		procedure WriteToCallback(const ATheWriteCallback: PLib3MF_WriteCallback; const ATheSeekCallback: PLib3MF_SeekCallback; const AUserData: Pointer);
		procedure SetProgressCallback(const AProgressCallback: PLib3MF_ProgressCallback; const AUserData: Pointer);
		function GetDecimalPrecision(): Cardinal;
		procedure SetDecimalPrecision(const ADecimalPrecision: Cardinal);
		procedure SetStrictModeActive(const AStrictModeActive: Boolean);
		function GetStrictModeActive(): Boolean;
		function GetWarning(const AIndex: Cardinal; out AErrorCode: Cardinal): String;
		function GetWarningCount(): Cardinal;
		procedure AddKeyWrappingCallback(const AConsumerID: String; const ATheCallback: PLib3MF_KeyWrappingCallback; const AUserData: Pointer);
		procedure SetContentEncryptionCallback(const ATheCallback: PLib3MF_ContentEncryptionCallback; const AUserData: Pointer);
	end;


(*************************************************************************************************************************
 Class definition for Reader
**************************************************************************************************************************)

	TLib3MFReader = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		procedure ReadFromFile(const AFilename: String);
		procedure ReadFromBuffer(const ABuffer: TByteDynArray);
		procedure ReadFromCallback(const ATheReadCallback: PLib3MF_ReadCallback; const AStreamSize: QWord; const ATheSeekCallback: PLib3MF_SeekCallback; const AUserData: Pointer);
		procedure SetProgressCallback(const AProgressCallback: PLib3MF_ProgressCallback; const AUserData: Pointer);
		procedure AddRelationToRead(const ARelationShipType: String);
		procedure RemoveRelationToRead(const ARelationShipType: String);
		procedure SetStrictModeActive(const AStrictModeActive: Boolean);
		function GetStrictModeActive(): Boolean;
		function GetWarning(const AIndex: Cardinal; out AErrorCode: Cardinal): String;
		function GetWarningCount(): Cardinal;
		procedure AddKeyWrappingCallback(const AConsumerID: String; const ATheCallback: PLib3MF_KeyWrappingCallback; const AUserData: Pointer);
		procedure SetContentEncryptionCallback(const ATheCallback: PLib3MF_ContentEncryptionCallback; const AUserData: Pointer);
	end;


(*************************************************************************************************************************
 Class definition for PackagePart
**************************************************************************************************************************)

	TLib3MFPackagePart = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetPath(): String;
		procedure SetPath(const APath: String);
	end;


(*************************************************************************************************************************
 Class definition for Resource
**************************************************************************************************************************)

	TLib3MFResource = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetResourceID(): Cardinal;
		function GetUniqueResourceID(): Cardinal;
		function PackagePart(): TLib3MFPackagePart;
		procedure SetPackagePart(const APackagePart: TLib3MFPackagePart);
		function GetModelResourceID(): Cardinal;
	end;


(*************************************************************************************************************************
 Class definition for ResourceIterator
**************************************************************************************************************************)

	TLib3MFResourceIterator = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function MoveNext(): Boolean;
		function MovePrevious(): Boolean;
		function GetCurrent(): TLib3MFResource;
		function Clone(): TLib3MFResourceIterator;
		function Count(): QWord;
	end;


(*************************************************************************************************************************
 Class definition for SliceStackIterator
**************************************************************************************************************************)

	TLib3MFSliceStackIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentSliceStack(): TLib3MFSliceStack;
	end;


(*************************************************************************************************************************
 Class definition for ObjectIterator
**************************************************************************************************************************)

	TLib3MFObjectIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentObject(): TLib3MFObject;
	end;


(*************************************************************************************************************************
 Class definition for MeshObjectIterator
**************************************************************************************************************************)

	TLib3MFMeshObjectIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentMeshObject(): TLib3MFMeshObject;
	end;


(*************************************************************************************************************************
 Class definition for ComponentsObjectIterator
**************************************************************************************************************************)

	TLib3MFComponentsObjectIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentComponentsObject(): TLib3MFComponentsObject;
	end;


(*************************************************************************************************************************
 Class definition for Texture2DIterator
**************************************************************************************************************************)

	TLib3MFTexture2DIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentTexture2D(): TLib3MFTexture2D;
	end;


(*************************************************************************************************************************
 Class definition for BaseMaterialGroupIterator
**************************************************************************************************************************)

	TLib3MFBaseMaterialGroupIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentBaseMaterialGroup(): TLib3MFBaseMaterialGroup;
	end;


(*************************************************************************************************************************
 Class definition for ColorGroupIterator
**************************************************************************************************************************)

	TLib3MFColorGroupIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentColorGroup(): TLib3MFColorGroup;
	end;


(*************************************************************************************************************************
 Class definition for Texture2DGroupIterator
**************************************************************************************************************************)

	TLib3MFTexture2DGroupIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentTexture2DGroup(): TLib3MFTexture2DGroup;
	end;


(*************************************************************************************************************************
 Class definition for CompositeMaterialsIterator
**************************************************************************************************************************)

	TLib3MFCompositeMaterialsIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentCompositeMaterials(): TLib3MFCompositeMaterials;
	end;


(*************************************************************************************************************************
 Class definition for MultiPropertyGroupIterator
**************************************************************************************************************************)

	TLib3MFMultiPropertyGroupIterator = class(TLib3MFResourceIterator)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCurrentMultiPropertyGroup(): TLib3MFMultiPropertyGroup;
	end;


(*************************************************************************************************************************
 Class definition for MetaData
**************************************************************************************************************************)

	TLib3MFMetaData = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetNameSpace(): String;
		procedure SetNameSpace(const ANameSpace: String);
		function GetName(): String;
		procedure SetName(const AName: String);
		function GetKey(): String;
		function GetMustPreserve(): Boolean;
		procedure SetMustPreserve(const AMustPreserve: Boolean);
		function GetType(): String;
		procedure SetType(const AType: String);
		function GetValue(): String;
		procedure SetValue(const AValue: String);
	end;


(*************************************************************************************************************************
 Class definition for MetaDataGroup
**************************************************************************************************************************)

	TLib3MFMetaDataGroup = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetMetaDataCount(): Cardinal;
		function GetMetaData(const AIndex: Cardinal): TLib3MFMetaData;
		function GetMetaDataByKey(const ANameSpace: String; const AName: String): TLib3MFMetaData;
		procedure RemoveMetaDataByIndex(const AIndex: Cardinal);
		procedure RemoveMetaData(const ATheMetaData: TLib3MFMetaData);
		function AddMetaData(const ANameSpace: String; const AName: String; const AValue: String; const AType: String; const AMustPreserve: Boolean): TLib3MFMetaData;
	end;


(*************************************************************************************************************************
 Class definition for Object
**************************************************************************************************************************)

	TLib3MFObject = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetType(): TLib3MFObjectType;
		procedure SetType(const AObjectType: TLib3MFObjectType);
		function GetName(): String;
		procedure SetName(const AName: String);
		function GetPartNumber(): String;
		procedure SetPartNumber(const APartNumber: String);
		function IsMeshObject(): Boolean;
		function IsComponentsObject(): Boolean;
		function IsValid(): Boolean;
		procedure SetAttachmentAsThumbnail(const AAttachment: TLib3MFAttachment);
		function GetThumbnailAttachment(): TLib3MFAttachment;
		procedure ClearThumbnailAttachment();
		function GetOutbox(): TLib3MFBox;
		function GetUUID(out AHasUUID: Boolean): String;
		procedure SetUUID(const AUUID: String);
		function GetMetaDataGroup(): TLib3MFMetaDataGroup;
		procedure SetSlicesMeshResolution(const AMeshResolution: TLib3MFSlicesMeshResolution);
		function GetSlicesMeshResolution(): TLib3MFSlicesMeshResolution;
		function HasSlices(const ARecursive: Boolean): Boolean;
		procedure ClearSliceStack();
		function GetSliceStack(): TLib3MFSliceStack;
		procedure AssignSliceStack(const ASliceStackInstance: TLib3MFSliceStack);
	end;


(*************************************************************************************************************************
 Class definition for MeshObject
**************************************************************************************************************************)

	TLib3MFMeshObject = class(TLib3MFObject)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetVertexCount(): Cardinal;
		function GetTriangleCount(): Cardinal;
		function GetVertex(const AIndex: Cardinal): TLib3MFPosition;
		procedure SetVertex(const AIndex: Cardinal; const ACoordinates: TLib3MFPosition);
		function AddVertex(const ACoordinates: TLib3MFPosition): Cardinal;
		procedure GetVertices(out AVertices: ArrayOfLib3MFPosition);
		function GetTriangle(const AIndex: Cardinal): TLib3MFTriangle;
		procedure SetTriangle(const AIndex: Cardinal; const AIndices: TLib3MFTriangle);
		function AddTriangle(const AIndices: TLib3MFTriangle): Cardinal;
		procedure GetTriangleIndices(out AIndices: ArrayOfLib3MFTriangle);
		procedure SetObjectLevelProperty(const AUniqueResourceID: Cardinal; const APropertyID: Cardinal);
		function GetObjectLevelProperty(out AUniqueResourceID: Cardinal; out APropertyID: Cardinal): Boolean;
		procedure SetTriangleProperties(const AIndex: Cardinal; const AProperties: TLib3MFTriangleProperties);
		procedure GetTriangleProperties(const AIndex: Cardinal; out AProperty: TLib3MFTriangleProperties);
		procedure SetAllTriangleProperties(const APropertiesArray: ArrayOfLib3MFTriangleProperties);
		procedure GetAllTriangleProperties(out APropertiesArray: ArrayOfLib3MFTriangleProperties);
		procedure ClearAllProperties();
		procedure SetGeometry(const AVertices: ArrayOfLib3MFPosition; const AIndices: ArrayOfLib3MFTriangle);
		function IsManifoldAndOriented(): Boolean;
		function BeamLattice(): TLib3MFBeamLattice;
	end;


(*************************************************************************************************************************
 Class definition for BeamLattice
**************************************************************************************************************************)

	TLib3MFBeamLattice = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetMinLength(): Double;
		procedure SetMinLength(const AMinLength: Double);
		procedure GetClipping(out AClipMode: TLib3MFBeamLatticeClipMode; out AUniqueResourceID: Cardinal);
		procedure SetClipping(const AClipMode: TLib3MFBeamLatticeClipMode; const AUniqueResourceID: Cardinal);
		function GetRepresentation(out AUniqueResourceID: Cardinal): Boolean;
		procedure SetRepresentation(const AUniqueResourceID: Cardinal);
		procedure GetBallOptions(out ABallMode: TLib3MFBeamLatticeBallMode; out ABallRadius: Double);
		procedure SetBallOptions(const ABallMode: TLib3MFBeamLatticeBallMode; const ABallRadius: Double);
		function GetBeamCount(): Cardinal;
		function GetBeam(const AIndex: Cardinal): TLib3MFBeam;
		function AddBeam(const ABeamInfo: TLib3MFBeam): Cardinal;
		procedure SetBeam(const AIndex: Cardinal; const ABeamInfo: TLib3MFBeam);
		procedure SetBeams(const ABeamInfo: ArrayOfLib3MFBeam);
		procedure GetBeams(out ABeamInfo: ArrayOfLib3MFBeam);
		function GetBallCount(): Cardinal;
		function GetBall(const AIndex: Cardinal): TLib3MFBall;
		function AddBall(const ABallInfo: TLib3MFBall): Cardinal;
		procedure SetBall(const AIndex: Cardinal; const ABallInfo: TLib3MFBall);
		procedure SetBalls(const ABallInfo: ArrayOfLib3MFBall);
		procedure GetBalls(out ABallInfo: ArrayOfLib3MFBall);
		function GetBeamSetCount(): Cardinal;
		function AddBeamSet(): TLib3MFBeamSet;
		function GetBeamSet(const AIndex: Cardinal): TLib3MFBeamSet;
	end;


(*************************************************************************************************************************
 Class definition for Component
**************************************************************************************************************************)

	TLib3MFComponent = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetObjectResource(): TLib3MFObject;
		function GetObjectResourceID(): Cardinal;
		function GetUUID(out AHasUUID: Boolean): String;
		procedure SetUUID(const AUUID: String);
		function HasTransform(): Boolean;
		function GetTransform(): TLib3MFTransform;
		procedure SetTransform(const ATransform: TLib3MFTransform);
	end;


(*************************************************************************************************************************
 Class definition for ComponentsObject
**************************************************************************************************************************)

	TLib3MFComponentsObject = class(TLib3MFObject)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function AddComponent(const AObjectResource: TLib3MFObject; const ATransform: TLib3MFTransform): TLib3MFComponent;
		function GetComponent(const AIndex: Cardinal): TLib3MFComponent;
		function GetComponentCount(): Cardinal;
	end;


(*************************************************************************************************************************
 Class definition for BeamSet
**************************************************************************************************************************)

	TLib3MFBeamSet = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		procedure SetName(const AName: String);
		function GetName(): String;
		procedure SetIdentifier(const AIdentifier: String);
		function GetIdentifier(): String;
		function GetReferenceCount(): Cardinal;
		procedure SetReferences(const AReferences: TCardinalDynArray);
		procedure GetReferences(out AReferences: TCardinalDynArray);
		function GetBallReferenceCount(): Cardinal;
		procedure SetBallReferences(const ABallReferences: TCardinalDynArray);
		procedure GetBallReferences(out ABallReferences: TCardinalDynArray);
	end;


(*************************************************************************************************************************
 Class definition for BaseMaterialGroup
**************************************************************************************************************************)

	TLib3MFBaseMaterialGroup = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCount(): Cardinal;
		procedure GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
		function AddMaterial(const AName: String; const ADisplayColor: TLib3MFColor): Cardinal;
		procedure RemoveMaterial(const APropertyID: Cardinal);
		function GetName(const APropertyID: Cardinal): String;
		procedure SetName(const APropertyID: Cardinal; const AName: String);
		procedure SetDisplayColor(const APropertyID: Cardinal; const ATheColor: TLib3MFColor);
		function GetDisplayColor(const APropertyID: Cardinal): TLib3MFColor;
	end;


(*************************************************************************************************************************
 Class definition for ColorGroup
**************************************************************************************************************************)

	TLib3MFColorGroup = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCount(): Cardinal;
		procedure GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
		function AddColor(const ATheColor: TLib3MFColor): Cardinal;
		procedure RemoveColor(const APropertyID: Cardinal);
		procedure SetColor(const APropertyID: Cardinal; const ATheColor: TLib3MFColor);
		function GetColor(const APropertyID: Cardinal): TLib3MFColor;
	end;


(*************************************************************************************************************************
 Class definition for Texture2DGroup
**************************************************************************************************************************)

	TLib3MFTexture2DGroup = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCount(): Cardinal;
		procedure GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
		function AddTex2Coord(const AUVCoordinate: TLib3MFTex2Coord): Cardinal;
		function GetTex2Coord(const APropertyID: Cardinal): TLib3MFTex2Coord;
		procedure RemoveTex2Coord(const APropertyID: Cardinal);
		function GetTexture2D(): TLib3MFTexture2D;
	end;


(*************************************************************************************************************************
 Class definition for CompositeMaterials
**************************************************************************************************************************)

	TLib3MFCompositeMaterials = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCount(): Cardinal;
		procedure GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
		function GetBaseMaterialGroup(): TLib3MFBaseMaterialGroup;
		function AddComposite(const AComposite: ArrayOfLib3MFCompositeConstituent): Cardinal;
		procedure RemoveComposite(const APropertyID: Cardinal);
		procedure GetComposite(const APropertyID: Cardinal; out AComposite: ArrayOfLib3MFCompositeConstituent);
	end;


(*************************************************************************************************************************
 Class definition for MultiPropertyGroup
**************************************************************************************************************************)

	TLib3MFMultiPropertyGroup = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetCount(): Cardinal;
		procedure GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
		function AddMultiProperty(const APropertyIDs: TCardinalDynArray): Cardinal;
		procedure SetMultiProperty(const APropertyID: Cardinal; const APropertyIDs: TCardinalDynArray);
		procedure GetMultiProperty(const APropertyID: Cardinal; out APropertyIDs: TCardinalDynArray);
		procedure RemoveMultiProperty(const APropertyID: Cardinal);
		function GetLayerCount(): Cardinal;
		function AddLayer(const ATheLayer: TLib3MFMultiPropertyLayer): Cardinal;
		function GetLayer(const ALayerIndex: Cardinal): TLib3MFMultiPropertyLayer;
		procedure RemoveLayer(const ALayerIndex: Cardinal);
	end;


(*************************************************************************************************************************
 Class definition for Attachment
**************************************************************************************************************************)

	TLib3MFAttachment = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetPath(): String;
		procedure SetPath(const APath: String);
		function PackagePart(): TLib3MFPackagePart;
		function GetRelationShipType(): String;
		procedure SetRelationShipType(const APath: String);
		procedure WriteToFile(const AFileName: String);
		procedure ReadFromFile(const AFileName: String);
		procedure ReadFromCallback(const ATheReadCallback: PLib3MF_ReadCallback; const AStreamSize: QWord; const ATheSeekCallback: PLib3MF_SeekCallback; const AUserData: Pointer);
		function GetStreamSize(): QWord;
		procedure WriteToBuffer(out ABuffer: TByteDynArray);
		procedure ReadFromBuffer(const ABuffer: TByteDynArray);
	end;


(*************************************************************************************************************************
 Class definition for Texture2D
**************************************************************************************************************************)

	TLib3MFTexture2D = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetAttachment(): TLib3MFAttachment;
		procedure SetAttachment(const AAttachment: TLib3MFAttachment);
		function GetContentType(): TLib3MFTextureType;
		procedure SetContentType(const AContentType: TLib3MFTextureType);
		procedure GetTileStyleUV(out ATileStyleU: TLib3MFTextureTileStyle; out ATileStyleV: TLib3MFTextureTileStyle);
		procedure SetTileStyleUV(const ATileStyleU: TLib3MFTextureTileStyle; const ATileStyleV: TLib3MFTextureTileStyle);
		function GetFilter(): TLib3MFTextureFilter;
		procedure SetFilter(const AFilter: TLib3MFTextureFilter);
	end;


(*************************************************************************************************************************
 Class definition for BuildItem
**************************************************************************************************************************)

	TLib3MFBuildItem = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetObjectResource(): TLib3MFObject;
		function GetUUID(out AHasUUID: Boolean): String;
		procedure SetUUID(const AUUID: String);
		function GetObjectResourceID(): Cardinal;
		function HasObjectTransform(): Boolean;
		function GetObjectTransform(): TLib3MFTransform;
		procedure SetObjectTransform(const ATransform: TLib3MFTransform);
		function GetPartNumber(): String;
		procedure SetPartNumber(const ASetPartnumber: String);
		function GetMetaDataGroup(): TLib3MFMetaDataGroup;
		function GetOutbox(): TLib3MFBox;
	end;


(*************************************************************************************************************************
 Class definition for BuildItemIterator
**************************************************************************************************************************)

	TLib3MFBuildItemIterator = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function MoveNext(): Boolean;
		function MovePrevious(): Boolean;
		function GetCurrent(): TLib3MFBuildItem;
		function Clone(): TLib3MFBuildItemIterator;
		function Count(): QWord;
	end;


(*************************************************************************************************************************
 Class definition for Slice
**************************************************************************************************************************)

	TLib3MFSlice = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		procedure SetVertices(const AVertices: ArrayOfLib3MFPosition2D);
		procedure GetVertices(out AVertices: ArrayOfLib3MFPosition2D);
		function GetVertexCount(): QWord;
		function AddPolygon(const AIndices: TCardinalDynArray): QWord;
		function GetPolygonCount(): QWord;
		procedure SetPolygonIndices(const AIndex: QWord; const AIndices: TCardinalDynArray);
		procedure GetPolygonIndices(const AIndex: QWord; out AIndices: TCardinalDynArray);
		function GetPolygonIndexCount(const AIndex: QWord): QWord;
		function GetZTop(): Double;
	end;


(*************************************************************************************************************************
 Class definition for SliceStack
**************************************************************************************************************************)

	TLib3MFSliceStack = class(TLib3MFResource)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetBottomZ(): Double;
		function GetSliceCount(): QWord;
		function GetSlice(const ASliceIndex: QWord): TLib3MFSlice;
		function AddSlice(const AZTop: Double): TLib3MFSlice;
		function GetSliceRefCount(): QWord;
		procedure AddSliceStackReference(const ATheSliceStack: TLib3MFSliceStack);
		function GetSliceStackReference(const ASliceRefIndex: QWord): TLib3MFSliceStack;
		procedure CollapseSliceReferences();
		procedure SetOwnPath(const APath: String);
		function GetOwnPath(): String;
	end;


(*************************************************************************************************************************
 Class definition for Consumer
**************************************************************************************************************************)

	TLib3MFConsumer = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetConsumerID(): String;
		function GetKeyID(): String;
		function GetKeyValue(): String;
	end;


(*************************************************************************************************************************
 Class definition for AccessRight
**************************************************************************************************************************)

	TLib3MFAccessRight = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetConsumer(): TLib3MFConsumer;
		function GetWrappingAlgorithm(): TLib3MFWrappingAlgorithm;
		function GetMgfAlgorithm(): TLib3MFMgfAlgorithm;
		function GetDigestMethod(): TLib3MFDigestMethod;
	end;


(*************************************************************************************************************************
 Class definition for ContentEncryptionParams
**************************************************************************************************************************)

	TLib3MFContentEncryptionParams = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetEncryptionAlgorithm(): TLib3MFEncryptionAlgorithm;
		procedure GetKey(out AByteData: TByteDynArray);
		procedure GetInitializationVector(out AByteData: TByteDynArray);
		procedure GetAuthenticationTag(out AByteData: TByteDynArray);
		procedure SetAuthenticationTag(const AByteData: TByteDynArray);
		procedure GetAdditionalAuthenticationData(out AByteData: TByteDynArray);
		function GetDescriptor(): QWord;
		function GetKeyUUID(): String;
	end;


(*************************************************************************************************************************
 Class definition for ResourceData
**************************************************************************************************************************)

	TLib3MFResourceData = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetPath(): TLib3MFPackagePart;
		function GetEncryptionAlgorithm(): TLib3MFEncryptionAlgorithm;
		function GetCompression(): TLib3MFCompression;
		procedure GetAdditionalAuthenticationData(out AByteData: TByteDynArray);
	end;


(*************************************************************************************************************************
 Class definition for ResourceDataGroup
**************************************************************************************************************************)

	TLib3MFResourceDataGroup = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function GetKeyUUID(): String;
		function AddAccessRight(const AConsumer: TLib3MFConsumer; const AWrappingAlgorithm: TLib3MFWrappingAlgorithm; const AMgfAlgorithm: TLib3MFMgfAlgorithm; const ADigestMethod: TLib3MFDigestMethod): TLib3MFAccessRight;
		function FindAccessRightByConsumer(const AConsumer: TLib3MFConsumer): TLib3MFAccessRight;
		procedure RemoveAccessRight(const AConsumer: TLib3MFConsumer);
	end;


(*************************************************************************************************************************
 Class definition for KeyStore
**************************************************************************************************************************)

	TLib3MFKeyStore = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function AddConsumer(const AConsumerID: String; const AKeyID: String; const AKeyValue: String): TLib3MFConsumer;
		function GetConsumerCount(): QWord;
		function GetConsumer(const AConsumerIndex: QWord): TLib3MFConsumer;
		procedure RemoveConsumer(const AConsumer: TLib3MFConsumer);
		function FindConsumer(const AConsumerID: String): TLib3MFConsumer;
		function GetResourceDataGroupCount(): QWord;
		function AddResourceDataGroup(): TLib3MFResourceDataGroup;
		function GetResourceDataGroup(const AResourceDataIndex: QWord): TLib3MFResourceDataGroup;
		procedure RemoveResourceDataGroup(const AResourceDataGroup: TLib3MFResourceDataGroup);
		function FindResourceDataGroup(const APartPath: TLib3MFPackagePart): TLib3MFResourceDataGroup;
		function AddResourceData(const AResourceDataGroup: TLib3MFResourceDataGroup; const APartPath: TLib3MFPackagePart; const AAlgorithm: TLib3MFEncryptionAlgorithm; const ACompression: TLib3MFCompression; const AAdditionalAuthenticationData: TByteDynArray): TLib3MFResourceData;
		procedure RemoveResourceData(const AResourceData: TLib3MFResourceData);
		function FindResourceData(const AResourcePath: TLib3MFPackagePart): TLib3MFResourceData;
		function GetResourceDataCount(): QWord;
		function GetResourceData(const AResourceDataIndex: QWord): TLib3MFResourceData;
		function GetUUID(out AHasUUID: Boolean): String;
		procedure SetUUID(const AUUID: String);
	end;


(*************************************************************************************************************************
 Class definition for Model
**************************************************************************************************************************)

	TLib3MFModel = class(TLib3MFBase)
	public
		constructor Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
		destructor Destroy; override;
		function RootModelPart(): TLib3MFPackagePart;
		function FindOrCreatePackagePart(const AAbsolutePath: String): TLib3MFPackagePart;
		procedure SetUnit(const AUnit: TLib3MFModelUnit);
		function GetUnit(): TLib3MFModelUnit;
		function GetLanguage(): String;
		procedure SetLanguage(const ALanguage: String);
		function QueryWriter(const AWriterClass: String): TLib3MFWriter;
		function QueryReader(const AReaderClass: String): TLib3MFReader;
		function GetResourceByID(const AUniqueResourceID: Cardinal): TLib3MFResource;
		function GetTexture2DByID(const AUniqueResourceID: Cardinal): TLib3MFTexture2D;
		function GetPropertyTypeByID(const AUniqueResourceID: Cardinal): TLib3MFPropertyType;
		function GetBaseMaterialGroupByID(const AUniqueResourceID: Cardinal): TLib3MFBaseMaterialGroup;
		function GetTexture2DGroupByID(const AUniqueResourceID: Cardinal): TLib3MFTexture2DGroup;
		function GetCompositeMaterialsByID(const AUniqueResourceID: Cardinal): TLib3MFCompositeMaterials;
		function GetMultiPropertyGroupByID(const AUniqueResourceID: Cardinal): TLib3MFMultiPropertyGroup;
		function GetMeshObjectByID(const AUniqueResourceID: Cardinal): TLib3MFMeshObject;
		function GetComponentsObjectByID(const AUniqueResourceID: Cardinal): TLib3MFComponentsObject;
		function GetColorGroupByID(const AUniqueResourceID: Cardinal): TLib3MFColorGroup;
		function GetSliceStackByID(const AUniqueResourceID: Cardinal): TLib3MFSliceStack;
		function GetBuildUUID(out AHasUUID: Boolean): String;
		procedure SetBuildUUID(const AUUID: String);
		function GetBuildItems(): TLib3MFBuildItemIterator;
		function GetOutbox(): TLib3MFBox;
		function GetResources(): TLib3MFResourceIterator;
		function GetObjects(): TLib3MFObjectIterator;
		function GetMeshObjects(): TLib3MFMeshObjectIterator;
		function GetComponentsObjects(): TLib3MFComponentsObjectIterator;
		function GetTexture2Ds(): TLib3MFTexture2DIterator;
		function GetBaseMaterialGroups(): TLib3MFBaseMaterialGroupIterator;
		function GetColorGroups(): TLib3MFColorGroupIterator;
		function GetTexture2DGroups(): TLib3MFTexture2DGroupIterator;
		function GetCompositeMaterials(): TLib3MFCompositeMaterialsIterator;
		function GetMultiPropertyGroups(): TLib3MFMultiPropertyGroupIterator;
		function GetSliceStacks(): TLib3MFSliceStackIterator;
		function MergeToModel(): TLib3MFModel;
		function AddMeshObject(): TLib3MFMeshObject;
		function AddComponentsObject(): TLib3MFComponentsObject;
		function AddSliceStack(const AZBottom: Double): TLib3MFSliceStack;
		function AddTexture2DFromAttachment(const ATextureAttachment: TLib3MFAttachment): TLib3MFTexture2D;
		function AddBaseMaterialGroup(): TLib3MFBaseMaterialGroup;
		function AddColorGroup(): TLib3MFColorGroup;
		function AddTexture2DGroup(const ATexture2DInstance: TLib3MFTexture2D): TLib3MFTexture2DGroup;
		function AddCompositeMaterials(const ABaseMaterialGroupInstance: TLib3MFBaseMaterialGroup): TLib3MFCompositeMaterials;
		function AddMultiPropertyGroup(): TLib3MFMultiPropertyGroup;
		function AddBuildItem(const AObject: TLib3MFObject; const ATransform: TLib3MFTransform): TLib3MFBuildItem;
		procedure RemoveBuildItem(const ABuildItemInstance: TLib3MFBuildItem);
		function GetMetaDataGroup(): TLib3MFMetaDataGroup;
		function AddAttachment(const AURI: String; const ARelationShipType: String): TLib3MFAttachment;
		procedure RemoveAttachment(const AAttachmentInstance: TLib3MFAttachment);
		function GetAttachment(const AIndex: Cardinal): TLib3MFAttachment;
		function FindAttachment(const AURI: String): TLib3MFAttachment;
		function GetAttachmentCount(): Cardinal;
		function HasPackageThumbnailAttachment(): Boolean;
		function CreatePackageThumbnailAttachment(): TLib3MFAttachment;
		function GetPackageThumbnailAttachment(): TLib3MFAttachment;
		procedure RemovePackageThumbnailAttachment();
		procedure AddCustomContentType(const AExtension: String; const AContentType: String);
		procedure RemoveCustomContentType(const AExtension: String);
		procedure SetRandomNumberCallback(const ATheCallback: PLib3MF_RandomNumberCallback; const AUserData: Pointer);
		function GetKeyStore(): TLib3MFKeyStore;
	end;

(*************************************************************************************************************************
 Wrapper definition
**************************************************************************************************************************)

	TLib3MFWrapper = class(TObject)
	private
		FModule: HMODULE;
		FLib3MFBase_ClassTypeIdFunc: TLib3MFBase_ClassTypeIdFunc;
		FLib3MFWriter_WriteToFileFunc: TLib3MFWriter_WriteToFileFunc;
		FLib3MFWriter_GetStreamSizeFunc: TLib3MFWriter_GetStreamSizeFunc;
		FLib3MFWriter_WriteToBufferFunc: TLib3MFWriter_WriteToBufferFunc;
		FLib3MFWriter_WriteToCallbackFunc: TLib3MFWriter_WriteToCallbackFunc;
		FLib3MFWriter_SetProgressCallbackFunc: TLib3MFWriter_SetProgressCallbackFunc;
		FLib3MFWriter_GetDecimalPrecisionFunc: TLib3MFWriter_GetDecimalPrecisionFunc;
		FLib3MFWriter_SetDecimalPrecisionFunc: TLib3MFWriter_SetDecimalPrecisionFunc;
		FLib3MFWriter_SetStrictModeActiveFunc: TLib3MFWriter_SetStrictModeActiveFunc;
		FLib3MFWriter_GetStrictModeActiveFunc: TLib3MFWriter_GetStrictModeActiveFunc;
		FLib3MFWriter_GetWarningFunc: TLib3MFWriter_GetWarningFunc;
		FLib3MFWriter_GetWarningCountFunc: TLib3MFWriter_GetWarningCountFunc;
		FLib3MFWriter_AddKeyWrappingCallbackFunc: TLib3MFWriter_AddKeyWrappingCallbackFunc;
		FLib3MFWriter_SetContentEncryptionCallbackFunc: TLib3MFWriter_SetContentEncryptionCallbackFunc;
		FLib3MFReader_ReadFromFileFunc: TLib3MFReader_ReadFromFileFunc;
		FLib3MFReader_ReadFromBufferFunc: TLib3MFReader_ReadFromBufferFunc;
		FLib3MFReader_ReadFromCallbackFunc: TLib3MFReader_ReadFromCallbackFunc;
		FLib3MFReader_SetProgressCallbackFunc: TLib3MFReader_SetProgressCallbackFunc;
		FLib3MFReader_AddRelationToReadFunc: TLib3MFReader_AddRelationToReadFunc;
		FLib3MFReader_RemoveRelationToReadFunc: TLib3MFReader_RemoveRelationToReadFunc;
		FLib3MFReader_SetStrictModeActiveFunc: TLib3MFReader_SetStrictModeActiveFunc;
		FLib3MFReader_GetStrictModeActiveFunc: TLib3MFReader_GetStrictModeActiveFunc;
		FLib3MFReader_GetWarningFunc: TLib3MFReader_GetWarningFunc;
		FLib3MFReader_GetWarningCountFunc: TLib3MFReader_GetWarningCountFunc;
		FLib3MFReader_AddKeyWrappingCallbackFunc: TLib3MFReader_AddKeyWrappingCallbackFunc;
		FLib3MFReader_SetContentEncryptionCallbackFunc: TLib3MFReader_SetContentEncryptionCallbackFunc;
		FLib3MFPackagePart_GetPathFunc: TLib3MFPackagePart_GetPathFunc;
		FLib3MFPackagePart_SetPathFunc: TLib3MFPackagePart_SetPathFunc;
		FLib3MFResource_GetResourceIDFunc: TLib3MFResource_GetResourceIDFunc;
		FLib3MFResource_GetUniqueResourceIDFunc: TLib3MFResource_GetUniqueResourceIDFunc;
		FLib3MFResource_PackagePartFunc: TLib3MFResource_PackagePartFunc;
		FLib3MFResource_SetPackagePartFunc: TLib3MFResource_SetPackagePartFunc;
		FLib3MFResource_GetModelResourceIDFunc: TLib3MFResource_GetModelResourceIDFunc;
		FLib3MFResourceIterator_MoveNextFunc: TLib3MFResourceIterator_MoveNextFunc;
		FLib3MFResourceIterator_MovePreviousFunc: TLib3MFResourceIterator_MovePreviousFunc;
		FLib3MFResourceIterator_GetCurrentFunc: TLib3MFResourceIterator_GetCurrentFunc;
		FLib3MFResourceIterator_CloneFunc: TLib3MFResourceIterator_CloneFunc;
		FLib3MFResourceIterator_CountFunc: TLib3MFResourceIterator_CountFunc;
		FLib3MFSliceStackIterator_GetCurrentSliceStackFunc: TLib3MFSliceStackIterator_GetCurrentSliceStackFunc;
		FLib3MFObjectIterator_GetCurrentObjectFunc: TLib3MFObjectIterator_GetCurrentObjectFunc;
		FLib3MFMeshObjectIterator_GetCurrentMeshObjectFunc: TLib3MFMeshObjectIterator_GetCurrentMeshObjectFunc;
		FLib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc: TLib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc;
		FLib3MFTexture2DIterator_GetCurrentTexture2DFunc: TLib3MFTexture2DIterator_GetCurrentTexture2DFunc;
		FLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc: TLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc;
		FLib3MFColorGroupIterator_GetCurrentColorGroupFunc: TLib3MFColorGroupIterator_GetCurrentColorGroupFunc;
		FLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc: TLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc;
		FLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc: TLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc;
		FLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc: TLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc;
		FLib3MFMetaData_GetNameSpaceFunc: TLib3MFMetaData_GetNameSpaceFunc;
		FLib3MFMetaData_SetNameSpaceFunc: TLib3MFMetaData_SetNameSpaceFunc;
		FLib3MFMetaData_GetNameFunc: TLib3MFMetaData_GetNameFunc;
		FLib3MFMetaData_SetNameFunc: TLib3MFMetaData_SetNameFunc;
		FLib3MFMetaData_GetKeyFunc: TLib3MFMetaData_GetKeyFunc;
		FLib3MFMetaData_GetMustPreserveFunc: TLib3MFMetaData_GetMustPreserveFunc;
		FLib3MFMetaData_SetMustPreserveFunc: TLib3MFMetaData_SetMustPreserveFunc;
		FLib3MFMetaData_GetTypeFunc: TLib3MFMetaData_GetTypeFunc;
		FLib3MFMetaData_SetTypeFunc: TLib3MFMetaData_SetTypeFunc;
		FLib3MFMetaData_GetValueFunc: TLib3MFMetaData_GetValueFunc;
		FLib3MFMetaData_SetValueFunc: TLib3MFMetaData_SetValueFunc;
		FLib3MFMetaDataGroup_GetMetaDataCountFunc: TLib3MFMetaDataGroup_GetMetaDataCountFunc;
		FLib3MFMetaDataGroup_GetMetaDataFunc: TLib3MFMetaDataGroup_GetMetaDataFunc;
		FLib3MFMetaDataGroup_GetMetaDataByKeyFunc: TLib3MFMetaDataGroup_GetMetaDataByKeyFunc;
		FLib3MFMetaDataGroup_RemoveMetaDataByIndexFunc: TLib3MFMetaDataGroup_RemoveMetaDataByIndexFunc;
		FLib3MFMetaDataGroup_RemoveMetaDataFunc: TLib3MFMetaDataGroup_RemoveMetaDataFunc;
		FLib3MFMetaDataGroup_AddMetaDataFunc: TLib3MFMetaDataGroup_AddMetaDataFunc;
		FLib3MFObject_GetTypeFunc: TLib3MFObject_GetTypeFunc;
		FLib3MFObject_SetTypeFunc: TLib3MFObject_SetTypeFunc;
		FLib3MFObject_GetNameFunc: TLib3MFObject_GetNameFunc;
		FLib3MFObject_SetNameFunc: TLib3MFObject_SetNameFunc;
		FLib3MFObject_GetPartNumberFunc: TLib3MFObject_GetPartNumberFunc;
		FLib3MFObject_SetPartNumberFunc: TLib3MFObject_SetPartNumberFunc;
		FLib3MFObject_IsMeshObjectFunc: TLib3MFObject_IsMeshObjectFunc;
		FLib3MFObject_IsComponentsObjectFunc: TLib3MFObject_IsComponentsObjectFunc;
		FLib3MFObject_IsValidFunc: TLib3MFObject_IsValidFunc;
		FLib3MFObject_SetAttachmentAsThumbnailFunc: TLib3MFObject_SetAttachmentAsThumbnailFunc;
		FLib3MFObject_GetThumbnailAttachmentFunc: TLib3MFObject_GetThumbnailAttachmentFunc;
		FLib3MFObject_ClearThumbnailAttachmentFunc: TLib3MFObject_ClearThumbnailAttachmentFunc;
		FLib3MFObject_GetOutboxFunc: TLib3MFObject_GetOutboxFunc;
		FLib3MFObject_GetUUIDFunc: TLib3MFObject_GetUUIDFunc;
		FLib3MFObject_SetUUIDFunc: TLib3MFObject_SetUUIDFunc;
		FLib3MFObject_GetMetaDataGroupFunc: TLib3MFObject_GetMetaDataGroupFunc;
		FLib3MFObject_SetSlicesMeshResolutionFunc: TLib3MFObject_SetSlicesMeshResolutionFunc;
		FLib3MFObject_GetSlicesMeshResolutionFunc: TLib3MFObject_GetSlicesMeshResolutionFunc;
		FLib3MFObject_HasSlicesFunc: TLib3MFObject_HasSlicesFunc;
		FLib3MFObject_ClearSliceStackFunc: TLib3MFObject_ClearSliceStackFunc;
		FLib3MFObject_GetSliceStackFunc: TLib3MFObject_GetSliceStackFunc;
		FLib3MFObject_AssignSliceStackFunc: TLib3MFObject_AssignSliceStackFunc;
		FLib3MFMeshObject_GetVertexCountFunc: TLib3MFMeshObject_GetVertexCountFunc;
		FLib3MFMeshObject_GetTriangleCountFunc: TLib3MFMeshObject_GetTriangleCountFunc;
		FLib3MFMeshObject_GetVertexFunc: TLib3MFMeshObject_GetVertexFunc;
		FLib3MFMeshObject_SetVertexFunc: TLib3MFMeshObject_SetVertexFunc;
		FLib3MFMeshObject_AddVertexFunc: TLib3MFMeshObject_AddVertexFunc;
		FLib3MFMeshObject_GetVerticesFunc: TLib3MFMeshObject_GetVerticesFunc;
		FLib3MFMeshObject_GetTriangleFunc: TLib3MFMeshObject_GetTriangleFunc;
		FLib3MFMeshObject_SetTriangleFunc: TLib3MFMeshObject_SetTriangleFunc;
		FLib3MFMeshObject_AddTriangleFunc: TLib3MFMeshObject_AddTriangleFunc;
		FLib3MFMeshObject_GetTriangleIndicesFunc: TLib3MFMeshObject_GetTriangleIndicesFunc;
		FLib3MFMeshObject_SetObjectLevelPropertyFunc: TLib3MFMeshObject_SetObjectLevelPropertyFunc;
		FLib3MFMeshObject_GetObjectLevelPropertyFunc: TLib3MFMeshObject_GetObjectLevelPropertyFunc;
		FLib3MFMeshObject_SetTrianglePropertiesFunc: TLib3MFMeshObject_SetTrianglePropertiesFunc;
		FLib3MFMeshObject_GetTrianglePropertiesFunc: TLib3MFMeshObject_GetTrianglePropertiesFunc;
		FLib3MFMeshObject_SetAllTrianglePropertiesFunc: TLib3MFMeshObject_SetAllTrianglePropertiesFunc;
		FLib3MFMeshObject_GetAllTrianglePropertiesFunc: TLib3MFMeshObject_GetAllTrianglePropertiesFunc;
		FLib3MFMeshObject_ClearAllPropertiesFunc: TLib3MFMeshObject_ClearAllPropertiesFunc;
		FLib3MFMeshObject_SetGeometryFunc: TLib3MFMeshObject_SetGeometryFunc;
		FLib3MFMeshObject_IsManifoldAndOrientedFunc: TLib3MFMeshObject_IsManifoldAndOrientedFunc;
		FLib3MFMeshObject_BeamLatticeFunc: TLib3MFMeshObject_BeamLatticeFunc;
		FLib3MFBeamLattice_GetMinLengthFunc: TLib3MFBeamLattice_GetMinLengthFunc;
		FLib3MFBeamLattice_SetMinLengthFunc: TLib3MFBeamLattice_SetMinLengthFunc;
		FLib3MFBeamLattice_GetClippingFunc: TLib3MFBeamLattice_GetClippingFunc;
		FLib3MFBeamLattice_SetClippingFunc: TLib3MFBeamLattice_SetClippingFunc;
		FLib3MFBeamLattice_GetRepresentationFunc: TLib3MFBeamLattice_GetRepresentationFunc;
		FLib3MFBeamLattice_SetRepresentationFunc: TLib3MFBeamLattice_SetRepresentationFunc;
		FLib3MFBeamLattice_GetBallOptionsFunc: TLib3MFBeamLattice_GetBallOptionsFunc;
		FLib3MFBeamLattice_SetBallOptionsFunc: TLib3MFBeamLattice_SetBallOptionsFunc;
		FLib3MFBeamLattice_GetBeamCountFunc: TLib3MFBeamLattice_GetBeamCountFunc;
		FLib3MFBeamLattice_GetBeamFunc: TLib3MFBeamLattice_GetBeamFunc;
		FLib3MFBeamLattice_AddBeamFunc: TLib3MFBeamLattice_AddBeamFunc;
		FLib3MFBeamLattice_SetBeamFunc: TLib3MFBeamLattice_SetBeamFunc;
		FLib3MFBeamLattice_SetBeamsFunc: TLib3MFBeamLattice_SetBeamsFunc;
		FLib3MFBeamLattice_GetBeamsFunc: TLib3MFBeamLattice_GetBeamsFunc;
		FLib3MFBeamLattice_GetBallCountFunc: TLib3MFBeamLattice_GetBallCountFunc;
		FLib3MFBeamLattice_GetBallFunc: TLib3MFBeamLattice_GetBallFunc;
		FLib3MFBeamLattice_AddBallFunc: TLib3MFBeamLattice_AddBallFunc;
		FLib3MFBeamLattice_SetBallFunc: TLib3MFBeamLattice_SetBallFunc;
		FLib3MFBeamLattice_SetBallsFunc: TLib3MFBeamLattice_SetBallsFunc;
		FLib3MFBeamLattice_GetBallsFunc: TLib3MFBeamLattice_GetBallsFunc;
		FLib3MFBeamLattice_GetBeamSetCountFunc: TLib3MFBeamLattice_GetBeamSetCountFunc;
		FLib3MFBeamLattice_AddBeamSetFunc: TLib3MFBeamLattice_AddBeamSetFunc;
		FLib3MFBeamLattice_GetBeamSetFunc: TLib3MFBeamLattice_GetBeamSetFunc;
		FLib3MFComponent_GetObjectResourceFunc: TLib3MFComponent_GetObjectResourceFunc;
		FLib3MFComponent_GetObjectResourceIDFunc: TLib3MFComponent_GetObjectResourceIDFunc;
		FLib3MFComponent_GetUUIDFunc: TLib3MFComponent_GetUUIDFunc;
		FLib3MFComponent_SetUUIDFunc: TLib3MFComponent_SetUUIDFunc;
		FLib3MFComponent_HasTransformFunc: TLib3MFComponent_HasTransformFunc;
		FLib3MFComponent_GetTransformFunc: TLib3MFComponent_GetTransformFunc;
		FLib3MFComponent_SetTransformFunc: TLib3MFComponent_SetTransformFunc;
		FLib3MFComponentsObject_AddComponentFunc: TLib3MFComponentsObject_AddComponentFunc;
		FLib3MFComponentsObject_GetComponentFunc: TLib3MFComponentsObject_GetComponentFunc;
		FLib3MFComponentsObject_GetComponentCountFunc: TLib3MFComponentsObject_GetComponentCountFunc;
		FLib3MFBeamSet_SetNameFunc: TLib3MFBeamSet_SetNameFunc;
		FLib3MFBeamSet_GetNameFunc: TLib3MFBeamSet_GetNameFunc;
		FLib3MFBeamSet_SetIdentifierFunc: TLib3MFBeamSet_SetIdentifierFunc;
		FLib3MFBeamSet_GetIdentifierFunc: TLib3MFBeamSet_GetIdentifierFunc;
		FLib3MFBeamSet_GetReferenceCountFunc: TLib3MFBeamSet_GetReferenceCountFunc;
		FLib3MFBeamSet_SetReferencesFunc: TLib3MFBeamSet_SetReferencesFunc;
		FLib3MFBeamSet_GetReferencesFunc: TLib3MFBeamSet_GetReferencesFunc;
		FLib3MFBeamSet_GetBallReferenceCountFunc: TLib3MFBeamSet_GetBallReferenceCountFunc;
		FLib3MFBeamSet_SetBallReferencesFunc: TLib3MFBeamSet_SetBallReferencesFunc;
		FLib3MFBeamSet_GetBallReferencesFunc: TLib3MFBeamSet_GetBallReferencesFunc;
		FLib3MFBaseMaterialGroup_GetCountFunc: TLib3MFBaseMaterialGroup_GetCountFunc;
		FLib3MFBaseMaterialGroup_GetAllPropertyIDsFunc: TLib3MFBaseMaterialGroup_GetAllPropertyIDsFunc;
		FLib3MFBaseMaterialGroup_AddMaterialFunc: TLib3MFBaseMaterialGroup_AddMaterialFunc;
		FLib3MFBaseMaterialGroup_RemoveMaterialFunc: TLib3MFBaseMaterialGroup_RemoveMaterialFunc;
		FLib3MFBaseMaterialGroup_GetNameFunc: TLib3MFBaseMaterialGroup_GetNameFunc;
		FLib3MFBaseMaterialGroup_SetNameFunc: TLib3MFBaseMaterialGroup_SetNameFunc;
		FLib3MFBaseMaterialGroup_SetDisplayColorFunc: TLib3MFBaseMaterialGroup_SetDisplayColorFunc;
		FLib3MFBaseMaterialGroup_GetDisplayColorFunc: TLib3MFBaseMaterialGroup_GetDisplayColorFunc;
		FLib3MFColorGroup_GetCountFunc: TLib3MFColorGroup_GetCountFunc;
		FLib3MFColorGroup_GetAllPropertyIDsFunc: TLib3MFColorGroup_GetAllPropertyIDsFunc;
		FLib3MFColorGroup_AddColorFunc: TLib3MFColorGroup_AddColorFunc;
		FLib3MFColorGroup_RemoveColorFunc: TLib3MFColorGroup_RemoveColorFunc;
		FLib3MFColorGroup_SetColorFunc: TLib3MFColorGroup_SetColorFunc;
		FLib3MFColorGroup_GetColorFunc: TLib3MFColorGroup_GetColorFunc;
		FLib3MFTexture2DGroup_GetCountFunc: TLib3MFTexture2DGroup_GetCountFunc;
		FLib3MFTexture2DGroup_GetAllPropertyIDsFunc: TLib3MFTexture2DGroup_GetAllPropertyIDsFunc;
		FLib3MFTexture2DGroup_AddTex2CoordFunc: TLib3MFTexture2DGroup_AddTex2CoordFunc;
		FLib3MFTexture2DGroup_GetTex2CoordFunc: TLib3MFTexture2DGroup_GetTex2CoordFunc;
		FLib3MFTexture2DGroup_RemoveTex2CoordFunc: TLib3MFTexture2DGroup_RemoveTex2CoordFunc;
		FLib3MFTexture2DGroup_GetTexture2DFunc: TLib3MFTexture2DGroup_GetTexture2DFunc;
		FLib3MFCompositeMaterials_GetCountFunc: TLib3MFCompositeMaterials_GetCountFunc;
		FLib3MFCompositeMaterials_GetAllPropertyIDsFunc: TLib3MFCompositeMaterials_GetAllPropertyIDsFunc;
		FLib3MFCompositeMaterials_GetBaseMaterialGroupFunc: TLib3MFCompositeMaterials_GetBaseMaterialGroupFunc;
		FLib3MFCompositeMaterials_AddCompositeFunc: TLib3MFCompositeMaterials_AddCompositeFunc;
		FLib3MFCompositeMaterials_RemoveCompositeFunc: TLib3MFCompositeMaterials_RemoveCompositeFunc;
		FLib3MFCompositeMaterials_GetCompositeFunc: TLib3MFCompositeMaterials_GetCompositeFunc;
		FLib3MFMultiPropertyGroup_GetCountFunc: TLib3MFMultiPropertyGroup_GetCountFunc;
		FLib3MFMultiPropertyGroup_GetAllPropertyIDsFunc: TLib3MFMultiPropertyGroup_GetAllPropertyIDsFunc;
		FLib3MFMultiPropertyGroup_AddMultiPropertyFunc: TLib3MFMultiPropertyGroup_AddMultiPropertyFunc;
		FLib3MFMultiPropertyGroup_SetMultiPropertyFunc: TLib3MFMultiPropertyGroup_SetMultiPropertyFunc;
		FLib3MFMultiPropertyGroup_GetMultiPropertyFunc: TLib3MFMultiPropertyGroup_GetMultiPropertyFunc;
		FLib3MFMultiPropertyGroup_RemoveMultiPropertyFunc: TLib3MFMultiPropertyGroup_RemoveMultiPropertyFunc;
		FLib3MFMultiPropertyGroup_GetLayerCountFunc: TLib3MFMultiPropertyGroup_GetLayerCountFunc;
		FLib3MFMultiPropertyGroup_AddLayerFunc: TLib3MFMultiPropertyGroup_AddLayerFunc;
		FLib3MFMultiPropertyGroup_GetLayerFunc: TLib3MFMultiPropertyGroup_GetLayerFunc;
		FLib3MFMultiPropertyGroup_RemoveLayerFunc: TLib3MFMultiPropertyGroup_RemoveLayerFunc;
		FLib3MFAttachment_GetPathFunc: TLib3MFAttachment_GetPathFunc;
		FLib3MFAttachment_SetPathFunc: TLib3MFAttachment_SetPathFunc;
		FLib3MFAttachment_PackagePartFunc: TLib3MFAttachment_PackagePartFunc;
		FLib3MFAttachment_GetRelationShipTypeFunc: TLib3MFAttachment_GetRelationShipTypeFunc;
		FLib3MFAttachment_SetRelationShipTypeFunc: TLib3MFAttachment_SetRelationShipTypeFunc;
		FLib3MFAttachment_WriteToFileFunc: TLib3MFAttachment_WriteToFileFunc;
		FLib3MFAttachment_ReadFromFileFunc: TLib3MFAttachment_ReadFromFileFunc;
		FLib3MFAttachment_ReadFromCallbackFunc: TLib3MFAttachment_ReadFromCallbackFunc;
		FLib3MFAttachment_GetStreamSizeFunc: TLib3MFAttachment_GetStreamSizeFunc;
		FLib3MFAttachment_WriteToBufferFunc: TLib3MFAttachment_WriteToBufferFunc;
		FLib3MFAttachment_ReadFromBufferFunc: TLib3MFAttachment_ReadFromBufferFunc;
		FLib3MFTexture2D_GetAttachmentFunc: TLib3MFTexture2D_GetAttachmentFunc;
		FLib3MFTexture2D_SetAttachmentFunc: TLib3MFTexture2D_SetAttachmentFunc;
		FLib3MFTexture2D_GetContentTypeFunc: TLib3MFTexture2D_GetContentTypeFunc;
		FLib3MFTexture2D_SetContentTypeFunc: TLib3MFTexture2D_SetContentTypeFunc;
		FLib3MFTexture2D_GetTileStyleUVFunc: TLib3MFTexture2D_GetTileStyleUVFunc;
		FLib3MFTexture2D_SetTileStyleUVFunc: TLib3MFTexture2D_SetTileStyleUVFunc;
		FLib3MFTexture2D_GetFilterFunc: TLib3MFTexture2D_GetFilterFunc;
		FLib3MFTexture2D_SetFilterFunc: TLib3MFTexture2D_SetFilterFunc;
		FLib3MFBuildItem_GetObjectResourceFunc: TLib3MFBuildItem_GetObjectResourceFunc;
		FLib3MFBuildItem_GetUUIDFunc: TLib3MFBuildItem_GetUUIDFunc;
		FLib3MFBuildItem_SetUUIDFunc: TLib3MFBuildItem_SetUUIDFunc;
		FLib3MFBuildItem_GetObjectResourceIDFunc: TLib3MFBuildItem_GetObjectResourceIDFunc;
		FLib3MFBuildItem_HasObjectTransformFunc: TLib3MFBuildItem_HasObjectTransformFunc;
		FLib3MFBuildItem_GetObjectTransformFunc: TLib3MFBuildItem_GetObjectTransformFunc;
		FLib3MFBuildItem_SetObjectTransformFunc: TLib3MFBuildItem_SetObjectTransformFunc;
		FLib3MFBuildItem_GetPartNumberFunc: TLib3MFBuildItem_GetPartNumberFunc;
		FLib3MFBuildItem_SetPartNumberFunc: TLib3MFBuildItem_SetPartNumberFunc;
		FLib3MFBuildItem_GetMetaDataGroupFunc: TLib3MFBuildItem_GetMetaDataGroupFunc;
		FLib3MFBuildItem_GetOutboxFunc: TLib3MFBuildItem_GetOutboxFunc;
		FLib3MFBuildItemIterator_MoveNextFunc: TLib3MFBuildItemIterator_MoveNextFunc;
		FLib3MFBuildItemIterator_MovePreviousFunc: TLib3MFBuildItemIterator_MovePreviousFunc;
		FLib3MFBuildItemIterator_GetCurrentFunc: TLib3MFBuildItemIterator_GetCurrentFunc;
		FLib3MFBuildItemIterator_CloneFunc: TLib3MFBuildItemIterator_CloneFunc;
		FLib3MFBuildItemIterator_CountFunc: TLib3MFBuildItemIterator_CountFunc;
		FLib3MFSlice_SetVerticesFunc: TLib3MFSlice_SetVerticesFunc;
		FLib3MFSlice_GetVerticesFunc: TLib3MFSlice_GetVerticesFunc;
		FLib3MFSlice_GetVertexCountFunc: TLib3MFSlice_GetVertexCountFunc;
		FLib3MFSlice_AddPolygonFunc: TLib3MFSlice_AddPolygonFunc;
		FLib3MFSlice_GetPolygonCountFunc: TLib3MFSlice_GetPolygonCountFunc;
		FLib3MFSlice_SetPolygonIndicesFunc: TLib3MFSlice_SetPolygonIndicesFunc;
		FLib3MFSlice_GetPolygonIndicesFunc: TLib3MFSlice_GetPolygonIndicesFunc;
		FLib3MFSlice_GetPolygonIndexCountFunc: TLib3MFSlice_GetPolygonIndexCountFunc;
		FLib3MFSlice_GetZTopFunc: TLib3MFSlice_GetZTopFunc;
		FLib3MFSliceStack_GetBottomZFunc: TLib3MFSliceStack_GetBottomZFunc;
		FLib3MFSliceStack_GetSliceCountFunc: TLib3MFSliceStack_GetSliceCountFunc;
		FLib3MFSliceStack_GetSliceFunc: TLib3MFSliceStack_GetSliceFunc;
		FLib3MFSliceStack_AddSliceFunc: TLib3MFSliceStack_AddSliceFunc;
		FLib3MFSliceStack_GetSliceRefCountFunc: TLib3MFSliceStack_GetSliceRefCountFunc;
		FLib3MFSliceStack_AddSliceStackReferenceFunc: TLib3MFSliceStack_AddSliceStackReferenceFunc;
		FLib3MFSliceStack_GetSliceStackReferenceFunc: TLib3MFSliceStack_GetSliceStackReferenceFunc;
		FLib3MFSliceStack_CollapseSliceReferencesFunc: TLib3MFSliceStack_CollapseSliceReferencesFunc;
		FLib3MFSliceStack_SetOwnPathFunc: TLib3MFSliceStack_SetOwnPathFunc;
		FLib3MFSliceStack_GetOwnPathFunc: TLib3MFSliceStack_GetOwnPathFunc;
		FLib3MFConsumer_GetConsumerIDFunc: TLib3MFConsumer_GetConsumerIDFunc;
		FLib3MFConsumer_GetKeyIDFunc: TLib3MFConsumer_GetKeyIDFunc;
		FLib3MFConsumer_GetKeyValueFunc: TLib3MFConsumer_GetKeyValueFunc;
		FLib3MFAccessRight_GetConsumerFunc: TLib3MFAccessRight_GetConsumerFunc;
		FLib3MFAccessRight_GetWrappingAlgorithmFunc: TLib3MFAccessRight_GetWrappingAlgorithmFunc;
		FLib3MFAccessRight_GetMgfAlgorithmFunc: TLib3MFAccessRight_GetMgfAlgorithmFunc;
		FLib3MFAccessRight_GetDigestMethodFunc: TLib3MFAccessRight_GetDigestMethodFunc;
		FLib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc: TLib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc;
		FLib3MFContentEncryptionParams_GetKeyFunc: TLib3MFContentEncryptionParams_GetKeyFunc;
		FLib3MFContentEncryptionParams_GetInitializationVectorFunc: TLib3MFContentEncryptionParams_GetInitializationVectorFunc;
		FLib3MFContentEncryptionParams_GetAuthenticationTagFunc: TLib3MFContentEncryptionParams_GetAuthenticationTagFunc;
		FLib3MFContentEncryptionParams_SetAuthenticationTagFunc: TLib3MFContentEncryptionParams_SetAuthenticationTagFunc;
		FLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc: TLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc;
		FLib3MFContentEncryptionParams_GetDescriptorFunc: TLib3MFContentEncryptionParams_GetDescriptorFunc;
		FLib3MFContentEncryptionParams_GetKeyUUIDFunc: TLib3MFContentEncryptionParams_GetKeyUUIDFunc;
		FLib3MFResourceData_GetPathFunc: TLib3MFResourceData_GetPathFunc;
		FLib3MFResourceData_GetEncryptionAlgorithmFunc: TLib3MFResourceData_GetEncryptionAlgorithmFunc;
		FLib3MFResourceData_GetCompressionFunc: TLib3MFResourceData_GetCompressionFunc;
		FLib3MFResourceData_GetAdditionalAuthenticationDataFunc: TLib3MFResourceData_GetAdditionalAuthenticationDataFunc;
		FLib3MFResourceDataGroup_GetKeyUUIDFunc: TLib3MFResourceDataGroup_GetKeyUUIDFunc;
		FLib3MFResourceDataGroup_AddAccessRightFunc: TLib3MFResourceDataGroup_AddAccessRightFunc;
		FLib3MFResourceDataGroup_FindAccessRightByConsumerFunc: TLib3MFResourceDataGroup_FindAccessRightByConsumerFunc;
		FLib3MFResourceDataGroup_RemoveAccessRightFunc: TLib3MFResourceDataGroup_RemoveAccessRightFunc;
		FLib3MFKeyStore_AddConsumerFunc: TLib3MFKeyStore_AddConsumerFunc;
		FLib3MFKeyStore_GetConsumerCountFunc: TLib3MFKeyStore_GetConsumerCountFunc;
		FLib3MFKeyStore_GetConsumerFunc: TLib3MFKeyStore_GetConsumerFunc;
		FLib3MFKeyStore_RemoveConsumerFunc: TLib3MFKeyStore_RemoveConsumerFunc;
		FLib3MFKeyStore_FindConsumerFunc: TLib3MFKeyStore_FindConsumerFunc;
		FLib3MFKeyStore_GetResourceDataGroupCountFunc: TLib3MFKeyStore_GetResourceDataGroupCountFunc;
		FLib3MFKeyStore_AddResourceDataGroupFunc: TLib3MFKeyStore_AddResourceDataGroupFunc;
		FLib3MFKeyStore_GetResourceDataGroupFunc: TLib3MFKeyStore_GetResourceDataGroupFunc;
		FLib3MFKeyStore_RemoveResourceDataGroupFunc: TLib3MFKeyStore_RemoveResourceDataGroupFunc;
		FLib3MFKeyStore_FindResourceDataGroupFunc: TLib3MFKeyStore_FindResourceDataGroupFunc;
		FLib3MFKeyStore_AddResourceDataFunc: TLib3MFKeyStore_AddResourceDataFunc;
		FLib3MFKeyStore_RemoveResourceDataFunc: TLib3MFKeyStore_RemoveResourceDataFunc;
		FLib3MFKeyStore_FindResourceDataFunc: TLib3MFKeyStore_FindResourceDataFunc;
		FLib3MFKeyStore_GetResourceDataCountFunc: TLib3MFKeyStore_GetResourceDataCountFunc;
		FLib3MFKeyStore_GetResourceDataFunc: TLib3MFKeyStore_GetResourceDataFunc;
		FLib3MFKeyStore_GetUUIDFunc: TLib3MFKeyStore_GetUUIDFunc;
		FLib3MFKeyStore_SetUUIDFunc: TLib3MFKeyStore_SetUUIDFunc;
		FLib3MFModel_RootModelPartFunc: TLib3MFModel_RootModelPartFunc;
		FLib3MFModel_FindOrCreatePackagePartFunc: TLib3MFModel_FindOrCreatePackagePartFunc;
		FLib3MFModel_SetUnitFunc: TLib3MFModel_SetUnitFunc;
		FLib3MFModel_GetUnitFunc: TLib3MFModel_GetUnitFunc;
		FLib3MFModel_GetLanguageFunc: TLib3MFModel_GetLanguageFunc;
		FLib3MFModel_SetLanguageFunc: TLib3MFModel_SetLanguageFunc;
		FLib3MFModel_QueryWriterFunc: TLib3MFModel_QueryWriterFunc;
		FLib3MFModel_QueryReaderFunc: TLib3MFModel_QueryReaderFunc;
		FLib3MFModel_GetResourceByIDFunc: TLib3MFModel_GetResourceByIDFunc;
		FLib3MFModel_GetTexture2DByIDFunc: TLib3MFModel_GetTexture2DByIDFunc;
		FLib3MFModel_GetPropertyTypeByIDFunc: TLib3MFModel_GetPropertyTypeByIDFunc;
		FLib3MFModel_GetBaseMaterialGroupByIDFunc: TLib3MFModel_GetBaseMaterialGroupByIDFunc;
		FLib3MFModel_GetTexture2DGroupByIDFunc: TLib3MFModel_GetTexture2DGroupByIDFunc;
		FLib3MFModel_GetCompositeMaterialsByIDFunc: TLib3MFModel_GetCompositeMaterialsByIDFunc;
		FLib3MFModel_GetMultiPropertyGroupByIDFunc: TLib3MFModel_GetMultiPropertyGroupByIDFunc;
		FLib3MFModel_GetMeshObjectByIDFunc: TLib3MFModel_GetMeshObjectByIDFunc;
		FLib3MFModel_GetComponentsObjectByIDFunc: TLib3MFModel_GetComponentsObjectByIDFunc;
		FLib3MFModel_GetColorGroupByIDFunc: TLib3MFModel_GetColorGroupByIDFunc;
		FLib3MFModel_GetSliceStackByIDFunc: TLib3MFModel_GetSliceStackByIDFunc;
		FLib3MFModel_GetBuildUUIDFunc: TLib3MFModel_GetBuildUUIDFunc;
		FLib3MFModel_SetBuildUUIDFunc: TLib3MFModel_SetBuildUUIDFunc;
		FLib3MFModel_GetBuildItemsFunc: TLib3MFModel_GetBuildItemsFunc;
		FLib3MFModel_GetOutboxFunc: TLib3MFModel_GetOutboxFunc;
		FLib3MFModel_GetResourcesFunc: TLib3MFModel_GetResourcesFunc;
		FLib3MFModel_GetObjectsFunc: TLib3MFModel_GetObjectsFunc;
		FLib3MFModel_GetMeshObjectsFunc: TLib3MFModel_GetMeshObjectsFunc;
		FLib3MFModel_GetComponentsObjectsFunc: TLib3MFModel_GetComponentsObjectsFunc;
		FLib3MFModel_GetTexture2DsFunc: TLib3MFModel_GetTexture2DsFunc;
		FLib3MFModel_GetBaseMaterialGroupsFunc: TLib3MFModel_GetBaseMaterialGroupsFunc;
		FLib3MFModel_GetColorGroupsFunc: TLib3MFModel_GetColorGroupsFunc;
		FLib3MFModel_GetTexture2DGroupsFunc: TLib3MFModel_GetTexture2DGroupsFunc;
		FLib3MFModel_GetCompositeMaterialsFunc: TLib3MFModel_GetCompositeMaterialsFunc;
		FLib3MFModel_GetMultiPropertyGroupsFunc: TLib3MFModel_GetMultiPropertyGroupsFunc;
		FLib3MFModel_GetSliceStacksFunc: TLib3MFModel_GetSliceStacksFunc;
		FLib3MFModel_MergeToModelFunc: TLib3MFModel_MergeToModelFunc;
		FLib3MFModel_AddMeshObjectFunc: TLib3MFModel_AddMeshObjectFunc;
		FLib3MFModel_AddComponentsObjectFunc: TLib3MFModel_AddComponentsObjectFunc;
		FLib3MFModel_AddSliceStackFunc: TLib3MFModel_AddSliceStackFunc;
		FLib3MFModel_AddTexture2DFromAttachmentFunc: TLib3MFModel_AddTexture2DFromAttachmentFunc;
		FLib3MFModel_AddBaseMaterialGroupFunc: TLib3MFModel_AddBaseMaterialGroupFunc;
		FLib3MFModel_AddColorGroupFunc: TLib3MFModel_AddColorGroupFunc;
		FLib3MFModel_AddTexture2DGroupFunc: TLib3MFModel_AddTexture2DGroupFunc;
		FLib3MFModel_AddCompositeMaterialsFunc: TLib3MFModel_AddCompositeMaterialsFunc;
		FLib3MFModel_AddMultiPropertyGroupFunc: TLib3MFModel_AddMultiPropertyGroupFunc;
		FLib3MFModel_AddBuildItemFunc: TLib3MFModel_AddBuildItemFunc;
		FLib3MFModel_RemoveBuildItemFunc: TLib3MFModel_RemoveBuildItemFunc;
		FLib3MFModel_GetMetaDataGroupFunc: TLib3MFModel_GetMetaDataGroupFunc;
		FLib3MFModel_AddAttachmentFunc: TLib3MFModel_AddAttachmentFunc;
		FLib3MFModel_RemoveAttachmentFunc: TLib3MFModel_RemoveAttachmentFunc;
		FLib3MFModel_GetAttachmentFunc: TLib3MFModel_GetAttachmentFunc;
		FLib3MFModel_FindAttachmentFunc: TLib3MFModel_FindAttachmentFunc;
		FLib3MFModel_GetAttachmentCountFunc: TLib3MFModel_GetAttachmentCountFunc;
		FLib3MFModel_HasPackageThumbnailAttachmentFunc: TLib3MFModel_HasPackageThumbnailAttachmentFunc;
		FLib3MFModel_CreatePackageThumbnailAttachmentFunc: TLib3MFModel_CreatePackageThumbnailAttachmentFunc;
		FLib3MFModel_GetPackageThumbnailAttachmentFunc: TLib3MFModel_GetPackageThumbnailAttachmentFunc;
		FLib3MFModel_RemovePackageThumbnailAttachmentFunc: TLib3MFModel_RemovePackageThumbnailAttachmentFunc;
		FLib3MFModel_AddCustomContentTypeFunc: TLib3MFModel_AddCustomContentTypeFunc;
		FLib3MFModel_RemoveCustomContentTypeFunc: TLib3MFModel_RemoveCustomContentTypeFunc;
		FLib3MFModel_SetRandomNumberCallbackFunc: TLib3MFModel_SetRandomNumberCallbackFunc;
		FLib3MFModel_GetKeyStoreFunc: TLib3MFModel_GetKeyStoreFunc;
		FLib3MFGetLibraryVersionFunc: TLib3MFGetLibraryVersionFunc;
		FLib3MFGetPrereleaseInformationFunc: TLib3MFGetPrereleaseInformationFunc;
		FLib3MFGetBuildInformationFunc: TLib3MFGetBuildInformationFunc;
		FLib3MFGetSpecificationVersionFunc: TLib3MFGetSpecificationVersionFunc;
		FLib3MFCreateModelFunc: TLib3MFCreateModelFunc;
		FLib3MFReleaseFunc: TLib3MFReleaseFunc;
		FLib3MFAcquireFunc: TLib3MFAcquireFunc;
		FLib3MFSetJournalFunc: TLib3MFSetJournalFunc;
		FLib3MFGetLastErrorFunc: TLib3MFGetLastErrorFunc;
		FLib3MFGetSymbolLookupMethodFunc: TLib3MFGetSymbolLookupMethodFunc;
		FLib3MFRetrieveProgressMessageFunc: TLib3MFRetrieveProgressMessageFunc;
		FLib3MFRGBAToColorFunc: TLib3MFRGBAToColorFunc;
		FLib3MFFloatRGBAToColorFunc: TLib3MFFloatRGBAToColorFunc;
		FLib3MFColorToRGBAFunc: TLib3MFColorToRGBAFunc;
		FLib3MFColorToFloatRGBAFunc: TLib3MFColorToFloatRGBAFunc;
		FLib3MFGetIdentityTransformFunc: TLib3MFGetIdentityTransformFunc;
		FLib3MFGetUniformScaleTransformFunc: TLib3MFGetUniformScaleTransformFunc;
		FLib3MFGetScaleTransformFunc: TLib3MFGetScaleTransformFunc;
		FLib3MFGetTranslationTransformFunc: TLib3MFGetTranslationTransformFunc;

		{$IFDEF MSWINDOWS}
		function LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean = True): FARPROC;
		{$ELSE}
		function LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean = True): Pointer;
		{$ENDIF MSWINDOWS}

		procedure checkBinaryVersion();

	protected
		property Lib3MFBase_ClassTypeIdFunc: TLib3MFBase_ClassTypeIdFunc read FLib3MFBase_ClassTypeIdFunc;
		property Lib3MFWriter_WriteToFileFunc: TLib3MFWriter_WriteToFileFunc read FLib3MFWriter_WriteToFileFunc;
		property Lib3MFWriter_GetStreamSizeFunc: TLib3MFWriter_GetStreamSizeFunc read FLib3MFWriter_GetStreamSizeFunc;
		property Lib3MFWriter_WriteToBufferFunc: TLib3MFWriter_WriteToBufferFunc read FLib3MFWriter_WriteToBufferFunc;
		property Lib3MFWriter_WriteToCallbackFunc: TLib3MFWriter_WriteToCallbackFunc read FLib3MFWriter_WriteToCallbackFunc;
		property Lib3MFWriter_SetProgressCallbackFunc: TLib3MFWriter_SetProgressCallbackFunc read FLib3MFWriter_SetProgressCallbackFunc;
		property Lib3MFWriter_GetDecimalPrecisionFunc: TLib3MFWriter_GetDecimalPrecisionFunc read FLib3MFWriter_GetDecimalPrecisionFunc;
		property Lib3MFWriter_SetDecimalPrecisionFunc: TLib3MFWriter_SetDecimalPrecisionFunc read FLib3MFWriter_SetDecimalPrecisionFunc;
		property Lib3MFWriter_SetStrictModeActiveFunc: TLib3MFWriter_SetStrictModeActiveFunc read FLib3MFWriter_SetStrictModeActiveFunc;
		property Lib3MFWriter_GetStrictModeActiveFunc: TLib3MFWriter_GetStrictModeActiveFunc read FLib3MFWriter_GetStrictModeActiveFunc;
		property Lib3MFWriter_GetWarningFunc: TLib3MFWriter_GetWarningFunc read FLib3MFWriter_GetWarningFunc;
		property Lib3MFWriter_GetWarningCountFunc: TLib3MFWriter_GetWarningCountFunc read FLib3MFWriter_GetWarningCountFunc;
		property Lib3MFWriter_AddKeyWrappingCallbackFunc: TLib3MFWriter_AddKeyWrappingCallbackFunc read FLib3MFWriter_AddKeyWrappingCallbackFunc;
		property Lib3MFWriter_SetContentEncryptionCallbackFunc: TLib3MFWriter_SetContentEncryptionCallbackFunc read FLib3MFWriter_SetContentEncryptionCallbackFunc;
		property Lib3MFReader_ReadFromFileFunc: TLib3MFReader_ReadFromFileFunc read FLib3MFReader_ReadFromFileFunc;
		property Lib3MFReader_ReadFromBufferFunc: TLib3MFReader_ReadFromBufferFunc read FLib3MFReader_ReadFromBufferFunc;
		property Lib3MFReader_ReadFromCallbackFunc: TLib3MFReader_ReadFromCallbackFunc read FLib3MFReader_ReadFromCallbackFunc;
		property Lib3MFReader_SetProgressCallbackFunc: TLib3MFReader_SetProgressCallbackFunc read FLib3MFReader_SetProgressCallbackFunc;
		property Lib3MFReader_AddRelationToReadFunc: TLib3MFReader_AddRelationToReadFunc read FLib3MFReader_AddRelationToReadFunc;
		property Lib3MFReader_RemoveRelationToReadFunc: TLib3MFReader_RemoveRelationToReadFunc read FLib3MFReader_RemoveRelationToReadFunc;
		property Lib3MFReader_SetStrictModeActiveFunc: TLib3MFReader_SetStrictModeActiveFunc read FLib3MFReader_SetStrictModeActiveFunc;
		property Lib3MFReader_GetStrictModeActiveFunc: TLib3MFReader_GetStrictModeActiveFunc read FLib3MFReader_GetStrictModeActiveFunc;
		property Lib3MFReader_GetWarningFunc: TLib3MFReader_GetWarningFunc read FLib3MFReader_GetWarningFunc;
		property Lib3MFReader_GetWarningCountFunc: TLib3MFReader_GetWarningCountFunc read FLib3MFReader_GetWarningCountFunc;
		property Lib3MFReader_AddKeyWrappingCallbackFunc: TLib3MFReader_AddKeyWrappingCallbackFunc read FLib3MFReader_AddKeyWrappingCallbackFunc;
		property Lib3MFReader_SetContentEncryptionCallbackFunc: TLib3MFReader_SetContentEncryptionCallbackFunc read FLib3MFReader_SetContentEncryptionCallbackFunc;
		property Lib3MFPackagePart_GetPathFunc: TLib3MFPackagePart_GetPathFunc read FLib3MFPackagePart_GetPathFunc;
		property Lib3MFPackagePart_SetPathFunc: TLib3MFPackagePart_SetPathFunc read FLib3MFPackagePart_SetPathFunc;
		property Lib3MFResource_GetResourceIDFunc: TLib3MFResource_GetResourceIDFunc read FLib3MFResource_GetResourceIDFunc;
		property Lib3MFResource_GetUniqueResourceIDFunc: TLib3MFResource_GetUniqueResourceIDFunc read FLib3MFResource_GetUniqueResourceIDFunc;
		property Lib3MFResource_PackagePartFunc: TLib3MFResource_PackagePartFunc read FLib3MFResource_PackagePartFunc;
		property Lib3MFResource_SetPackagePartFunc: TLib3MFResource_SetPackagePartFunc read FLib3MFResource_SetPackagePartFunc;
		property Lib3MFResource_GetModelResourceIDFunc: TLib3MFResource_GetModelResourceIDFunc read FLib3MFResource_GetModelResourceIDFunc;
		property Lib3MFResourceIterator_MoveNextFunc: TLib3MFResourceIterator_MoveNextFunc read FLib3MFResourceIterator_MoveNextFunc;
		property Lib3MFResourceIterator_MovePreviousFunc: TLib3MFResourceIterator_MovePreviousFunc read FLib3MFResourceIterator_MovePreviousFunc;
		property Lib3MFResourceIterator_GetCurrentFunc: TLib3MFResourceIterator_GetCurrentFunc read FLib3MFResourceIterator_GetCurrentFunc;
		property Lib3MFResourceIterator_CloneFunc: TLib3MFResourceIterator_CloneFunc read FLib3MFResourceIterator_CloneFunc;
		property Lib3MFResourceIterator_CountFunc: TLib3MFResourceIterator_CountFunc read FLib3MFResourceIterator_CountFunc;
		property Lib3MFSliceStackIterator_GetCurrentSliceStackFunc: TLib3MFSliceStackIterator_GetCurrentSliceStackFunc read FLib3MFSliceStackIterator_GetCurrentSliceStackFunc;
		property Lib3MFObjectIterator_GetCurrentObjectFunc: TLib3MFObjectIterator_GetCurrentObjectFunc read FLib3MFObjectIterator_GetCurrentObjectFunc;
		property Lib3MFMeshObjectIterator_GetCurrentMeshObjectFunc: TLib3MFMeshObjectIterator_GetCurrentMeshObjectFunc read FLib3MFMeshObjectIterator_GetCurrentMeshObjectFunc;
		property Lib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc: TLib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc read FLib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc;
		property Lib3MFTexture2DIterator_GetCurrentTexture2DFunc: TLib3MFTexture2DIterator_GetCurrentTexture2DFunc read FLib3MFTexture2DIterator_GetCurrentTexture2DFunc;
		property Lib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc: TLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc read FLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc;
		property Lib3MFColorGroupIterator_GetCurrentColorGroupFunc: TLib3MFColorGroupIterator_GetCurrentColorGroupFunc read FLib3MFColorGroupIterator_GetCurrentColorGroupFunc;
		property Lib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc: TLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc read FLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc;
		property Lib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc: TLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc read FLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc;
		property Lib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc: TLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc read FLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc;
		property Lib3MFMetaData_GetNameSpaceFunc: TLib3MFMetaData_GetNameSpaceFunc read FLib3MFMetaData_GetNameSpaceFunc;
		property Lib3MFMetaData_SetNameSpaceFunc: TLib3MFMetaData_SetNameSpaceFunc read FLib3MFMetaData_SetNameSpaceFunc;
		property Lib3MFMetaData_GetNameFunc: TLib3MFMetaData_GetNameFunc read FLib3MFMetaData_GetNameFunc;
		property Lib3MFMetaData_SetNameFunc: TLib3MFMetaData_SetNameFunc read FLib3MFMetaData_SetNameFunc;
		property Lib3MFMetaData_GetKeyFunc: TLib3MFMetaData_GetKeyFunc read FLib3MFMetaData_GetKeyFunc;
		property Lib3MFMetaData_GetMustPreserveFunc: TLib3MFMetaData_GetMustPreserveFunc read FLib3MFMetaData_GetMustPreserveFunc;
		property Lib3MFMetaData_SetMustPreserveFunc: TLib3MFMetaData_SetMustPreserveFunc read FLib3MFMetaData_SetMustPreserveFunc;
		property Lib3MFMetaData_GetTypeFunc: TLib3MFMetaData_GetTypeFunc read FLib3MFMetaData_GetTypeFunc;
		property Lib3MFMetaData_SetTypeFunc: TLib3MFMetaData_SetTypeFunc read FLib3MFMetaData_SetTypeFunc;
		property Lib3MFMetaData_GetValueFunc: TLib3MFMetaData_GetValueFunc read FLib3MFMetaData_GetValueFunc;
		property Lib3MFMetaData_SetValueFunc: TLib3MFMetaData_SetValueFunc read FLib3MFMetaData_SetValueFunc;
		property Lib3MFMetaDataGroup_GetMetaDataCountFunc: TLib3MFMetaDataGroup_GetMetaDataCountFunc read FLib3MFMetaDataGroup_GetMetaDataCountFunc;
		property Lib3MFMetaDataGroup_GetMetaDataFunc: TLib3MFMetaDataGroup_GetMetaDataFunc read FLib3MFMetaDataGroup_GetMetaDataFunc;
		property Lib3MFMetaDataGroup_GetMetaDataByKeyFunc: TLib3MFMetaDataGroup_GetMetaDataByKeyFunc read FLib3MFMetaDataGroup_GetMetaDataByKeyFunc;
		property Lib3MFMetaDataGroup_RemoveMetaDataByIndexFunc: TLib3MFMetaDataGroup_RemoveMetaDataByIndexFunc read FLib3MFMetaDataGroup_RemoveMetaDataByIndexFunc;
		property Lib3MFMetaDataGroup_RemoveMetaDataFunc: TLib3MFMetaDataGroup_RemoveMetaDataFunc read FLib3MFMetaDataGroup_RemoveMetaDataFunc;
		property Lib3MFMetaDataGroup_AddMetaDataFunc: TLib3MFMetaDataGroup_AddMetaDataFunc read FLib3MFMetaDataGroup_AddMetaDataFunc;
		property Lib3MFObject_GetTypeFunc: TLib3MFObject_GetTypeFunc read FLib3MFObject_GetTypeFunc;
		property Lib3MFObject_SetTypeFunc: TLib3MFObject_SetTypeFunc read FLib3MFObject_SetTypeFunc;
		property Lib3MFObject_GetNameFunc: TLib3MFObject_GetNameFunc read FLib3MFObject_GetNameFunc;
		property Lib3MFObject_SetNameFunc: TLib3MFObject_SetNameFunc read FLib3MFObject_SetNameFunc;
		property Lib3MFObject_GetPartNumberFunc: TLib3MFObject_GetPartNumberFunc read FLib3MFObject_GetPartNumberFunc;
		property Lib3MFObject_SetPartNumberFunc: TLib3MFObject_SetPartNumberFunc read FLib3MFObject_SetPartNumberFunc;
		property Lib3MFObject_IsMeshObjectFunc: TLib3MFObject_IsMeshObjectFunc read FLib3MFObject_IsMeshObjectFunc;
		property Lib3MFObject_IsComponentsObjectFunc: TLib3MFObject_IsComponentsObjectFunc read FLib3MFObject_IsComponentsObjectFunc;
		property Lib3MFObject_IsValidFunc: TLib3MFObject_IsValidFunc read FLib3MFObject_IsValidFunc;
		property Lib3MFObject_SetAttachmentAsThumbnailFunc: TLib3MFObject_SetAttachmentAsThumbnailFunc read FLib3MFObject_SetAttachmentAsThumbnailFunc;
		property Lib3MFObject_GetThumbnailAttachmentFunc: TLib3MFObject_GetThumbnailAttachmentFunc read FLib3MFObject_GetThumbnailAttachmentFunc;
		property Lib3MFObject_ClearThumbnailAttachmentFunc: TLib3MFObject_ClearThumbnailAttachmentFunc read FLib3MFObject_ClearThumbnailAttachmentFunc;
		property Lib3MFObject_GetOutboxFunc: TLib3MFObject_GetOutboxFunc read FLib3MFObject_GetOutboxFunc;
		property Lib3MFObject_GetUUIDFunc: TLib3MFObject_GetUUIDFunc read FLib3MFObject_GetUUIDFunc;
		property Lib3MFObject_SetUUIDFunc: TLib3MFObject_SetUUIDFunc read FLib3MFObject_SetUUIDFunc;
		property Lib3MFObject_GetMetaDataGroupFunc: TLib3MFObject_GetMetaDataGroupFunc read FLib3MFObject_GetMetaDataGroupFunc;
		property Lib3MFObject_SetSlicesMeshResolutionFunc: TLib3MFObject_SetSlicesMeshResolutionFunc read FLib3MFObject_SetSlicesMeshResolutionFunc;
		property Lib3MFObject_GetSlicesMeshResolutionFunc: TLib3MFObject_GetSlicesMeshResolutionFunc read FLib3MFObject_GetSlicesMeshResolutionFunc;
		property Lib3MFObject_HasSlicesFunc: TLib3MFObject_HasSlicesFunc read FLib3MFObject_HasSlicesFunc;
		property Lib3MFObject_ClearSliceStackFunc: TLib3MFObject_ClearSliceStackFunc read FLib3MFObject_ClearSliceStackFunc;
		property Lib3MFObject_GetSliceStackFunc: TLib3MFObject_GetSliceStackFunc read FLib3MFObject_GetSliceStackFunc;
		property Lib3MFObject_AssignSliceStackFunc: TLib3MFObject_AssignSliceStackFunc read FLib3MFObject_AssignSliceStackFunc;
		property Lib3MFMeshObject_GetVertexCountFunc: TLib3MFMeshObject_GetVertexCountFunc read FLib3MFMeshObject_GetVertexCountFunc;
		property Lib3MFMeshObject_GetTriangleCountFunc: TLib3MFMeshObject_GetTriangleCountFunc read FLib3MFMeshObject_GetTriangleCountFunc;
		property Lib3MFMeshObject_GetVertexFunc: TLib3MFMeshObject_GetVertexFunc read FLib3MFMeshObject_GetVertexFunc;
		property Lib3MFMeshObject_SetVertexFunc: TLib3MFMeshObject_SetVertexFunc read FLib3MFMeshObject_SetVertexFunc;
		property Lib3MFMeshObject_AddVertexFunc: TLib3MFMeshObject_AddVertexFunc read FLib3MFMeshObject_AddVertexFunc;
		property Lib3MFMeshObject_GetVerticesFunc: TLib3MFMeshObject_GetVerticesFunc read FLib3MFMeshObject_GetVerticesFunc;
		property Lib3MFMeshObject_GetTriangleFunc: TLib3MFMeshObject_GetTriangleFunc read FLib3MFMeshObject_GetTriangleFunc;
		property Lib3MFMeshObject_SetTriangleFunc: TLib3MFMeshObject_SetTriangleFunc read FLib3MFMeshObject_SetTriangleFunc;
		property Lib3MFMeshObject_AddTriangleFunc: TLib3MFMeshObject_AddTriangleFunc read FLib3MFMeshObject_AddTriangleFunc;
		property Lib3MFMeshObject_GetTriangleIndicesFunc: TLib3MFMeshObject_GetTriangleIndicesFunc read FLib3MFMeshObject_GetTriangleIndicesFunc;
		property Lib3MFMeshObject_SetObjectLevelPropertyFunc: TLib3MFMeshObject_SetObjectLevelPropertyFunc read FLib3MFMeshObject_SetObjectLevelPropertyFunc;
		property Lib3MFMeshObject_GetObjectLevelPropertyFunc: TLib3MFMeshObject_GetObjectLevelPropertyFunc read FLib3MFMeshObject_GetObjectLevelPropertyFunc;
		property Lib3MFMeshObject_SetTrianglePropertiesFunc: TLib3MFMeshObject_SetTrianglePropertiesFunc read FLib3MFMeshObject_SetTrianglePropertiesFunc;
		property Lib3MFMeshObject_GetTrianglePropertiesFunc: TLib3MFMeshObject_GetTrianglePropertiesFunc read FLib3MFMeshObject_GetTrianglePropertiesFunc;
		property Lib3MFMeshObject_SetAllTrianglePropertiesFunc: TLib3MFMeshObject_SetAllTrianglePropertiesFunc read FLib3MFMeshObject_SetAllTrianglePropertiesFunc;
		property Lib3MFMeshObject_GetAllTrianglePropertiesFunc: TLib3MFMeshObject_GetAllTrianglePropertiesFunc read FLib3MFMeshObject_GetAllTrianglePropertiesFunc;
		property Lib3MFMeshObject_ClearAllPropertiesFunc: TLib3MFMeshObject_ClearAllPropertiesFunc read FLib3MFMeshObject_ClearAllPropertiesFunc;
		property Lib3MFMeshObject_SetGeometryFunc: TLib3MFMeshObject_SetGeometryFunc read FLib3MFMeshObject_SetGeometryFunc;
		property Lib3MFMeshObject_IsManifoldAndOrientedFunc: TLib3MFMeshObject_IsManifoldAndOrientedFunc read FLib3MFMeshObject_IsManifoldAndOrientedFunc;
		property Lib3MFMeshObject_BeamLatticeFunc: TLib3MFMeshObject_BeamLatticeFunc read FLib3MFMeshObject_BeamLatticeFunc;
		property Lib3MFBeamLattice_GetMinLengthFunc: TLib3MFBeamLattice_GetMinLengthFunc read FLib3MFBeamLattice_GetMinLengthFunc;
		property Lib3MFBeamLattice_SetMinLengthFunc: TLib3MFBeamLattice_SetMinLengthFunc read FLib3MFBeamLattice_SetMinLengthFunc;
		property Lib3MFBeamLattice_GetClippingFunc: TLib3MFBeamLattice_GetClippingFunc read FLib3MFBeamLattice_GetClippingFunc;
		property Lib3MFBeamLattice_SetClippingFunc: TLib3MFBeamLattice_SetClippingFunc read FLib3MFBeamLattice_SetClippingFunc;
		property Lib3MFBeamLattice_GetRepresentationFunc: TLib3MFBeamLattice_GetRepresentationFunc read FLib3MFBeamLattice_GetRepresentationFunc;
		property Lib3MFBeamLattice_SetRepresentationFunc: TLib3MFBeamLattice_SetRepresentationFunc read FLib3MFBeamLattice_SetRepresentationFunc;
		property Lib3MFBeamLattice_GetBallOptionsFunc: TLib3MFBeamLattice_GetBallOptionsFunc read FLib3MFBeamLattice_GetBallOptionsFunc;
		property Lib3MFBeamLattice_SetBallOptionsFunc: TLib3MFBeamLattice_SetBallOptionsFunc read FLib3MFBeamLattice_SetBallOptionsFunc;
		property Lib3MFBeamLattice_GetBeamCountFunc: TLib3MFBeamLattice_GetBeamCountFunc read FLib3MFBeamLattice_GetBeamCountFunc;
		property Lib3MFBeamLattice_GetBeamFunc: TLib3MFBeamLattice_GetBeamFunc read FLib3MFBeamLattice_GetBeamFunc;
		property Lib3MFBeamLattice_AddBeamFunc: TLib3MFBeamLattice_AddBeamFunc read FLib3MFBeamLattice_AddBeamFunc;
		property Lib3MFBeamLattice_SetBeamFunc: TLib3MFBeamLattice_SetBeamFunc read FLib3MFBeamLattice_SetBeamFunc;
		property Lib3MFBeamLattice_SetBeamsFunc: TLib3MFBeamLattice_SetBeamsFunc read FLib3MFBeamLattice_SetBeamsFunc;
		property Lib3MFBeamLattice_GetBeamsFunc: TLib3MFBeamLattice_GetBeamsFunc read FLib3MFBeamLattice_GetBeamsFunc;
		property Lib3MFBeamLattice_GetBallCountFunc: TLib3MFBeamLattice_GetBallCountFunc read FLib3MFBeamLattice_GetBallCountFunc;
		property Lib3MFBeamLattice_GetBallFunc: TLib3MFBeamLattice_GetBallFunc read FLib3MFBeamLattice_GetBallFunc;
		property Lib3MFBeamLattice_AddBallFunc: TLib3MFBeamLattice_AddBallFunc read FLib3MFBeamLattice_AddBallFunc;
		property Lib3MFBeamLattice_SetBallFunc: TLib3MFBeamLattice_SetBallFunc read FLib3MFBeamLattice_SetBallFunc;
		property Lib3MFBeamLattice_SetBallsFunc: TLib3MFBeamLattice_SetBallsFunc read FLib3MFBeamLattice_SetBallsFunc;
		property Lib3MFBeamLattice_GetBallsFunc: TLib3MFBeamLattice_GetBallsFunc read FLib3MFBeamLattice_GetBallsFunc;
		property Lib3MFBeamLattice_GetBeamSetCountFunc: TLib3MFBeamLattice_GetBeamSetCountFunc read FLib3MFBeamLattice_GetBeamSetCountFunc;
		property Lib3MFBeamLattice_AddBeamSetFunc: TLib3MFBeamLattice_AddBeamSetFunc read FLib3MFBeamLattice_AddBeamSetFunc;
		property Lib3MFBeamLattice_GetBeamSetFunc: TLib3MFBeamLattice_GetBeamSetFunc read FLib3MFBeamLattice_GetBeamSetFunc;
		property Lib3MFComponent_GetObjectResourceFunc: TLib3MFComponent_GetObjectResourceFunc read FLib3MFComponent_GetObjectResourceFunc;
		property Lib3MFComponent_GetObjectResourceIDFunc: TLib3MFComponent_GetObjectResourceIDFunc read FLib3MFComponent_GetObjectResourceIDFunc;
		property Lib3MFComponent_GetUUIDFunc: TLib3MFComponent_GetUUIDFunc read FLib3MFComponent_GetUUIDFunc;
		property Lib3MFComponent_SetUUIDFunc: TLib3MFComponent_SetUUIDFunc read FLib3MFComponent_SetUUIDFunc;
		property Lib3MFComponent_HasTransformFunc: TLib3MFComponent_HasTransformFunc read FLib3MFComponent_HasTransformFunc;
		property Lib3MFComponent_GetTransformFunc: TLib3MFComponent_GetTransformFunc read FLib3MFComponent_GetTransformFunc;
		property Lib3MFComponent_SetTransformFunc: TLib3MFComponent_SetTransformFunc read FLib3MFComponent_SetTransformFunc;
		property Lib3MFComponentsObject_AddComponentFunc: TLib3MFComponentsObject_AddComponentFunc read FLib3MFComponentsObject_AddComponentFunc;
		property Lib3MFComponentsObject_GetComponentFunc: TLib3MFComponentsObject_GetComponentFunc read FLib3MFComponentsObject_GetComponentFunc;
		property Lib3MFComponentsObject_GetComponentCountFunc: TLib3MFComponentsObject_GetComponentCountFunc read FLib3MFComponentsObject_GetComponentCountFunc;
		property Lib3MFBeamSet_SetNameFunc: TLib3MFBeamSet_SetNameFunc read FLib3MFBeamSet_SetNameFunc;
		property Lib3MFBeamSet_GetNameFunc: TLib3MFBeamSet_GetNameFunc read FLib3MFBeamSet_GetNameFunc;
		property Lib3MFBeamSet_SetIdentifierFunc: TLib3MFBeamSet_SetIdentifierFunc read FLib3MFBeamSet_SetIdentifierFunc;
		property Lib3MFBeamSet_GetIdentifierFunc: TLib3MFBeamSet_GetIdentifierFunc read FLib3MFBeamSet_GetIdentifierFunc;
		property Lib3MFBeamSet_GetReferenceCountFunc: TLib3MFBeamSet_GetReferenceCountFunc read FLib3MFBeamSet_GetReferenceCountFunc;
		property Lib3MFBeamSet_SetReferencesFunc: TLib3MFBeamSet_SetReferencesFunc read FLib3MFBeamSet_SetReferencesFunc;
		property Lib3MFBeamSet_GetReferencesFunc: TLib3MFBeamSet_GetReferencesFunc read FLib3MFBeamSet_GetReferencesFunc;
		property Lib3MFBeamSet_GetBallReferenceCountFunc: TLib3MFBeamSet_GetBallReferenceCountFunc read FLib3MFBeamSet_GetBallReferenceCountFunc;
		property Lib3MFBeamSet_SetBallReferencesFunc: TLib3MFBeamSet_SetBallReferencesFunc read FLib3MFBeamSet_SetBallReferencesFunc;
		property Lib3MFBeamSet_GetBallReferencesFunc: TLib3MFBeamSet_GetBallReferencesFunc read FLib3MFBeamSet_GetBallReferencesFunc;
		property Lib3MFBaseMaterialGroup_GetCountFunc: TLib3MFBaseMaterialGroup_GetCountFunc read FLib3MFBaseMaterialGroup_GetCountFunc;
		property Lib3MFBaseMaterialGroup_GetAllPropertyIDsFunc: TLib3MFBaseMaterialGroup_GetAllPropertyIDsFunc read FLib3MFBaseMaterialGroup_GetAllPropertyIDsFunc;
		property Lib3MFBaseMaterialGroup_AddMaterialFunc: TLib3MFBaseMaterialGroup_AddMaterialFunc read FLib3MFBaseMaterialGroup_AddMaterialFunc;
		property Lib3MFBaseMaterialGroup_RemoveMaterialFunc: TLib3MFBaseMaterialGroup_RemoveMaterialFunc read FLib3MFBaseMaterialGroup_RemoveMaterialFunc;
		property Lib3MFBaseMaterialGroup_GetNameFunc: TLib3MFBaseMaterialGroup_GetNameFunc read FLib3MFBaseMaterialGroup_GetNameFunc;
		property Lib3MFBaseMaterialGroup_SetNameFunc: TLib3MFBaseMaterialGroup_SetNameFunc read FLib3MFBaseMaterialGroup_SetNameFunc;
		property Lib3MFBaseMaterialGroup_SetDisplayColorFunc: TLib3MFBaseMaterialGroup_SetDisplayColorFunc read FLib3MFBaseMaterialGroup_SetDisplayColorFunc;
		property Lib3MFBaseMaterialGroup_GetDisplayColorFunc: TLib3MFBaseMaterialGroup_GetDisplayColorFunc read FLib3MFBaseMaterialGroup_GetDisplayColorFunc;
		property Lib3MFColorGroup_GetCountFunc: TLib3MFColorGroup_GetCountFunc read FLib3MFColorGroup_GetCountFunc;
		property Lib3MFColorGroup_GetAllPropertyIDsFunc: TLib3MFColorGroup_GetAllPropertyIDsFunc read FLib3MFColorGroup_GetAllPropertyIDsFunc;
		property Lib3MFColorGroup_AddColorFunc: TLib3MFColorGroup_AddColorFunc read FLib3MFColorGroup_AddColorFunc;
		property Lib3MFColorGroup_RemoveColorFunc: TLib3MFColorGroup_RemoveColorFunc read FLib3MFColorGroup_RemoveColorFunc;
		property Lib3MFColorGroup_SetColorFunc: TLib3MFColorGroup_SetColorFunc read FLib3MFColorGroup_SetColorFunc;
		property Lib3MFColorGroup_GetColorFunc: TLib3MFColorGroup_GetColorFunc read FLib3MFColorGroup_GetColorFunc;
		property Lib3MFTexture2DGroup_GetCountFunc: TLib3MFTexture2DGroup_GetCountFunc read FLib3MFTexture2DGroup_GetCountFunc;
		property Lib3MFTexture2DGroup_GetAllPropertyIDsFunc: TLib3MFTexture2DGroup_GetAllPropertyIDsFunc read FLib3MFTexture2DGroup_GetAllPropertyIDsFunc;
		property Lib3MFTexture2DGroup_AddTex2CoordFunc: TLib3MFTexture2DGroup_AddTex2CoordFunc read FLib3MFTexture2DGroup_AddTex2CoordFunc;
		property Lib3MFTexture2DGroup_GetTex2CoordFunc: TLib3MFTexture2DGroup_GetTex2CoordFunc read FLib3MFTexture2DGroup_GetTex2CoordFunc;
		property Lib3MFTexture2DGroup_RemoveTex2CoordFunc: TLib3MFTexture2DGroup_RemoveTex2CoordFunc read FLib3MFTexture2DGroup_RemoveTex2CoordFunc;
		property Lib3MFTexture2DGroup_GetTexture2DFunc: TLib3MFTexture2DGroup_GetTexture2DFunc read FLib3MFTexture2DGroup_GetTexture2DFunc;
		property Lib3MFCompositeMaterials_GetCountFunc: TLib3MFCompositeMaterials_GetCountFunc read FLib3MFCompositeMaterials_GetCountFunc;
		property Lib3MFCompositeMaterials_GetAllPropertyIDsFunc: TLib3MFCompositeMaterials_GetAllPropertyIDsFunc read FLib3MFCompositeMaterials_GetAllPropertyIDsFunc;
		property Lib3MFCompositeMaterials_GetBaseMaterialGroupFunc: TLib3MFCompositeMaterials_GetBaseMaterialGroupFunc read FLib3MFCompositeMaterials_GetBaseMaterialGroupFunc;
		property Lib3MFCompositeMaterials_AddCompositeFunc: TLib3MFCompositeMaterials_AddCompositeFunc read FLib3MFCompositeMaterials_AddCompositeFunc;
		property Lib3MFCompositeMaterials_RemoveCompositeFunc: TLib3MFCompositeMaterials_RemoveCompositeFunc read FLib3MFCompositeMaterials_RemoveCompositeFunc;
		property Lib3MFCompositeMaterials_GetCompositeFunc: TLib3MFCompositeMaterials_GetCompositeFunc read FLib3MFCompositeMaterials_GetCompositeFunc;
		property Lib3MFMultiPropertyGroup_GetCountFunc: TLib3MFMultiPropertyGroup_GetCountFunc read FLib3MFMultiPropertyGroup_GetCountFunc;
		property Lib3MFMultiPropertyGroup_GetAllPropertyIDsFunc: TLib3MFMultiPropertyGroup_GetAllPropertyIDsFunc read FLib3MFMultiPropertyGroup_GetAllPropertyIDsFunc;
		property Lib3MFMultiPropertyGroup_AddMultiPropertyFunc: TLib3MFMultiPropertyGroup_AddMultiPropertyFunc read FLib3MFMultiPropertyGroup_AddMultiPropertyFunc;
		property Lib3MFMultiPropertyGroup_SetMultiPropertyFunc: TLib3MFMultiPropertyGroup_SetMultiPropertyFunc read FLib3MFMultiPropertyGroup_SetMultiPropertyFunc;
		property Lib3MFMultiPropertyGroup_GetMultiPropertyFunc: TLib3MFMultiPropertyGroup_GetMultiPropertyFunc read FLib3MFMultiPropertyGroup_GetMultiPropertyFunc;
		property Lib3MFMultiPropertyGroup_RemoveMultiPropertyFunc: TLib3MFMultiPropertyGroup_RemoveMultiPropertyFunc read FLib3MFMultiPropertyGroup_RemoveMultiPropertyFunc;
		property Lib3MFMultiPropertyGroup_GetLayerCountFunc: TLib3MFMultiPropertyGroup_GetLayerCountFunc read FLib3MFMultiPropertyGroup_GetLayerCountFunc;
		property Lib3MFMultiPropertyGroup_AddLayerFunc: TLib3MFMultiPropertyGroup_AddLayerFunc read FLib3MFMultiPropertyGroup_AddLayerFunc;
		property Lib3MFMultiPropertyGroup_GetLayerFunc: TLib3MFMultiPropertyGroup_GetLayerFunc read FLib3MFMultiPropertyGroup_GetLayerFunc;
		property Lib3MFMultiPropertyGroup_RemoveLayerFunc: TLib3MFMultiPropertyGroup_RemoveLayerFunc read FLib3MFMultiPropertyGroup_RemoveLayerFunc;
		property Lib3MFAttachment_GetPathFunc: TLib3MFAttachment_GetPathFunc read FLib3MFAttachment_GetPathFunc;
		property Lib3MFAttachment_SetPathFunc: TLib3MFAttachment_SetPathFunc read FLib3MFAttachment_SetPathFunc;
		property Lib3MFAttachment_PackagePartFunc: TLib3MFAttachment_PackagePartFunc read FLib3MFAttachment_PackagePartFunc;
		property Lib3MFAttachment_GetRelationShipTypeFunc: TLib3MFAttachment_GetRelationShipTypeFunc read FLib3MFAttachment_GetRelationShipTypeFunc;
		property Lib3MFAttachment_SetRelationShipTypeFunc: TLib3MFAttachment_SetRelationShipTypeFunc read FLib3MFAttachment_SetRelationShipTypeFunc;
		property Lib3MFAttachment_WriteToFileFunc: TLib3MFAttachment_WriteToFileFunc read FLib3MFAttachment_WriteToFileFunc;
		property Lib3MFAttachment_ReadFromFileFunc: TLib3MFAttachment_ReadFromFileFunc read FLib3MFAttachment_ReadFromFileFunc;
		property Lib3MFAttachment_ReadFromCallbackFunc: TLib3MFAttachment_ReadFromCallbackFunc read FLib3MFAttachment_ReadFromCallbackFunc;
		property Lib3MFAttachment_GetStreamSizeFunc: TLib3MFAttachment_GetStreamSizeFunc read FLib3MFAttachment_GetStreamSizeFunc;
		property Lib3MFAttachment_WriteToBufferFunc: TLib3MFAttachment_WriteToBufferFunc read FLib3MFAttachment_WriteToBufferFunc;
		property Lib3MFAttachment_ReadFromBufferFunc: TLib3MFAttachment_ReadFromBufferFunc read FLib3MFAttachment_ReadFromBufferFunc;
		property Lib3MFTexture2D_GetAttachmentFunc: TLib3MFTexture2D_GetAttachmentFunc read FLib3MFTexture2D_GetAttachmentFunc;
		property Lib3MFTexture2D_SetAttachmentFunc: TLib3MFTexture2D_SetAttachmentFunc read FLib3MFTexture2D_SetAttachmentFunc;
		property Lib3MFTexture2D_GetContentTypeFunc: TLib3MFTexture2D_GetContentTypeFunc read FLib3MFTexture2D_GetContentTypeFunc;
		property Lib3MFTexture2D_SetContentTypeFunc: TLib3MFTexture2D_SetContentTypeFunc read FLib3MFTexture2D_SetContentTypeFunc;
		property Lib3MFTexture2D_GetTileStyleUVFunc: TLib3MFTexture2D_GetTileStyleUVFunc read FLib3MFTexture2D_GetTileStyleUVFunc;
		property Lib3MFTexture2D_SetTileStyleUVFunc: TLib3MFTexture2D_SetTileStyleUVFunc read FLib3MFTexture2D_SetTileStyleUVFunc;
		property Lib3MFTexture2D_GetFilterFunc: TLib3MFTexture2D_GetFilterFunc read FLib3MFTexture2D_GetFilterFunc;
		property Lib3MFTexture2D_SetFilterFunc: TLib3MFTexture2D_SetFilterFunc read FLib3MFTexture2D_SetFilterFunc;
		property Lib3MFBuildItem_GetObjectResourceFunc: TLib3MFBuildItem_GetObjectResourceFunc read FLib3MFBuildItem_GetObjectResourceFunc;
		property Lib3MFBuildItem_GetUUIDFunc: TLib3MFBuildItem_GetUUIDFunc read FLib3MFBuildItem_GetUUIDFunc;
		property Lib3MFBuildItem_SetUUIDFunc: TLib3MFBuildItem_SetUUIDFunc read FLib3MFBuildItem_SetUUIDFunc;
		property Lib3MFBuildItem_GetObjectResourceIDFunc: TLib3MFBuildItem_GetObjectResourceIDFunc read FLib3MFBuildItem_GetObjectResourceIDFunc;
		property Lib3MFBuildItem_HasObjectTransformFunc: TLib3MFBuildItem_HasObjectTransformFunc read FLib3MFBuildItem_HasObjectTransformFunc;
		property Lib3MFBuildItem_GetObjectTransformFunc: TLib3MFBuildItem_GetObjectTransformFunc read FLib3MFBuildItem_GetObjectTransformFunc;
		property Lib3MFBuildItem_SetObjectTransformFunc: TLib3MFBuildItem_SetObjectTransformFunc read FLib3MFBuildItem_SetObjectTransformFunc;
		property Lib3MFBuildItem_GetPartNumberFunc: TLib3MFBuildItem_GetPartNumberFunc read FLib3MFBuildItem_GetPartNumberFunc;
		property Lib3MFBuildItem_SetPartNumberFunc: TLib3MFBuildItem_SetPartNumberFunc read FLib3MFBuildItem_SetPartNumberFunc;
		property Lib3MFBuildItem_GetMetaDataGroupFunc: TLib3MFBuildItem_GetMetaDataGroupFunc read FLib3MFBuildItem_GetMetaDataGroupFunc;
		property Lib3MFBuildItem_GetOutboxFunc: TLib3MFBuildItem_GetOutboxFunc read FLib3MFBuildItem_GetOutboxFunc;
		property Lib3MFBuildItemIterator_MoveNextFunc: TLib3MFBuildItemIterator_MoveNextFunc read FLib3MFBuildItemIterator_MoveNextFunc;
		property Lib3MFBuildItemIterator_MovePreviousFunc: TLib3MFBuildItemIterator_MovePreviousFunc read FLib3MFBuildItemIterator_MovePreviousFunc;
		property Lib3MFBuildItemIterator_GetCurrentFunc: TLib3MFBuildItemIterator_GetCurrentFunc read FLib3MFBuildItemIterator_GetCurrentFunc;
		property Lib3MFBuildItemIterator_CloneFunc: TLib3MFBuildItemIterator_CloneFunc read FLib3MFBuildItemIterator_CloneFunc;
		property Lib3MFBuildItemIterator_CountFunc: TLib3MFBuildItemIterator_CountFunc read FLib3MFBuildItemIterator_CountFunc;
		property Lib3MFSlice_SetVerticesFunc: TLib3MFSlice_SetVerticesFunc read FLib3MFSlice_SetVerticesFunc;
		property Lib3MFSlice_GetVerticesFunc: TLib3MFSlice_GetVerticesFunc read FLib3MFSlice_GetVerticesFunc;
		property Lib3MFSlice_GetVertexCountFunc: TLib3MFSlice_GetVertexCountFunc read FLib3MFSlice_GetVertexCountFunc;
		property Lib3MFSlice_AddPolygonFunc: TLib3MFSlice_AddPolygonFunc read FLib3MFSlice_AddPolygonFunc;
		property Lib3MFSlice_GetPolygonCountFunc: TLib3MFSlice_GetPolygonCountFunc read FLib3MFSlice_GetPolygonCountFunc;
		property Lib3MFSlice_SetPolygonIndicesFunc: TLib3MFSlice_SetPolygonIndicesFunc read FLib3MFSlice_SetPolygonIndicesFunc;
		property Lib3MFSlice_GetPolygonIndicesFunc: TLib3MFSlice_GetPolygonIndicesFunc read FLib3MFSlice_GetPolygonIndicesFunc;
		property Lib3MFSlice_GetPolygonIndexCountFunc: TLib3MFSlice_GetPolygonIndexCountFunc read FLib3MFSlice_GetPolygonIndexCountFunc;
		property Lib3MFSlice_GetZTopFunc: TLib3MFSlice_GetZTopFunc read FLib3MFSlice_GetZTopFunc;
		property Lib3MFSliceStack_GetBottomZFunc: TLib3MFSliceStack_GetBottomZFunc read FLib3MFSliceStack_GetBottomZFunc;
		property Lib3MFSliceStack_GetSliceCountFunc: TLib3MFSliceStack_GetSliceCountFunc read FLib3MFSliceStack_GetSliceCountFunc;
		property Lib3MFSliceStack_GetSliceFunc: TLib3MFSliceStack_GetSliceFunc read FLib3MFSliceStack_GetSliceFunc;
		property Lib3MFSliceStack_AddSliceFunc: TLib3MFSliceStack_AddSliceFunc read FLib3MFSliceStack_AddSliceFunc;
		property Lib3MFSliceStack_GetSliceRefCountFunc: TLib3MFSliceStack_GetSliceRefCountFunc read FLib3MFSliceStack_GetSliceRefCountFunc;
		property Lib3MFSliceStack_AddSliceStackReferenceFunc: TLib3MFSliceStack_AddSliceStackReferenceFunc read FLib3MFSliceStack_AddSliceStackReferenceFunc;
		property Lib3MFSliceStack_GetSliceStackReferenceFunc: TLib3MFSliceStack_GetSliceStackReferenceFunc read FLib3MFSliceStack_GetSliceStackReferenceFunc;
		property Lib3MFSliceStack_CollapseSliceReferencesFunc: TLib3MFSliceStack_CollapseSliceReferencesFunc read FLib3MFSliceStack_CollapseSliceReferencesFunc;
		property Lib3MFSliceStack_SetOwnPathFunc: TLib3MFSliceStack_SetOwnPathFunc read FLib3MFSliceStack_SetOwnPathFunc;
		property Lib3MFSliceStack_GetOwnPathFunc: TLib3MFSliceStack_GetOwnPathFunc read FLib3MFSliceStack_GetOwnPathFunc;
		property Lib3MFConsumer_GetConsumerIDFunc: TLib3MFConsumer_GetConsumerIDFunc read FLib3MFConsumer_GetConsumerIDFunc;
		property Lib3MFConsumer_GetKeyIDFunc: TLib3MFConsumer_GetKeyIDFunc read FLib3MFConsumer_GetKeyIDFunc;
		property Lib3MFConsumer_GetKeyValueFunc: TLib3MFConsumer_GetKeyValueFunc read FLib3MFConsumer_GetKeyValueFunc;
		property Lib3MFAccessRight_GetConsumerFunc: TLib3MFAccessRight_GetConsumerFunc read FLib3MFAccessRight_GetConsumerFunc;
		property Lib3MFAccessRight_GetWrappingAlgorithmFunc: TLib3MFAccessRight_GetWrappingAlgorithmFunc read FLib3MFAccessRight_GetWrappingAlgorithmFunc;
		property Lib3MFAccessRight_GetMgfAlgorithmFunc: TLib3MFAccessRight_GetMgfAlgorithmFunc read FLib3MFAccessRight_GetMgfAlgorithmFunc;
		property Lib3MFAccessRight_GetDigestMethodFunc: TLib3MFAccessRight_GetDigestMethodFunc read FLib3MFAccessRight_GetDigestMethodFunc;
		property Lib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc: TLib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc read FLib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc;
		property Lib3MFContentEncryptionParams_GetKeyFunc: TLib3MFContentEncryptionParams_GetKeyFunc read FLib3MFContentEncryptionParams_GetKeyFunc;
		property Lib3MFContentEncryptionParams_GetInitializationVectorFunc: TLib3MFContentEncryptionParams_GetInitializationVectorFunc read FLib3MFContentEncryptionParams_GetInitializationVectorFunc;
		property Lib3MFContentEncryptionParams_GetAuthenticationTagFunc: TLib3MFContentEncryptionParams_GetAuthenticationTagFunc read FLib3MFContentEncryptionParams_GetAuthenticationTagFunc;
		property Lib3MFContentEncryptionParams_SetAuthenticationTagFunc: TLib3MFContentEncryptionParams_SetAuthenticationTagFunc read FLib3MFContentEncryptionParams_SetAuthenticationTagFunc;
		property Lib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc: TLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc read FLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc;
		property Lib3MFContentEncryptionParams_GetDescriptorFunc: TLib3MFContentEncryptionParams_GetDescriptorFunc read FLib3MFContentEncryptionParams_GetDescriptorFunc;
		property Lib3MFContentEncryptionParams_GetKeyUUIDFunc: TLib3MFContentEncryptionParams_GetKeyUUIDFunc read FLib3MFContentEncryptionParams_GetKeyUUIDFunc;
		property Lib3MFResourceData_GetPathFunc: TLib3MFResourceData_GetPathFunc read FLib3MFResourceData_GetPathFunc;
		property Lib3MFResourceData_GetEncryptionAlgorithmFunc: TLib3MFResourceData_GetEncryptionAlgorithmFunc read FLib3MFResourceData_GetEncryptionAlgorithmFunc;
		property Lib3MFResourceData_GetCompressionFunc: TLib3MFResourceData_GetCompressionFunc read FLib3MFResourceData_GetCompressionFunc;
		property Lib3MFResourceData_GetAdditionalAuthenticationDataFunc: TLib3MFResourceData_GetAdditionalAuthenticationDataFunc read FLib3MFResourceData_GetAdditionalAuthenticationDataFunc;
		property Lib3MFResourceDataGroup_GetKeyUUIDFunc: TLib3MFResourceDataGroup_GetKeyUUIDFunc read FLib3MFResourceDataGroup_GetKeyUUIDFunc;
		property Lib3MFResourceDataGroup_AddAccessRightFunc: TLib3MFResourceDataGroup_AddAccessRightFunc read FLib3MFResourceDataGroup_AddAccessRightFunc;
		property Lib3MFResourceDataGroup_FindAccessRightByConsumerFunc: TLib3MFResourceDataGroup_FindAccessRightByConsumerFunc read FLib3MFResourceDataGroup_FindAccessRightByConsumerFunc;
		property Lib3MFResourceDataGroup_RemoveAccessRightFunc: TLib3MFResourceDataGroup_RemoveAccessRightFunc read FLib3MFResourceDataGroup_RemoveAccessRightFunc;
		property Lib3MFKeyStore_AddConsumerFunc: TLib3MFKeyStore_AddConsumerFunc read FLib3MFKeyStore_AddConsumerFunc;
		property Lib3MFKeyStore_GetConsumerCountFunc: TLib3MFKeyStore_GetConsumerCountFunc read FLib3MFKeyStore_GetConsumerCountFunc;
		property Lib3MFKeyStore_GetConsumerFunc: TLib3MFKeyStore_GetConsumerFunc read FLib3MFKeyStore_GetConsumerFunc;
		property Lib3MFKeyStore_RemoveConsumerFunc: TLib3MFKeyStore_RemoveConsumerFunc read FLib3MFKeyStore_RemoveConsumerFunc;
		property Lib3MFKeyStore_FindConsumerFunc: TLib3MFKeyStore_FindConsumerFunc read FLib3MFKeyStore_FindConsumerFunc;
		property Lib3MFKeyStore_GetResourceDataGroupCountFunc: TLib3MFKeyStore_GetResourceDataGroupCountFunc read FLib3MFKeyStore_GetResourceDataGroupCountFunc;
		property Lib3MFKeyStore_AddResourceDataGroupFunc: TLib3MFKeyStore_AddResourceDataGroupFunc read FLib3MFKeyStore_AddResourceDataGroupFunc;
		property Lib3MFKeyStore_GetResourceDataGroupFunc: TLib3MFKeyStore_GetResourceDataGroupFunc read FLib3MFKeyStore_GetResourceDataGroupFunc;
		property Lib3MFKeyStore_RemoveResourceDataGroupFunc: TLib3MFKeyStore_RemoveResourceDataGroupFunc read FLib3MFKeyStore_RemoveResourceDataGroupFunc;
		property Lib3MFKeyStore_FindResourceDataGroupFunc: TLib3MFKeyStore_FindResourceDataGroupFunc read FLib3MFKeyStore_FindResourceDataGroupFunc;
		property Lib3MFKeyStore_AddResourceDataFunc: TLib3MFKeyStore_AddResourceDataFunc read FLib3MFKeyStore_AddResourceDataFunc;
		property Lib3MFKeyStore_RemoveResourceDataFunc: TLib3MFKeyStore_RemoveResourceDataFunc read FLib3MFKeyStore_RemoveResourceDataFunc;
		property Lib3MFKeyStore_FindResourceDataFunc: TLib3MFKeyStore_FindResourceDataFunc read FLib3MFKeyStore_FindResourceDataFunc;
		property Lib3MFKeyStore_GetResourceDataCountFunc: TLib3MFKeyStore_GetResourceDataCountFunc read FLib3MFKeyStore_GetResourceDataCountFunc;
		property Lib3MFKeyStore_GetResourceDataFunc: TLib3MFKeyStore_GetResourceDataFunc read FLib3MFKeyStore_GetResourceDataFunc;
		property Lib3MFKeyStore_GetUUIDFunc: TLib3MFKeyStore_GetUUIDFunc read FLib3MFKeyStore_GetUUIDFunc;
		property Lib3MFKeyStore_SetUUIDFunc: TLib3MFKeyStore_SetUUIDFunc read FLib3MFKeyStore_SetUUIDFunc;
		property Lib3MFModel_RootModelPartFunc: TLib3MFModel_RootModelPartFunc read FLib3MFModel_RootModelPartFunc;
		property Lib3MFModel_FindOrCreatePackagePartFunc: TLib3MFModel_FindOrCreatePackagePartFunc read FLib3MFModel_FindOrCreatePackagePartFunc;
		property Lib3MFModel_SetUnitFunc: TLib3MFModel_SetUnitFunc read FLib3MFModel_SetUnitFunc;
		property Lib3MFModel_GetUnitFunc: TLib3MFModel_GetUnitFunc read FLib3MFModel_GetUnitFunc;
		property Lib3MFModel_GetLanguageFunc: TLib3MFModel_GetLanguageFunc read FLib3MFModel_GetLanguageFunc;
		property Lib3MFModel_SetLanguageFunc: TLib3MFModel_SetLanguageFunc read FLib3MFModel_SetLanguageFunc;
		property Lib3MFModel_QueryWriterFunc: TLib3MFModel_QueryWriterFunc read FLib3MFModel_QueryWriterFunc;
		property Lib3MFModel_QueryReaderFunc: TLib3MFModel_QueryReaderFunc read FLib3MFModel_QueryReaderFunc;
		property Lib3MFModel_GetResourceByIDFunc: TLib3MFModel_GetResourceByIDFunc read FLib3MFModel_GetResourceByIDFunc;
		property Lib3MFModel_GetTexture2DByIDFunc: TLib3MFModel_GetTexture2DByIDFunc read FLib3MFModel_GetTexture2DByIDFunc;
		property Lib3MFModel_GetPropertyTypeByIDFunc: TLib3MFModel_GetPropertyTypeByIDFunc read FLib3MFModel_GetPropertyTypeByIDFunc;
		property Lib3MFModel_GetBaseMaterialGroupByIDFunc: TLib3MFModel_GetBaseMaterialGroupByIDFunc read FLib3MFModel_GetBaseMaterialGroupByIDFunc;
		property Lib3MFModel_GetTexture2DGroupByIDFunc: TLib3MFModel_GetTexture2DGroupByIDFunc read FLib3MFModel_GetTexture2DGroupByIDFunc;
		property Lib3MFModel_GetCompositeMaterialsByIDFunc: TLib3MFModel_GetCompositeMaterialsByIDFunc read FLib3MFModel_GetCompositeMaterialsByIDFunc;
		property Lib3MFModel_GetMultiPropertyGroupByIDFunc: TLib3MFModel_GetMultiPropertyGroupByIDFunc read FLib3MFModel_GetMultiPropertyGroupByIDFunc;
		property Lib3MFModel_GetMeshObjectByIDFunc: TLib3MFModel_GetMeshObjectByIDFunc read FLib3MFModel_GetMeshObjectByIDFunc;
		property Lib3MFModel_GetComponentsObjectByIDFunc: TLib3MFModel_GetComponentsObjectByIDFunc read FLib3MFModel_GetComponentsObjectByIDFunc;
		property Lib3MFModel_GetColorGroupByIDFunc: TLib3MFModel_GetColorGroupByIDFunc read FLib3MFModel_GetColorGroupByIDFunc;
		property Lib3MFModel_GetSliceStackByIDFunc: TLib3MFModel_GetSliceStackByIDFunc read FLib3MFModel_GetSliceStackByIDFunc;
		property Lib3MFModel_GetBuildUUIDFunc: TLib3MFModel_GetBuildUUIDFunc read FLib3MFModel_GetBuildUUIDFunc;
		property Lib3MFModel_SetBuildUUIDFunc: TLib3MFModel_SetBuildUUIDFunc read FLib3MFModel_SetBuildUUIDFunc;
		property Lib3MFModel_GetBuildItemsFunc: TLib3MFModel_GetBuildItemsFunc read FLib3MFModel_GetBuildItemsFunc;
		property Lib3MFModel_GetOutboxFunc: TLib3MFModel_GetOutboxFunc read FLib3MFModel_GetOutboxFunc;
		property Lib3MFModel_GetResourcesFunc: TLib3MFModel_GetResourcesFunc read FLib3MFModel_GetResourcesFunc;
		property Lib3MFModel_GetObjectsFunc: TLib3MFModel_GetObjectsFunc read FLib3MFModel_GetObjectsFunc;
		property Lib3MFModel_GetMeshObjectsFunc: TLib3MFModel_GetMeshObjectsFunc read FLib3MFModel_GetMeshObjectsFunc;
		property Lib3MFModel_GetComponentsObjectsFunc: TLib3MFModel_GetComponentsObjectsFunc read FLib3MFModel_GetComponentsObjectsFunc;
		property Lib3MFModel_GetTexture2DsFunc: TLib3MFModel_GetTexture2DsFunc read FLib3MFModel_GetTexture2DsFunc;
		property Lib3MFModel_GetBaseMaterialGroupsFunc: TLib3MFModel_GetBaseMaterialGroupsFunc read FLib3MFModel_GetBaseMaterialGroupsFunc;
		property Lib3MFModel_GetColorGroupsFunc: TLib3MFModel_GetColorGroupsFunc read FLib3MFModel_GetColorGroupsFunc;
		property Lib3MFModel_GetTexture2DGroupsFunc: TLib3MFModel_GetTexture2DGroupsFunc read FLib3MFModel_GetTexture2DGroupsFunc;
		property Lib3MFModel_GetCompositeMaterialsFunc: TLib3MFModel_GetCompositeMaterialsFunc read FLib3MFModel_GetCompositeMaterialsFunc;
		property Lib3MFModel_GetMultiPropertyGroupsFunc: TLib3MFModel_GetMultiPropertyGroupsFunc read FLib3MFModel_GetMultiPropertyGroupsFunc;
		property Lib3MFModel_GetSliceStacksFunc: TLib3MFModel_GetSliceStacksFunc read FLib3MFModel_GetSliceStacksFunc;
		property Lib3MFModel_MergeToModelFunc: TLib3MFModel_MergeToModelFunc read FLib3MFModel_MergeToModelFunc;
		property Lib3MFModel_AddMeshObjectFunc: TLib3MFModel_AddMeshObjectFunc read FLib3MFModel_AddMeshObjectFunc;
		property Lib3MFModel_AddComponentsObjectFunc: TLib3MFModel_AddComponentsObjectFunc read FLib3MFModel_AddComponentsObjectFunc;
		property Lib3MFModel_AddSliceStackFunc: TLib3MFModel_AddSliceStackFunc read FLib3MFModel_AddSliceStackFunc;
		property Lib3MFModel_AddTexture2DFromAttachmentFunc: TLib3MFModel_AddTexture2DFromAttachmentFunc read FLib3MFModel_AddTexture2DFromAttachmentFunc;
		property Lib3MFModel_AddBaseMaterialGroupFunc: TLib3MFModel_AddBaseMaterialGroupFunc read FLib3MFModel_AddBaseMaterialGroupFunc;
		property Lib3MFModel_AddColorGroupFunc: TLib3MFModel_AddColorGroupFunc read FLib3MFModel_AddColorGroupFunc;
		property Lib3MFModel_AddTexture2DGroupFunc: TLib3MFModel_AddTexture2DGroupFunc read FLib3MFModel_AddTexture2DGroupFunc;
		property Lib3MFModel_AddCompositeMaterialsFunc: TLib3MFModel_AddCompositeMaterialsFunc read FLib3MFModel_AddCompositeMaterialsFunc;
		property Lib3MFModel_AddMultiPropertyGroupFunc: TLib3MFModel_AddMultiPropertyGroupFunc read FLib3MFModel_AddMultiPropertyGroupFunc;
		property Lib3MFModel_AddBuildItemFunc: TLib3MFModel_AddBuildItemFunc read FLib3MFModel_AddBuildItemFunc;
		property Lib3MFModel_RemoveBuildItemFunc: TLib3MFModel_RemoveBuildItemFunc read FLib3MFModel_RemoveBuildItemFunc;
		property Lib3MFModel_GetMetaDataGroupFunc: TLib3MFModel_GetMetaDataGroupFunc read FLib3MFModel_GetMetaDataGroupFunc;
		property Lib3MFModel_AddAttachmentFunc: TLib3MFModel_AddAttachmentFunc read FLib3MFModel_AddAttachmentFunc;
		property Lib3MFModel_RemoveAttachmentFunc: TLib3MFModel_RemoveAttachmentFunc read FLib3MFModel_RemoveAttachmentFunc;
		property Lib3MFModel_GetAttachmentFunc: TLib3MFModel_GetAttachmentFunc read FLib3MFModel_GetAttachmentFunc;
		property Lib3MFModel_FindAttachmentFunc: TLib3MFModel_FindAttachmentFunc read FLib3MFModel_FindAttachmentFunc;
		property Lib3MFModel_GetAttachmentCountFunc: TLib3MFModel_GetAttachmentCountFunc read FLib3MFModel_GetAttachmentCountFunc;
		property Lib3MFModel_HasPackageThumbnailAttachmentFunc: TLib3MFModel_HasPackageThumbnailAttachmentFunc read FLib3MFModel_HasPackageThumbnailAttachmentFunc;
		property Lib3MFModel_CreatePackageThumbnailAttachmentFunc: TLib3MFModel_CreatePackageThumbnailAttachmentFunc read FLib3MFModel_CreatePackageThumbnailAttachmentFunc;
		property Lib3MFModel_GetPackageThumbnailAttachmentFunc: TLib3MFModel_GetPackageThumbnailAttachmentFunc read FLib3MFModel_GetPackageThumbnailAttachmentFunc;
		property Lib3MFModel_RemovePackageThumbnailAttachmentFunc: TLib3MFModel_RemovePackageThumbnailAttachmentFunc read FLib3MFModel_RemovePackageThumbnailAttachmentFunc;
		property Lib3MFModel_AddCustomContentTypeFunc: TLib3MFModel_AddCustomContentTypeFunc read FLib3MFModel_AddCustomContentTypeFunc;
		property Lib3MFModel_RemoveCustomContentTypeFunc: TLib3MFModel_RemoveCustomContentTypeFunc read FLib3MFModel_RemoveCustomContentTypeFunc;
		property Lib3MFModel_SetRandomNumberCallbackFunc: TLib3MFModel_SetRandomNumberCallbackFunc read FLib3MFModel_SetRandomNumberCallbackFunc;
		property Lib3MFModel_GetKeyStoreFunc: TLib3MFModel_GetKeyStoreFunc read FLib3MFModel_GetKeyStoreFunc;
		property Lib3MFGetLibraryVersionFunc: TLib3MFGetLibraryVersionFunc read FLib3MFGetLibraryVersionFunc;
		property Lib3MFGetPrereleaseInformationFunc: TLib3MFGetPrereleaseInformationFunc read FLib3MFGetPrereleaseInformationFunc;
		property Lib3MFGetBuildInformationFunc: TLib3MFGetBuildInformationFunc read FLib3MFGetBuildInformationFunc;
		property Lib3MFGetSpecificationVersionFunc: TLib3MFGetSpecificationVersionFunc read FLib3MFGetSpecificationVersionFunc;
		property Lib3MFCreateModelFunc: TLib3MFCreateModelFunc read FLib3MFCreateModelFunc;
		property Lib3MFReleaseFunc: TLib3MFReleaseFunc read FLib3MFReleaseFunc;
		property Lib3MFAcquireFunc: TLib3MFAcquireFunc read FLib3MFAcquireFunc;
		property Lib3MFSetJournalFunc: TLib3MFSetJournalFunc read FLib3MFSetJournalFunc;
		property Lib3MFGetLastErrorFunc: TLib3MFGetLastErrorFunc read FLib3MFGetLastErrorFunc;
		property Lib3MFGetSymbolLookupMethodFunc: TLib3MFGetSymbolLookupMethodFunc read FLib3MFGetSymbolLookupMethodFunc;
		property Lib3MFRetrieveProgressMessageFunc: TLib3MFRetrieveProgressMessageFunc read FLib3MFRetrieveProgressMessageFunc;
		property Lib3MFRGBAToColorFunc: TLib3MFRGBAToColorFunc read FLib3MFRGBAToColorFunc;
		property Lib3MFFloatRGBAToColorFunc: TLib3MFFloatRGBAToColorFunc read FLib3MFFloatRGBAToColorFunc;
		property Lib3MFColorToRGBAFunc: TLib3MFColorToRGBAFunc read FLib3MFColorToRGBAFunc;
		property Lib3MFColorToFloatRGBAFunc: TLib3MFColorToFloatRGBAFunc read FLib3MFColorToFloatRGBAFunc;
		property Lib3MFGetIdentityTransformFunc: TLib3MFGetIdentityTransformFunc read FLib3MFGetIdentityTransformFunc;
		property Lib3MFGetUniformScaleTransformFunc: TLib3MFGetUniformScaleTransformFunc read FLib3MFGetUniformScaleTransformFunc;
		property Lib3MFGetScaleTransformFunc: TLib3MFGetScaleTransformFunc read FLib3MFGetScaleTransformFunc;
		property Lib3MFGetTranslationTransformFunc: TLib3MFGetTranslationTransformFunc read FLib3MFGetTranslationTransformFunc;
		procedure CheckError(AInstance: TLib3MFBase; AErrorCode: TLib3MFResult);
	public
		constructor Create(ADLLName: String);
		constructor CreateFromSymbolLookupMethod(ALookupMethod: TLib3MFSymbolLookupMethod);
		destructor Destroy; override;
		procedure GetLibraryVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
		function GetPrereleaseInformation(out APrereleaseInfo: String): Boolean;
		function GetBuildInformation(out ABuildInformation: String): Boolean;
		procedure GetSpecificationVersion(const ASpecificationURL: String; out AIsSupported: Boolean; out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
		function CreateModel(): TLib3MFModel;
		procedure Release(const AInstance: TLib3MFBase);
		procedure Acquire(const AInstance: TLib3MFBase);
		procedure SetJournal(const AJournalPath: String);
		function GetLastError(const AInstance: TLib3MFBase; out ALastErrorString: String): Boolean;
		function GetSymbolLookupMethod(): Pointer;
		procedure RetrieveProgressMessage(const ATheProgressIdentifier: TLib3MFProgressIdentifier; out AProgressMessage: String);
		function RGBAToColor(const ARed: Byte; const AGreen: Byte; const ABlue: Byte; const AAlpha: Byte): TLib3MFColor;
		function FloatRGBAToColor(const ARed: Single; const AGreen: Single; const ABlue: Single; const AAlpha: Single): TLib3MFColor;
		procedure ColorToRGBA(const ATheColor: TLib3MFColor; out ARed: Byte; out AGreen: Byte; out ABlue: Byte; out AAlpha: Byte);
		procedure ColorToFloatRGBA(const ATheColor: TLib3MFColor; out ARed: Single; out AGreen: Single; out ABlue: Single; out AAlpha: Single);
		function GetIdentityTransform(): TLib3MFTransform;
		function GetUniformScaleTransform(const AFactor: Single): TLib3MFTransform;
		function GetScaleTransform(const AFactorX: Single; const AFactorY: Single; const AFactorZ: Single): TLib3MFTransform;
		function GetTranslationTransform(const AVectorX: Single; const AVectorY: Single; const AVectorZ: Single): TLib3MFTransform;
	end;

(*************************************************************************************************************************
 Enum conversion
**************************************************************************************************************************)

	function convertPropertyTypeToConst(const AValue: TLib3MFPropertyType): Integer;
	function convertConstToPropertyType(const AValue: Integer): TLib3MFPropertyType;
	function convertSlicesMeshResolutionToConst(const AValue: TLib3MFSlicesMeshResolution): Integer;
	function convertConstToSlicesMeshResolution(const AValue: Integer): TLib3MFSlicesMeshResolution;
	function convertModelUnitToConst(const AValue: TLib3MFModelUnit): Integer;
	function convertConstToModelUnit(const AValue: Integer): TLib3MFModelUnit;
	function convertObjectTypeToConst(const AValue: TLib3MFObjectType): Integer;
	function convertConstToObjectType(const AValue: Integer): TLib3MFObjectType;
	function convertTextureTypeToConst(const AValue: TLib3MFTextureType): Integer;
	function convertConstToTextureType(const AValue: Integer): TLib3MFTextureType;
	function convertTextureTileStyleToConst(const AValue: TLib3MFTextureTileStyle): Integer;
	function convertConstToTextureTileStyle(const AValue: Integer): TLib3MFTextureTileStyle;
	function convertTextureFilterToConst(const AValue: TLib3MFTextureFilter): Integer;
	function convertConstToTextureFilter(const AValue: Integer): TLib3MFTextureFilter;
	function convertBeamLatticeCapModeToConst(const AValue: TLib3MFBeamLatticeCapMode): Integer;
	function convertConstToBeamLatticeCapMode(const AValue: Integer): TLib3MFBeamLatticeCapMode;
	function convertBeamLatticeClipModeToConst(const AValue: TLib3MFBeamLatticeClipMode): Integer;
	function convertConstToBeamLatticeClipMode(const AValue: Integer): TLib3MFBeamLatticeClipMode;
	function convertBeamLatticeBallModeToConst(const AValue: TLib3MFBeamLatticeBallMode): Integer;
	function convertConstToBeamLatticeBallMode(const AValue: Integer): TLib3MFBeamLatticeBallMode;
	function convertProgressIdentifierToConst(const AValue: TLib3MFProgressIdentifier): Integer;
	function convertConstToProgressIdentifier(const AValue: Integer): TLib3MFProgressIdentifier;
	function convertBlendMethodToConst(const AValue: TLib3MFBlendMethod): Integer;
	function convertConstToBlendMethod(const AValue: Integer): TLib3MFBlendMethod;
	function convertEncryptionAlgorithmToConst(const AValue: TLib3MFEncryptionAlgorithm): Integer;
	function convertConstToEncryptionAlgorithm(const AValue: Integer): TLib3MFEncryptionAlgorithm;
	function convertWrappingAlgorithmToConst(const AValue: TLib3MFWrappingAlgorithm): Integer;
	function convertConstToWrappingAlgorithm(const AValue: Integer): TLib3MFWrappingAlgorithm;
	function convertMgfAlgorithmToConst(const AValue: TLib3MFMgfAlgorithm): Integer;
	function convertConstToMgfAlgorithm(const AValue: Integer): TLib3MFMgfAlgorithm;
	function convertDigestMethodToConst(const AValue: TLib3MFDigestMethod): Integer;
	function convertConstToDigestMethod(const AValue: Integer): TLib3MFDigestMethod;
	function convertCompressionToConst(const AValue: TLib3MFCompression): Integer;
	function convertConstToCompression(const AValue: Integer): TLib3MFCompression;

	TLib3MFPolymorphicFactory<_T:class; _B> = record
		class function Make(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): _T; static;
	end;
	function TLib3MFPolymorphicFactoryMakeBase(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBase;
	function TLib3MFPolymorphicFactoryMakeWriter(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFWriter;
	function TLib3MFPolymorphicFactoryMakeReader(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFReader;
	function TLib3MFPolymorphicFactoryMakePackagePart(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFPackagePart;
	function TLib3MFPolymorphicFactoryMakeResource(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResource;
	function TLib3MFPolymorphicFactoryMakeResourceIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResourceIterator;
	function TLib3MFPolymorphicFactoryMakeSliceStackIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFSliceStackIterator;
	function TLib3MFPolymorphicFactoryMakeObjectIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFObjectIterator;
	function TLib3MFPolymorphicFactoryMakeMeshObjectIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMeshObjectIterator;
	function TLib3MFPolymorphicFactoryMakeComponentsObjectIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFComponentsObjectIterator;
	function TLib3MFPolymorphicFactoryMakeTexture2DIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2DIterator;
	function TLib3MFPolymorphicFactoryMakeBaseMaterialGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBaseMaterialGroupIterator;
	function TLib3MFPolymorphicFactoryMakeColorGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFColorGroupIterator;
	function TLib3MFPolymorphicFactoryMakeTexture2DGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2DGroupIterator;
	function TLib3MFPolymorphicFactoryMakeCompositeMaterialsIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFCompositeMaterialsIterator;
	function TLib3MFPolymorphicFactoryMakeMultiPropertyGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMultiPropertyGroupIterator;
	function TLib3MFPolymorphicFactoryMakeMetaData(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMetaData;
	function TLib3MFPolymorphicFactoryMakeMetaDataGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMetaDataGroup;
	function TLib3MFPolymorphicFactoryMakeObject(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFObject;
	function TLib3MFPolymorphicFactoryMakeMeshObject(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMeshObject;
	function TLib3MFPolymorphicFactoryMakeBeamLattice(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBeamLattice;
	function TLib3MFPolymorphicFactoryMakeComponent(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFComponent;
	function TLib3MFPolymorphicFactoryMakeComponentsObject(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFComponentsObject;
	function TLib3MFPolymorphicFactoryMakeBeamSet(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBeamSet;
	function TLib3MFPolymorphicFactoryMakeBaseMaterialGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBaseMaterialGroup;
	function TLib3MFPolymorphicFactoryMakeColorGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFColorGroup;
	function TLib3MFPolymorphicFactoryMakeTexture2DGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2DGroup;
	function TLib3MFPolymorphicFactoryMakeCompositeMaterials(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFCompositeMaterials;
	function TLib3MFPolymorphicFactoryMakeMultiPropertyGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMultiPropertyGroup;
	function TLib3MFPolymorphicFactoryMakeAttachment(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFAttachment;
	function TLib3MFPolymorphicFactoryMakeTexture2D(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2D;
	function TLib3MFPolymorphicFactoryMakeBuildItem(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBuildItem;
	function TLib3MFPolymorphicFactoryMakeBuildItemIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBuildItemIterator;
	function TLib3MFPolymorphicFactoryMakeSlice(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFSlice;
	function TLib3MFPolymorphicFactoryMakeSliceStack(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFSliceStack;
	function TLib3MFPolymorphicFactoryMakeConsumer(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFConsumer;
	function TLib3MFPolymorphicFactoryMakeAccessRight(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFAccessRight;
	function TLib3MFPolymorphicFactoryMakeContentEncryptionParams(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFContentEncryptionParams;
	function TLib3MFPolymorphicFactoryMakeResourceData(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResourceData;
	function TLib3MFPolymorphicFactoryMakeResourceDataGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResourceDataGroup;
	function TLib3MFPolymorphicFactoryMakeKeyStore(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFKeyStore;
	function TLib3MFPolymorphicFactoryMakeModel(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFModel;

implementation

(*************************************************************************************************************************
 Enum conversion
**************************************************************************************************************************)

	function convertPropertyTypeToConst(const AValue: TLib3MFPropertyType): Integer;
	begin
		case AValue of
			ePropertyTypeNoPropertyType: Result := 0;
			ePropertyTypeBaseMaterial: Result := 1;
			ePropertyTypeTexCoord: Result := 2;
			ePropertyTypeColors: Result := 3;
			ePropertyTypeComposite: Result := 4;
			ePropertyTypeMulti: Result := 5;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToPropertyType(const AValue: Integer): TLib3MFPropertyType;
	begin
		case AValue of
			0: Result := ePropertyTypeNoPropertyType;
			1: Result := ePropertyTypeBaseMaterial;
			2: Result := ePropertyTypeTexCoord;
			3: Result := ePropertyTypeColors;
			4: Result := ePropertyTypeComposite;
			5: Result := ePropertyTypeMulti;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertSlicesMeshResolutionToConst(const AValue: TLib3MFSlicesMeshResolution): Integer;
	begin
		case AValue of
			eSlicesMeshResolutionFullres: Result := 0;
			eSlicesMeshResolutionLowres: Result := 1;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToSlicesMeshResolution(const AValue: Integer): TLib3MFSlicesMeshResolution;
	begin
		case AValue of
			0: Result := eSlicesMeshResolutionFullres;
			1: Result := eSlicesMeshResolutionLowres;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertModelUnitToConst(const AValue: TLib3MFModelUnit): Integer;
	begin
		case AValue of
			eModelUnitMicroMeter: Result := 0;
			eModelUnitMilliMeter: Result := 1;
			eModelUnitCentiMeter: Result := 2;
			eModelUnitInch: Result := 3;
			eModelUnitFoot: Result := 4;
			eModelUnitMeter: Result := 5;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToModelUnit(const AValue: Integer): TLib3MFModelUnit;
	begin
		case AValue of
			0: Result := eModelUnitMicroMeter;
			1: Result := eModelUnitMilliMeter;
			2: Result := eModelUnitCentiMeter;
			3: Result := eModelUnitInch;
			4: Result := eModelUnitFoot;
			5: Result := eModelUnitMeter;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertObjectTypeToConst(const AValue: TLib3MFObjectType): Integer;
	begin
		case AValue of
			eObjectTypeOther: Result := 0;
			eObjectTypeModel: Result := 1;
			eObjectTypeSupport: Result := 2;
			eObjectTypeSolidSupport: Result := 3;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToObjectType(const AValue: Integer): TLib3MFObjectType;
	begin
		case AValue of
			0: Result := eObjectTypeOther;
			1: Result := eObjectTypeModel;
			2: Result := eObjectTypeSupport;
			3: Result := eObjectTypeSolidSupport;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertTextureTypeToConst(const AValue: TLib3MFTextureType): Integer;
	begin
		case AValue of
			eTextureTypeUnknown: Result := 0;
			eTextureTypePNG: Result := 1;
			eTextureTypeJPEG: Result := 2;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToTextureType(const AValue: Integer): TLib3MFTextureType;
	begin
		case AValue of
			0: Result := eTextureTypeUnknown;
			1: Result := eTextureTypePNG;
			2: Result := eTextureTypeJPEG;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertTextureTileStyleToConst(const AValue: TLib3MFTextureTileStyle): Integer;
	begin
		case AValue of
			eTextureTileStyleWrap: Result := 0;
			eTextureTileStyleMirror: Result := 1;
			eTextureTileStyleClamp: Result := 2;
			eTextureTileStyleNoTileStyle: Result := 3;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToTextureTileStyle(const AValue: Integer): TLib3MFTextureTileStyle;
	begin
		case AValue of
			0: Result := eTextureTileStyleWrap;
			1: Result := eTextureTileStyleMirror;
			2: Result := eTextureTileStyleClamp;
			3: Result := eTextureTileStyleNoTileStyle;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertTextureFilterToConst(const AValue: TLib3MFTextureFilter): Integer;
	begin
		case AValue of
			eTextureFilterAuto: Result := 0;
			eTextureFilterLinear: Result := 1;
			eTextureFilterNearest: Result := 2;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToTextureFilter(const AValue: Integer): TLib3MFTextureFilter;
	begin
		case AValue of
			0: Result := eTextureFilterAuto;
			1: Result := eTextureFilterLinear;
			2: Result := eTextureFilterNearest;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertBeamLatticeCapModeToConst(const AValue: TLib3MFBeamLatticeCapMode): Integer;
	begin
		case AValue of
			eBeamLatticeCapModeSphere: Result := 0;
			eBeamLatticeCapModeHemiSphere: Result := 1;
			eBeamLatticeCapModeButt: Result := 2;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToBeamLatticeCapMode(const AValue: Integer): TLib3MFBeamLatticeCapMode;
	begin
		case AValue of
			0: Result := eBeamLatticeCapModeSphere;
			1: Result := eBeamLatticeCapModeHemiSphere;
			2: Result := eBeamLatticeCapModeButt;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertBeamLatticeClipModeToConst(const AValue: TLib3MFBeamLatticeClipMode): Integer;
	begin
		case AValue of
			eBeamLatticeClipModeNoClipMode: Result := 0;
			eBeamLatticeClipModeInside: Result := 1;
			eBeamLatticeClipModeOutside: Result := 2;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToBeamLatticeClipMode(const AValue: Integer): TLib3MFBeamLatticeClipMode;
	begin
		case AValue of
			0: Result := eBeamLatticeClipModeNoClipMode;
			1: Result := eBeamLatticeClipModeInside;
			2: Result := eBeamLatticeClipModeOutside;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertBeamLatticeBallModeToConst(const AValue: TLib3MFBeamLatticeBallMode): Integer;
	begin
		case AValue of
			eBeamLatticeBallModeNone: Result := 0;
			eBeamLatticeBallModeMixed: Result := 1;
			eBeamLatticeBallModeAll: Result := 2;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToBeamLatticeBallMode(const AValue: Integer): TLib3MFBeamLatticeBallMode;
	begin
		case AValue of
			0: Result := eBeamLatticeBallModeNone;
			1: Result := eBeamLatticeBallModeMixed;
			2: Result := eBeamLatticeBallModeAll;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertProgressIdentifierToConst(const AValue: TLib3MFProgressIdentifier): Integer;
	begin
		case AValue of
			eProgressIdentifierQUERYCANCELED: Result := 0;
			eProgressIdentifierDONE: Result := 1;
			eProgressIdentifierCLEANUP: Result := 2;
			eProgressIdentifierREADSTREAM: Result := 3;
			eProgressIdentifierEXTRACTOPCPACKAGE: Result := 4;
			eProgressIdentifierREADNONROOTMODELS: Result := 5;
			eProgressIdentifierREADROOTMODEL: Result := 6;
			eProgressIdentifierREADRESOURCES: Result := 7;
			eProgressIdentifierREADMESH: Result := 8;
			eProgressIdentifierREADSLICES: Result := 9;
			eProgressIdentifierREADBUILD: Result := 10;
			eProgressIdentifierREADCUSTOMATTACHMENT: Result := 11;
			eProgressIdentifierREADTEXTURETACHMENTS: Result := 12;
			eProgressIdentifierCREATEOPCPACKAGE: Result := 13;
			eProgressIdentifierWRITEMODELSTOSTREAM: Result := 14;
			eProgressIdentifierWRITEROOTMODEL: Result := 15;
			eProgressIdentifierWRITENONROOTMODELS: Result := 16;
			eProgressIdentifierWRITEATTACHMENTS: Result := 17;
			eProgressIdentifierWRITECONTENTTYPES: Result := 18;
			eProgressIdentifierWRITENOBJECTS: Result := 19;
			eProgressIdentifierWRITENODES: Result := 20;
			eProgressIdentifierWRITETRIANGLES: Result := 21;
			eProgressIdentifierWRITESLICES: Result := 22;
			eProgressIdentifierWRITEKEYSTORE: Result := 23;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToProgressIdentifier(const AValue: Integer): TLib3MFProgressIdentifier;
	begin
		case AValue of
			0: Result := eProgressIdentifierQUERYCANCELED;
			1: Result := eProgressIdentifierDONE;
			2: Result := eProgressIdentifierCLEANUP;
			3: Result := eProgressIdentifierREADSTREAM;
			4: Result := eProgressIdentifierEXTRACTOPCPACKAGE;
			5: Result := eProgressIdentifierREADNONROOTMODELS;
			6: Result := eProgressIdentifierREADROOTMODEL;
			7: Result := eProgressIdentifierREADRESOURCES;
			8: Result := eProgressIdentifierREADMESH;
			9: Result := eProgressIdentifierREADSLICES;
			10: Result := eProgressIdentifierREADBUILD;
			11: Result := eProgressIdentifierREADCUSTOMATTACHMENT;
			12: Result := eProgressIdentifierREADTEXTURETACHMENTS;
			13: Result := eProgressIdentifierCREATEOPCPACKAGE;
			14: Result := eProgressIdentifierWRITEMODELSTOSTREAM;
			15: Result := eProgressIdentifierWRITEROOTMODEL;
			16: Result := eProgressIdentifierWRITENONROOTMODELS;
			17: Result := eProgressIdentifierWRITEATTACHMENTS;
			18: Result := eProgressIdentifierWRITECONTENTTYPES;
			19: Result := eProgressIdentifierWRITENOBJECTS;
			20: Result := eProgressIdentifierWRITENODES;
			21: Result := eProgressIdentifierWRITETRIANGLES;
			22: Result := eProgressIdentifierWRITESLICES;
			23: Result := eProgressIdentifierWRITEKEYSTORE;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertBlendMethodToConst(const AValue: TLib3MFBlendMethod): Integer;
	begin
		case AValue of
			eBlendMethodNoBlendMethod: Result := 0;
			eBlendMethodMix: Result := 1;
			eBlendMethodMultiply: Result := 2;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToBlendMethod(const AValue: Integer): TLib3MFBlendMethod;
	begin
		case AValue of
			0: Result := eBlendMethodNoBlendMethod;
			1: Result := eBlendMethodMix;
			2: Result := eBlendMethodMultiply;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertEncryptionAlgorithmToConst(const AValue: TLib3MFEncryptionAlgorithm): Integer;
	begin
		case AValue of
			eEncryptionAlgorithmAES256_GCM: Result := 1;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToEncryptionAlgorithm(const AValue: Integer): TLib3MFEncryptionAlgorithm;
	begin
		case AValue of
			1: Result := eEncryptionAlgorithmAES256_GCM;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertWrappingAlgorithmToConst(const AValue: TLib3MFWrappingAlgorithm): Integer;
	begin
		case AValue of
			eWrappingAlgorithmRSA_OAEP: Result := 0;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToWrappingAlgorithm(const AValue: Integer): TLib3MFWrappingAlgorithm;
	begin
		case AValue of
			0: Result := eWrappingAlgorithmRSA_OAEP;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertMgfAlgorithmToConst(const AValue: TLib3MFMgfAlgorithm): Integer;
	begin
		case AValue of
			eMgfAlgorithmMGF1_SHA1: Result := 160;
			eMgfAlgorithmMGF1_SHA224: Result := 224;
			eMgfAlgorithmMGF1_SHA256: Result := 256;
			eMgfAlgorithmMGF1_SHA384: Result := 384;
			eMgfAlgorithmMGF1_SHA512: Result := 512;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToMgfAlgorithm(const AValue: Integer): TLib3MFMgfAlgorithm;
	begin
		case AValue of
			160: Result := eMgfAlgorithmMGF1_SHA1;
			224: Result := eMgfAlgorithmMGF1_SHA224;
			256: Result := eMgfAlgorithmMGF1_SHA256;
			384: Result := eMgfAlgorithmMGF1_SHA384;
			512: Result := eMgfAlgorithmMGF1_SHA512;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertDigestMethodToConst(const AValue: TLib3MFDigestMethod): Integer;
	begin
		case AValue of
			eDigestMethodSHA1: Result := 160;
			eDigestMethodSHA256: Result := 256;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToDigestMethod(const AValue: Integer): TLib3MFDigestMethod;
	begin
		case AValue of
			160: Result := eDigestMethodSHA1;
			256: Result := eDigestMethodSHA256;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	
	function convertCompressionToConst(const AValue: TLib3MFCompression): Integer;
	begin
		case AValue of
			eCompressionNoCompression: Result := 0;
			eCompressionDeflate: Result := 1;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum value');
		end;
	end;
	
	function convertConstToCompression(const AValue: Integer): TLib3MFCompression;
	begin
		case AValue of
			0: Result := eCompressionNoCompression;
			1: Result := eCompressionDeflate;
			else 
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'invalid enum constant');
		end;
	end;
	
	


(*************************************************************************************************************************
 PolymorficFactory implementation
**************************************************************************************************************************)

	(**
	 * IMPORTANT: PolymorphicFactory method should not be used by application directly.
	 *            It's designed to be used on Lib3MFHandle object only once.
	 *            If it's used on any existing object as a form of dynamic cast then
	 *            TLIB3MFWrapper::AcquireInstance(object: TLIB3MFBase) must be called after instantiating new object.
	 *            This is important to keep reference count matching between application and library sides.
	*)
	class function TLib3MFPolymorphicFactory<_T, _B>.Make(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): _T;
	var
		ClassTypeId: QWord;
		Obj: TLIB3MFBase;
	begin
		Result := nil;
		Wrapper.CheckError(nil, Wrapper.Lib3MFBase_ClassTypeIdFunc(handle, ClassTypeId));
		case (ClassTypeId) of
			QWord($856632D0BAF1D8B7): begin Obj := TLIB3MFBase.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Base"
			QWord($E76F642F363FD7E9): begin Obj := TLIB3MFWriter.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Writer"
			QWord($2D86831DA59FBE72): begin Obj := TLIB3MFReader.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Reader"
			QWord($0E55A826D377483E): begin Obj := TLIB3MFPackagePart.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
			QWord($DFE3889D1B269CBB): begin Obj := TLIB3MFResource.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Resource"
			QWord($460F3515E2621DBE): begin Obj := TLIB3MFResourceIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
			QWord($69684DB99FA813F6): begin Obj := TLIB3MFSliceStackIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
			QWord($DE92510BD2112288): begin Obj := TLIB3MFObjectIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
			QWord($F4196034E2B9FDE6): begin Obj := TLIB3MFMeshObjectIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
			QWord($564DE4217ED7614A): begin Obj := TLIB3MFComponentsObjectIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
			QWord($4BD32B4870FFC03B): begin Obj := TLIB3MFTexture2DIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
			QWord($65E6EDD9362C79CB): begin Obj := TLIB3MFBaseMaterialGroupIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
			QWord($10274A1757C729C0): begin Obj := TLIB3MFColorGroupIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
			QWord($30D55F4DB88FE0CA): begin Obj := TLIB3MFTexture2DGroupIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
			QWord($A99CC6C3F70FB6F9): begin Obj := TLIB3MFCompositeMaterialsIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
			QWord($C2BDF5D8CBBDB1F0): begin Obj := TLIB3MFMultiPropertyGroupIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
			QWord($D17716D063DE2C22): begin Obj := TLIB3MFMetaData.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
			QWord($0C3B85369E9B25D3): begin Obj := TLIB3MFMetaDataGroup.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
			QWord($2DA2136F577A779C): begin Obj := TLIB3MFObject.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Object"
			QWord($3B3A6DC6EC610497): begin Obj := TLIB3MFMeshObject.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
			QWord($63B3B461B30B4BA5): begin Obj := TLIB3MFBeamLattice.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
			QWord($4ECDB6A6F69F2BEB): begin Obj := TLIB3MFComponent.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Component"
			QWord($6522CF04EB283FED): begin Obj := TLIB3MFComponentsObject.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
			QWord($30CCDBE90E00B55B): begin Obj := TLIB3MFBeamSet.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
			QWord($B27D4656E16609FA): begin Obj := TLIB3MFBaseMaterialGroup.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
			QWord($D085FB2E49CDB5B1): begin Obj := TLIB3MFColorGroup.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
			QWord($BC1208397E37055D): begin Obj := TLIB3MFTexture2DGroup.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
			QWord($CE16224D688B86F2): begin Obj := TLIB3MFCompositeMaterials.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
			QWord($B989E02E43158FE6): begin Obj := TLIB3MFMultiPropertyGroup.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
			QWord($8CE7A1191A63A35D): begin Obj := TLIB3MFAttachment.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
			QWord($E0441CF976B36319): begin Obj := TLIB3MFTexture2D.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
			QWord($68FB2D5FFC4BA12A): begin Obj := TLIB3MFBuildItem.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
			QWord($A7D21BD364910860): begin Obj := TLIB3MFBuildItemIterator.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
			QWord($2198BCF4D8DF9C40): begin Obj := TLIB3MFSlice.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Slice"
			QWord($6594B031B6096238): begin Obj := TLIB3MFSliceStack.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
			QWord($D9E46D5E6D8118EE): begin Obj := TLIB3MFConsumer.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
			QWord($385C42FC5609498A): begin Obj := TLIB3MFAccessRight.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
			QWord($7FB36B91D4CE4671): begin Obj := TLIB3MFContentEncryptionParams.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
			QWord($1A47A5E258E22EF9): begin Obj := TLIB3MFResourceData.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
			QWord($D59067227E428AA4): begin Obj := TLIB3MFResourceDataGroup.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
			QWord($1CC9E0CC082253C6): begin Obj := TLIB3MFKeyStore.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
			QWord($5A8164ECEDB03F09): begin Obj := TLIB3MFModel.Create(Wrapper, Handle); if Obj.inheritsFrom(_T) then Result := Obj as _T; end; // First 64 bits of SHA1 of a string: "Lib3MF::Model"
		end;
		if Result = nil then Result := _B.Create(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeBase(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBase;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFBase, TLIB3MFBase>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeWriter(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFWriter;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFWriter, TLIB3MFWriter>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeReader(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFReader;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFReader, TLIB3MFReader>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakePackagePart(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFPackagePart;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFPackagePart, TLIB3MFPackagePart>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeResource(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResource;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFResource, TLIB3MFResource>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeResourceIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResourceIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFResourceIterator, TLIB3MFResourceIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeSliceStackIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFSliceStackIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFSliceStackIterator, TLIB3MFSliceStackIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeObjectIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFObjectIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFObjectIterator, TLIB3MFObjectIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeMeshObjectIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMeshObjectIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFMeshObjectIterator, TLIB3MFMeshObjectIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeComponentsObjectIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFComponentsObjectIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFComponentsObjectIterator, TLIB3MFComponentsObjectIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeTexture2DIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2DIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFTexture2DIterator, TLIB3MFTexture2DIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeBaseMaterialGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBaseMaterialGroupIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFBaseMaterialGroupIterator, TLIB3MFBaseMaterialGroupIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeColorGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFColorGroupIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFColorGroupIterator, TLIB3MFColorGroupIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeTexture2DGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2DGroupIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFTexture2DGroupIterator, TLIB3MFTexture2DGroupIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeCompositeMaterialsIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFCompositeMaterialsIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFCompositeMaterialsIterator, TLIB3MFCompositeMaterialsIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeMultiPropertyGroupIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMultiPropertyGroupIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFMultiPropertyGroupIterator, TLIB3MFMultiPropertyGroupIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeMetaData(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMetaData;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFMetaData, TLIB3MFMetaData>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeMetaDataGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMetaDataGroup;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFMetaDataGroup, TLIB3MFMetaDataGroup>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeObject(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFObject;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFObject, TLIB3MFObject>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeMeshObject(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMeshObject;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFMeshObject, TLIB3MFMeshObject>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeBeamLattice(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBeamLattice;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFBeamLattice, TLIB3MFBeamLattice>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeComponent(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFComponent;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFComponent, TLIB3MFComponent>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeComponentsObject(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFComponentsObject;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFComponentsObject, TLIB3MFComponentsObject>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeBeamSet(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBeamSet;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFBeamSet, TLIB3MFBeamSet>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeBaseMaterialGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBaseMaterialGroup;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFBaseMaterialGroup, TLIB3MFBaseMaterialGroup>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeColorGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFColorGroup;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFColorGroup, TLIB3MFColorGroup>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeTexture2DGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2DGroup;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFTexture2DGroup, TLIB3MFTexture2DGroup>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeCompositeMaterials(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFCompositeMaterials;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFCompositeMaterials, TLIB3MFCompositeMaterials>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeMultiPropertyGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFMultiPropertyGroup;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFMultiPropertyGroup, TLIB3MFMultiPropertyGroup>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeAttachment(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFAttachment;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFAttachment, TLIB3MFAttachment>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeTexture2D(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFTexture2D;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFTexture2D, TLIB3MFTexture2D>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeBuildItem(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBuildItem;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFBuildItem, TLIB3MFBuildItem>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeBuildItemIterator(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFBuildItemIterator;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFBuildItemIterator, TLIB3MFBuildItemIterator>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeSlice(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFSlice;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFSlice, TLIB3MFSlice>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeSliceStack(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFSliceStack;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFSliceStack, TLIB3MFSliceStack>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeConsumer(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFConsumer;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFConsumer, TLIB3MFConsumer>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeAccessRight(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFAccessRight;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFAccessRight, TLIB3MFAccessRight>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeContentEncryptionParams(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFContentEncryptionParams;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFContentEncryptionParams, TLIB3MFContentEncryptionParams>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeResourceData(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResourceData;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFResourceData, TLIB3MFResourceData>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeResourceDataGroup(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFResourceDataGroup;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFResourceDataGroup, TLIB3MFResourceDataGroup>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeKeyStore(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFKeyStore;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFKeyStore, TLIB3MFKeyStore>.Make(Wrapper, Handle);
	end;
	function TLib3MFPolymorphicFactoryMakeModel(Wrapper: TLib3MFWrapper; Handle: TLib3MFHandle): TLIB3MFModel;
	begin
		Result := TLib3MFPolymorphicFactory<TLIB3MFModel, TLIB3MFModel>.Make(Wrapper, Handle);
	end;

(*************************************************************************************************************************
 Exception implementation
**************************************************************************************************************************)

	constructor ELib3MFException.Create(AErrorCode: TLib3MFResult; AMessage: String);
	var
		ADescription: String;
	begin
		FErrorCode := AErrorCode;
		case FErrorCode of
			LIB3MF_ERROR_NOTIMPLEMENTED: ADescription := 'functionality not implemented';
			LIB3MF_ERROR_INVALIDPARAM: ADescription := 'an invalid parameter was passed';
			LIB3MF_ERROR_INVALIDCAST: ADescription := 'a type cast failed';
			LIB3MF_ERROR_BUFFERTOOSMALL: ADescription := 'a provided buffer is too small';
			LIB3MF_ERROR_GENERICEXCEPTION: ADescription := 'a generic exception occurred';
			LIB3MF_ERROR_COULDNOTLOADLIBRARY: ADescription := 'the library could not be loaded';
			LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT: ADescription := 'a required exported symbol could not be found in the library';
			LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION: ADescription := 'the version of the binary interface does not match the bindings interface';
			LIB3MF_ERROR_CALCULATIONABORTED: ADescription := 'a calculation has been aborted';
			LIB3MF_ERROR_SHOULDNOTBECALLED: ADescription := 'functionality should not be called';
			LIB3MF_ERROR_READERCLASSUNKNOWN: ADescription := 'the queried reader class is unknown';
			LIB3MF_ERROR_WRITERCLASSUNKNOWN: ADescription := 'the queried writer class is unknown';
			LIB3MF_ERROR_ITERATORINVALIDINDEX: ADescription := 'the current index of an iterator is invalid';
			LIB3MF_ERROR_INVALIDMODELRESOURCE: ADescription := 'no Model Resource has been given';
			LIB3MF_ERROR_RESOURCENOTFOUND: ADescription := 'Resource not found';
			LIB3MF_ERROR_INVALIDMODEL: ADescription := 'A model is invalid';
			LIB3MF_ERROR_INVALIDOBJECT: ADescription := 'An object is invalid';
			LIB3MF_ERROR_INVALIDMESHOBJECT: ADescription := 'A mesh object is invalid';
			LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT: ADescription := 'A components object is invalid';
			LIB3MF_ERROR_INVALIDCOMPONENT: ADescription := 'A component is invalid';
			LIB3MF_ERROR_INVALIDBUILDITEM: ADescription := 'A build item is invalid';
			LIB3MF_ERROR_INVALIDBASEMATERIALGROUP: ADescription := 'A basematerialgroup is invalid';
			LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE: ADescription := 'A slicestack resource is invalid';
			LIB3MF_ERROR_INVALIDTEXTURERESOURCE: ADescription := 'A texture resource is invalid';
			LIB3MF_ERROR_INVALIDCOLORGROUP: ADescription := 'A color group resource is invalid';
			LIB3MF_ERROR_INVALIDTEXTURE2DGROUP: ADescription := 'A texture2d group resource is invalid';
			LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS: ADescription := 'A composite materials resource is invalid';
			LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP: ADescription := 'A MultiPropertyGroup resource is invalid';
			LIB3MF_ERROR_INVALIDRESOURCEINDEX: ADescription := 'A resource index is invalid';
			LIB3MF_ERROR_ATTACHMENTNOTFOUND: ADescription := 'Attachment not found';
			LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE: ADescription := 'A component references one of its ancestors';
			LIB3MF_ERROR_INVALIDATTACHMENTSTREAM: ADescription := 'An attachment stream is invalid';
			LIB3MF_ERROR_INVALIDPROPERTYCOUNT: ADescription := 'Invalid property count.';
			LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER: ADescription := 'A progress identifier is unknown';
			LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT: ADescription := 'An element buffer exceeds its spec limit';
			LIB3MF_ERROR_INVALIDRESOURCE: ADescription := 'A resource is invalid';
			LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE: ADescription := 'This object type is not valid for beamlattices';
			LIB3MF_ERROR_INVALIDKEYSTORE: ADescription := 'The keystore object is invalid';
			LIB3MF_ERROR_INVALIDKEYSTORECONSUMER: ADescription := 'The consumer keystore object is invalid';
			LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND: ADescription := 'A consumer has not been found';
			LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND: ADescription := 'A resource data has not been found';
			LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED: ADescription := 'A Key or Conentent encryption callback has not been registered';
			LIB3MF_ERROR_INVALIDKEYSIZE: ADescription := 'The key siue is invalid';
			else
				ADescription := 'unknown';
		end;

		inherited Create(Format('the 3MF Library Error - %s (#%d, %s)', [ ADescription, AErrorCode, AMessage ]));
	end;

	constructor ELib3MFException.CreateCustomMessage(AErrorCode: TLib3MFResult; AMessage: String);
	begin
		FCustomMessage := AMessage;
		FErrorCode := AErrorCode;
		inherited Create(Format('%s (%d)', [FCustomMessage, AErrorCode]));
	end;

(*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************)

	constructor TLib3MFBase.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		if not Assigned(AWrapper) then
			raise ELib3MFException.Create(LIB3MF_ERROR_INVALIDPARAM, '');
		if not Assigned(AHandle) then
			raise ELib3MFException.Create(LIB3MF_ERROR_INVALIDPARAM, '');

		inherited Create();
		FWrapper := AWrapper;
		FHandle := AHandle;
	end;

	destructor TLib3MFBase.Destroy;
	begin
		FWrapper.Release(self);
		inherited;
	end;

	function TLib3MFBase.ClassTypeId(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBase_ClassTypeIdFunc(FHandle, Result));
	end;

(*************************************************************************************************************************
 Class implementation for Writer
**************************************************************************************************************************)

	constructor TLib3MFWriter.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFWriter.Destroy;
	begin
		inherited;
	end;

	procedure TLib3MFWriter.WriteToFile(const AFilename: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_WriteToFileFunc(FHandle, PAnsiChar(AFilename)));
	end;

	function TLib3MFWriter.GetStreamSize(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_GetStreamSizeFunc(FHandle, Result));
	end;

	procedure TLib3MFWriter.WriteToBuffer(out ABuffer: TByteDynArray);
	var
		countNeededBuffer: QWord;
		countWrittenBuffer: QWord;
	begin
		countNeededBuffer:= 0;
		countWrittenBuffer:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_WriteToBufferFunc(FHandle, 0, countNeededBuffer, nil));
		SetLength(ABuffer, countNeededBuffer);
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_WriteToBufferFunc(FHandle, countNeededBuffer, countWrittenBuffer, @ABuffer[0]));
	end;

	procedure TLib3MFWriter.WriteToCallback(const ATheWriteCallback: PLib3MF_WriteCallback; const ATheSeekCallback: PLib3MF_SeekCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheWriteCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheWriteCallback is a nil value.');
		if not Assigned(ATheSeekCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheSeekCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_WriteToCallbackFunc(FHandle, ATheWriteCallback, ATheSeekCallback, AUserData));
	end;

	procedure TLib3MFWriter.SetProgressCallback(const AProgressCallback: PLib3MF_ProgressCallback; const AUserData: Pointer);
	begin
		if not Assigned(AProgressCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AProgressCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_SetProgressCallbackFunc(FHandle, AProgressCallback, AUserData));
	end;

	function TLib3MFWriter.GetDecimalPrecision(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_GetDecimalPrecisionFunc(FHandle, Result));
	end;

	procedure TLib3MFWriter.SetDecimalPrecision(const ADecimalPrecision: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_SetDecimalPrecisionFunc(FHandle, ADecimalPrecision));
	end;

	procedure TLib3MFWriter.SetStrictModeActive(const AStrictModeActive: Boolean);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_SetStrictModeActiveFunc(FHandle, Ord(AStrictModeActive)));
	end;

	function TLib3MFWriter.GetStrictModeActive(): Boolean;
	var
		ResultStrictModeActive: Byte;
	begin
		ResultStrictModeActive := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_GetStrictModeActiveFunc(FHandle, ResultStrictModeActive));
		Result := (ResultStrictModeActive <> 0);
	end;

	function TLib3MFWriter.GetWarning(const AIndex: Cardinal; out AErrorCode: Cardinal): String;
	var
		bytesNeededWarning: Cardinal;
		bytesWrittenWarning: Cardinal;
		bufferWarning: array of Char;
	begin
		bytesNeededWarning:= 0;
		bytesWrittenWarning:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_GetWarningFunc(FHandle, AIndex, AErrorCode, 0, bytesNeededWarning, nil));
		SetLength(bufferWarning, bytesNeededWarning);
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_GetWarningFunc(FHandle, AIndex, AErrorCode, bytesNeededWarning, bytesWrittenWarning, @bufferWarning[0]));
		Result := StrPas(@bufferWarning[0]);
	end;

	function TLib3MFWriter.GetWarningCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_GetWarningCountFunc(FHandle, Result));
	end;

	procedure TLib3MFWriter.AddKeyWrappingCallback(const AConsumerID: String; const ATheCallback: PLib3MF_KeyWrappingCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_AddKeyWrappingCallbackFunc(FHandle, PAnsiChar(AConsumerID), ATheCallback, AUserData));
	end;

	procedure TLib3MFWriter.SetContentEncryptionCallback(const ATheCallback: PLib3MF_ContentEncryptionCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFWriter_SetContentEncryptionCallbackFunc(FHandle, ATheCallback, AUserData));
	end;

(*************************************************************************************************************************
 Class implementation for Reader
**************************************************************************************************************************)

	constructor TLib3MFReader.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFReader.Destroy;
	begin
		inherited;
	end;

	procedure TLib3MFReader.ReadFromFile(const AFilename: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_ReadFromFileFunc(FHandle, PAnsiChar(AFilename)));
	end;

	procedure TLib3MFReader.ReadFromBuffer(const ABuffer: TByteDynArray);
	var
		PtrBuffer: PByte;
		LenBuffer: QWord;
	begin
		LenBuffer := Length(ABuffer);
		if LenBuffer > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenBuffer > 0 then
			PtrBuffer := @ABuffer[0]
		else
			PtrBuffer := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_ReadFromBufferFunc(FHandle, QWord(LenBuffer), PtrBuffer));
	end;

	procedure TLib3MFReader.ReadFromCallback(const ATheReadCallback: PLib3MF_ReadCallback; const AStreamSize: QWord; const ATheSeekCallback: PLib3MF_SeekCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheReadCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheReadCallback is a nil value.');
		if not Assigned(ATheSeekCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheSeekCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_ReadFromCallbackFunc(FHandle, ATheReadCallback, AStreamSize, ATheSeekCallback, AUserData));
	end;

	procedure TLib3MFReader.SetProgressCallback(const AProgressCallback: PLib3MF_ProgressCallback; const AUserData: Pointer);
	begin
		if not Assigned(AProgressCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AProgressCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_SetProgressCallbackFunc(FHandle, AProgressCallback, AUserData));
	end;

	procedure TLib3MFReader.AddRelationToRead(const ARelationShipType: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_AddRelationToReadFunc(FHandle, PAnsiChar(ARelationShipType)));
	end;

	procedure TLib3MFReader.RemoveRelationToRead(const ARelationShipType: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_RemoveRelationToReadFunc(FHandle, PAnsiChar(ARelationShipType)));
	end;

	procedure TLib3MFReader.SetStrictModeActive(const AStrictModeActive: Boolean);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_SetStrictModeActiveFunc(FHandle, Ord(AStrictModeActive)));
	end;

	function TLib3MFReader.GetStrictModeActive(): Boolean;
	var
		ResultStrictModeActive: Byte;
	begin
		ResultStrictModeActive := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_GetStrictModeActiveFunc(FHandle, ResultStrictModeActive));
		Result := (ResultStrictModeActive <> 0);
	end;

	function TLib3MFReader.GetWarning(const AIndex: Cardinal; out AErrorCode: Cardinal): String;
	var
		bytesNeededWarning: Cardinal;
		bytesWrittenWarning: Cardinal;
		bufferWarning: array of Char;
	begin
		bytesNeededWarning:= 0;
		bytesWrittenWarning:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_GetWarningFunc(FHandle, AIndex, AErrorCode, 0, bytesNeededWarning, nil));
		SetLength(bufferWarning, bytesNeededWarning);
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_GetWarningFunc(FHandle, AIndex, AErrorCode, bytesNeededWarning, bytesWrittenWarning, @bufferWarning[0]));
		Result := StrPas(@bufferWarning[0]);
	end;

	function TLib3MFReader.GetWarningCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_GetWarningCountFunc(FHandle, Result));
	end;

	procedure TLib3MFReader.AddKeyWrappingCallback(const AConsumerID: String; const ATheCallback: PLib3MF_KeyWrappingCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_AddKeyWrappingCallbackFunc(FHandle, PAnsiChar(AConsumerID), ATheCallback, AUserData));
	end;

	procedure TLib3MFReader.SetContentEncryptionCallback(const ATheCallback: PLib3MF_ContentEncryptionCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFReader_SetContentEncryptionCallbackFunc(FHandle, ATheCallback, AUserData));
	end;

(*************************************************************************************************************************
 Class implementation for PackagePart
**************************************************************************************************************************)

	constructor TLib3MFPackagePart.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFPackagePart.Destroy;
	begin
		inherited;
	end;

	function TLib3MFPackagePart.GetPath(): String;
	var
		bytesNeededPath: Cardinal;
		bytesWrittenPath: Cardinal;
		bufferPath: array of Char;
	begin
		bytesNeededPath:= 0;
		bytesWrittenPath:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFPackagePart_GetPathFunc(FHandle, 0, bytesNeededPath, nil));
		SetLength(bufferPath, bytesNeededPath);
		FWrapper.CheckError(Self, FWrapper.Lib3MFPackagePart_GetPathFunc(FHandle, bytesNeededPath, bytesWrittenPath, @bufferPath[0]));
		Result := StrPas(@bufferPath[0]);
	end;

	procedure TLib3MFPackagePart.SetPath(const APath: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFPackagePart_SetPathFunc(FHandle, PAnsiChar(APath)));
	end;

(*************************************************************************************************************************
 Class implementation for Resource
**************************************************************************************************************************)

	constructor TLib3MFResource.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFResource.Destroy;
	begin
		inherited;
	end;

	function TLib3MFResource.GetResourceID(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFResource_GetResourceIDFunc(FHandle, Result));
	end;

	function TLib3MFResource.GetUniqueResourceID(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFResource_GetUniqueResourceIDFunc(FHandle, Result));
	end;

	function TLib3MFResource.PackagePart(): TLib3MFPackagePart;
	var
		HPackagePart: TLib3MFHandle;
	begin
		Result := nil;
		HPackagePart := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResource_PackagePartFunc(FHandle, HPackagePart));
		if Assigned(HPackagePart) then
			Result := TLib3MFPolymorphicFactory<TLib3MFPackagePart, TLib3MFPackagePart>.Make(FWrapper, HPackagePart);
	end;

	procedure TLib3MFResource.SetPackagePart(const APackagePart: TLib3MFPackagePart);
	var
		APackagePartHandle: TLib3MFHandle;
	begin
		if Assigned(APackagePart) then
		APackagePartHandle := APackagePart.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'APackagePart is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFResource_SetPackagePartFunc(FHandle, APackagePartHandle));
	end;

	function TLib3MFResource.GetModelResourceID(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFResource_GetModelResourceIDFunc(FHandle, Result));
	end;

(*************************************************************************************************************************
 Class implementation for ResourceIterator
**************************************************************************************************************************)

	constructor TLib3MFResourceIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFResourceIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFResourceIterator.MoveNext(): Boolean;
	var
		ResultHasNext: Byte;
	begin
		ResultHasNext := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceIterator_MoveNextFunc(FHandle, ResultHasNext));
		Result := (ResultHasNext <> 0);
	end;

	function TLib3MFResourceIterator.MovePrevious(): Boolean;
	var
		ResultHasPrevious: Byte;
	begin
		ResultHasPrevious := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceIterator_MovePreviousFunc(FHandle, ResultHasPrevious));
		Result := (ResultHasPrevious <> 0);
	end;

	function TLib3MFResourceIterator.GetCurrent(): TLib3MFResource;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceIterator_GetCurrentFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResource, TLib3MFResource>.Make(FWrapper, HResource);
	end;

	function TLib3MFResourceIterator.Clone(): TLib3MFResourceIterator;
	var
		HOutResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HOutResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceIterator_CloneFunc(FHandle, HOutResourceIterator));
		if Assigned(HOutResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceIterator, TLib3MFResourceIterator>.Make(FWrapper, HOutResourceIterator);
	end;

	function TLib3MFResourceIterator.Count(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceIterator_CountFunc(FHandle, Result));
	end;

(*************************************************************************************************************************
 Class implementation for SliceStackIterator
**************************************************************************************************************************)

	constructor TLib3MFSliceStackIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFSliceStackIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFSliceStackIterator.GetCurrentSliceStack(): TLib3MFSliceStack;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStackIterator_GetCurrentSliceStackFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSliceStack, TLib3MFSliceStack>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for ObjectIterator
**************************************************************************************************************************)

	constructor TLib3MFObjectIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFObjectIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFObjectIterator.GetCurrentObject(): TLib3MFObject;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObjectIterator_GetCurrentObjectFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFObject, TLib3MFObject>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for MeshObjectIterator
**************************************************************************************************************************)

	constructor TLib3MFMeshObjectIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFMeshObjectIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFMeshObjectIterator.GetCurrentMeshObject(): TLib3MFMeshObject;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObjectIterator_GetCurrentMeshObjectFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMeshObject, TLib3MFMeshObject>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for ComponentsObjectIterator
**************************************************************************************************************************)

	constructor TLib3MFComponentsObjectIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFComponentsObjectIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFComponentsObjectIterator.GetCurrentComponentsObject(): TLib3MFComponentsObject;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFComponentsObject, TLib3MFComponentsObject>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for Texture2DIterator
**************************************************************************************************************************)

	constructor TLib3MFTexture2DIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFTexture2DIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFTexture2DIterator.GetCurrentTexture2D(): TLib3MFTexture2D;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DIterator_GetCurrentTexture2DFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2D, TLib3MFTexture2D>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for BaseMaterialGroupIterator
**************************************************************************************************************************)

	constructor TLib3MFBaseMaterialGroupIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFBaseMaterialGroupIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFBaseMaterialGroupIterator.GetCurrentBaseMaterialGroup(): TLib3MFBaseMaterialGroup;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBaseMaterialGroup, TLib3MFBaseMaterialGroup>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for ColorGroupIterator
**************************************************************************************************************************)

	constructor TLib3MFColorGroupIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFColorGroupIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFColorGroupIterator.GetCurrentColorGroup(): TLib3MFColorGroup;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroupIterator_GetCurrentColorGroupFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFColorGroup, TLib3MFColorGroup>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for Texture2DGroupIterator
**************************************************************************************************************************)

	constructor TLib3MFTexture2DGroupIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFTexture2DGroupIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFTexture2DGroupIterator.GetCurrentTexture2DGroup(): TLib3MFTexture2DGroup;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2DGroup, TLib3MFTexture2DGroup>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for CompositeMaterialsIterator
**************************************************************************************************************************)

	constructor TLib3MFCompositeMaterialsIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFCompositeMaterialsIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFCompositeMaterialsIterator.GetCurrentCompositeMaterials(): TLib3MFCompositeMaterials;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFCompositeMaterials, TLib3MFCompositeMaterials>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for MultiPropertyGroupIterator
**************************************************************************************************************************)

	constructor TLib3MFMultiPropertyGroupIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFMultiPropertyGroupIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFMultiPropertyGroupIterator.GetCurrentMultiPropertyGroup(): TLib3MFMultiPropertyGroup;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc(FHandle, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMultiPropertyGroup, TLib3MFMultiPropertyGroup>.Make(FWrapper, HResource);
	end;

(*************************************************************************************************************************
 Class implementation for MetaData
**************************************************************************************************************************)

	constructor TLib3MFMetaData.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFMetaData.Destroy;
	begin
		inherited;
	end;

	function TLib3MFMetaData.GetNameSpace(): String;
	var
		bytesNeededNameSpace: Cardinal;
		bytesWrittenNameSpace: Cardinal;
		bufferNameSpace: array of Char;
	begin
		bytesNeededNameSpace:= 0;
		bytesWrittenNameSpace:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetNameSpaceFunc(FHandle, 0, bytesNeededNameSpace, nil));
		SetLength(bufferNameSpace, bytesNeededNameSpace);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetNameSpaceFunc(FHandle, bytesNeededNameSpace, bytesWrittenNameSpace, @bufferNameSpace[0]));
		Result := StrPas(@bufferNameSpace[0]);
	end;

	procedure TLib3MFMetaData.SetNameSpace(const ANameSpace: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_SetNameSpaceFunc(FHandle, PAnsiChar(ANameSpace)));
	end;

	function TLib3MFMetaData.GetName(): String;
	var
		bytesNeededName: Cardinal;
		bytesWrittenName: Cardinal;
		bufferName: array of Char;
	begin
		bytesNeededName:= 0;
		bytesWrittenName:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetNameFunc(FHandle, 0, bytesNeededName, nil));
		SetLength(bufferName, bytesNeededName);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetNameFunc(FHandle, bytesNeededName, bytesWrittenName, @bufferName[0]));
		Result := StrPas(@bufferName[0]);
	end;

	procedure TLib3MFMetaData.SetName(const AName: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_SetNameFunc(FHandle, PAnsiChar(AName)));
	end;

	function TLib3MFMetaData.GetKey(): String;
	var
		bytesNeededKey: Cardinal;
		bytesWrittenKey: Cardinal;
		bufferKey: array of Char;
	begin
		bytesNeededKey:= 0;
		bytesWrittenKey:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetKeyFunc(FHandle, 0, bytesNeededKey, nil));
		SetLength(bufferKey, bytesNeededKey);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetKeyFunc(FHandle, bytesNeededKey, bytesWrittenKey, @bufferKey[0]));
		Result := StrPas(@bufferKey[0]);
	end;

	function TLib3MFMetaData.GetMustPreserve(): Boolean;
	var
		ResultMustPreserve: Byte;
	begin
		ResultMustPreserve := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetMustPreserveFunc(FHandle, ResultMustPreserve));
		Result := (ResultMustPreserve <> 0);
	end;

	procedure TLib3MFMetaData.SetMustPreserve(const AMustPreserve: Boolean);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_SetMustPreserveFunc(FHandle, Ord(AMustPreserve)));
	end;

	function TLib3MFMetaData.GetType(): String;
	var
		bytesNeededType: Cardinal;
		bytesWrittenType: Cardinal;
		bufferType: array of Char;
	begin
		bytesNeededType:= 0;
		bytesWrittenType:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetTypeFunc(FHandle, 0, bytesNeededType, nil));
		SetLength(bufferType, bytesNeededType);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetTypeFunc(FHandle, bytesNeededType, bytesWrittenType, @bufferType[0]));
		Result := StrPas(@bufferType[0]);
	end;

	procedure TLib3MFMetaData.SetType(const AType: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_SetTypeFunc(FHandle, PAnsiChar(AType)));
	end;

	function TLib3MFMetaData.GetValue(): String;
	var
		bytesNeededValue: Cardinal;
		bytesWrittenValue: Cardinal;
		bufferValue: array of Char;
	begin
		bytesNeededValue:= 0;
		bytesWrittenValue:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetValueFunc(FHandle, 0, bytesNeededValue, nil));
		SetLength(bufferValue, bytesNeededValue);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_GetValueFunc(FHandle, bytesNeededValue, bytesWrittenValue, @bufferValue[0]));
		Result := StrPas(@bufferValue[0]);
	end;

	procedure TLib3MFMetaData.SetValue(const AValue: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaData_SetValueFunc(FHandle, PAnsiChar(AValue)));
	end;

(*************************************************************************************************************************
 Class implementation for MetaDataGroup
**************************************************************************************************************************)

	constructor TLib3MFMetaDataGroup.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFMetaDataGroup.Destroy;
	begin
		inherited;
	end;

	function TLib3MFMetaDataGroup.GetMetaDataCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaDataGroup_GetMetaDataCountFunc(FHandle, Result));
	end;

	function TLib3MFMetaDataGroup.GetMetaData(const AIndex: Cardinal): TLib3MFMetaData;
	var
		HMetaData: TLib3MFHandle;
	begin
		Result := nil;
		HMetaData := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaDataGroup_GetMetaDataFunc(FHandle, AIndex, HMetaData));
		if Assigned(HMetaData) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMetaData, TLib3MFMetaData>.Make(FWrapper, HMetaData);
	end;

	function TLib3MFMetaDataGroup.GetMetaDataByKey(const ANameSpace: String; const AName: String): TLib3MFMetaData;
	var
		HMetaData: TLib3MFHandle;
	begin
		Result := nil;
		HMetaData := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaDataGroup_GetMetaDataByKeyFunc(FHandle, PAnsiChar(ANameSpace), PAnsiChar(AName), HMetaData));
		if Assigned(HMetaData) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMetaData, TLib3MFMetaData>.Make(FWrapper, HMetaData);
	end;

	procedure TLib3MFMetaDataGroup.RemoveMetaDataByIndex(const AIndex: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaDataGroup_RemoveMetaDataByIndexFunc(FHandle, AIndex));
	end;

	procedure TLib3MFMetaDataGroup.RemoveMetaData(const ATheMetaData: TLib3MFMetaData);
	var
		ATheMetaDataHandle: TLib3MFHandle;
	begin
		if Assigned(ATheMetaData) then
		ATheMetaDataHandle := ATheMetaData.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheMetaData is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaDataGroup_RemoveMetaDataFunc(FHandle, ATheMetaDataHandle));
	end;

	function TLib3MFMetaDataGroup.AddMetaData(const ANameSpace: String; const AName: String; const AValue: String; const AType: String; const AMustPreserve: Boolean): TLib3MFMetaData;
	var
		HMetaData: TLib3MFHandle;
	begin
		Result := nil;
		HMetaData := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMetaDataGroup_AddMetaDataFunc(FHandle, PAnsiChar(ANameSpace), PAnsiChar(AName), PAnsiChar(AValue), PAnsiChar(AType), Ord(AMustPreserve), HMetaData));
		if Assigned(HMetaData) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMetaData, TLib3MFMetaData>.Make(FWrapper, HMetaData);
	end;

(*************************************************************************************************************************
 Class implementation for Object
**************************************************************************************************************************)

	constructor TLib3MFObject.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFObject.Destroy;
	begin
		inherited;
	end;

	function TLib3MFObject.GetType(): TLib3MFObjectType;
	var
		ResultObjectType: Integer;
	begin
		ResultObjectType := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetTypeFunc(FHandle, ResultObjectType));
		Result := convertConstToObjectType(ResultObjectType);
	end;

	procedure TLib3MFObject.SetType(const AObjectType: TLib3MFObjectType);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_SetTypeFunc(FHandle, convertObjectTypeToConst(AObjectType)));
	end;

	function TLib3MFObject.GetName(): String;
	var
		bytesNeededName: Cardinal;
		bytesWrittenName: Cardinal;
		bufferName: array of Char;
	begin
		bytesNeededName:= 0;
		bytesWrittenName:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetNameFunc(FHandle, 0, bytesNeededName, nil));
		SetLength(bufferName, bytesNeededName);
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetNameFunc(FHandle, bytesNeededName, bytesWrittenName, @bufferName[0]));
		Result := StrPas(@bufferName[0]);
	end;

	procedure TLib3MFObject.SetName(const AName: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_SetNameFunc(FHandle, PAnsiChar(AName)));
	end;

	function TLib3MFObject.GetPartNumber(): String;
	var
		bytesNeededPartNumber: Cardinal;
		bytesWrittenPartNumber: Cardinal;
		bufferPartNumber: array of Char;
	begin
		bytesNeededPartNumber:= 0;
		bytesWrittenPartNumber:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetPartNumberFunc(FHandle, 0, bytesNeededPartNumber, nil));
		SetLength(bufferPartNumber, bytesNeededPartNumber);
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetPartNumberFunc(FHandle, bytesNeededPartNumber, bytesWrittenPartNumber, @bufferPartNumber[0]));
		Result := StrPas(@bufferPartNumber[0]);
	end;

	procedure TLib3MFObject.SetPartNumber(const APartNumber: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_SetPartNumberFunc(FHandle, PAnsiChar(APartNumber)));
	end;

	function TLib3MFObject.IsMeshObject(): Boolean;
	var
		ResultIsMeshObject: Byte;
	begin
		ResultIsMeshObject := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_IsMeshObjectFunc(FHandle, ResultIsMeshObject));
		Result := (ResultIsMeshObject <> 0);
	end;

	function TLib3MFObject.IsComponentsObject(): Boolean;
	var
		ResultIsComponentsObject: Byte;
	begin
		ResultIsComponentsObject := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_IsComponentsObjectFunc(FHandle, ResultIsComponentsObject));
		Result := (ResultIsComponentsObject <> 0);
	end;

	function TLib3MFObject.IsValid(): Boolean;
	var
		ResultIsValid: Byte;
	begin
		ResultIsValid := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_IsValidFunc(FHandle, ResultIsValid));
		Result := (ResultIsValid <> 0);
	end;

	procedure TLib3MFObject.SetAttachmentAsThumbnail(const AAttachment: TLib3MFAttachment);
	var
		AAttachmentHandle: TLib3MFHandle;
	begin
		if Assigned(AAttachment) then
		AAttachmentHandle := AAttachment.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AAttachment is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_SetAttachmentAsThumbnailFunc(FHandle, AAttachmentHandle));
	end;

	function TLib3MFObject.GetThumbnailAttachment(): TLib3MFAttachment;
	var
		HAttachment: TLib3MFHandle;
	begin
		Result := nil;
		HAttachment := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetThumbnailAttachmentFunc(FHandle, HAttachment));
		if Assigned(HAttachment) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAttachment, TLib3MFAttachment>.Make(FWrapper, HAttachment);
	end;

	procedure TLib3MFObject.ClearThumbnailAttachment();
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_ClearThumbnailAttachmentFunc(FHandle));
	end;

	function TLib3MFObject.GetOutbox(): TLib3MFBox;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetOutboxFunc(FHandle, @Result));
	end;

	function TLib3MFObject.GetUUID(out AHasUUID: Boolean): String;
	var
		ResultHasUUID: Byte;
		bytesNeededUUID: Cardinal;
		bytesWrittenUUID: Cardinal;
		bufferUUID: array of Char;
	begin
		ResultHasUUID := 0;
		bytesNeededUUID:= 0;
		bytesWrittenUUID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetUUIDFunc(FHandle, ResultHasUUID, 0, bytesNeededUUID, nil));
		SetLength(bufferUUID, bytesNeededUUID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetUUIDFunc(FHandle, ResultHasUUID, bytesNeededUUID, bytesWrittenUUID, @bufferUUID[0]));
		AHasUUID := ResultHasUUID <> 0;
		Result := StrPas(@bufferUUID[0]);
	end;

	procedure TLib3MFObject.SetUUID(const AUUID: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_SetUUIDFunc(FHandle, PAnsiChar(AUUID)));
	end;

	function TLib3MFObject.GetMetaDataGroup(): TLib3MFMetaDataGroup;
	var
		HMetaDataGroup: TLib3MFHandle;
	begin
		Result := nil;
		HMetaDataGroup := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetMetaDataGroupFunc(FHandle, HMetaDataGroup));
		if Assigned(HMetaDataGroup) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMetaDataGroup, TLib3MFMetaDataGroup>.Make(FWrapper, HMetaDataGroup);
	end;

	procedure TLib3MFObject.SetSlicesMeshResolution(const AMeshResolution: TLib3MFSlicesMeshResolution);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_SetSlicesMeshResolutionFunc(FHandle, convertSlicesMeshResolutionToConst(AMeshResolution)));
	end;

	function TLib3MFObject.GetSlicesMeshResolution(): TLib3MFSlicesMeshResolution;
	var
		ResultMeshResolution: Integer;
	begin
		ResultMeshResolution := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetSlicesMeshResolutionFunc(FHandle, ResultMeshResolution));
		Result := convertConstToSlicesMeshResolution(ResultMeshResolution);
	end;

	function TLib3MFObject.HasSlices(const ARecursive: Boolean): Boolean;
	var
		ResultHasSlices: Byte;
	begin
		ResultHasSlices := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_HasSlicesFunc(FHandle, Ord(ARecursive), ResultHasSlices));
		Result := (ResultHasSlices <> 0);
	end;

	procedure TLib3MFObject.ClearSliceStack();
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_ClearSliceStackFunc(FHandle));
	end;

	function TLib3MFObject.GetSliceStack(): TLib3MFSliceStack;
	var
		HSliceStackInstance: TLib3MFHandle;
	begin
		Result := nil;
		HSliceStackInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_GetSliceStackFunc(FHandle, HSliceStackInstance));
		if Assigned(HSliceStackInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSliceStack, TLib3MFSliceStack>.Make(FWrapper, HSliceStackInstance);
	end;

	procedure TLib3MFObject.AssignSliceStack(const ASliceStackInstance: TLib3MFSliceStack);
	var
		ASliceStackInstanceHandle: TLib3MFHandle;
	begin
		if Assigned(ASliceStackInstance) then
		ASliceStackInstanceHandle := ASliceStackInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ASliceStackInstance is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFObject_AssignSliceStackFunc(FHandle, ASliceStackInstanceHandle));
	end;

(*************************************************************************************************************************
 Class implementation for MeshObject
**************************************************************************************************************************)

	constructor TLib3MFMeshObject.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFMeshObject.Destroy;
	begin
		inherited;
	end;

	function TLib3MFMeshObject.GetVertexCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetVertexCountFunc(FHandle, Result));
	end;

	function TLib3MFMeshObject.GetTriangleCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetTriangleCountFunc(FHandle, Result));
	end;

	function TLib3MFMeshObject.GetVertex(const AIndex: Cardinal): TLib3MFPosition;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetVertexFunc(FHandle, AIndex, @Result));
	end;

	procedure TLib3MFMeshObject.SetVertex(const AIndex: Cardinal; const ACoordinates: TLib3MFPosition);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_SetVertexFunc(FHandle, AIndex, @ACoordinates));
	end;

	function TLib3MFMeshObject.AddVertex(const ACoordinates: TLib3MFPosition): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_AddVertexFunc(FHandle, @ACoordinates, Result));
	end;

	procedure TLib3MFMeshObject.GetVertices(out AVertices: ArrayOfLib3MFPosition);
	var
		countNeededVertices: QWord;
		countWrittenVertices: QWord;
	begin
		countNeededVertices:= 0;
		countWrittenVertices:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetVerticesFunc(FHandle, 0, countNeededVertices, nil));
		SetLength(AVertices, countNeededVertices);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetVerticesFunc(FHandle, countNeededVertices, countWrittenVertices, @AVertices[0]));
	end;

	function TLib3MFMeshObject.GetTriangle(const AIndex: Cardinal): TLib3MFTriangle;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetTriangleFunc(FHandle, AIndex, @Result));
	end;

	procedure TLib3MFMeshObject.SetTriangle(const AIndex: Cardinal; const AIndices: TLib3MFTriangle);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_SetTriangleFunc(FHandle, AIndex, @AIndices));
	end;

	function TLib3MFMeshObject.AddTriangle(const AIndices: TLib3MFTriangle): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_AddTriangleFunc(FHandle, @AIndices, Result));
	end;

	procedure TLib3MFMeshObject.GetTriangleIndices(out AIndices: ArrayOfLib3MFTriangle);
	var
		countNeededIndices: QWord;
		countWrittenIndices: QWord;
	begin
		countNeededIndices:= 0;
		countWrittenIndices:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetTriangleIndicesFunc(FHandle, 0, countNeededIndices, nil));
		SetLength(AIndices, countNeededIndices);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetTriangleIndicesFunc(FHandle, countNeededIndices, countWrittenIndices, @AIndices[0]));
	end;

	procedure TLib3MFMeshObject.SetObjectLevelProperty(const AUniqueResourceID: Cardinal; const APropertyID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_SetObjectLevelPropertyFunc(FHandle, AUniqueResourceID, APropertyID));
	end;

	function TLib3MFMeshObject.GetObjectLevelProperty(out AUniqueResourceID: Cardinal; out APropertyID: Cardinal): Boolean;
	var
		ResultHasObjectLevelProperty: Byte;
	begin
		ResultHasObjectLevelProperty := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetObjectLevelPropertyFunc(FHandle, AUniqueResourceID, APropertyID, ResultHasObjectLevelProperty));
		Result := (ResultHasObjectLevelProperty <> 0);
	end;

	procedure TLib3MFMeshObject.SetTriangleProperties(const AIndex: Cardinal; const AProperties: TLib3MFTriangleProperties);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_SetTrianglePropertiesFunc(FHandle, AIndex, @AProperties));
	end;

	procedure TLib3MFMeshObject.GetTriangleProperties(const AIndex: Cardinal; out AProperty: TLib3MFTriangleProperties);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetTrianglePropertiesFunc(FHandle, AIndex, @AProperty));
	end;

	procedure TLib3MFMeshObject.SetAllTriangleProperties(const APropertiesArray: ArrayOfLib3MFTriangleProperties);
	var
		PtrPropertiesArray: PLib3MFTriangleProperties;
		LenPropertiesArray: QWord;
	begin
		LenPropertiesArray := Length(APropertiesArray);
		if LenPropertiesArray > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenPropertiesArray > 0 then
			PtrPropertiesArray := @APropertiesArray[0]
		else
			PtrPropertiesArray := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_SetAllTrianglePropertiesFunc(FHandle, QWord(LenPropertiesArray), PtrPropertiesArray));
	end;

	procedure TLib3MFMeshObject.GetAllTriangleProperties(out APropertiesArray: ArrayOfLib3MFTriangleProperties);
	var
		countNeededPropertiesArray: QWord;
		countWrittenPropertiesArray: QWord;
	begin
		countNeededPropertiesArray:= 0;
		countWrittenPropertiesArray:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetAllTrianglePropertiesFunc(FHandle, 0, countNeededPropertiesArray, nil));
		SetLength(APropertiesArray, countNeededPropertiesArray);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_GetAllTrianglePropertiesFunc(FHandle, countNeededPropertiesArray, countWrittenPropertiesArray, @APropertiesArray[0]));
	end;

	procedure TLib3MFMeshObject.ClearAllProperties();
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_ClearAllPropertiesFunc(FHandle));
	end;

	procedure TLib3MFMeshObject.SetGeometry(const AVertices: ArrayOfLib3MFPosition; const AIndices: ArrayOfLib3MFTriangle);
	var
		PtrVertices: PLib3MFPosition;
		LenVertices: QWord;
		PtrIndices: PLib3MFTriangle;
		LenIndices: QWord;
	begin
		LenVertices := Length(AVertices);
		if LenVertices > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenVertices > 0 then
			PtrVertices := @AVertices[0]
		else
			PtrVertices := nil;
		
		LenIndices := Length(AIndices);
		if LenIndices > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenIndices > 0 then
			PtrIndices := @AIndices[0]
		else
			PtrIndices := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_SetGeometryFunc(FHandle, QWord(LenVertices), PtrVertices, QWord(LenIndices), PtrIndices));
	end;

	function TLib3MFMeshObject.IsManifoldAndOriented(): Boolean;
	var
		ResultIsManifoldAndOriented: Byte;
	begin
		ResultIsManifoldAndOriented := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_IsManifoldAndOrientedFunc(FHandle, ResultIsManifoldAndOriented));
		Result := (ResultIsManifoldAndOriented <> 0);
	end;

	function TLib3MFMeshObject.BeamLattice(): TLib3MFBeamLattice;
	var
		HTheBeamLattice: TLib3MFHandle;
	begin
		Result := nil;
		HTheBeamLattice := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMeshObject_BeamLatticeFunc(FHandle, HTheBeamLattice));
		if Assigned(HTheBeamLattice) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBeamLattice, TLib3MFBeamLattice>.Make(FWrapper, HTheBeamLattice);
	end;

(*************************************************************************************************************************
 Class implementation for BeamLattice
**************************************************************************************************************************)

	constructor TLib3MFBeamLattice.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFBeamLattice.Destroy;
	begin
		inherited;
	end;

	function TLib3MFBeamLattice.GetMinLength(): Double;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetMinLengthFunc(FHandle, Result));
	end;

	procedure TLib3MFBeamLattice.SetMinLength(const AMinLength: Double);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetMinLengthFunc(FHandle, AMinLength));
	end;

	procedure TLib3MFBeamLattice.GetClipping(out AClipMode: TLib3MFBeamLatticeClipMode; out AUniqueResourceID: Cardinal);
	var
		ResultClipMode: Integer;
	begin
		ResultClipMode := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetClippingFunc(FHandle, ResultClipMode, AUniqueResourceID));
		AClipMode := convertConstToBeamLatticeClipMode(ResultClipMode);
	end;

	procedure TLib3MFBeamLattice.SetClipping(const AClipMode: TLib3MFBeamLatticeClipMode; const AUniqueResourceID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetClippingFunc(FHandle, convertBeamLatticeClipModeToConst(AClipMode), AUniqueResourceID));
	end;

	function TLib3MFBeamLattice.GetRepresentation(out AUniqueResourceID: Cardinal): Boolean;
	var
		ResultHasRepresentation: Byte;
	begin
		ResultHasRepresentation := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetRepresentationFunc(FHandle, ResultHasRepresentation, AUniqueResourceID));
		Result := (ResultHasRepresentation <> 0);
	end;

	procedure TLib3MFBeamLattice.SetRepresentation(const AUniqueResourceID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetRepresentationFunc(FHandle, AUniqueResourceID));
	end;

	procedure TLib3MFBeamLattice.GetBallOptions(out ABallMode: TLib3MFBeamLatticeBallMode; out ABallRadius: Double);
	var
		ResultBallMode: Integer;
	begin
		ResultBallMode := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBallOptionsFunc(FHandle, ResultBallMode, ABallRadius));
		ABallMode := convertConstToBeamLatticeBallMode(ResultBallMode);
	end;

	procedure TLib3MFBeamLattice.SetBallOptions(const ABallMode: TLib3MFBeamLatticeBallMode; const ABallRadius: Double);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetBallOptionsFunc(FHandle, convertBeamLatticeBallModeToConst(ABallMode), ABallRadius));
	end;

	function TLib3MFBeamLattice.GetBeamCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBeamCountFunc(FHandle, Result));
	end;

	function TLib3MFBeamLattice.GetBeam(const AIndex: Cardinal): TLib3MFBeam;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBeamFunc(FHandle, AIndex, @Result));
	end;

	function TLib3MFBeamLattice.AddBeam(const ABeamInfo: TLib3MFBeam): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_AddBeamFunc(FHandle, @ABeamInfo, Result));
	end;

	procedure TLib3MFBeamLattice.SetBeam(const AIndex: Cardinal; const ABeamInfo: TLib3MFBeam);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetBeamFunc(FHandle, AIndex, @ABeamInfo));
	end;

	procedure TLib3MFBeamLattice.SetBeams(const ABeamInfo: ArrayOfLib3MFBeam);
	var
		PtrBeamInfo: PLib3MFBeam;
		LenBeamInfo: QWord;
	begin
		LenBeamInfo := Length(ABeamInfo);
		if LenBeamInfo > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenBeamInfo > 0 then
			PtrBeamInfo := @ABeamInfo[0]
		else
			PtrBeamInfo := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetBeamsFunc(FHandle, QWord(LenBeamInfo), PtrBeamInfo));
	end;

	procedure TLib3MFBeamLattice.GetBeams(out ABeamInfo: ArrayOfLib3MFBeam);
	var
		countNeededBeamInfo: QWord;
		countWrittenBeamInfo: QWord;
	begin
		countNeededBeamInfo:= 0;
		countWrittenBeamInfo:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBeamsFunc(FHandle, 0, countNeededBeamInfo, nil));
		SetLength(ABeamInfo, countNeededBeamInfo);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBeamsFunc(FHandle, countNeededBeamInfo, countWrittenBeamInfo, @ABeamInfo[0]));
	end;

	function TLib3MFBeamLattice.GetBallCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBallCountFunc(FHandle, Result));
	end;

	function TLib3MFBeamLattice.GetBall(const AIndex: Cardinal): TLib3MFBall;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBallFunc(FHandle, AIndex, @Result));
	end;

	function TLib3MFBeamLattice.AddBall(const ABallInfo: TLib3MFBall): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_AddBallFunc(FHandle, @ABallInfo, Result));
	end;

	procedure TLib3MFBeamLattice.SetBall(const AIndex: Cardinal; const ABallInfo: TLib3MFBall);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetBallFunc(FHandle, AIndex, @ABallInfo));
	end;

	procedure TLib3MFBeamLattice.SetBalls(const ABallInfo: ArrayOfLib3MFBall);
	var
		PtrBallInfo: PLib3MFBall;
		LenBallInfo: QWord;
	begin
		LenBallInfo := Length(ABallInfo);
		if LenBallInfo > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenBallInfo > 0 then
			PtrBallInfo := @ABallInfo[0]
		else
			PtrBallInfo := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_SetBallsFunc(FHandle, QWord(LenBallInfo), PtrBallInfo));
	end;

	procedure TLib3MFBeamLattice.GetBalls(out ABallInfo: ArrayOfLib3MFBall);
	var
		countNeededBallInfo: QWord;
		countWrittenBallInfo: QWord;
	begin
		countNeededBallInfo:= 0;
		countWrittenBallInfo:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBallsFunc(FHandle, 0, countNeededBallInfo, nil));
		SetLength(ABallInfo, countNeededBallInfo);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBallsFunc(FHandle, countNeededBallInfo, countWrittenBallInfo, @ABallInfo[0]));
	end;

	function TLib3MFBeamLattice.GetBeamSetCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBeamSetCountFunc(FHandle, Result));
	end;

	function TLib3MFBeamLattice.AddBeamSet(): TLib3MFBeamSet;
	var
		HBeamSet: TLib3MFHandle;
	begin
		Result := nil;
		HBeamSet := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_AddBeamSetFunc(FHandle, HBeamSet));
		if Assigned(HBeamSet) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBeamSet, TLib3MFBeamSet>.Make(FWrapper, HBeamSet);
	end;

	function TLib3MFBeamLattice.GetBeamSet(const AIndex: Cardinal): TLib3MFBeamSet;
	var
		HBeamSet: TLib3MFHandle;
	begin
		Result := nil;
		HBeamSet := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamLattice_GetBeamSetFunc(FHandle, AIndex, HBeamSet));
		if Assigned(HBeamSet) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBeamSet, TLib3MFBeamSet>.Make(FWrapper, HBeamSet);
	end;

(*************************************************************************************************************************
 Class implementation for Component
**************************************************************************************************************************)

	constructor TLib3MFComponent.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFComponent.Destroy;
	begin
		inherited;
	end;

	function TLib3MFComponent.GetObjectResource(): TLib3MFObject;
	var
		HObjectResource: TLib3MFHandle;
	begin
		Result := nil;
		HObjectResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_GetObjectResourceFunc(FHandle, HObjectResource));
		if Assigned(HObjectResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFObject, TLib3MFObject>.Make(FWrapper, HObjectResource);
	end;

	function TLib3MFComponent.GetObjectResourceID(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_GetObjectResourceIDFunc(FHandle, Result));
	end;

	function TLib3MFComponent.GetUUID(out AHasUUID: Boolean): String;
	var
		ResultHasUUID: Byte;
		bytesNeededUUID: Cardinal;
		bytesWrittenUUID: Cardinal;
		bufferUUID: array of Char;
	begin
		ResultHasUUID := 0;
		bytesNeededUUID:= 0;
		bytesWrittenUUID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_GetUUIDFunc(FHandle, ResultHasUUID, 0, bytesNeededUUID, nil));
		SetLength(bufferUUID, bytesNeededUUID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_GetUUIDFunc(FHandle, ResultHasUUID, bytesNeededUUID, bytesWrittenUUID, @bufferUUID[0]));
		AHasUUID := ResultHasUUID <> 0;
		Result := StrPas(@bufferUUID[0]);
	end;

	procedure TLib3MFComponent.SetUUID(const AUUID: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_SetUUIDFunc(FHandle, PAnsiChar(AUUID)));
	end;

	function TLib3MFComponent.HasTransform(): Boolean;
	var
		ResultHasTransform: Byte;
	begin
		ResultHasTransform := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_HasTransformFunc(FHandle, ResultHasTransform));
		Result := (ResultHasTransform <> 0);
	end;

	function TLib3MFComponent.GetTransform(): TLib3MFTransform;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_GetTransformFunc(FHandle, @Result));
	end;

	procedure TLib3MFComponent.SetTransform(const ATransform: TLib3MFTransform);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponent_SetTransformFunc(FHandle, @ATransform));
	end;

(*************************************************************************************************************************
 Class implementation for ComponentsObject
**************************************************************************************************************************)

	constructor TLib3MFComponentsObject.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFComponentsObject.Destroy;
	begin
		inherited;
	end;

	function TLib3MFComponentsObject.AddComponent(const AObjectResource: TLib3MFObject; const ATransform: TLib3MFTransform): TLib3MFComponent;
	var
		AObjectResourceHandle: TLib3MFHandle;
		HComponentInstance: TLib3MFHandle;
	begin
		if Assigned(AObjectResource) then
		AObjectResourceHandle := AObjectResource.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AObjectResource is a nil value.');
		Result := nil;
		HComponentInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponentsObject_AddComponentFunc(FHandle, AObjectResourceHandle, @ATransform, HComponentInstance));
		if Assigned(HComponentInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFComponent, TLib3MFComponent>.Make(FWrapper, HComponentInstance);
	end;

	function TLib3MFComponentsObject.GetComponent(const AIndex: Cardinal): TLib3MFComponent;
	var
		HComponentInstance: TLib3MFHandle;
	begin
		Result := nil;
		HComponentInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponentsObject_GetComponentFunc(FHandle, AIndex, HComponentInstance));
		if Assigned(HComponentInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFComponent, TLib3MFComponent>.Make(FWrapper, HComponentInstance);
	end;

	function TLib3MFComponentsObject.GetComponentCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFComponentsObject_GetComponentCountFunc(FHandle, Result));
	end;

(*************************************************************************************************************************
 Class implementation for BeamSet
**************************************************************************************************************************)

	constructor TLib3MFBeamSet.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFBeamSet.Destroy;
	begin
		inherited;
	end;

	procedure TLib3MFBeamSet.SetName(const AName: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_SetNameFunc(FHandle, PAnsiChar(AName)));
	end;

	function TLib3MFBeamSet.GetName(): String;
	var
		bytesNeededName: Cardinal;
		bytesWrittenName: Cardinal;
		bufferName: array of Char;
	begin
		bytesNeededName:= 0;
		bytesWrittenName:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetNameFunc(FHandle, 0, bytesNeededName, nil));
		SetLength(bufferName, bytesNeededName);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetNameFunc(FHandle, bytesNeededName, bytesWrittenName, @bufferName[0]));
		Result := StrPas(@bufferName[0]);
	end;

	procedure TLib3MFBeamSet.SetIdentifier(const AIdentifier: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_SetIdentifierFunc(FHandle, PAnsiChar(AIdentifier)));
	end;

	function TLib3MFBeamSet.GetIdentifier(): String;
	var
		bytesNeededIdentifier: Cardinal;
		bytesWrittenIdentifier: Cardinal;
		bufferIdentifier: array of Char;
	begin
		bytesNeededIdentifier:= 0;
		bytesWrittenIdentifier:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetIdentifierFunc(FHandle, 0, bytesNeededIdentifier, nil));
		SetLength(bufferIdentifier, bytesNeededIdentifier);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetIdentifierFunc(FHandle, bytesNeededIdentifier, bytesWrittenIdentifier, @bufferIdentifier[0]));
		Result := StrPas(@bufferIdentifier[0]);
	end;

	function TLib3MFBeamSet.GetReferenceCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetReferenceCountFunc(FHandle, Result));
	end;

	procedure TLib3MFBeamSet.SetReferences(const AReferences: TCardinalDynArray);
	var
		PtrReferences: PCardinal;
		LenReferences: QWord;
	begin
		LenReferences := Length(AReferences);
		if LenReferences > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenReferences > 0 then
			PtrReferences := @AReferences[0]
		else
			PtrReferences := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_SetReferencesFunc(FHandle, QWord(LenReferences), PtrReferences));
	end;

	procedure TLib3MFBeamSet.GetReferences(out AReferences: TCardinalDynArray);
	var
		countNeededReferences: QWord;
		countWrittenReferences: QWord;
	begin
		countNeededReferences:= 0;
		countWrittenReferences:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetReferencesFunc(FHandle, 0, countNeededReferences, nil));
		SetLength(AReferences, countNeededReferences);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetReferencesFunc(FHandle, countNeededReferences, countWrittenReferences, @AReferences[0]));
	end;

	function TLib3MFBeamSet.GetBallReferenceCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetBallReferenceCountFunc(FHandle, Result));
	end;

	procedure TLib3MFBeamSet.SetBallReferences(const ABallReferences: TCardinalDynArray);
	var
		PtrBallReferences: PCardinal;
		LenBallReferences: QWord;
	begin
		LenBallReferences := Length(ABallReferences);
		if LenBallReferences > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenBallReferences > 0 then
			PtrBallReferences := @ABallReferences[0]
		else
			PtrBallReferences := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_SetBallReferencesFunc(FHandle, QWord(LenBallReferences), PtrBallReferences));
	end;

	procedure TLib3MFBeamSet.GetBallReferences(out ABallReferences: TCardinalDynArray);
	var
		countNeededBallReferences: QWord;
		countWrittenBallReferences: QWord;
	begin
		countNeededBallReferences:= 0;
		countWrittenBallReferences:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetBallReferencesFunc(FHandle, 0, countNeededBallReferences, nil));
		SetLength(ABallReferences, countNeededBallReferences);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBeamSet_GetBallReferencesFunc(FHandle, countNeededBallReferences, countWrittenBallReferences, @ABallReferences[0]));
	end;

(*************************************************************************************************************************
 Class implementation for BaseMaterialGroup
**************************************************************************************************************************)

	constructor TLib3MFBaseMaterialGroup.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFBaseMaterialGroup.Destroy;
	begin
		inherited;
	end;

	function TLib3MFBaseMaterialGroup.GetCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_GetCountFunc(FHandle, Result));
	end;

	procedure TLib3MFBaseMaterialGroup.GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
	var
		countNeededPropertyIDs: QWord;
		countWrittenPropertyIDs: QWord;
	begin
		countNeededPropertyIDs:= 0;
		countWrittenPropertyIDs:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_GetAllPropertyIDsFunc(FHandle, 0, countNeededPropertyIDs, nil));
		SetLength(APropertyIDs, countNeededPropertyIDs);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_GetAllPropertyIDsFunc(FHandle, countNeededPropertyIDs, countWrittenPropertyIDs, @APropertyIDs[0]));
	end;

	function TLib3MFBaseMaterialGroup.AddMaterial(const AName: String; const ADisplayColor: TLib3MFColor): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_AddMaterialFunc(FHandle, PAnsiChar(AName), @ADisplayColor, Result));
	end;

	procedure TLib3MFBaseMaterialGroup.RemoveMaterial(const APropertyID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_RemoveMaterialFunc(FHandle, APropertyID));
	end;

	function TLib3MFBaseMaterialGroup.GetName(const APropertyID: Cardinal): String;
	var
		bytesNeededName: Cardinal;
		bytesWrittenName: Cardinal;
		bufferName: array of Char;
	begin
		bytesNeededName:= 0;
		bytesWrittenName:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_GetNameFunc(FHandle, APropertyID, 0, bytesNeededName, nil));
		SetLength(bufferName, bytesNeededName);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_GetNameFunc(FHandle, APropertyID, bytesNeededName, bytesWrittenName, @bufferName[0]));
		Result := StrPas(@bufferName[0]);
	end;

	procedure TLib3MFBaseMaterialGroup.SetName(const APropertyID: Cardinal; const AName: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_SetNameFunc(FHandle, APropertyID, PAnsiChar(AName)));
	end;

	procedure TLib3MFBaseMaterialGroup.SetDisplayColor(const APropertyID: Cardinal; const ATheColor: TLib3MFColor);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_SetDisplayColorFunc(FHandle, APropertyID, @ATheColor));
	end;

	function TLib3MFBaseMaterialGroup.GetDisplayColor(const APropertyID: Cardinal): TLib3MFColor;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBaseMaterialGroup_GetDisplayColorFunc(FHandle, APropertyID, @Result));
	end;

(*************************************************************************************************************************
 Class implementation for ColorGroup
**************************************************************************************************************************)

	constructor TLib3MFColorGroup.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFColorGroup.Destroy;
	begin
		inherited;
	end;

	function TLib3MFColorGroup.GetCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroup_GetCountFunc(FHandle, Result));
	end;

	procedure TLib3MFColorGroup.GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
	var
		countNeededPropertyIDs: QWord;
		countWrittenPropertyIDs: QWord;
	begin
		countNeededPropertyIDs:= 0;
		countWrittenPropertyIDs:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroup_GetAllPropertyIDsFunc(FHandle, 0, countNeededPropertyIDs, nil));
		SetLength(APropertyIDs, countNeededPropertyIDs);
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroup_GetAllPropertyIDsFunc(FHandle, countNeededPropertyIDs, countWrittenPropertyIDs, @APropertyIDs[0]));
	end;

	function TLib3MFColorGroup.AddColor(const ATheColor: TLib3MFColor): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroup_AddColorFunc(FHandle, @ATheColor, Result));
	end;

	procedure TLib3MFColorGroup.RemoveColor(const APropertyID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroup_RemoveColorFunc(FHandle, APropertyID));
	end;

	procedure TLib3MFColorGroup.SetColor(const APropertyID: Cardinal; const ATheColor: TLib3MFColor);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroup_SetColorFunc(FHandle, APropertyID, @ATheColor));
	end;

	function TLib3MFColorGroup.GetColor(const APropertyID: Cardinal): TLib3MFColor;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFColorGroup_GetColorFunc(FHandle, APropertyID, @Result));
	end;

(*************************************************************************************************************************
 Class implementation for Texture2DGroup
**************************************************************************************************************************)

	constructor TLib3MFTexture2DGroup.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFTexture2DGroup.Destroy;
	begin
		inherited;
	end;

	function TLib3MFTexture2DGroup.GetCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroup_GetCountFunc(FHandle, Result));
	end;

	procedure TLib3MFTexture2DGroup.GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
	var
		countNeededPropertyIDs: QWord;
		countWrittenPropertyIDs: QWord;
	begin
		countNeededPropertyIDs:= 0;
		countWrittenPropertyIDs:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroup_GetAllPropertyIDsFunc(FHandle, 0, countNeededPropertyIDs, nil));
		SetLength(APropertyIDs, countNeededPropertyIDs);
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroup_GetAllPropertyIDsFunc(FHandle, countNeededPropertyIDs, countWrittenPropertyIDs, @APropertyIDs[0]));
	end;

	function TLib3MFTexture2DGroup.AddTex2Coord(const AUVCoordinate: TLib3MFTex2Coord): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroup_AddTex2CoordFunc(FHandle, @AUVCoordinate, Result));
	end;

	function TLib3MFTexture2DGroup.GetTex2Coord(const APropertyID: Cardinal): TLib3MFTex2Coord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroup_GetTex2CoordFunc(FHandle, APropertyID, @Result));
	end;

	procedure TLib3MFTexture2DGroup.RemoveTex2Coord(const APropertyID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroup_RemoveTex2CoordFunc(FHandle, APropertyID));
	end;

	function TLib3MFTexture2DGroup.GetTexture2D(): TLib3MFTexture2D;
	var
		HTexture2DInstance: TLib3MFHandle;
	begin
		Result := nil;
		HTexture2DInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2DGroup_GetTexture2DFunc(FHandle, HTexture2DInstance));
		if Assigned(HTexture2DInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2D, TLib3MFTexture2D>.Make(FWrapper, HTexture2DInstance);
	end;

(*************************************************************************************************************************
 Class implementation for CompositeMaterials
**************************************************************************************************************************)

	constructor TLib3MFCompositeMaterials.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFCompositeMaterials.Destroy;
	begin
		inherited;
	end;

	function TLib3MFCompositeMaterials.GetCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_GetCountFunc(FHandle, Result));
	end;

	procedure TLib3MFCompositeMaterials.GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
	var
		countNeededPropertyIDs: QWord;
		countWrittenPropertyIDs: QWord;
	begin
		countNeededPropertyIDs:= 0;
		countWrittenPropertyIDs:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_GetAllPropertyIDsFunc(FHandle, 0, countNeededPropertyIDs, nil));
		SetLength(APropertyIDs, countNeededPropertyIDs);
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_GetAllPropertyIDsFunc(FHandle, countNeededPropertyIDs, countWrittenPropertyIDs, @APropertyIDs[0]));
	end;

	function TLib3MFCompositeMaterials.GetBaseMaterialGroup(): TLib3MFBaseMaterialGroup;
	var
		HBaseMaterialGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HBaseMaterialGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_GetBaseMaterialGroupFunc(FHandle, HBaseMaterialGroupInstance));
		if Assigned(HBaseMaterialGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBaseMaterialGroup, TLib3MFBaseMaterialGroup>.Make(FWrapper, HBaseMaterialGroupInstance);
	end;

	function TLib3MFCompositeMaterials.AddComposite(const AComposite: ArrayOfLib3MFCompositeConstituent): Cardinal;
	var
		PtrComposite: PLib3MFCompositeConstituent;
		LenComposite: QWord;
	begin
		LenComposite := Length(AComposite);
		if LenComposite > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenComposite > 0 then
			PtrComposite := @AComposite[0]
		else
			PtrComposite := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_AddCompositeFunc(FHandle, QWord(LenComposite), PtrComposite, Result));
	end;

	procedure TLib3MFCompositeMaterials.RemoveComposite(const APropertyID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_RemoveCompositeFunc(FHandle, APropertyID));
	end;

	procedure TLib3MFCompositeMaterials.GetComposite(const APropertyID: Cardinal; out AComposite: ArrayOfLib3MFCompositeConstituent);
	var
		countNeededComposite: QWord;
		countWrittenComposite: QWord;
	begin
		countNeededComposite:= 0;
		countWrittenComposite:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_GetCompositeFunc(FHandle, APropertyID, 0, countNeededComposite, nil));
		SetLength(AComposite, countNeededComposite);
		FWrapper.CheckError(Self, FWrapper.Lib3MFCompositeMaterials_GetCompositeFunc(FHandle, APropertyID, countNeededComposite, countWrittenComposite, @AComposite[0]));
	end;

(*************************************************************************************************************************
 Class implementation for MultiPropertyGroup
**************************************************************************************************************************)

	constructor TLib3MFMultiPropertyGroup.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFMultiPropertyGroup.Destroy;
	begin
		inherited;
	end;

	function TLib3MFMultiPropertyGroup.GetCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_GetCountFunc(FHandle, Result));
	end;

	procedure TLib3MFMultiPropertyGroup.GetAllPropertyIDs(out APropertyIDs: TCardinalDynArray);
	var
		countNeededPropertyIDs: QWord;
		countWrittenPropertyIDs: QWord;
	begin
		countNeededPropertyIDs:= 0;
		countWrittenPropertyIDs:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_GetAllPropertyIDsFunc(FHandle, 0, countNeededPropertyIDs, nil));
		SetLength(APropertyIDs, countNeededPropertyIDs);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_GetAllPropertyIDsFunc(FHandle, countNeededPropertyIDs, countWrittenPropertyIDs, @APropertyIDs[0]));
	end;

	function TLib3MFMultiPropertyGroup.AddMultiProperty(const APropertyIDs: TCardinalDynArray): Cardinal;
	var
		PtrPropertyIDs: PCardinal;
		LenPropertyIDs: QWord;
	begin
		LenPropertyIDs := Length(APropertyIDs);
		if LenPropertyIDs > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenPropertyIDs > 0 then
			PtrPropertyIDs := @APropertyIDs[0]
		else
			PtrPropertyIDs := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_AddMultiPropertyFunc(FHandle, QWord(LenPropertyIDs), PtrPropertyIDs, Result));
	end;

	procedure TLib3MFMultiPropertyGroup.SetMultiProperty(const APropertyID: Cardinal; const APropertyIDs: TCardinalDynArray);
	var
		PtrPropertyIDs: PCardinal;
		LenPropertyIDs: QWord;
	begin
		LenPropertyIDs := Length(APropertyIDs);
		if LenPropertyIDs > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenPropertyIDs > 0 then
			PtrPropertyIDs := @APropertyIDs[0]
		else
			PtrPropertyIDs := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_SetMultiPropertyFunc(FHandle, APropertyID, QWord(LenPropertyIDs), PtrPropertyIDs));
	end;

	procedure TLib3MFMultiPropertyGroup.GetMultiProperty(const APropertyID: Cardinal; out APropertyIDs: TCardinalDynArray);
	var
		countNeededPropertyIDs: QWord;
		countWrittenPropertyIDs: QWord;
	begin
		countNeededPropertyIDs:= 0;
		countWrittenPropertyIDs:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_GetMultiPropertyFunc(FHandle, APropertyID, 0, countNeededPropertyIDs, nil));
		SetLength(APropertyIDs, countNeededPropertyIDs);
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_GetMultiPropertyFunc(FHandle, APropertyID, countNeededPropertyIDs, countWrittenPropertyIDs, @APropertyIDs[0]));
	end;

	procedure TLib3MFMultiPropertyGroup.RemoveMultiProperty(const APropertyID: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_RemoveMultiPropertyFunc(FHandle, APropertyID));
	end;

	function TLib3MFMultiPropertyGroup.GetLayerCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_GetLayerCountFunc(FHandle, Result));
	end;

	function TLib3MFMultiPropertyGroup.AddLayer(const ATheLayer: TLib3MFMultiPropertyLayer): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_AddLayerFunc(FHandle, @ATheLayer, Result));
	end;

	function TLib3MFMultiPropertyGroup.GetLayer(const ALayerIndex: Cardinal): TLib3MFMultiPropertyLayer;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_GetLayerFunc(FHandle, ALayerIndex, @Result));
	end;

	procedure TLib3MFMultiPropertyGroup.RemoveLayer(const ALayerIndex: Cardinal);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFMultiPropertyGroup_RemoveLayerFunc(FHandle, ALayerIndex));
	end;

(*************************************************************************************************************************
 Class implementation for Attachment
**************************************************************************************************************************)

	constructor TLib3MFAttachment.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFAttachment.Destroy;
	begin
		inherited;
	end;

	function TLib3MFAttachment.GetPath(): String;
	var
		bytesNeededPath: Cardinal;
		bytesWrittenPath: Cardinal;
		bufferPath: array of Char;
	begin
		bytesNeededPath:= 0;
		bytesWrittenPath:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_GetPathFunc(FHandle, 0, bytesNeededPath, nil));
		SetLength(bufferPath, bytesNeededPath);
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_GetPathFunc(FHandle, bytesNeededPath, bytesWrittenPath, @bufferPath[0]));
		Result := StrPas(@bufferPath[0]);
	end;

	procedure TLib3MFAttachment.SetPath(const APath: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_SetPathFunc(FHandle, PAnsiChar(APath)));
	end;

	function TLib3MFAttachment.PackagePart(): TLib3MFPackagePart;
	var
		HPackagePart: TLib3MFHandle;
	begin
		Result := nil;
		HPackagePart := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_PackagePartFunc(FHandle, HPackagePart));
		if Assigned(HPackagePart) then
			Result := TLib3MFPolymorphicFactory<TLib3MFPackagePart, TLib3MFPackagePart>.Make(FWrapper, HPackagePart);
	end;

	function TLib3MFAttachment.GetRelationShipType(): String;
	var
		bytesNeededPath: Cardinal;
		bytesWrittenPath: Cardinal;
		bufferPath: array of Char;
	begin
		bytesNeededPath:= 0;
		bytesWrittenPath:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_GetRelationShipTypeFunc(FHandle, 0, bytesNeededPath, nil));
		SetLength(bufferPath, bytesNeededPath);
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_GetRelationShipTypeFunc(FHandle, bytesNeededPath, bytesWrittenPath, @bufferPath[0]));
		Result := StrPas(@bufferPath[0]);
	end;

	procedure TLib3MFAttachment.SetRelationShipType(const APath: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_SetRelationShipTypeFunc(FHandle, PAnsiChar(APath)));
	end;

	procedure TLib3MFAttachment.WriteToFile(const AFileName: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_WriteToFileFunc(FHandle, PAnsiChar(AFileName)));
	end;

	procedure TLib3MFAttachment.ReadFromFile(const AFileName: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_ReadFromFileFunc(FHandle, PAnsiChar(AFileName)));
	end;

	procedure TLib3MFAttachment.ReadFromCallback(const ATheReadCallback: PLib3MF_ReadCallback; const AStreamSize: QWord; const ATheSeekCallback: PLib3MF_SeekCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheReadCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheReadCallback is a nil value.');
		if not Assigned(ATheSeekCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheSeekCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_ReadFromCallbackFunc(FHandle, ATheReadCallback, AStreamSize, ATheSeekCallback, AUserData));
	end;

	function TLib3MFAttachment.GetStreamSize(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_GetStreamSizeFunc(FHandle, Result));
	end;

	procedure TLib3MFAttachment.WriteToBuffer(out ABuffer: TByteDynArray);
	var
		countNeededBuffer: QWord;
		countWrittenBuffer: QWord;
	begin
		countNeededBuffer:= 0;
		countWrittenBuffer:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_WriteToBufferFunc(FHandle, 0, countNeededBuffer, nil));
		SetLength(ABuffer, countNeededBuffer);
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_WriteToBufferFunc(FHandle, countNeededBuffer, countWrittenBuffer, @ABuffer[0]));
	end;

	procedure TLib3MFAttachment.ReadFromBuffer(const ABuffer: TByteDynArray);
	var
		PtrBuffer: PByte;
		LenBuffer: QWord;
	begin
		LenBuffer := Length(ABuffer);
		if LenBuffer > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenBuffer > 0 then
			PtrBuffer := @ABuffer[0]
		else
			PtrBuffer := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFAttachment_ReadFromBufferFunc(FHandle, QWord(LenBuffer), PtrBuffer));
	end;

(*************************************************************************************************************************
 Class implementation for Texture2D
**************************************************************************************************************************)

	constructor TLib3MFTexture2D.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFTexture2D.Destroy;
	begin
		inherited;
	end;

	function TLib3MFTexture2D.GetAttachment(): TLib3MFAttachment;
	var
		HAttachment: TLib3MFHandle;
	begin
		Result := nil;
		HAttachment := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_GetAttachmentFunc(FHandle, HAttachment));
		if Assigned(HAttachment) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAttachment, TLib3MFAttachment>.Make(FWrapper, HAttachment);
	end;

	procedure TLib3MFTexture2D.SetAttachment(const AAttachment: TLib3MFAttachment);
	var
		AAttachmentHandle: TLib3MFHandle;
	begin
		if Assigned(AAttachment) then
		AAttachmentHandle := AAttachment.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AAttachment is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_SetAttachmentFunc(FHandle, AAttachmentHandle));
	end;

	function TLib3MFTexture2D.GetContentType(): TLib3MFTextureType;
	var
		ResultContentType: Integer;
	begin
		ResultContentType := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_GetContentTypeFunc(FHandle, ResultContentType));
		Result := convertConstToTextureType(ResultContentType);
	end;

	procedure TLib3MFTexture2D.SetContentType(const AContentType: TLib3MFTextureType);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_SetContentTypeFunc(FHandle, convertTextureTypeToConst(AContentType)));
	end;

	procedure TLib3MFTexture2D.GetTileStyleUV(out ATileStyleU: TLib3MFTextureTileStyle; out ATileStyleV: TLib3MFTextureTileStyle);
	var
		ResultTileStyleU: Integer;
		ResultTileStyleV: Integer;
	begin
		ResultTileStyleU := 0;
		ResultTileStyleV := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_GetTileStyleUVFunc(FHandle, ResultTileStyleU, ResultTileStyleV));
		ATileStyleU := convertConstToTextureTileStyle(ResultTileStyleU);
		ATileStyleV := convertConstToTextureTileStyle(ResultTileStyleV);
	end;

	procedure TLib3MFTexture2D.SetTileStyleUV(const ATileStyleU: TLib3MFTextureTileStyle; const ATileStyleV: TLib3MFTextureTileStyle);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_SetTileStyleUVFunc(FHandle, convertTextureTileStyleToConst(ATileStyleU), convertTextureTileStyleToConst(ATileStyleV)));
	end;

	function TLib3MFTexture2D.GetFilter(): TLib3MFTextureFilter;
	var
		ResultFilter: Integer;
	begin
		ResultFilter := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_GetFilterFunc(FHandle, ResultFilter));
		Result := convertConstToTextureFilter(ResultFilter);
	end;

	procedure TLib3MFTexture2D.SetFilter(const AFilter: TLib3MFTextureFilter);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFTexture2D_SetFilterFunc(FHandle, convertTextureFilterToConst(AFilter)));
	end;

(*************************************************************************************************************************
 Class implementation for BuildItem
**************************************************************************************************************************)

	constructor TLib3MFBuildItem.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFBuildItem.Destroy;
	begin
		inherited;
	end;

	function TLib3MFBuildItem.GetObjectResource(): TLib3MFObject;
	var
		HObjectResource: TLib3MFHandle;
	begin
		Result := nil;
		HObjectResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetObjectResourceFunc(FHandle, HObjectResource));
		if Assigned(HObjectResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFObject, TLib3MFObject>.Make(FWrapper, HObjectResource);
	end;

	function TLib3MFBuildItem.GetUUID(out AHasUUID: Boolean): String;
	var
		ResultHasUUID: Byte;
		bytesNeededUUID: Cardinal;
		bytesWrittenUUID: Cardinal;
		bufferUUID: array of Char;
	begin
		ResultHasUUID := 0;
		bytesNeededUUID:= 0;
		bytesWrittenUUID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetUUIDFunc(FHandle, ResultHasUUID, 0, bytesNeededUUID, nil));
		SetLength(bufferUUID, bytesNeededUUID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetUUIDFunc(FHandle, ResultHasUUID, bytesNeededUUID, bytesWrittenUUID, @bufferUUID[0]));
		AHasUUID := ResultHasUUID <> 0;
		Result := StrPas(@bufferUUID[0]);
	end;

	procedure TLib3MFBuildItem.SetUUID(const AUUID: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_SetUUIDFunc(FHandle, PAnsiChar(AUUID)));
	end;

	function TLib3MFBuildItem.GetObjectResourceID(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetObjectResourceIDFunc(FHandle, Result));
	end;

	function TLib3MFBuildItem.HasObjectTransform(): Boolean;
	var
		ResultHasTransform: Byte;
	begin
		ResultHasTransform := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_HasObjectTransformFunc(FHandle, ResultHasTransform));
		Result := (ResultHasTransform <> 0);
	end;

	function TLib3MFBuildItem.GetObjectTransform(): TLib3MFTransform;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetObjectTransformFunc(FHandle, @Result));
	end;

	procedure TLib3MFBuildItem.SetObjectTransform(const ATransform: TLib3MFTransform);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_SetObjectTransformFunc(FHandle, @ATransform));
	end;

	function TLib3MFBuildItem.GetPartNumber(): String;
	var
		bytesNeededPartNumber: Cardinal;
		bytesWrittenPartNumber: Cardinal;
		bufferPartNumber: array of Char;
	begin
		bytesNeededPartNumber:= 0;
		bytesWrittenPartNumber:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetPartNumberFunc(FHandle, 0, bytesNeededPartNumber, nil));
		SetLength(bufferPartNumber, bytesNeededPartNumber);
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetPartNumberFunc(FHandle, bytesNeededPartNumber, bytesWrittenPartNumber, @bufferPartNumber[0]));
		Result := StrPas(@bufferPartNumber[0]);
	end;

	procedure TLib3MFBuildItem.SetPartNumber(const ASetPartnumber: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_SetPartNumberFunc(FHandle, PAnsiChar(ASetPartnumber)));
	end;

	function TLib3MFBuildItem.GetMetaDataGroup(): TLib3MFMetaDataGroup;
	var
		HMetaDataGroup: TLib3MFHandle;
	begin
		Result := nil;
		HMetaDataGroup := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetMetaDataGroupFunc(FHandle, HMetaDataGroup));
		if Assigned(HMetaDataGroup) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMetaDataGroup, TLib3MFMetaDataGroup>.Make(FWrapper, HMetaDataGroup);
	end;

	function TLib3MFBuildItem.GetOutbox(): TLib3MFBox;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItem_GetOutboxFunc(FHandle, @Result));
	end;

(*************************************************************************************************************************
 Class implementation for BuildItemIterator
**************************************************************************************************************************)

	constructor TLib3MFBuildItemIterator.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFBuildItemIterator.Destroy;
	begin
		inherited;
	end;

	function TLib3MFBuildItemIterator.MoveNext(): Boolean;
	var
		ResultHasNext: Byte;
	begin
		ResultHasNext := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItemIterator_MoveNextFunc(FHandle, ResultHasNext));
		Result := (ResultHasNext <> 0);
	end;

	function TLib3MFBuildItemIterator.MovePrevious(): Boolean;
	var
		ResultHasPrevious: Byte;
	begin
		ResultHasPrevious := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItemIterator_MovePreviousFunc(FHandle, ResultHasPrevious));
		Result := (ResultHasPrevious <> 0);
	end;

	function TLib3MFBuildItemIterator.GetCurrent(): TLib3MFBuildItem;
	var
		HBuildItem: TLib3MFHandle;
	begin
		Result := nil;
		HBuildItem := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItemIterator_GetCurrentFunc(FHandle, HBuildItem));
		if Assigned(HBuildItem) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBuildItem, TLib3MFBuildItem>.Make(FWrapper, HBuildItem);
	end;

	function TLib3MFBuildItemIterator.Clone(): TLib3MFBuildItemIterator;
	var
		HOutBuildItemIterator: TLib3MFHandle;
	begin
		Result := nil;
		HOutBuildItemIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItemIterator_CloneFunc(FHandle, HOutBuildItemIterator));
		if Assigned(HOutBuildItemIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBuildItemIterator, TLib3MFBuildItemIterator>.Make(FWrapper, HOutBuildItemIterator);
	end;

	function TLib3MFBuildItemIterator.Count(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFBuildItemIterator_CountFunc(FHandle, Result));
	end;

(*************************************************************************************************************************
 Class implementation for Slice
**************************************************************************************************************************)

	constructor TLib3MFSlice.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFSlice.Destroy;
	begin
		inherited;
	end;

	procedure TLib3MFSlice.SetVertices(const AVertices: ArrayOfLib3MFPosition2D);
	var
		PtrVertices: PLib3MFPosition2D;
		LenVertices: QWord;
	begin
		LenVertices := Length(AVertices);
		if LenVertices > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenVertices > 0 then
			PtrVertices := @AVertices[0]
		else
			PtrVertices := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_SetVerticesFunc(FHandle, QWord(LenVertices), PtrVertices));
	end;

	procedure TLib3MFSlice.GetVertices(out AVertices: ArrayOfLib3MFPosition2D);
	var
		countNeededVertices: QWord;
		countWrittenVertices: QWord;
	begin
		countNeededVertices:= 0;
		countWrittenVertices:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetVerticesFunc(FHandle, 0, countNeededVertices, nil));
		SetLength(AVertices, countNeededVertices);
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetVerticesFunc(FHandle, countNeededVertices, countWrittenVertices, @AVertices[0]));
	end;

	function TLib3MFSlice.GetVertexCount(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetVertexCountFunc(FHandle, Result));
	end;

	function TLib3MFSlice.AddPolygon(const AIndices: TCardinalDynArray): QWord;
	var
		PtrIndices: PCardinal;
		LenIndices: QWord;
	begin
		LenIndices := Length(AIndices);
		if LenIndices > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenIndices > 0 then
			PtrIndices := @AIndices[0]
		else
			PtrIndices := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_AddPolygonFunc(FHandle, QWord(LenIndices), PtrIndices, Result));
	end;

	function TLib3MFSlice.GetPolygonCount(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetPolygonCountFunc(FHandle, Result));
	end;

	procedure TLib3MFSlice.SetPolygonIndices(const AIndex: QWord; const AIndices: TCardinalDynArray);
	var
		PtrIndices: PCardinal;
		LenIndices: QWord;
	begin
		LenIndices := Length(AIndices);
		if LenIndices > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenIndices > 0 then
			PtrIndices := @AIndices[0]
		else
			PtrIndices := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_SetPolygonIndicesFunc(FHandle, AIndex, QWord(LenIndices), PtrIndices));
	end;

	procedure TLib3MFSlice.GetPolygonIndices(const AIndex: QWord; out AIndices: TCardinalDynArray);
	var
		countNeededIndices: QWord;
		countWrittenIndices: QWord;
	begin
		countNeededIndices:= 0;
		countWrittenIndices:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetPolygonIndicesFunc(FHandle, AIndex, 0, countNeededIndices, nil));
		SetLength(AIndices, countNeededIndices);
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetPolygonIndicesFunc(FHandle, AIndex, countNeededIndices, countWrittenIndices, @AIndices[0]));
	end;

	function TLib3MFSlice.GetPolygonIndexCount(const AIndex: QWord): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetPolygonIndexCountFunc(FHandle, AIndex, Result));
	end;

	function TLib3MFSlice.GetZTop(): Double;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSlice_GetZTopFunc(FHandle, Result));
	end;

(*************************************************************************************************************************
 Class implementation for SliceStack
**************************************************************************************************************************)

	constructor TLib3MFSliceStack.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFSliceStack.Destroy;
	begin
		inherited;
	end;

	function TLib3MFSliceStack.GetBottomZ(): Double;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_GetBottomZFunc(FHandle, Result));
	end;

	function TLib3MFSliceStack.GetSliceCount(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_GetSliceCountFunc(FHandle, Result));
	end;

	function TLib3MFSliceStack.GetSlice(const ASliceIndex: QWord): TLib3MFSlice;
	var
		HTheSlice: TLib3MFHandle;
	begin
		Result := nil;
		HTheSlice := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_GetSliceFunc(FHandle, ASliceIndex, HTheSlice));
		if Assigned(HTheSlice) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSlice, TLib3MFSlice>.Make(FWrapper, HTheSlice);
	end;

	function TLib3MFSliceStack.AddSlice(const AZTop: Double): TLib3MFSlice;
	var
		HTheSlice: TLib3MFHandle;
	begin
		Result := nil;
		HTheSlice := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_AddSliceFunc(FHandle, AZTop, HTheSlice));
		if Assigned(HTheSlice) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSlice, TLib3MFSlice>.Make(FWrapper, HTheSlice);
	end;

	function TLib3MFSliceStack.GetSliceRefCount(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_GetSliceRefCountFunc(FHandle, Result));
	end;

	procedure TLib3MFSliceStack.AddSliceStackReference(const ATheSliceStack: TLib3MFSliceStack);
	var
		ATheSliceStackHandle: TLib3MFHandle;
	begin
		if Assigned(ATheSliceStack) then
		ATheSliceStackHandle := ATheSliceStack.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheSliceStack is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_AddSliceStackReferenceFunc(FHandle, ATheSliceStackHandle));
	end;

	function TLib3MFSliceStack.GetSliceStackReference(const ASliceRefIndex: QWord): TLib3MFSliceStack;
	var
		HTheSliceStack: TLib3MFHandle;
	begin
		Result := nil;
		HTheSliceStack := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_GetSliceStackReferenceFunc(FHandle, ASliceRefIndex, HTheSliceStack));
		if Assigned(HTheSliceStack) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSliceStack, TLib3MFSliceStack>.Make(FWrapper, HTheSliceStack);
	end;

	procedure TLib3MFSliceStack.CollapseSliceReferences();
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_CollapseSliceReferencesFunc(FHandle));
	end;

	procedure TLib3MFSliceStack.SetOwnPath(const APath: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_SetOwnPathFunc(FHandle, PAnsiChar(APath)));
	end;

	function TLib3MFSliceStack.GetOwnPath(): String;
	var
		bytesNeededPath: Cardinal;
		bytesWrittenPath: Cardinal;
		bufferPath: array of Char;
	begin
		bytesNeededPath:= 0;
		bytesWrittenPath:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_GetOwnPathFunc(FHandle, 0, bytesNeededPath, nil));
		SetLength(bufferPath, bytesNeededPath);
		FWrapper.CheckError(Self, FWrapper.Lib3MFSliceStack_GetOwnPathFunc(FHandle, bytesNeededPath, bytesWrittenPath, @bufferPath[0]));
		Result := StrPas(@bufferPath[0]);
	end;

(*************************************************************************************************************************
 Class implementation for Consumer
**************************************************************************************************************************)

	constructor TLib3MFConsumer.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFConsumer.Destroy;
	begin
		inherited;
	end;

	function TLib3MFConsumer.GetConsumerID(): String;
	var
		bytesNeededConsumerID: Cardinal;
		bytesWrittenConsumerID: Cardinal;
		bufferConsumerID: array of Char;
	begin
		bytesNeededConsumerID:= 0;
		bytesWrittenConsumerID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFConsumer_GetConsumerIDFunc(FHandle, 0, bytesNeededConsumerID, nil));
		SetLength(bufferConsumerID, bytesNeededConsumerID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFConsumer_GetConsumerIDFunc(FHandle, bytesNeededConsumerID, bytesWrittenConsumerID, @bufferConsumerID[0]));
		Result := StrPas(@bufferConsumerID[0]);
	end;

	function TLib3MFConsumer.GetKeyID(): String;
	var
		bytesNeededKeyID: Cardinal;
		bytesWrittenKeyID: Cardinal;
		bufferKeyID: array of Char;
	begin
		bytesNeededKeyID:= 0;
		bytesWrittenKeyID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFConsumer_GetKeyIDFunc(FHandle, 0, bytesNeededKeyID, nil));
		SetLength(bufferKeyID, bytesNeededKeyID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFConsumer_GetKeyIDFunc(FHandle, bytesNeededKeyID, bytesWrittenKeyID, @bufferKeyID[0]));
		Result := StrPas(@bufferKeyID[0]);
	end;

	function TLib3MFConsumer.GetKeyValue(): String;
	var
		bytesNeededKeyValue: Cardinal;
		bytesWrittenKeyValue: Cardinal;
		bufferKeyValue: array of Char;
	begin
		bytesNeededKeyValue:= 0;
		bytesWrittenKeyValue:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFConsumer_GetKeyValueFunc(FHandle, 0, bytesNeededKeyValue, nil));
		SetLength(bufferKeyValue, bytesNeededKeyValue);
		FWrapper.CheckError(Self, FWrapper.Lib3MFConsumer_GetKeyValueFunc(FHandle, bytesNeededKeyValue, bytesWrittenKeyValue, @bufferKeyValue[0]));
		Result := StrPas(@bufferKeyValue[0]);
	end;

(*************************************************************************************************************************
 Class implementation for AccessRight
**************************************************************************************************************************)

	constructor TLib3MFAccessRight.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFAccessRight.Destroy;
	begin
		inherited;
	end;

	function TLib3MFAccessRight.GetConsumer(): TLib3MFConsumer;
	var
		HConsumer: TLib3MFHandle;
	begin
		Result := nil;
		HConsumer := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAccessRight_GetConsumerFunc(FHandle, HConsumer));
		if Assigned(HConsumer) then
			Result := TLib3MFPolymorphicFactory<TLib3MFConsumer, TLib3MFConsumer>.Make(FWrapper, HConsumer);
	end;

	function TLib3MFAccessRight.GetWrappingAlgorithm(): TLib3MFWrappingAlgorithm;
	var
		ResultAlgorithm: Integer;
	begin
		ResultAlgorithm := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAccessRight_GetWrappingAlgorithmFunc(FHandle, ResultAlgorithm));
		Result := convertConstToWrappingAlgorithm(ResultAlgorithm);
	end;

	function TLib3MFAccessRight.GetMgfAlgorithm(): TLib3MFMgfAlgorithm;
	var
		ResultAlgorithm: Integer;
	begin
		ResultAlgorithm := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAccessRight_GetMgfAlgorithmFunc(FHandle, ResultAlgorithm));
		Result := convertConstToMgfAlgorithm(ResultAlgorithm);
	end;

	function TLib3MFAccessRight.GetDigestMethod(): TLib3MFDigestMethod;
	var
		ResultAlgorithm: Integer;
	begin
		ResultAlgorithm := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFAccessRight_GetDigestMethodFunc(FHandle, ResultAlgorithm));
		Result := convertConstToDigestMethod(ResultAlgorithm);
	end;

(*************************************************************************************************************************
 Class implementation for ContentEncryptionParams
**************************************************************************************************************************)

	constructor TLib3MFContentEncryptionParams.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFContentEncryptionParams.Destroy;
	begin
		inherited;
	end;

	function TLib3MFContentEncryptionParams.GetEncryptionAlgorithm(): TLib3MFEncryptionAlgorithm;
	var
		ResultAlgorithm: Integer;
	begin
		ResultAlgorithm := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc(FHandle, ResultAlgorithm));
		Result := convertConstToEncryptionAlgorithm(ResultAlgorithm);
	end;

	procedure TLib3MFContentEncryptionParams.GetKey(out AByteData: TByteDynArray);
	var
		countNeededByteData: QWord;
		countWrittenByteData: QWord;
	begin
		countNeededByteData:= 0;
		countWrittenByteData:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetKeyFunc(FHandle, 0, countNeededByteData, nil));
		SetLength(AByteData, countNeededByteData);
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetKeyFunc(FHandle, countNeededByteData, countWrittenByteData, @AByteData[0]));
	end;

	procedure TLib3MFContentEncryptionParams.GetInitializationVector(out AByteData: TByteDynArray);
	var
		countNeededByteData: QWord;
		countWrittenByteData: QWord;
	begin
		countNeededByteData:= 0;
		countWrittenByteData:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetInitializationVectorFunc(FHandle, 0, countNeededByteData, nil));
		SetLength(AByteData, countNeededByteData);
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetInitializationVectorFunc(FHandle, countNeededByteData, countWrittenByteData, @AByteData[0]));
	end;

	procedure TLib3MFContentEncryptionParams.GetAuthenticationTag(out AByteData: TByteDynArray);
	var
		countNeededByteData: QWord;
		countWrittenByteData: QWord;
	begin
		countNeededByteData:= 0;
		countWrittenByteData:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetAuthenticationTagFunc(FHandle, 0, countNeededByteData, nil));
		SetLength(AByteData, countNeededByteData);
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetAuthenticationTagFunc(FHandle, countNeededByteData, countWrittenByteData, @AByteData[0]));
	end;

	procedure TLib3MFContentEncryptionParams.SetAuthenticationTag(const AByteData: TByteDynArray);
	var
		PtrByteData: PByte;
		LenByteData: QWord;
	begin
		LenByteData := Length(AByteData);
		if LenByteData > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenByteData > 0 then
			PtrByteData := @AByteData[0]
		else
			PtrByteData := nil;
		
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_SetAuthenticationTagFunc(FHandle, QWord(LenByteData), PtrByteData));
	end;

	procedure TLib3MFContentEncryptionParams.GetAdditionalAuthenticationData(out AByteData: TByteDynArray);
	var
		countNeededByteData: QWord;
		countWrittenByteData: QWord;
	begin
		countNeededByteData:= 0;
		countWrittenByteData:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc(FHandle, 0, countNeededByteData, nil));
		SetLength(AByteData, countNeededByteData);
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc(FHandle, countNeededByteData, countWrittenByteData, @AByteData[0]));
	end;

	function TLib3MFContentEncryptionParams.GetDescriptor(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetDescriptorFunc(FHandle, Result));
	end;

	function TLib3MFContentEncryptionParams.GetKeyUUID(): String;
	var
		bytesNeededUUID: Cardinal;
		bytesWrittenUUID: Cardinal;
		bufferUUID: array of Char;
	begin
		bytesNeededUUID:= 0;
		bytesWrittenUUID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetKeyUUIDFunc(FHandle, 0, bytesNeededUUID, nil));
		SetLength(bufferUUID, bytesNeededUUID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFContentEncryptionParams_GetKeyUUIDFunc(FHandle, bytesNeededUUID, bytesWrittenUUID, @bufferUUID[0]));
		Result := StrPas(@bufferUUID[0]);
	end;

(*************************************************************************************************************************
 Class implementation for ResourceData
**************************************************************************************************************************)

	constructor TLib3MFResourceData.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFResourceData.Destroy;
	begin
		inherited;
	end;

	function TLib3MFResourceData.GetPath(): TLib3MFPackagePart;
	var
		HPath: TLib3MFHandle;
	begin
		Result := nil;
		HPath := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceData_GetPathFunc(FHandle, HPath));
		if Assigned(HPath) then
			Result := TLib3MFPolymorphicFactory<TLib3MFPackagePart, TLib3MFPackagePart>.Make(FWrapper, HPath);
	end;

	function TLib3MFResourceData.GetEncryptionAlgorithm(): TLib3MFEncryptionAlgorithm;
	var
		ResultEncryptionAlgorithm: Integer;
	begin
		ResultEncryptionAlgorithm := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceData_GetEncryptionAlgorithmFunc(FHandle, ResultEncryptionAlgorithm));
		Result := convertConstToEncryptionAlgorithm(ResultEncryptionAlgorithm);
	end;

	function TLib3MFResourceData.GetCompression(): TLib3MFCompression;
	var
		ResultCompression: Integer;
	begin
		ResultCompression := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceData_GetCompressionFunc(FHandle, ResultCompression));
		Result := convertConstToCompression(ResultCompression);
	end;

	procedure TLib3MFResourceData.GetAdditionalAuthenticationData(out AByteData: TByteDynArray);
	var
		countNeededByteData: QWord;
		countWrittenByteData: QWord;
	begin
		countNeededByteData:= 0;
		countWrittenByteData:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceData_GetAdditionalAuthenticationDataFunc(FHandle, 0, countNeededByteData, nil));
		SetLength(AByteData, countNeededByteData);
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceData_GetAdditionalAuthenticationDataFunc(FHandle, countNeededByteData, countWrittenByteData, @AByteData[0]));
	end;

(*************************************************************************************************************************
 Class implementation for ResourceDataGroup
**************************************************************************************************************************)

	constructor TLib3MFResourceDataGroup.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFResourceDataGroup.Destroy;
	begin
		inherited;
	end;

	function TLib3MFResourceDataGroup.GetKeyUUID(): String;
	var
		bytesNeededUUID: Cardinal;
		bytesWrittenUUID: Cardinal;
		bufferUUID: array of Char;
	begin
		bytesNeededUUID:= 0;
		bytesWrittenUUID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceDataGroup_GetKeyUUIDFunc(FHandle, 0, bytesNeededUUID, nil));
		SetLength(bufferUUID, bytesNeededUUID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceDataGroup_GetKeyUUIDFunc(FHandle, bytesNeededUUID, bytesWrittenUUID, @bufferUUID[0]));
		Result := StrPas(@bufferUUID[0]);
	end;

	function TLib3MFResourceDataGroup.AddAccessRight(const AConsumer: TLib3MFConsumer; const AWrappingAlgorithm: TLib3MFWrappingAlgorithm; const AMgfAlgorithm: TLib3MFMgfAlgorithm; const ADigestMethod: TLib3MFDigestMethod): TLib3MFAccessRight;
	var
		AConsumerHandle: TLib3MFHandle;
		HTheAccessRight: TLib3MFHandle;
	begin
		if Assigned(AConsumer) then
		AConsumerHandle := AConsumer.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AConsumer is a nil value.');
		Result := nil;
		HTheAccessRight := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceDataGroup_AddAccessRightFunc(FHandle, AConsumerHandle, convertWrappingAlgorithmToConst(AWrappingAlgorithm), convertMgfAlgorithmToConst(AMgfAlgorithm), convertDigestMethodToConst(ADigestMethod), HTheAccessRight));
		if Assigned(HTheAccessRight) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAccessRight, TLib3MFAccessRight>.Make(FWrapper, HTheAccessRight);
	end;

	function TLib3MFResourceDataGroup.FindAccessRightByConsumer(const AConsumer: TLib3MFConsumer): TLib3MFAccessRight;
	var
		AConsumerHandle: TLib3MFHandle;
		HTheAccessRight: TLib3MFHandle;
	begin
		if Assigned(AConsumer) then
		AConsumerHandle := AConsumer.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AConsumer is a nil value.');
		Result := nil;
		HTheAccessRight := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceDataGroup_FindAccessRightByConsumerFunc(FHandle, AConsumerHandle, HTheAccessRight));
		if Assigned(HTheAccessRight) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAccessRight, TLib3MFAccessRight>.Make(FWrapper, HTheAccessRight);
	end;

	procedure TLib3MFResourceDataGroup.RemoveAccessRight(const AConsumer: TLib3MFConsumer);
	var
		AConsumerHandle: TLib3MFHandle;
	begin
		if Assigned(AConsumer) then
		AConsumerHandle := AConsumer.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AConsumer is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFResourceDataGroup_RemoveAccessRightFunc(FHandle, AConsumerHandle));
	end;

(*************************************************************************************************************************
 Class implementation for KeyStore
**************************************************************************************************************************)

	constructor TLib3MFKeyStore.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFKeyStore.Destroy;
	begin
		inherited;
	end;

	function TLib3MFKeyStore.AddConsumer(const AConsumerID: String; const AKeyID: String; const AKeyValue: String): TLib3MFConsumer;
	var
		HConsumer: TLib3MFHandle;
	begin
		Result := nil;
		HConsumer := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_AddConsumerFunc(FHandle, PAnsiChar(AConsumerID), PAnsiChar(AKeyID), PAnsiChar(AKeyValue), HConsumer));
		if Assigned(HConsumer) then
			Result := TLib3MFPolymorphicFactory<TLib3MFConsumer, TLib3MFConsumer>.Make(FWrapper, HConsumer);
	end;

	function TLib3MFKeyStore.GetConsumerCount(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetConsumerCountFunc(FHandle, Result));
	end;

	function TLib3MFKeyStore.GetConsumer(const AConsumerIndex: QWord): TLib3MFConsumer;
	var
		HConsumer: TLib3MFHandle;
	begin
		Result := nil;
		HConsumer := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetConsumerFunc(FHandle, AConsumerIndex, HConsumer));
		if Assigned(HConsumer) then
			Result := TLib3MFPolymorphicFactory<TLib3MFConsumer, TLib3MFConsumer>.Make(FWrapper, HConsumer);
	end;

	procedure TLib3MFKeyStore.RemoveConsumer(const AConsumer: TLib3MFConsumer);
	var
		AConsumerHandle: TLib3MFHandle;
	begin
		if Assigned(AConsumer) then
		AConsumerHandle := AConsumer.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AConsumer is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_RemoveConsumerFunc(FHandle, AConsumerHandle));
	end;

	function TLib3MFKeyStore.FindConsumer(const AConsumerID: String): TLib3MFConsumer;
	var
		HConsumer: TLib3MFHandle;
	begin
		Result := nil;
		HConsumer := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_FindConsumerFunc(FHandle, PAnsiChar(AConsumerID), HConsumer));
		if Assigned(HConsumer) then
			Result := TLib3MFPolymorphicFactory<TLib3MFConsumer, TLib3MFConsumer>.Make(FWrapper, HConsumer);
	end;

	function TLib3MFKeyStore.GetResourceDataGroupCount(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetResourceDataGroupCountFunc(FHandle, Result));
	end;

	function TLib3MFKeyStore.AddResourceDataGroup(): TLib3MFResourceDataGroup;
	var
		HResourceDataGroup: TLib3MFHandle;
	begin
		Result := nil;
		HResourceDataGroup := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_AddResourceDataGroupFunc(FHandle, HResourceDataGroup));
		if Assigned(HResourceDataGroup) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceDataGroup, TLib3MFResourceDataGroup>.Make(FWrapper, HResourceDataGroup);
	end;

	function TLib3MFKeyStore.GetResourceDataGroup(const AResourceDataIndex: QWord): TLib3MFResourceDataGroup;
	var
		HResourceDataGroup: TLib3MFHandle;
	begin
		Result := nil;
		HResourceDataGroup := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetResourceDataGroupFunc(FHandle, AResourceDataIndex, HResourceDataGroup));
		if Assigned(HResourceDataGroup) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceDataGroup, TLib3MFResourceDataGroup>.Make(FWrapper, HResourceDataGroup);
	end;

	procedure TLib3MFKeyStore.RemoveResourceDataGroup(const AResourceDataGroup: TLib3MFResourceDataGroup);
	var
		AResourceDataGroupHandle: TLib3MFHandle;
	begin
		if Assigned(AResourceDataGroup) then
		AResourceDataGroupHandle := AResourceDataGroup.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AResourceDataGroup is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_RemoveResourceDataGroupFunc(FHandle, AResourceDataGroupHandle));
	end;

	function TLib3MFKeyStore.FindResourceDataGroup(const APartPath: TLib3MFPackagePart): TLib3MFResourceDataGroup;
	var
		APartPathHandle: TLib3MFHandle;
		HResourceDataGroup: TLib3MFHandle;
	begin
		if Assigned(APartPath) then
		APartPathHandle := APartPath.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'APartPath is a nil value.');
		Result := nil;
		HResourceDataGroup := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_FindResourceDataGroupFunc(FHandle, APartPathHandle, HResourceDataGroup));
		if Assigned(HResourceDataGroup) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceDataGroup, TLib3MFResourceDataGroup>.Make(FWrapper, HResourceDataGroup);
	end;

	function TLib3MFKeyStore.AddResourceData(const AResourceDataGroup: TLib3MFResourceDataGroup; const APartPath: TLib3MFPackagePart; const AAlgorithm: TLib3MFEncryptionAlgorithm; const ACompression: TLib3MFCompression; const AAdditionalAuthenticationData: TByteDynArray): TLib3MFResourceData;
	var
		AResourceDataGroupHandle: TLib3MFHandle;
		APartPathHandle: TLib3MFHandle;
		PtrAdditionalAuthenticationData: PByte;
		LenAdditionalAuthenticationData: QWord;
		HResourceData: TLib3MFHandle;
	begin
		if Assigned(AResourceDataGroup) then
		AResourceDataGroupHandle := AResourceDataGroup.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AResourceDataGroup is a nil value.');
		if Assigned(APartPath) then
		APartPathHandle := APartPath.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'APartPath is a nil value.');
		LenAdditionalAuthenticationData := Length(AAdditionalAuthenticationData);
		if LenAdditionalAuthenticationData > $FFFFFFFF then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'array has too many entries.');
		if LenAdditionalAuthenticationData > 0 then
			PtrAdditionalAuthenticationData := @AAdditionalAuthenticationData[0]
		else
			PtrAdditionalAuthenticationData := nil;
		
		Result := nil;
		HResourceData := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_AddResourceDataFunc(FHandle, AResourceDataGroupHandle, APartPathHandle, convertEncryptionAlgorithmToConst(AAlgorithm), convertCompressionToConst(ACompression), QWord(LenAdditionalAuthenticationData), PtrAdditionalAuthenticationData, HResourceData));
		if Assigned(HResourceData) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceData, TLib3MFResourceData>.Make(FWrapper, HResourceData);
	end;

	procedure TLib3MFKeyStore.RemoveResourceData(const AResourceData: TLib3MFResourceData);
	var
		AResourceDataHandle: TLib3MFHandle;
	begin
		if Assigned(AResourceData) then
		AResourceDataHandle := AResourceData.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AResourceData is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_RemoveResourceDataFunc(FHandle, AResourceDataHandle));
	end;

	function TLib3MFKeyStore.FindResourceData(const AResourcePath: TLib3MFPackagePart): TLib3MFResourceData;
	var
		AResourcePathHandle: TLib3MFHandle;
		HResourceData: TLib3MFHandle;
	begin
		if Assigned(AResourcePath) then
		AResourcePathHandle := AResourcePath.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AResourcePath is a nil value.');
		Result := nil;
		HResourceData := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_FindResourceDataFunc(FHandle, AResourcePathHandle, HResourceData));
		if Assigned(HResourceData) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceData, TLib3MFResourceData>.Make(FWrapper, HResourceData);
	end;

	function TLib3MFKeyStore.GetResourceDataCount(): QWord;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetResourceDataCountFunc(FHandle, Result));
	end;

	function TLib3MFKeyStore.GetResourceData(const AResourceDataIndex: QWord): TLib3MFResourceData;
	var
		HResourceData: TLib3MFHandle;
	begin
		Result := nil;
		HResourceData := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetResourceDataFunc(FHandle, AResourceDataIndex, HResourceData));
		if Assigned(HResourceData) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceData, TLib3MFResourceData>.Make(FWrapper, HResourceData);
	end;

	function TLib3MFKeyStore.GetUUID(out AHasUUID: Boolean): String;
	var
		ResultHasUUID: Byte;
		bytesNeededUUID: Cardinal;
		bytesWrittenUUID: Cardinal;
		bufferUUID: array of Char;
	begin
		ResultHasUUID := 0;
		bytesNeededUUID:= 0;
		bytesWrittenUUID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetUUIDFunc(FHandle, ResultHasUUID, 0, bytesNeededUUID, nil));
		SetLength(bufferUUID, bytesNeededUUID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_GetUUIDFunc(FHandle, ResultHasUUID, bytesNeededUUID, bytesWrittenUUID, @bufferUUID[0]));
		AHasUUID := ResultHasUUID <> 0;
		Result := StrPas(@bufferUUID[0]);
	end;

	procedure TLib3MFKeyStore.SetUUID(const AUUID: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFKeyStore_SetUUIDFunc(FHandle, PAnsiChar(AUUID)));
	end;

(*************************************************************************************************************************
 Class implementation for Model
**************************************************************************************************************************)

	constructor TLib3MFModel.Create(AWrapper: TLib3MFWrapper; AHandle: TLib3MFHandle);
	begin
		inherited Create(AWrapper, AHandle);
	end;

	destructor TLib3MFModel.Destroy;
	begin
		inherited;
	end;

	function TLib3MFModel.RootModelPart(): TLib3MFPackagePart;
	var
		HRootModelPart: TLib3MFHandle;
	begin
		Result := nil;
		HRootModelPart := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_RootModelPartFunc(FHandle, HRootModelPart));
		if Assigned(HRootModelPart) then
			Result := TLib3MFPolymorphicFactory<TLib3MFPackagePart, TLib3MFPackagePart>.Make(FWrapper, HRootModelPart);
	end;

	function TLib3MFModel.FindOrCreatePackagePart(const AAbsolutePath: String): TLib3MFPackagePart;
	var
		HModelPart: TLib3MFHandle;
	begin
		Result := nil;
		HModelPart := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_FindOrCreatePackagePartFunc(FHandle, PAnsiChar(AAbsolutePath), HModelPart));
		if Assigned(HModelPart) then
			Result := TLib3MFPolymorphicFactory<TLib3MFPackagePart, TLib3MFPackagePart>.Make(FWrapper, HModelPart);
	end;

	procedure TLib3MFModel.SetUnit(const AUnit: TLib3MFModelUnit);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_SetUnitFunc(FHandle, convertModelUnitToConst(AUnit)));
	end;

	function TLib3MFModel.GetUnit(): TLib3MFModelUnit;
	var
		ResultUnit: Integer;
	begin
		ResultUnit := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetUnitFunc(FHandle, ResultUnit));
		Result := convertConstToModelUnit(ResultUnit);
	end;

	function TLib3MFModel.GetLanguage(): String;
	var
		bytesNeededLanguage: Cardinal;
		bytesWrittenLanguage: Cardinal;
		bufferLanguage: array of Char;
	begin
		bytesNeededLanguage:= 0;
		bytesWrittenLanguage:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetLanguageFunc(FHandle, 0, bytesNeededLanguage, nil));
		SetLength(bufferLanguage, bytesNeededLanguage);
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetLanguageFunc(FHandle, bytesNeededLanguage, bytesWrittenLanguage, @bufferLanguage[0]));
		Result := StrPas(@bufferLanguage[0]);
	end;

	procedure TLib3MFModel.SetLanguage(const ALanguage: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_SetLanguageFunc(FHandle, PAnsiChar(ALanguage)));
	end;

	function TLib3MFModel.QueryWriter(const AWriterClass: String): TLib3MFWriter;
	var
		HWriterInstance: TLib3MFHandle;
	begin
		Result := nil;
		HWriterInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_QueryWriterFunc(FHandle, PAnsiChar(AWriterClass), HWriterInstance));
		if Assigned(HWriterInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFWriter, TLib3MFWriter>.Make(FWrapper, HWriterInstance);
	end;

	function TLib3MFModel.QueryReader(const AReaderClass: String): TLib3MFReader;
	var
		HReaderInstance: TLib3MFHandle;
	begin
		Result := nil;
		HReaderInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_QueryReaderFunc(FHandle, PAnsiChar(AReaderClass), HReaderInstance));
		if Assigned(HReaderInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFReader, TLib3MFReader>.Make(FWrapper, HReaderInstance);
	end;

	function TLib3MFModel.GetResourceByID(const AUniqueResourceID: Cardinal): TLib3MFResource;
	var
		HResource: TLib3MFHandle;
	begin
		Result := nil;
		HResource := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetResourceByIDFunc(FHandle, AUniqueResourceID, HResource));
		if Assigned(HResource) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResource, TLib3MFResource>.Make(FWrapper, HResource);
	end;

	function TLib3MFModel.GetTexture2DByID(const AUniqueResourceID: Cardinal): TLib3MFTexture2D;
	var
		HTextureInstance: TLib3MFHandle;
	begin
		Result := nil;
		HTextureInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetTexture2DByIDFunc(FHandle, AUniqueResourceID, HTextureInstance));
		if Assigned(HTextureInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2D, TLib3MFTexture2D>.Make(FWrapper, HTextureInstance);
	end;

	function TLib3MFModel.GetPropertyTypeByID(const AUniqueResourceID: Cardinal): TLib3MFPropertyType;
	var
		ResultThePropertyType: Integer;
	begin
		ResultThePropertyType := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetPropertyTypeByIDFunc(FHandle, AUniqueResourceID, ResultThePropertyType));
		Result := convertConstToPropertyType(ResultThePropertyType);
	end;

	function TLib3MFModel.GetBaseMaterialGroupByID(const AUniqueResourceID: Cardinal): TLib3MFBaseMaterialGroup;
	var
		HBaseMaterialGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HBaseMaterialGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetBaseMaterialGroupByIDFunc(FHandle, AUniqueResourceID, HBaseMaterialGroupInstance));
		if Assigned(HBaseMaterialGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBaseMaterialGroup, TLib3MFBaseMaterialGroup>.Make(FWrapper, HBaseMaterialGroupInstance);
	end;

	function TLib3MFModel.GetTexture2DGroupByID(const AUniqueResourceID: Cardinal): TLib3MFTexture2DGroup;
	var
		HTexture2DGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HTexture2DGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetTexture2DGroupByIDFunc(FHandle, AUniqueResourceID, HTexture2DGroupInstance));
		if Assigned(HTexture2DGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2DGroup, TLib3MFTexture2DGroup>.Make(FWrapper, HTexture2DGroupInstance);
	end;

	function TLib3MFModel.GetCompositeMaterialsByID(const AUniqueResourceID: Cardinal): TLib3MFCompositeMaterials;
	var
		HCompositeMaterialsInstance: TLib3MFHandle;
	begin
		Result := nil;
		HCompositeMaterialsInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetCompositeMaterialsByIDFunc(FHandle, AUniqueResourceID, HCompositeMaterialsInstance));
		if Assigned(HCompositeMaterialsInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFCompositeMaterials, TLib3MFCompositeMaterials>.Make(FWrapper, HCompositeMaterialsInstance);
	end;

	function TLib3MFModel.GetMultiPropertyGroupByID(const AUniqueResourceID: Cardinal): TLib3MFMultiPropertyGroup;
	var
		HMultiPropertyGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HMultiPropertyGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetMultiPropertyGroupByIDFunc(FHandle, AUniqueResourceID, HMultiPropertyGroupInstance));
		if Assigned(HMultiPropertyGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMultiPropertyGroup, TLib3MFMultiPropertyGroup>.Make(FWrapper, HMultiPropertyGroupInstance);
	end;

	function TLib3MFModel.GetMeshObjectByID(const AUniqueResourceID: Cardinal): TLib3MFMeshObject;
	var
		HMeshObjectInstance: TLib3MFHandle;
	begin
		Result := nil;
		HMeshObjectInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetMeshObjectByIDFunc(FHandle, AUniqueResourceID, HMeshObjectInstance));
		if Assigned(HMeshObjectInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMeshObject, TLib3MFMeshObject>.Make(FWrapper, HMeshObjectInstance);
	end;

	function TLib3MFModel.GetComponentsObjectByID(const AUniqueResourceID: Cardinal): TLib3MFComponentsObject;
	var
		HComponentsObjectInstance: TLib3MFHandle;
	begin
		Result := nil;
		HComponentsObjectInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetComponentsObjectByIDFunc(FHandle, AUniqueResourceID, HComponentsObjectInstance));
		if Assigned(HComponentsObjectInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFComponentsObject, TLib3MFComponentsObject>.Make(FWrapper, HComponentsObjectInstance);
	end;

	function TLib3MFModel.GetColorGroupByID(const AUniqueResourceID: Cardinal): TLib3MFColorGroup;
	var
		HColorGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HColorGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetColorGroupByIDFunc(FHandle, AUniqueResourceID, HColorGroupInstance));
		if Assigned(HColorGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFColorGroup, TLib3MFColorGroup>.Make(FWrapper, HColorGroupInstance);
	end;

	function TLib3MFModel.GetSliceStackByID(const AUniqueResourceID: Cardinal): TLib3MFSliceStack;
	var
		HSliceStacInstance: TLib3MFHandle;
	begin
		Result := nil;
		HSliceStacInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetSliceStackByIDFunc(FHandle, AUniqueResourceID, HSliceStacInstance));
		if Assigned(HSliceStacInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSliceStack, TLib3MFSliceStack>.Make(FWrapper, HSliceStacInstance);
	end;

	function TLib3MFModel.GetBuildUUID(out AHasUUID: Boolean): String;
	var
		ResultHasUUID: Byte;
		bytesNeededUUID: Cardinal;
		bytesWrittenUUID: Cardinal;
		bufferUUID: array of Char;
	begin
		ResultHasUUID := 0;
		bytesNeededUUID:= 0;
		bytesWrittenUUID:= 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetBuildUUIDFunc(FHandle, ResultHasUUID, 0, bytesNeededUUID, nil));
		SetLength(bufferUUID, bytesNeededUUID);
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetBuildUUIDFunc(FHandle, ResultHasUUID, bytesNeededUUID, bytesWrittenUUID, @bufferUUID[0]));
		AHasUUID := ResultHasUUID <> 0;
		Result := StrPas(@bufferUUID[0]);
	end;

	procedure TLib3MFModel.SetBuildUUID(const AUUID: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_SetBuildUUIDFunc(FHandle, PAnsiChar(AUUID)));
	end;

	function TLib3MFModel.GetBuildItems(): TLib3MFBuildItemIterator;
	var
		HBuildItemIterator: TLib3MFHandle;
	begin
		Result := nil;
		HBuildItemIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetBuildItemsFunc(FHandle, HBuildItemIterator));
		if Assigned(HBuildItemIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBuildItemIterator, TLib3MFBuildItemIterator>.Make(FWrapper, HBuildItemIterator);
	end;

	function TLib3MFModel.GetOutbox(): TLib3MFBox;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetOutboxFunc(FHandle, @Result));
	end;

	function TLib3MFModel.GetResources(): TLib3MFResourceIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetResourcesFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFResourceIterator, TLib3MFResourceIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetObjects(): TLib3MFObjectIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetObjectsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFObjectIterator, TLib3MFObjectIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetMeshObjects(): TLib3MFMeshObjectIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetMeshObjectsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMeshObjectIterator, TLib3MFMeshObjectIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetComponentsObjects(): TLib3MFComponentsObjectIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetComponentsObjectsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFComponentsObjectIterator, TLib3MFComponentsObjectIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetTexture2Ds(): TLib3MFTexture2DIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetTexture2DsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2DIterator, TLib3MFTexture2DIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetBaseMaterialGroups(): TLib3MFBaseMaterialGroupIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetBaseMaterialGroupsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBaseMaterialGroupIterator, TLib3MFBaseMaterialGroupIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetColorGroups(): TLib3MFColorGroupIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetColorGroupsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFColorGroupIterator, TLib3MFColorGroupIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetTexture2DGroups(): TLib3MFTexture2DGroupIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetTexture2DGroupsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2DGroupIterator, TLib3MFTexture2DGroupIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetCompositeMaterials(): TLib3MFCompositeMaterialsIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetCompositeMaterialsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFCompositeMaterialsIterator, TLib3MFCompositeMaterialsIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetMultiPropertyGroups(): TLib3MFMultiPropertyGroupIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetMultiPropertyGroupsFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMultiPropertyGroupIterator, TLib3MFMultiPropertyGroupIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.GetSliceStacks(): TLib3MFSliceStackIterator;
	var
		HResourceIterator: TLib3MFHandle;
	begin
		Result := nil;
		HResourceIterator := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetSliceStacksFunc(FHandle, HResourceIterator));
		if Assigned(HResourceIterator) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSliceStackIterator, TLib3MFSliceStackIterator>.Make(FWrapper, HResourceIterator);
	end;

	function TLib3MFModel.MergeToModel(): TLib3MFModel;
	var
		HMergedModelInstance: TLib3MFHandle;
	begin
		Result := nil;
		HMergedModelInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_MergeToModelFunc(FHandle, HMergedModelInstance));
		if Assigned(HMergedModelInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFModel, TLib3MFModel>.Make(FWrapper, HMergedModelInstance);
	end;

	function TLib3MFModel.AddMeshObject(): TLib3MFMeshObject;
	var
		HMeshObjectInstance: TLib3MFHandle;
	begin
		Result := nil;
		HMeshObjectInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddMeshObjectFunc(FHandle, HMeshObjectInstance));
		if Assigned(HMeshObjectInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMeshObject, TLib3MFMeshObject>.Make(FWrapper, HMeshObjectInstance);
	end;

	function TLib3MFModel.AddComponentsObject(): TLib3MFComponentsObject;
	var
		HComponentsObjectInstance: TLib3MFHandle;
	begin
		Result := nil;
		HComponentsObjectInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddComponentsObjectFunc(FHandle, HComponentsObjectInstance));
		if Assigned(HComponentsObjectInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFComponentsObject, TLib3MFComponentsObject>.Make(FWrapper, HComponentsObjectInstance);
	end;

	function TLib3MFModel.AddSliceStack(const AZBottom: Double): TLib3MFSliceStack;
	var
		HSliceStackInstance: TLib3MFHandle;
	begin
		Result := nil;
		HSliceStackInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddSliceStackFunc(FHandle, AZBottom, HSliceStackInstance));
		if Assigned(HSliceStackInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFSliceStack, TLib3MFSliceStack>.Make(FWrapper, HSliceStackInstance);
	end;

	function TLib3MFModel.AddTexture2DFromAttachment(const ATextureAttachment: TLib3MFAttachment): TLib3MFTexture2D;
	var
		ATextureAttachmentHandle: TLib3MFHandle;
		HTexture2DInstance: TLib3MFHandle;
	begin
		if Assigned(ATextureAttachment) then
		ATextureAttachmentHandle := ATextureAttachment.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATextureAttachment is a nil value.');
		Result := nil;
		HTexture2DInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddTexture2DFromAttachmentFunc(FHandle, ATextureAttachmentHandle, HTexture2DInstance));
		if Assigned(HTexture2DInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2D, TLib3MFTexture2D>.Make(FWrapper, HTexture2DInstance);
	end;

	function TLib3MFModel.AddBaseMaterialGroup(): TLib3MFBaseMaterialGroup;
	var
		HBaseMaterialGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HBaseMaterialGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddBaseMaterialGroupFunc(FHandle, HBaseMaterialGroupInstance));
		if Assigned(HBaseMaterialGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBaseMaterialGroup, TLib3MFBaseMaterialGroup>.Make(FWrapper, HBaseMaterialGroupInstance);
	end;

	function TLib3MFModel.AddColorGroup(): TLib3MFColorGroup;
	var
		HColorGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HColorGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddColorGroupFunc(FHandle, HColorGroupInstance));
		if Assigned(HColorGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFColorGroup, TLib3MFColorGroup>.Make(FWrapper, HColorGroupInstance);
	end;

	function TLib3MFModel.AddTexture2DGroup(const ATexture2DInstance: TLib3MFTexture2D): TLib3MFTexture2DGroup;
	var
		ATexture2DInstanceHandle: TLib3MFHandle;
		HTexture2DGroupInstance: TLib3MFHandle;
	begin
		if Assigned(ATexture2DInstance) then
		ATexture2DInstanceHandle := ATexture2DInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATexture2DInstance is a nil value.');
		Result := nil;
		HTexture2DGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddTexture2DGroupFunc(FHandle, ATexture2DInstanceHandle, HTexture2DGroupInstance));
		if Assigned(HTexture2DGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFTexture2DGroup, TLib3MFTexture2DGroup>.Make(FWrapper, HTexture2DGroupInstance);
	end;

	function TLib3MFModel.AddCompositeMaterials(const ABaseMaterialGroupInstance: TLib3MFBaseMaterialGroup): TLib3MFCompositeMaterials;
	var
		ABaseMaterialGroupInstanceHandle: TLib3MFHandle;
		HCompositeMaterialsInstance: TLib3MFHandle;
	begin
		if Assigned(ABaseMaterialGroupInstance) then
		ABaseMaterialGroupInstanceHandle := ABaseMaterialGroupInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ABaseMaterialGroupInstance is a nil value.');
		Result := nil;
		HCompositeMaterialsInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddCompositeMaterialsFunc(FHandle, ABaseMaterialGroupInstanceHandle, HCompositeMaterialsInstance));
		if Assigned(HCompositeMaterialsInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFCompositeMaterials, TLib3MFCompositeMaterials>.Make(FWrapper, HCompositeMaterialsInstance);
	end;

	function TLib3MFModel.AddMultiPropertyGroup(): TLib3MFMultiPropertyGroup;
	var
		HMultiPropertyGroupInstance: TLib3MFHandle;
	begin
		Result := nil;
		HMultiPropertyGroupInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddMultiPropertyGroupFunc(FHandle, HMultiPropertyGroupInstance));
		if Assigned(HMultiPropertyGroupInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMultiPropertyGroup, TLib3MFMultiPropertyGroup>.Make(FWrapper, HMultiPropertyGroupInstance);
	end;

	function TLib3MFModel.AddBuildItem(const AObject: TLib3MFObject; const ATransform: TLib3MFTransform): TLib3MFBuildItem;
	var
		AObjectHandle: TLib3MFHandle;
		HBuildItemInstance: TLib3MFHandle;
	begin
		if Assigned(AObject) then
		AObjectHandle := AObject.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AObject is a nil value.');
		Result := nil;
		HBuildItemInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddBuildItemFunc(FHandle, AObjectHandle, @ATransform, HBuildItemInstance));
		if Assigned(HBuildItemInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFBuildItem, TLib3MFBuildItem>.Make(FWrapper, HBuildItemInstance);
	end;

	procedure TLib3MFModel.RemoveBuildItem(const ABuildItemInstance: TLib3MFBuildItem);
	var
		ABuildItemInstanceHandle: TLib3MFHandle;
	begin
		if Assigned(ABuildItemInstance) then
		ABuildItemInstanceHandle := ABuildItemInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ABuildItemInstance is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_RemoveBuildItemFunc(FHandle, ABuildItemInstanceHandle));
	end;

	function TLib3MFModel.GetMetaDataGroup(): TLib3MFMetaDataGroup;
	var
		HTheMetaDataGroup: TLib3MFHandle;
	begin
		Result := nil;
		HTheMetaDataGroup := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetMetaDataGroupFunc(FHandle, HTheMetaDataGroup));
		if Assigned(HTheMetaDataGroup) then
			Result := TLib3MFPolymorphicFactory<TLib3MFMetaDataGroup, TLib3MFMetaDataGroup>.Make(FWrapper, HTheMetaDataGroup);
	end;

	function TLib3MFModel.AddAttachment(const AURI: String; const ARelationShipType: String): TLib3MFAttachment;
	var
		HAttachmentInstance: TLib3MFHandle;
	begin
		Result := nil;
		HAttachmentInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddAttachmentFunc(FHandle, PAnsiChar(AURI), PAnsiChar(ARelationShipType), HAttachmentInstance));
		if Assigned(HAttachmentInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAttachment, TLib3MFAttachment>.Make(FWrapper, HAttachmentInstance);
	end;

	procedure TLib3MFModel.RemoveAttachment(const AAttachmentInstance: TLib3MFAttachment);
	var
		AAttachmentInstanceHandle: TLib3MFHandle;
	begin
		if Assigned(AAttachmentInstance) then
		AAttachmentInstanceHandle := AAttachmentInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AAttachmentInstance is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_RemoveAttachmentFunc(FHandle, AAttachmentInstanceHandle));
	end;

	function TLib3MFModel.GetAttachment(const AIndex: Cardinal): TLib3MFAttachment;
	var
		HAttachmentInstance: TLib3MFHandle;
	begin
		Result := nil;
		HAttachmentInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetAttachmentFunc(FHandle, AIndex, HAttachmentInstance));
		if Assigned(HAttachmentInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAttachment, TLib3MFAttachment>.Make(FWrapper, HAttachmentInstance);
	end;

	function TLib3MFModel.FindAttachment(const AURI: String): TLib3MFAttachment;
	var
		HAttachmentInstance: TLib3MFHandle;
	begin
		Result := nil;
		HAttachmentInstance := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_FindAttachmentFunc(FHandle, PAnsiChar(AURI), HAttachmentInstance));
		if Assigned(HAttachmentInstance) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAttachment, TLib3MFAttachment>.Make(FWrapper, HAttachmentInstance);
	end;

	function TLib3MFModel.GetAttachmentCount(): Cardinal;
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetAttachmentCountFunc(FHandle, Result));
	end;

	function TLib3MFModel.HasPackageThumbnailAttachment(): Boolean;
	var
		ResultHasThumbnail: Byte;
	begin
		ResultHasThumbnail := 0;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_HasPackageThumbnailAttachmentFunc(FHandle, ResultHasThumbnail));
		Result := (ResultHasThumbnail <> 0);
	end;

	function TLib3MFModel.CreatePackageThumbnailAttachment(): TLib3MFAttachment;
	var
		HAttachment: TLib3MFHandle;
	begin
		Result := nil;
		HAttachment := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_CreatePackageThumbnailAttachmentFunc(FHandle, HAttachment));
		if Assigned(HAttachment) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAttachment, TLib3MFAttachment>.Make(FWrapper, HAttachment);
	end;

	function TLib3MFModel.GetPackageThumbnailAttachment(): TLib3MFAttachment;
	var
		HAttachment: TLib3MFHandle;
	begin
		Result := nil;
		HAttachment := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetPackageThumbnailAttachmentFunc(FHandle, HAttachment));
		if Assigned(HAttachment) then
			Result := TLib3MFPolymorphicFactory<TLib3MFAttachment, TLib3MFAttachment>.Make(FWrapper, HAttachment);
	end;

	procedure TLib3MFModel.RemovePackageThumbnailAttachment();
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_RemovePackageThumbnailAttachmentFunc(FHandle));
	end;

	procedure TLib3MFModel.AddCustomContentType(const AExtension: String; const AContentType: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_AddCustomContentTypeFunc(FHandle, PAnsiChar(AExtension), PAnsiChar(AContentType)));
	end;

	procedure TLib3MFModel.RemoveCustomContentType(const AExtension: String);
	begin
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_RemoveCustomContentTypeFunc(FHandle, PAnsiChar(AExtension)));
	end;

	procedure TLib3MFModel.SetRandomNumberCallback(const ATheCallback: PLib3MF_RandomNumberCallback; const AUserData: Pointer);
	begin
		if not Assigned(ATheCallback) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'ATheCallback is a nil value.');
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_SetRandomNumberCallbackFunc(FHandle, ATheCallback, AUserData));
	end;

	function TLib3MFModel.GetKeyStore(): TLib3MFKeyStore;
	var
		HKeyStore: TLib3MFHandle;
	begin
		Result := nil;
		HKeyStore := nil;
		FWrapper.CheckError(Self, FWrapper.Lib3MFModel_GetKeyStoreFunc(FHandle, HKeyStore));
		if Assigned(HKeyStore) then
			Result := TLib3MFPolymorphicFactory<TLib3MFKeyStore, TLib3MFKeyStore>.Make(FWrapper, HKeyStore);
	end;

(*************************************************************************************************************************
 Wrapper class implementation
**************************************************************************************************************************)

	constructor TLib3MFWrapper.Create(ADLLName: String);
	{$IFDEF MSWINDOWS}
	var
		AWideString: WideString;
	{$ENDIF MSWINDOWS}
	begin
		inherited Create;
		
		
		{$IFDEF MSWINDOWS}
			AWideString := UTF8Decode(ADLLName + #0);
			FModule := LoadLibraryW(PWideChar(AWideString));
		{$ELSE}
			FModule := dynlibs.LoadLibrary(ADLLName);
		{$ENDIF MSWINDOWS}
		if FModule = 0 then
			raise ELib3MFException.Create(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');

		FLib3MFBase_ClassTypeIdFunc := LoadFunction('lib3mf_base_classtypeid');
		FLib3MFWriter_WriteToFileFunc := LoadFunction('lib3mf_writer_writetofile');
		FLib3MFWriter_GetStreamSizeFunc := LoadFunction('lib3mf_writer_getstreamsize');
		FLib3MFWriter_WriteToBufferFunc := LoadFunction('lib3mf_writer_writetobuffer');
		FLib3MFWriter_WriteToCallbackFunc := LoadFunction('lib3mf_writer_writetocallback');
		FLib3MFWriter_SetProgressCallbackFunc := LoadFunction('lib3mf_writer_setprogresscallback');
		FLib3MFWriter_GetDecimalPrecisionFunc := LoadFunction('lib3mf_writer_getdecimalprecision');
		FLib3MFWriter_SetDecimalPrecisionFunc := LoadFunction('lib3mf_writer_setdecimalprecision');
		FLib3MFWriter_SetStrictModeActiveFunc := LoadFunction('lib3mf_writer_setstrictmodeactive');
		FLib3MFWriter_GetStrictModeActiveFunc := LoadFunction('lib3mf_writer_getstrictmodeactive');
		FLib3MFWriter_GetWarningFunc := LoadFunction('lib3mf_writer_getwarning');
		FLib3MFWriter_GetWarningCountFunc := LoadFunction('lib3mf_writer_getwarningcount');
		FLib3MFWriter_AddKeyWrappingCallbackFunc := LoadFunction('lib3mf_writer_addkeywrappingcallback');
		FLib3MFWriter_SetContentEncryptionCallbackFunc := LoadFunction('lib3mf_writer_setcontentencryptioncallback');
		FLib3MFReader_ReadFromFileFunc := LoadFunction('lib3mf_reader_readfromfile');
		FLib3MFReader_ReadFromBufferFunc := LoadFunction('lib3mf_reader_readfrombuffer');
		FLib3MFReader_ReadFromCallbackFunc := LoadFunction('lib3mf_reader_readfromcallback');
		FLib3MFReader_SetProgressCallbackFunc := LoadFunction('lib3mf_reader_setprogresscallback');
		FLib3MFReader_AddRelationToReadFunc := LoadFunction('lib3mf_reader_addrelationtoread');
		FLib3MFReader_RemoveRelationToReadFunc := LoadFunction('lib3mf_reader_removerelationtoread');
		FLib3MFReader_SetStrictModeActiveFunc := LoadFunction('lib3mf_reader_setstrictmodeactive');
		FLib3MFReader_GetStrictModeActiveFunc := LoadFunction('lib3mf_reader_getstrictmodeactive');
		FLib3MFReader_GetWarningFunc := LoadFunction('lib3mf_reader_getwarning');
		FLib3MFReader_GetWarningCountFunc := LoadFunction('lib3mf_reader_getwarningcount');
		FLib3MFReader_AddKeyWrappingCallbackFunc := LoadFunction('lib3mf_reader_addkeywrappingcallback');
		FLib3MFReader_SetContentEncryptionCallbackFunc := LoadFunction('lib3mf_reader_setcontentencryptioncallback');
		FLib3MFPackagePart_GetPathFunc := LoadFunction('lib3mf_packagepart_getpath');
		FLib3MFPackagePart_SetPathFunc := LoadFunction('lib3mf_packagepart_setpath');
		FLib3MFResource_GetResourceIDFunc := LoadFunction('lib3mf_resource_getresourceid');
		FLib3MFResource_GetUniqueResourceIDFunc := LoadFunction('lib3mf_resource_getuniqueresourceid');
		FLib3MFResource_PackagePartFunc := LoadFunction('lib3mf_resource_packagepart');
		FLib3MFResource_SetPackagePartFunc := LoadFunction('lib3mf_resource_setpackagepart');
		FLib3MFResource_GetModelResourceIDFunc := LoadFunction('lib3mf_resource_getmodelresourceid');
		FLib3MFResourceIterator_MoveNextFunc := LoadFunction('lib3mf_resourceiterator_movenext');
		FLib3MFResourceIterator_MovePreviousFunc := LoadFunction('lib3mf_resourceiterator_moveprevious');
		FLib3MFResourceIterator_GetCurrentFunc := LoadFunction('lib3mf_resourceiterator_getcurrent');
		FLib3MFResourceIterator_CloneFunc := LoadFunction('lib3mf_resourceiterator_clone');
		FLib3MFResourceIterator_CountFunc := LoadFunction('lib3mf_resourceiterator_count');
		FLib3MFSliceStackIterator_GetCurrentSliceStackFunc := LoadFunction('lib3mf_slicestackiterator_getcurrentslicestack');
		FLib3MFObjectIterator_GetCurrentObjectFunc := LoadFunction('lib3mf_objectiterator_getcurrentobject');
		FLib3MFMeshObjectIterator_GetCurrentMeshObjectFunc := LoadFunction('lib3mf_meshobjectiterator_getcurrentmeshobject');
		FLib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc := LoadFunction('lib3mf_componentsobjectiterator_getcurrentcomponentsobject');
		FLib3MFTexture2DIterator_GetCurrentTexture2DFunc := LoadFunction('lib3mf_texture2diterator_getcurrenttexture2d');
		FLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc := LoadFunction('lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup');
		FLib3MFColorGroupIterator_GetCurrentColorGroupFunc := LoadFunction('lib3mf_colorgroupiterator_getcurrentcolorgroup');
		FLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc := LoadFunction('lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup');
		FLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc := LoadFunction('lib3mf_compositematerialsiterator_getcurrentcompositematerials');
		FLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc := LoadFunction('lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup');
		FLib3MFMetaData_GetNameSpaceFunc := LoadFunction('lib3mf_metadata_getnamespace');
		FLib3MFMetaData_SetNameSpaceFunc := LoadFunction('lib3mf_metadata_setnamespace');
		FLib3MFMetaData_GetNameFunc := LoadFunction('lib3mf_metadata_getname');
		FLib3MFMetaData_SetNameFunc := LoadFunction('lib3mf_metadata_setname');
		FLib3MFMetaData_GetKeyFunc := LoadFunction('lib3mf_metadata_getkey');
		FLib3MFMetaData_GetMustPreserveFunc := LoadFunction('lib3mf_metadata_getmustpreserve');
		FLib3MFMetaData_SetMustPreserveFunc := LoadFunction('lib3mf_metadata_setmustpreserve');
		FLib3MFMetaData_GetTypeFunc := LoadFunction('lib3mf_metadata_gettype');
		FLib3MFMetaData_SetTypeFunc := LoadFunction('lib3mf_metadata_settype');
		FLib3MFMetaData_GetValueFunc := LoadFunction('lib3mf_metadata_getvalue');
		FLib3MFMetaData_SetValueFunc := LoadFunction('lib3mf_metadata_setvalue');
		FLib3MFMetaDataGroup_GetMetaDataCountFunc := LoadFunction('lib3mf_metadatagroup_getmetadatacount');
		FLib3MFMetaDataGroup_GetMetaDataFunc := LoadFunction('lib3mf_metadatagroup_getmetadata');
		FLib3MFMetaDataGroup_GetMetaDataByKeyFunc := LoadFunction('lib3mf_metadatagroup_getmetadatabykey');
		FLib3MFMetaDataGroup_RemoveMetaDataByIndexFunc := LoadFunction('lib3mf_metadatagroup_removemetadatabyindex');
		FLib3MFMetaDataGroup_RemoveMetaDataFunc := LoadFunction('lib3mf_metadatagroup_removemetadata');
		FLib3MFMetaDataGroup_AddMetaDataFunc := LoadFunction('lib3mf_metadatagroup_addmetadata');
		FLib3MFObject_GetTypeFunc := LoadFunction('lib3mf_object_gettype');
		FLib3MFObject_SetTypeFunc := LoadFunction('lib3mf_object_settype');
		FLib3MFObject_GetNameFunc := LoadFunction('lib3mf_object_getname');
		FLib3MFObject_SetNameFunc := LoadFunction('lib3mf_object_setname');
		FLib3MFObject_GetPartNumberFunc := LoadFunction('lib3mf_object_getpartnumber');
		FLib3MFObject_SetPartNumberFunc := LoadFunction('lib3mf_object_setpartnumber');
		FLib3MFObject_IsMeshObjectFunc := LoadFunction('lib3mf_object_ismeshobject');
		FLib3MFObject_IsComponentsObjectFunc := LoadFunction('lib3mf_object_iscomponentsobject');
		FLib3MFObject_IsValidFunc := LoadFunction('lib3mf_object_isvalid');
		FLib3MFObject_SetAttachmentAsThumbnailFunc := LoadFunction('lib3mf_object_setattachmentasthumbnail');
		FLib3MFObject_GetThumbnailAttachmentFunc := LoadFunction('lib3mf_object_getthumbnailattachment');
		FLib3MFObject_ClearThumbnailAttachmentFunc := LoadFunction('lib3mf_object_clearthumbnailattachment');
		FLib3MFObject_GetOutboxFunc := LoadFunction('lib3mf_object_getoutbox');
		FLib3MFObject_GetUUIDFunc := LoadFunction('lib3mf_object_getuuid');
		FLib3MFObject_SetUUIDFunc := LoadFunction('lib3mf_object_setuuid');
		FLib3MFObject_GetMetaDataGroupFunc := LoadFunction('lib3mf_object_getmetadatagroup');
		FLib3MFObject_SetSlicesMeshResolutionFunc := LoadFunction('lib3mf_object_setslicesmeshresolution');
		FLib3MFObject_GetSlicesMeshResolutionFunc := LoadFunction('lib3mf_object_getslicesmeshresolution');
		FLib3MFObject_HasSlicesFunc := LoadFunction('lib3mf_object_hasslices');
		FLib3MFObject_ClearSliceStackFunc := LoadFunction('lib3mf_object_clearslicestack');
		FLib3MFObject_GetSliceStackFunc := LoadFunction('lib3mf_object_getslicestack');
		FLib3MFObject_AssignSliceStackFunc := LoadFunction('lib3mf_object_assignslicestack');
		FLib3MFMeshObject_GetVertexCountFunc := LoadFunction('lib3mf_meshobject_getvertexcount');
		FLib3MFMeshObject_GetTriangleCountFunc := LoadFunction('lib3mf_meshobject_gettrianglecount');
		FLib3MFMeshObject_GetVertexFunc := LoadFunction('lib3mf_meshobject_getvertex');
		FLib3MFMeshObject_SetVertexFunc := LoadFunction('lib3mf_meshobject_setvertex');
		FLib3MFMeshObject_AddVertexFunc := LoadFunction('lib3mf_meshobject_addvertex');
		FLib3MFMeshObject_GetVerticesFunc := LoadFunction('lib3mf_meshobject_getvertices');
		FLib3MFMeshObject_GetTriangleFunc := LoadFunction('lib3mf_meshobject_gettriangle');
		FLib3MFMeshObject_SetTriangleFunc := LoadFunction('lib3mf_meshobject_settriangle');
		FLib3MFMeshObject_AddTriangleFunc := LoadFunction('lib3mf_meshobject_addtriangle');
		FLib3MFMeshObject_GetTriangleIndicesFunc := LoadFunction('lib3mf_meshobject_gettriangleindices');
		FLib3MFMeshObject_SetObjectLevelPropertyFunc := LoadFunction('lib3mf_meshobject_setobjectlevelproperty');
		FLib3MFMeshObject_GetObjectLevelPropertyFunc := LoadFunction('lib3mf_meshobject_getobjectlevelproperty');
		FLib3MFMeshObject_SetTrianglePropertiesFunc := LoadFunction('lib3mf_meshobject_settriangleproperties');
		FLib3MFMeshObject_GetTrianglePropertiesFunc := LoadFunction('lib3mf_meshobject_gettriangleproperties');
		FLib3MFMeshObject_SetAllTrianglePropertiesFunc := LoadFunction('lib3mf_meshobject_setalltriangleproperties');
		FLib3MFMeshObject_GetAllTrianglePropertiesFunc := LoadFunction('lib3mf_meshobject_getalltriangleproperties');
		FLib3MFMeshObject_ClearAllPropertiesFunc := LoadFunction('lib3mf_meshobject_clearallproperties');
		FLib3MFMeshObject_SetGeometryFunc := LoadFunction('lib3mf_meshobject_setgeometry');
		FLib3MFMeshObject_IsManifoldAndOrientedFunc := LoadFunction('lib3mf_meshobject_ismanifoldandoriented');
		FLib3MFMeshObject_BeamLatticeFunc := LoadFunction('lib3mf_meshobject_beamlattice');
		FLib3MFBeamLattice_GetMinLengthFunc := LoadFunction('lib3mf_beamlattice_getminlength');
		FLib3MFBeamLattice_SetMinLengthFunc := LoadFunction('lib3mf_beamlattice_setminlength');
		FLib3MFBeamLattice_GetClippingFunc := LoadFunction('lib3mf_beamlattice_getclipping');
		FLib3MFBeamLattice_SetClippingFunc := LoadFunction('lib3mf_beamlattice_setclipping');
		FLib3MFBeamLattice_GetRepresentationFunc := LoadFunction('lib3mf_beamlattice_getrepresentation');
		FLib3MFBeamLattice_SetRepresentationFunc := LoadFunction('lib3mf_beamlattice_setrepresentation');
		FLib3MFBeamLattice_GetBallOptionsFunc := LoadFunction('lib3mf_beamlattice_getballoptions');
		FLib3MFBeamLattice_SetBallOptionsFunc := LoadFunction('lib3mf_beamlattice_setballoptions');
		FLib3MFBeamLattice_GetBeamCountFunc := LoadFunction('lib3mf_beamlattice_getbeamcount');
		FLib3MFBeamLattice_GetBeamFunc := LoadFunction('lib3mf_beamlattice_getbeam');
		FLib3MFBeamLattice_AddBeamFunc := LoadFunction('lib3mf_beamlattice_addbeam');
		FLib3MFBeamLattice_SetBeamFunc := LoadFunction('lib3mf_beamlattice_setbeam');
		FLib3MFBeamLattice_SetBeamsFunc := LoadFunction('lib3mf_beamlattice_setbeams');
		FLib3MFBeamLattice_GetBeamsFunc := LoadFunction('lib3mf_beamlattice_getbeams');
		FLib3MFBeamLattice_GetBallCountFunc := LoadFunction('lib3mf_beamlattice_getballcount');
		FLib3MFBeamLattice_GetBallFunc := LoadFunction('lib3mf_beamlattice_getball');
		FLib3MFBeamLattice_AddBallFunc := LoadFunction('lib3mf_beamlattice_addball');
		FLib3MFBeamLattice_SetBallFunc := LoadFunction('lib3mf_beamlattice_setball');
		FLib3MFBeamLattice_SetBallsFunc := LoadFunction('lib3mf_beamlattice_setballs');
		FLib3MFBeamLattice_GetBallsFunc := LoadFunction('lib3mf_beamlattice_getballs');
		FLib3MFBeamLattice_GetBeamSetCountFunc := LoadFunction('lib3mf_beamlattice_getbeamsetcount');
		FLib3MFBeamLattice_AddBeamSetFunc := LoadFunction('lib3mf_beamlattice_addbeamset');
		FLib3MFBeamLattice_GetBeamSetFunc := LoadFunction('lib3mf_beamlattice_getbeamset');
		FLib3MFComponent_GetObjectResourceFunc := LoadFunction('lib3mf_component_getobjectresource');
		FLib3MFComponent_GetObjectResourceIDFunc := LoadFunction('lib3mf_component_getobjectresourceid');
		FLib3MFComponent_GetUUIDFunc := LoadFunction('lib3mf_component_getuuid');
		FLib3MFComponent_SetUUIDFunc := LoadFunction('lib3mf_component_setuuid');
		FLib3MFComponent_HasTransformFunc := LoadFunction('lib3mf_component_hastransform');
		FLib3MFComponent_GetTransformFunc := LoadFunction('lib3mf_component_gettransform');
		FLib3MFComponent_SetTransformFunc := LoadFunction('lib3mf_component_settransform');
		FLib3MFComponentsObject_AddComponentFunc := LoadFunction('lib3mf_componentsobject_addcomponent');
		FLib3MFComponentsObject_GetComponentFunc := LoadFunction('lib3mf_componentsobject_getcomponent');
		FLib3MFComponentsObject_GetComponentCountFunc := LoadFunction('lib3mf_componentsobject_getcomponentcount');
		FLib3MFBeamSet_SetNameFunc := LoadFunction('lib3mf_beamset_setname');
		FLib3MFBeamSet_GetNameFunc := LoadFunction('lib3mf_beamset_getname');
		FLib3MFBeamSet_SetIdentifierFunc := LoadFunction('lib3mf_beamset_setidentifier');
		FLib3MFBeamSet_GetIdentifierFunc := LoadFunction('lib3mf_beamset_getidentifier');
		FLib3MFBeamSet_GetReferenceCountFunc := LoadFunction('lib3mf_beamset_getreferencecount');
		FLib3MFBeamSet_SetReferencesFunc := LoadFunction('lib3mf_beamset_setreferences');
		FLib3MFBeamSet_GetReferencesFunc := LoadFunction('lib3mf_beamset_getreferences');
		FLib3MFBeamSet_GetBallReferenceCountFunc := LoadFunction('lib3mf_beamset_getballreferencecount');
		FLib3MFBeamSet_SetBallReferencesFunc := LoadFunction('lib3mf_beamset_setballreferences');
		FLib3MFBeamSet_GetBallReferencesFunc := LoadFunction('lib3mf_beamset_getballreferences');
		FLib3MFBaseMaterialGroup_GetCountFunc := LoadFunction('lib3mf_basematerialgroup_getcount');
		FLib3MFBaseMaterialGroup_GetAllPropertyIDsFunc := LoadFunction('lib3mf_basematerialgroup_getallpropertyids');
		FLib3MFBaseMaterialGroup_AddMaterialFunc := LoadFunction('lib3mf_basematerialgroup_addmaterial');
		FLib3MFBaseMaterialGroup_RemoveMaterialFunc := LoadFunction('lib3mf_basematerialgroup_removematerial');
		FLib3MFBaseMaterialGroup_GetNameFunc := LoadFunction('lib3mf_basematerialgroup_getname');
		FLib3MFBaseMaterialGroup_SetNameFunc := LoadFunction('lib3mf_basematerialgroup_setname');
		FLib3MFBaseMaterialGroup_SetDisplayColorFunc := LoadFunction('lib3mf_basematerialgroup_setdisplaycolor');
		FLib3MFBaseMaterialGroup_GetDisplayColorFunc := LoadFunction('lib3mf_basematerialgroup_getdisplaycolor');
		FLib3MFColorGroup_GetCountFunc := LoadFunction('lib3mf_colorgroup_getcount');
		FLib3MFColorGroup_GetAllPropertyIDsFunc := LoadFunction('lib3mf_colorgroup_getallpropertyids');
		FLib3MFColorGroup_AddColorFunc := LoadFunction('lib3mf_colorgroup_addcolor');
		FLib3MFColorGroup_RemoveColorFunc := LoadFunction('lib3mf_colorgroup_removecolor');
		FLib3MFColorGroup_SetColorFunc := LoadFunction('lib3mf_colorgroup_setcolor');
		FLib3MFColorGroup_GetColorFunc := LoadFunction('lib3mf_colorgroup_getcolor');
		FLib3MFTexture2DGroup_GetCountFunc := LoadFunction('lib3mf_texture2dgroup_getcount');
		FLib3MFTexture2DGroup_GetAllPropertyIDsFunc := LoadFunction('lib3mf_texture2dgroup_getallpropertyids');
		FLib3MFTexture2DGroup_AddTex2CoordFunc := LoadFunction('lib3mf_texture2dgroup_addtex2coord');
		FLib3MFTexture2DGroup_GetTex2CoordFunc := LoadFunction('lib3mf_texture2dgroup_gettex2coord');
		FLib3MFTexture2DGroup_RemoveTex2CoordFunc := LoadFunction('lib3mf_texture2dgroup_removetex2coord');
		FLib3MFTexture2DGroup_GetTexture2DFunc := LoadFunction('lib3mf_texture2dgroup_gettexture2d');
		FLib3MFCompositeMaterials_GetCountFunc := LoadFunction('lib3mf_compositematerials_getcount');
		FLib3MFCompositeMaterials_GetAllPropertyIDsFunc := LoadFunction('lib3mf_compositematerials_getallpropertyids');
		FLib3MFCompositeMaterials_GetBaseMaterialGroupFunc := LoadFunction('lib3mf_compositematerials_getbasematerialgroup');
		FLib3MFCompositeMaterials_AddCompositeFunc := LoadFunction('lib3mf_compositematerials_addcomposite');
		FLib3MFCompositeMaterials_RemoveCompositeFunc := LoadFunction('lib3mf_compositematerials_removecomposite');
		FLib3MFCompositeMaterials_GetCompositeFunc := LoadFunction('lib3mf_compositematerials_getcomposite');
		FLib3MFMultiPropertyGroup_GetCountFunc := LoadFunction('lib3mf_multipropertygroup_getcount');
		FLib3MFMultiPropertyGroup_GetAllPropertyIDsFunc := LoadFunction('lib3mf_multipropertygroup_getallpropertyids');
		FLib3MFMultiPropertyGroup_AddMultiPropertyFunc := LoadFunction('lib3mf_multipropertygroup_addmultiproperty');
		FLib3MFMultiPropertyGroup_SetMultiPropertyFunc := LoadFunction('lib3mf_multipropertygroup_setmultiproperty');
		FLib3MFMultiPropertyGroup_GetMultiPropertyFunc := LoadFunction('lib3mf_multipropertygroup_getmultiproperty');
		FLib3MFMultiPropertyGroup_RemoveMultiPropertyFunc := LoadFunction('lib3mf_multipropertygroup_removemultiproperty');
		FLib3MFMultiPropertyGroup_GetLayerCountFunc := LoadFunction('lib3mf_multipropertygroup_getlayercount');
		FLib3MFMultiPropertyGroup_AddLayerFunc := LoadFunction('lib3mf_multipropertygroup_addlayer');
		FLib3MFMultiPropertyGroup_GetLayerFunc := LoadFunction('lib3mf_multipropertygroup_getlayer');
		FLib3MFMultiPropertyGroup_RemoveLayerFunc := LoadFunction('lib3mf_multipropertygroup_removelayer');
		FLib3MFAttachment_GetPathFunc := LoadFunction('lib3mf_attachment_getpath');
		FLib3MFAttachment_SetPathFunc := LoadFunction('lib3mf_attachment_setpath');
		FLib3MFAttachment_PackagePartFunc := LoadFunction('lib3mf_attachment_packagepart');
		FLib3MFAttachment_GetRelationShipTypeFunc := LoadFunction('lib3mf_attachment_getrelationshiptype');
		FLib3MFAttachment_SetRelationShipTypeFunc := LoadFunction('lib3mf_attachment_setrelationshiptype');
		FLib3MFAttachment_WriteToFileFunc := LoadFunction('lib3mf_attachment_writetofile');
		FLib3MFAttachment_ReadFromFileFunc := LoadFunction('lib3mf_attachment_readfromfile');
		FLib3MFAttachment_ReadFromCallbackFunc := LoadFunction('lib3mf_attachment_readfromcallback');
		FLib3MFAttachment_GetStreamSizeFunc := LoadFunction('lib3mf_attachment_getstreamsize');
		FLib3MFAttachment_WriteToBufferFunc := LoadFunction('lib3mf_attachment_writetobuffer');
		FLib3MFAttachment_ReadFromBufferFunc := LoadFunction('lib3mf_attachment_readfrombuffer');
		FLib3MFTexture2D_GetAttachmentFunc := LoadFunction('lib3mf_texture2d_getattachment');
		FLib3MFTexture2D_SetAttachmentFunc := LoadFunction('lib3mf_texture2d_setattachment');
		FLib3MFTexture2D_GetContentTypeFunc := LoadFunction('lib3mf_texture2d_getcontenttype');
		FLib3MFTexture2D_SetContentTypeFunc := LoadFunction('lib3mf_texture2d_setcontenttype');
		FLib3MFTexture2D_GetTileStyleUVFunc := LoadFunction('lib3mf_texture2d_gettilestyleuv');
		FLib3MFTexture2D_SetTileStyleUVFunc := LoadFunction('lib3mf_texture2d_settilestyleuv');
		FLib3MFTexture2D_GetFilterFunc := LoadFunction('lib3mf_texture2d_getfilter');
		FLib3MFTexture2D_SetFilterFunc := LoadFunction('lib3mf_texture2d_setfilter');
		FLib3MFBuildItem_GetObjectResourceFunc := LoadFunction('lib3mf_builditem_getobjectresource');
		FLib3MFBuildItem_GetUUIDFunc := LoadFunction('lib3mf_builditem_getuuid');
		FLib3MFBuildItem_SetUUIDFunc := LoadFunction('lib3mf_builditem_setuuid');
		FLib3MFBuildItem_GetObjectResourceIDFunc := LoadFunction('lib3mf_builditem_getobjectresourceid');
		FLib3MFBuildItem_HasObjectTransformFunc := LoadFunction('lib3mf_builditem_hasobjecttransform');
		FLib3MFBuildItem_GetObjectTransformFunc := LoadFunction('lib3mf_builditem_getobjecttransform');
		FLib3MFBuildItem_SetObjectTransformFunc := LoadFunction('lib3mf_builditem_setobjecttransform');
		FLib3MFBuildItem_GetPartNumberFunc := LoadFunction('lib3mf_builditem_getpartnumber');
		FLib3MFBuildItem_SetPartNumberFunc := LoadFunction('lib3mf_builditem_setpartnumber');
		FLib3MFBuildItem_GetMetaDataGroupFunc := LoadFunction('lib3mf_builditem_getmetadatagroup');
		FLib3MFBuildItem_GetOutboxFunc := LoadFunction('lib3mf_builditem_getoutbox');
		FLib3MFBuildItemIterator_MoveNextFunc := LoadFunction('lib3mf_builditemiterator_movenext');
		FLib3MFBuildItemIterator_MovePreviousFunc := LoadFunction('lib3mf_builditemiterator_moveprevious');
		FLib3MFBuildItemIterator_GetCurrentFunc := LoadFunction('lib3mf_builditemiterator_getcurrent');
		FLib3MFBuildItemIterator_CloneFunc := LoadFunction('lib3mf_builditemiterator_clone');
		FLib3MFBuildItemIterator_CountFunc := LoadFunction('lib3mf_builditemiterator_count');
		FLib3MFSlice_SetVerticesFunc := LoadFunction('lib3mf_slice_setvertices');
		FLib3MFSlice_GetVerticesFunc := LoadFunction('lib3mf_slice_getvertices');
		FLib3MFSlice_GetVertexCountFunc := LoadFunction('lib3mf_slice_getvertexcount');
		FLib3MFSlice_AddPolygonFunc := LoadFunction('lib3mf_slice_addpolygon');
		FLib3MFSlice_GetPolygonCountFunc := LoadFunction('lib3mf_slice_getpolygoncount');
		FLib3MFSlice_SetPolygonIndicesFunc := LoadFunction('lib3mf_slice_setpolygonindices');
		FLib3MFSlice_GetPolygonIndicesFunc := LoadFunction('lib3mf_slice_getpolygonindices');
		FLib3MFSlice_GetPolygonIndexCountFunc := LoadFunction('lib3mf_slice_getpolygonindexcount');
		FLib3MFSlice_GetZTopFunc := LoadFunction('lib3mf_slice_getztop');
		FLib3MFSliceStack_GetBottomZFunc := LoadFunction('lib3mf_slicestack_getbottomz');
		FLib3MFSliceStack_GetSliceCountFunc := LoadFunction('lib3mf_slicestack_getslicecount');
		FLib3MFSliceStack_GetSliceFunc := LoadFunction('lib3mf_slicestack_getslice');
		FLib3MFSliceStack_AddSliceFunc := LoadFunction('lib3mf_slicestack_addslice');
		FLib3MFSliceStack_GetSliceRefCountFunc := LoadFunction('lib3mf_slicestack_getslicerefcount');
		FLib3MFSliceStack_AddSliceStackReferenceFunc := LoadFunction('lib3mf_slicestack_addslicestackreference');
		FLib3MFSliceStack_GetSliceStackReferenceFunc := LoadFunction('lib3mf_slicestack_getslicestackreference');
		FLib3MFSliceStack_CollapseSliceReferencesFunc := LoadFunction('lib3mf_slicestack_collapseslicereferences');
		FLib3MFSliceStack_SetOwnPathFunc := LoadFunction('lib3mf_slicestack_setownpath');
		FLib3MFSliceStack_GetOwnPathFunc := LoadFunction('lib3mf_slicestack_getownpath');
		FLib3MFConsumer_GetConsumerIDFunc := LoadFunction('lib3mf_consumer_getconsumerid');
		FLib3MFConsumer_GetKeyIDFunc := LoadFunction('lib3mf_consumer_getkeyid');
		FLib3MFConsumer_GetKeyValueFunc := LoadFunction('lib3mf_consumer_getkeyvalue');
		FLib3MFAccessRight_GetConsumerFunc := LoadFunction('lib3mf_accessright_getconsumer');
		FLib3MFAccessRight_GetWrappingAlgorithmFunc := LoadFunction('lib3mf_accessright_getwrappingalgorithm');
		FLib3MFAccessRight_GetMgfAlgorithmFunc := LoadFunction('lib3mf_accessright_getmgfalgorithm');
		FLib3MFAccessRight_GetDigestMethodFunc := LoadFunction('lib3mf_accessright_getdigestmethod');
		FLib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc := LoadFunction('lib3mf_contentencryptionparams_getencryptionalgorithm');
		FLib3MFContentEncryptionParams_GetKeyFunc := LoadFunction('lib3mf_contentencryptionparams_getkey');
		FLib3MFContentEncryptionParams_GetInitializationVectorFunc := LoadFunction('lib3mf_contentencryptionparams_getinitializationvector');
		FLib3MFContentEncryptionParams_GetAuthenticationTagFunc := LoadFunction('lib3mf_contentencryptionparams_getauthenticationtag');
		FLib3MFContentEncryptionParams_SetAuthenticationTagFunc := LoadFunction('lib3mf_contentencryptionparams_setauthenticationtag');
		FLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc := LoadFunction('lib3mf_contentencryptionparams_getadditionalauthenticationdata');
		FLib3MFContentEncryptionParams_GetDescriptorFunc := LoadFunction('lib3mf_contentencryptionparams_getdescriptor');
		FLib3MFContentEncryptionParams_GetKeyUUIDFunc := LoadFunction('lib3mf_contentencryptionparams_getkeyuuid');
		FLib3MFResourceData_GetPathFunc := LoadFunction('lib3mf_resourcedata_getpath');
		FLib3MFResourceData_GetEncryptionAlgorithmFunc := LoadFunction('lib3mf_resourcedata_getencryptionalgorithm');
		FLib3MFResourceData_GetCompressionFunc := LoadFunction('lib3mf_resourcedata_getcompression');
		FLib3MFResourceData_GetAdditionalAuthenticationDataFunc := LoadFunction('lib3mf_resourcedata_getadditionalauthenticationdata');
		FLib3MFResourceDataGroup_GetKeyUUIDFunc := LoadFunction('lib3mf_resourcedatagroup_getkeyuuid');
		FLib3MFResourceDataGroup_AddAccessRightFunc := LoadFunction('lib3mf_resourcedatagroup_addaccessright');
		FLib3MFResourceDataGroup_FindAccessRightByConsumerFunc := LoadFunction('lib3mf_resourcedatagroup_findaccessrightbyconsumer');
		FLib3MFResourceDataGroup_RemoveAccessRightFunc := LoadFunction('lib3mf_resourcedatagroup_removeaccessright');
		FLib3MFKeyStore_AddConsumerFunc := LoadFunction('lib3mf_keystore_addconsumer');
		FLib3MFKeyStore_GetConsumerCountFunc := LoadFunction('lib3mf_keystore_getconsumercount');
		FLib3MFKeyStore_GetConsumerFunc := LoadFunction('lib3mf_keystore_getconsumer');
		FLib3MFKeyStore_RemoveConsumerFunc := LoadFunction('lib3mf_keystore_removeconsumer');
		FLib3MFKeyStore_FindConsumerFunc := LoadFunction('lib3mf_keystore_findconsumer');
		FLib3MFKeyStore_GetResourceDataGroupCountFunc := LoadFunction('lib3mf_keystore_getresourcedatagroupcount');
		FLib3MFKeyStore_AddResourceDataGroupFunc := LoadFunction('lib3mf_keystore_addresourcedatagroup');
		FLib3MFKeyStore_GetResourceDataGroupFunc := LoadFunction('lib3mf_keystore_getresourcedatagroup');
		FLib3MFKeyStore_RemoveResourceDataGroupFunc := LoadFunction('lib3mf_keystore_removeresourcedatagroup');
		FLib3MFKeyStore_FindResourceDataGroupFunc := LoadFunction('lib3mf_keystore_findresourcedatagroup');
		FLib3MFKeyStore_AddResourceDataFunc := LoadFunction('lib3mf_keystore_addresourcedata');
		FLib3MFKeyStore_RemoveResourceDataFunc := LoadFunction('lib3mf_keystore_removeresourcedata');
		FLib3MFKeyStore_FindResourceDataFunc := LoadFunction('lib3mf_keystore_findresourcedata');
		FLib3MFKeyStore_GetResourceDataCountFunc := LoadFunction('lib3mf_keystore_getresourcedatacount');
		FLib3MFKeyStore_GetResourceDataFunc := LoadFunction('lib3mf_keystore_getresourcedata');
		FLib3MFKeyStore_GetUUIDFunc := LoadFunction('lib3mf_keystore_getuuid');
		FLib3MFKeyStore_SetUUIDFunc := LoadFunction('lib3mf_keystore_setuuid');
		FLib3MFModel_RootModelPartFunc := LoadFunction('lib3mf_model_rootmodelpart');
		FLib3MFModel_FindOrCreatePackagePartFunc := LoadFunction('lib3mf_model_findorcreatepackagepart');
		FLib3MFModel_SetUnitFunc := LoadFunction('lib3mf_model_setunit');
		FLib3MFModel_GetUnitFunc := LoadFunction('lib3mf_model_getunit');
		FLib3MFModel_GetLanguageFunc := LoadFunction('lib3mf_model_getlanguage');
		FLib3MFModel_SetLanguageFunc := LoadFunction('lib3mf_model_setlanguage');
		FLib3MFModel_QueryWriterFunc := LoadFunction('lib3mf_model_querywriter');
		FLib3MFModel_QueryReaderFunc := LoadFunction('lib3mf_model_queryreader');
		FLib3MFModel_GetResourceByIDFunc := LoadFunction('lib3mf_model_getresourcebyid');
		FLib3MFModel_GetTexture2DByIDFunc := LoadFunction('lib3mf_model_gettexture2dbyid');
		FLib3MFModel_GetPropertyTypeByIDFunc := LoadFunction('lib3mf_model_getpropertytypebyid');
		FLib3MFModel_GetBaseMaterialGroupByIDFunc := LoadFunction('lib3mf_model_getbasematerialgroupbyid');
		FLib3MFModel_GetTexture2DGroupByIDFunc := LoadFunction('lib3mf_model_gettexture2dgroupbyid');
		FLib3MFModel_GetCompositeMaterialsByIDFunc := LoadFunction('lib3mf_model_getcompositematerialsbyid');
		FLib3MFModel_GetMultiPropertyGroupByIDFunc := LoadFunction('lib3mf_model_getmultipropertygroupbyid');
		FLib3MFModel_GetMeshObjectByIDFunc := LoadFunction('lib3mf_model_getmeshobjectbyid');
		FLib3MFModel_GetComponentsObjectByIDFunc := LoadFunction('lib3mf_model_getcomponentsobjectbyid');
		FLib3MFModel_GetColorGroupByIDFunc := LoadFunction('lib3mf_model_getcolorgroupbyid');
		FLib3MFModel_GetSliceStackByIDFunc := LoadFunction('lib3mf_model_getslicestackbyid');
		FLib3MFModel_GetBuildUUIDFunc := LoadFunction('lib3mf_model_getbuilduuid');
		FLib3MFModel_SetBuildUUIDFunc := LoadFunction('lib3mf_model_setbuilduuid');
		FLib3MFModel_GetBuildItemsFunc := LoadFunction('lib3mf_model_getbuilditems');
		FLib3MFModel_GetOutboxFunc := LoadFunction('lib3mf_model_getoutbox');
		FLib3MFModel_GetResourcesFunc := LoadFunction('lib3mf_model_getresources');
		FLib3MFModel_GetObjectsFunc := LoadFunction('lib3mf_model_getobjects');
		FLib3MFModel_GetMeshObjectsFunc := LoadFunction('lib3mf_model_getmeshobjects');
		FLib3MFModel_GetComponentsObjectsFunc := LoadFunction('lib3mf_model_getcomponentsobjects');
		FLib3MFModel_GetTexture2DsFunc := LoadFunction('lib3mf_model_gettexture2ds');
		FLib3MFModel_GetBaseMaterialGroupsFunc := LoadFunction('lib3mf_model_getbasematerialgroups');
		FLib3MFModel_GetColorGroupsFunc := LoadFunction('lib3mf_model_getcolorgroups');
		FLib3MFModel_GetTexture2DGroupsFunc := LoadFunction('lib3mf_model_gettexture2dgroups');
		FLib3MFModel_GetCompositeMaterialsFunc := LoadFunction('lib3mf_model_getcompositematerials');
		FLib3MFModel_GetMultiPropertyGroupsFunc := LoadFunction('lib3mf_model_getmultipropertygroups');
		FLib3MFModel_GetSliceStacksFunc := LoadFunction('lib3mf_model_getslicestacks');
		FLib3MFModel_MergeToModelFunc := LoadFunction('lib3mf_model_mergetomodel');
		FLib3MFModel_AddMeshObjectFunc := LoadFunction('lib3mf_model_addmeshobject');
		FLib3MFModel_AddComponentsObjectFunc := LoadFunction('lib3mf_model_addcomponentsobject');
		FLib3MFModel_AddSliceStackFunc := LoadFunction('lib3mf_model_addslicestack');
		FLib3MFModel_AddTexture2DFromAttachmentFunc := LoadFunction('lib3mf_model_addtexture2dfromattachment');
		FLib3MFModel_AddBaseMaterialGroupFunc := LoadFunction('lib3mf_model_addbasematerialgroup');
		FLib3MFModel_AddColorGroupFunc := LoadFunction('lib3mf_model_addcolorgroup');
		FLib3MFModel_AddTexture2DGroupFunc := LoadFunction('lib3mf_model_addtexture2dgroup');
		FLib3MFModel_AddCompositeMaterialsFunc := LoadFunction('lib3mf_model_addcompositematerials');
		FLib3MFModel_AddMultiPropertyGroupFunc := LoadFunction('lib3mf_model_addmultipropertygroup');
		FLib3MFModel_AddBuildItemFunc := LoadFunction('lib3mf_model_addbuilditem');
		FLib3MFModel_RemoveBuildItemFunc := LoadFunction('lib3mf_model_removebuilditem');
		FLib3MFModel_GetMetaDataGroupFunc := LoadFunction('lib3mf_model_getmetadatagroup');
		FLib3MFModel_AddAttachmentFunc := LoadFunction('lib3mf_model_addattachment');
		FLib3MFModel_RemoveAttachmentFunc := LoadFunction('lib3mf_model_removeattachment');
		FLib3MFModel_GetAttachmentFunc := LoadFunction('lib3mf_model_getattachment');
		FLib3MFModel_FindAttachmentFunc := LoadFunction('lib3mf_model_findattachment');
		FLib3MFModel_GetAttachmentCountFunc := LoadFunction('lib3mf_model_getattachmentcount');
		FLib3MFModel_HasPackageThumbnailAttachmentFunc := LoadFunction('lib3mf_model_haspackagethumbnailattachment');
		FLib3MFModel_CreatePackageThumbnailAttachmentFunc := LoadFunction('lib3mf_model_createpackagethumbnailattachment');
		FLib3MFModel_GetPackageThumbnailAttachmentFunc := LoadFunction('lib3mf_model_getpackagethumbnailattachment');
		FLib3MFModel_RemovePackageThumbnailAttachmentFunc := LoadFunction('lib3mf_model_removepackagethumbnailattachment');
		FLib3MFModel_AddCustomContentTypeFunc := LoadFunction('lib3mf_model_addcustomcontenttype');
		FLib3MFModel_RemoveCustomContentTypeFunc := LoadFunction('lib3mf_model_removecustomcontenttype');
		FLib3MFModel_SetRandomNumberCallbackFunc := LoadFunction('lib3mf_model_setrandomnumbercallback');
		FLib3MFModel_GetKeyStoreFunc := LoadFunction('lib3mf_model_getkeystore');
		FLib3MFGetLibraryVersionFunc := LoadFunction('lib3mf_getlibraryversion');
		FLib3MFGetPrereleaseInformationFunc := LoadFunction('lib3mf_getprereleaseinformation');
		FLib3MFGetBuildInformationFunc := LoadFunction('lib3mf_getbuildinformation');
		FLib3MFGetSpecificationVersionFunc := LoadFunction('lib3mf_getspecificationversion');
		FLib3MFCreateModelFunc := LoadFunction('lib3mf_createmodel');
		FLib3MFReleaseFunc := LoadFunction('lib3mf_release');
		FLib3MFAcquireFunc := LoadFunction('lib3mf_acquire');
		FLib3MFSetJournalFunc := LoadFunction('lib3mf_setjournal');
		FLib3MFGetLastErrorFunc := LoadFunction('lib3mf_getlasterror');
		FLib3MFGetSymbolLookupMethodFunc := LoadFunction('lib3mf_getsymbollookupmethod');
		FLib3MFRetrieveProgressMessageFunc := LoadFunction('lib3mf_retrieveprogressmessage');
		FLib3MFRGBAToColorFunc := LoadFunction('lib3mf_rgbatocolor');
		FLib3MFFloatRGBAToColorFunc := LoadFunction('lib3mf_floatrgbatocolor');
		FLib3MFColorToRGBAFunc := LoadFunction('lib3mf_colortorgba');
		FLib3MFColorToFloatRGBAFunc := LoadFunction('lib3mf_colortofloatrgba');
		FLib3MFGetIdentityTransformFunc := LoadFunction('lib3mf_getidentitytransform');
		FLib3MFGetUniformScaleTransformFunc := LoadFunction('lib3mf_getuniformscaletransform');
		FLib3MFGetScaleTransformFunc := LoadFunction('lib3mf_getscaletransform');
		FLib3MFGetTranslationTransformFunc := LoadFunction('lib3mf_gettranslationtransform');
		
		checkBinaryVersion();
	end;

	constructor TLib3MFWrapper.CreateFromSymbolLookupMethod(ALookupMethod: TLib3MFSymbolLookupMethod);
	var
		AResult : TLib3MFResult;
	begin
		inherited Create;
		
		
		AResult := ALookupMethod(PAnsiChar('lib3mf_base_classtypeid'), @FLib3MFBase_ClassTypeIdFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_writetofile'), @FLib3MFWriter_WriteToFileFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_getstreamsize'), @FLib3MFWriter_GetStreamSizeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_writetobuffer'), @FLib3MFWriter_WriteToBufferFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_writetocallback'), @FLib3MFWriter_WriteToCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_setprogresscallback'), @FLib3MFWriter_SetProgressCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_getdecimalprecision'), @FLib3MFWriter_GetDecimalPrecisionFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_setdecimalprecision'), @FLib3MFWriter_SetDecimalPrecisionFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_setstrictmodeactive'), @FLib3MFWriter_SetStrictModeActiveFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_getstrictmodeactive'), @FLib3MFWriter_GetStrictModeActiveFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_getwarning'), @FLib3MFWriter_GetWarningFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_getwarningcount'), @FLib3MFWriter_GetWarningCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_addkeywrappingcallback'), @FLib3MFWriter_AddKeyWrappingCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_writer_setcontentencryptioncallback'), @FLib3MFWriter_SetContentEncryptionCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_readfromfile'), @FLib3MFReader_ReadFromFileFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_readfrombuffer'), @FLib3MFReader_ReadFromBufferFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_readfromcallback'), @FLib3MFReader_ReadFromCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_setprogresscallback'), @FLib3MFReader_SetProgressCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_addrelationtoread'), @FLib3MFReader_AddRelationToReadFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_removerelationtoread'), @FLib3MFReader_RemoveRelationToReadFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_setstrictmodeactive'), @FLib3MFReader_SetStrictModeActiveFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_getstrictmodeactive'), @FLib3MFReader_GetStrictModeActiveFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_getwarning'), @FLib3MFReader_GetWarningFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_getwarningcount'), @FLib3MFReader_GetWarningCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_addkeywrappingcallback'), @FLib3MFReader_AddKeyWrappingCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_reader_setcontentencryptioncallback'), @FLib3MFReader_SetContentEncryptionCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_packagepart_getpath'), @FLib3MFPackagePart_GetPathFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_packagepart_setpath'), @FLib3MFPackagePart_SetPathFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resource_getresourceid'), @FLib3MFResource_GetResourceIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resource_getuniqueresourceid'), @FLib3MFResource_GetUniqueResourceIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resource_packagepart'), @FLib3MFResource_PackagePartFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resource_setpackagepart'), @FLib3MFResource_SetPackagePartFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resource_getmodelresourceid'), @FLib3MFResource_GetModelResourceIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourceiterator_movenext'), @FLib3MFResourceIterator_MoveNextFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourceiterator_moveprevious'), @FLib3MFResourceIterator_MovePreviousFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourceiterator_getcurrent'), @FLib3MFResourceIterator_GetCurrentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourceiterator_clone'), @FLib3MFResourceIterator_CloneFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourceiterator_count'), @FLib3MFResourceIterator_CountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestackiterator_getcurrentslicestack'), @FLib3MFSliceStackIterator_GetCurrentSliceStackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_objectiterator_getcurrentobject'), @FLib3MFObjectIterator_GetCurrentObjectFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobjectiterator_getcurrentmeshobject'), @FLib3MFMeshObjectIterator_GetCurrentMeshObjectFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_componentsobjectiterator_getcurrentcomponentsobject'), @FLib3MFComponentsObjectIterator_GetCurrentComponentsObjectFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2diterator_getcurrenttexture2d'), @FLib3MFTexture2DIterator_GetCurrentTexture2DFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup'), @FLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colorgroupiterator_getcurrentcolorgroup'), @FLib3MFColorGroupIterator_GetCurrentColorGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup'), @FLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_compositematerialsiterator_getcurrentcompositematerials'), @FLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup'), @FLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_getnamespace'), @FLib3MFMetaData_GetNameSpaceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_setnamespace'), @FLib3MFMetaData_SetNameSpaceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_getname'), @FLib3MFMetaData_GetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_setname'), @FLib3MFMetaData_SetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_getkey'), @FLib3MFMetaData_GetKeyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_getmustpreserve'), @FLib3MFMetaData_GetMustPreserveFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_setmustpreserve'), @FLib3MFMetaData_SetMustPreserveFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_gettype'), @FLib3MFMetaData_GetTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_settype'), @FLib3MFMetaData_SetTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_getvalue'), @FLib3MFMetaData_GetValueFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadata_setvalue'), @FLib3MFMetaData_SetValueFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadatagroup_getmetadatacount'), @FLib3MFMetaDataGroup_GetMetaDataCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadatagroup_getmetadata'), @FLib3MFMetaDataGroup_GetMetaDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadatagroup_getmetadatabykey'), @FLib3MFMetaDataGroup_GetMetaDataByKeyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadatagroup_removemetadatabyindex'), @FLib3MFMetaDataGroup_RemoveMetaDataByIndexFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadatagroup_removemetadata'), @FLib3MFMetaDataGroup_RemoveMetaDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_metadatagroup_addmetadata'), @FLib3MFMetaDataGroup_AddMetaDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_gettype'), @FLib3MFObject_GetTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_settype'), @FLib3MFObject_SetTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getname'), @FLib3MFObject_GetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_setname'), @FLib3MFObject_SetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getpartnumber'), @FLib3MFObject_GetPartNumberFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_setpartnumber'), @FLib3MFObject_SetPartNumberFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_ismeshobject'), @FLib3MFObject_IsMeshObjectFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_iscomponentsobject'), @FLib3MFObject_IsComponentsObjectFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_isvalid'), @FLib3MFObject_IsValidFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_setattachmentasthumbnail'), @FLib3MFObject_SetAttachmentAsThumbnailFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getthumbnailattachment'), @FLib3MFObject_GetThumbnailAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_clearthumbnailattachment'), @FLib3MFObject_ClearThumbnailAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getoutbox'), @FLib3MFObject_GetOutboxFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getuuid'), @FLib3MFObject_GetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_setuuid'), @FLib3MFObject_SetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getmetadatagroup'), @FLib3MFObject_GetMetaDataGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_setslicesmeshresolution'), @FLib3MFObject_SetSlicesMeshResolutionFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getslicesmeshresolution'), @FLib3MFObject_GetSlicesMeshResolutionFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_hasslices'), @FLib3MFObject_HasSlicesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_clearslicestack'), @FLib3MFObject_ClearSliceStackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_getslicestack'), @FLib3MFObject_GetSliceStackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_object_assignslicestack'), @FLib3MFObject_AssignSliceStackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_getvertexcount'), @FLib3MFMeshObject_GetVertexCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_gettrianglecount'), @FLib3MFMeshObject_GetTriangleCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_getvertex'), @FLib3MFMeshObject_GetVertexFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_setvertex'), @FLib3MFMeshObject_SetVertexFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_addvertex'), @FLib3MFMeshObject_AddVertexFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_getvertices'), @FLib3MFMeshObject_GetVerticesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_gettriangle'), @FLib3MFMeshObject_GetTriangleFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_settriangle'), @FLib3MFMeshObject_SetTriangleFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_addtriangle'), @FLib3MFMeshObject_AddTriangleFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_gettriangleindices'), @FLib3MFMeshObject_GetTriangleIndicesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_setobjectlevelproperty'), @FLib3MFMeshObject_SetObjectLevelPropertyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_getobjectlevelproperty'), @FLib3MFMeshObject_GetObjectLevelPropertyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_settriangleproperties'), @FLib3MFMeshObject_SetTrianglePropertiesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_gettriangleproperties'), @FLib3MFMeshObject_GetTrianglePropertiesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_setalltriangleproperties'), @FLib3MFMeshObject_SetAllTrianglePropertiesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_getalltriangleproperties'), @FLib3MFMeshObject_GetAllTrianglePropertiesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_clearallproperties'), @FLib3MFMeshObject_ClearAllPropertiesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_setgeometry'), @FLib3MFMeshObject_SetGeometryFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_ismanifoldandoriented'), @FLib3MFMeshObject_IsManifoldAndOrientedFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_meshobject_beamlattice'), @FLib3MFMeshObject_BeamLatticeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getminlength'), @FLib3MFBeamLattice_GetMinLengthFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setminlength'), @FLib3MFBeamLattice_SetMinLengthFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getclipping'), @FLib3MFBeamLattice_GetClippingFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setclipping'), @FLib3MFBeamLattice_SetClippingFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getrepresentation'), @FLib3MFBeamLattice_GetRepresentationFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setrepresentation'), @FLib3MFBeamLattice_SetRepresentationFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getballoptions'), @FLib3MFBeamLattice_GetBallOptionsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setballoptions'), @FLib3MFBeamLattice_SetBallOptionsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getbeamcount'), @FLib3MFBeamLattice_GetBeamCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getbeam'), @FLib3MFBeamLattice_GetBeamFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_addbeam'), @FLib3MFBeamLattice_AddBeamFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setbeam'), @FLib3MFBeamLattice_SetBeamFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setbeams'), @FLib3MFBeamLattice_SetBeamsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getbeams'), @FLib3MFBeamLattice_GetBeamsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getballcount'), @FLib3MFBeamLattice_GetBallCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getball'), @FLib3MFBeamLattice_GetBallFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_addball'), @FLib3MFBeamLattice_AddBallFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setball'), @FLib3MFBeamLattice_SetBallFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_setballs'), @FLib3MFBeamLattice_SetBallsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getballs'), @FLib3MFBeamLattice_GetBallsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getbeamsetcount'), @FLib3MFBeamLattice_GetBeamSetCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_addbeamset'), @FLib3MFBeamLattice_AddBeamSetFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamlattice_getbeamset'), @FLib3MFBeamLattice_GetBeamSetFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_component_getobjectresource'), @FLib3MFComponent_GetObjectResourceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_component_getobjectresourceid'), @FLib3MFComponent_GetObjectResourceIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_component_getuuid'), @FLib3MFComponent_GetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_component_setuuid'), @FLib3MFComponent_SetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_component_hastransform'), @FLib3MFComponent_HasTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_component_gettransform'), @FLib3MFComponent_GetTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_component_settransform'), @FLib3MFComponent_SetTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_componentsobject_addcomponent'), @FLib3MFComponentsObject_AddComponentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_componentsobject_getcomponent'), @FLib3MFComponentsObject_GetComponentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_componentsobject_getcomponentcount'), @FLib3MFComponentsObject_GetComponentCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_setname'), @FLib3MFBeamSet_SetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_getname'), @FLib3MFBeamSet_GetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_setidentifier'), @FLib3MFBeamSet_SetIdentifierFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_getidentifier'), @FLib3MFBeamSet_GetIdentifierFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_getreferencecount'), @FLib3MFBeamSet_GetReferenceCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_setreferences'), @FLib3MFBeamSet_SetReferencesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_getreferences'), @FLib3MFBeamSet_GetReferencesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_getballreferencecount'), @FLib3MFBeamSet_GetBallReferenceCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_setballreferences'), @FLib3MFBeamSet_SetBallReferencesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_beamset_getballreferences'), @FLib3MFBeamSet_GetBallReferencesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_getcount'), @FLib3MFBaseMaterialGroup_GetCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_getallpropertyids'), @FLib3MFBaseMaterialGroup_GetAllPropertyIDsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_addmaterial'), @FLib3MFBaseMaterialGroup_AddMaterialFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_removematerial'), @FLib3MFBaseMaterialGroup_RemoveMaterialFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_getname'), @FLib3MFBaseMaterialGroup_GetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_setname'), @FLib3MFBaseMaterialGroup_SetNameFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_setdisplaycolor'), @FLib3MFBaseMaterialGroup_SetDisplayColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_basematerialgroup_getdisplaycolor'), @FLib3MFBaseMaterialGroup_GetDisplayColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colorgroup_getcount'), @FLib3MFColorGroup_GetCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colorgroup_getallpropertyids'), @FLib3MFColorGroup_GetAllPropertyIDsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colorgroup_addcolor'), @FLib3MFColorGroup_AddColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colorgroup_removecolor'), @FLib3MFColorGroup_RemoveColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colorgroup_setcolor'), @FLib3MFColorGroup_SetColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colorgroup_getcolor'), @FLib3MFColorGroup_GetColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2dgroup_getcount'), @FLib3MFTexture2DGroup_GetCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2dgroup_getallpropertyids'), @FLib3MFTexture2DGroup_GetAllPropertyIDsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2dgroup_addtex2coord'), @FLib3MFTexture2DGroup_AddTex2CoordFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2dgroup_gettex2coord'), @FLib3MFTexture2DGroup_GetTex2CoordFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2dgroup_removetex2coord'), @FLib3MFTexture2DGroup_RemoveTex2CoordFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2dgroup_gettexture2d'), @FLib3MFTexture2DGroup_GetTexture2DFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_compositematerials_getcount'), @FLib3MFCompositeMaterials_GetCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_compositematerials_getallpropertyids'), @FLib3MFCompositeMaterials_GetAllPropertyIDsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_compositematerials_getbasematerialgroup'), @FLib3MFCompositeMaterials_GetBaseMaterialGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_compositematerials_addcomposite'), @FLib3MFCompositeMaterials_AddCompositeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_compositematerials_removecomposite'), @FLib3MFCompositeMaterials_RemoveCompositeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_compositematerials_getcomposite'), @FLib3MFCompositeMaterials_GetCompositeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_getcount'), @FLib3MFMultiPropertyGroup_GetCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_getallpropertyids'), @FLib3MFMultiPropertyGroup_GetAllPropertyIDsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_addmultiproperty'), @FLib3MFMultiPropertyGroup_AddMultiPropertyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_setmultiproperty'), @FLib3MFMultiPropertyGroup_SetMultiPropertyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_getmultiproperty'), @FLib3MFMultiPropertyGroup_GetMultiPropertyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_removemultiproperty'), @FLib3MFMultiPropertyGroup_RemoveMultiPropertyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_getlayercount'), @FLib3MFMultiPropertyGroup_GetLayerCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_addlayer'), @FLib3MFMultiPropertyGroup_AddLayerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_getlayer'), @FLib3MFMultiPropertyGroup_GetLayerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_multipropertygroup_removelayer'), @FLib3MFMultiPropertyGroup_RemoveLayerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_getpath'), @FLib3MFAttachment_GetPathFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_setpath'), @FLib3MFAttachment_SetPathFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_packagepart'), @FLib3MFAttachment_PackagePartFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_getrelationshiptype'), @FLib3MFAttachment_GetRelationShipTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_setrelationshiptype'), @FLib3MFAttachment_SetRelationShipTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_writetofile'), @FLib3MFAttachment_WriteToFileFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_readfromfile'), @FLib3MFAttachment_ReadFromFileFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_readfromcallback'), @FLib3MFAttachment_ReadFromCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_getstreamsize'), @FLib3MFAttachment_GetStreamSizeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_writetobuffer'), @FLib3MFAttachment_WriteToBufferFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_attachment_readfrombuffer'), @FLib3MFAttachment_ReadFromBufferFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_getattachment'), @FLib3MFTexture2D_GetAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_setattachment'), @FLib3MFTexture2D_SetAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_getcontenttype'), @FLib3MFTexture2D_GetContentTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_setcontenttype'), @FLib3MFTexture2D_SetContentTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_gettilestyleuv'), @FLib3MFTexture2D_GetTileStyleUVFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_settilestyleuv'), @FLib3MFTexture2D_SetTileStyleUVFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_getfilter'), @FLib3MFTexture2D_GetFilterFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_texture2d_setfilter'), @FLib3MFTexture2D_SetFilterFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_getobjectresource'), @FLib3MFBuildItem_GetObjectResourceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_getuuid'), @FLib3MFBuildItem_GetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_setuuid'), @FLib3MFBuildItem_SetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_getobjectresourceid'), @FLib3MFBuildItem_GetObjectResourceIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_hasobjecttransform'), @FLib3MFBuildItem_HasObjectTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_getobjecttransform'), @FLib3MFBuildItem_GetObjectTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_setobjecttransform'), @FLib3MFBuildItem_SetObjectTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_getpartnumber'), @FLib3MFBuildItem_GetPartNumberFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_setpartnumber'), @FLib3MFBuildItem_SetPartNumberFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_getmetadatagroup'), @FLib3MFBuildItem_GetMetaDataGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditem_getoutbox'), @FLib3MFBuildItem_GetOutboxFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditemiterator_movenext'), @FLib3MFBuildItemIterator_MoveNextFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditemiterator_moveprevious'), @FLib3MFBuildItemIterator_MovePreviousFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditemiterator_getcurrent'), @FLib3MFBuildItemIterator_GetCurrentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditemiterator_clone'), @FLib3MFBuildItemIterator_CloneFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_builditemiterator_count'), @FLib3MFBuildItemIterator_CountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_setvertices'), @FLib3MFSlice_SetVerticesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_getvertices'), @FLib3MFSlice_GetVerticesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_getvertexcount'), @FLib3MFSlice_GetVertexCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_addpolygon'), @FLib3MFSlice_AddPolygonFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_getpolygoncount'), @FLib3MFSlice_GetPolygonCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_setpolygonindices'), @FLib3MFSlice_SetPolygonIndicesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_getpolygonindices'), @FLib3MFSlice_GetPolygonIndicesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_getpolygonindexcount'), @FLib3MFSlice_GetPolygonIndexCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slice_getztop'), @FLib3MFSlice_GetZTopFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_getbottomz'), @FLib3MFSliceStack_GetBottomZFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_getslicecount'), @FLib3MFSliceStack_GetSliceCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_getslice'), @FLib3MFSliceStack_GetSliceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_addslice'), @FLib3MFSliceStack_AddSliceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_getslicerefcount'), @FLib3MFSliceStack_GetSliceRefCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_addslicestackreference'), @FLib3MFSliceStack_AddSliceStackReferenceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_getslicestackreference'), @FLib3MFSliceStack_GetSliceStackReferenceFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_collapseslicereferences'), @FLib3MFSliceStack_CollapseSliceReferencesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_setownpath'), @FLib3MFSliceStack_SetOwnPathFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_slicestack_getownpath'), @FLib3MFSliceStack_GetOwnPathFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_consumer_getconsumerid'), @FLib3MFConsumer_GetConsumerIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_consumer_getkeyid'), @FLib3MFConsumer_GetKeyIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_consumer_getkeyvalue'), @FLib3MFConsumer_GetKeyValueFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_accessright_getconsumer'), @FLib3MFAccessRight_GetConsumerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_accessright_getwrappingalgorithm'), @FLib3MFAccessRight_GetWrappingAlgorithmFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_accessright_getmgfalgorithm'), @FLib3MFAccessRight_GetMgfAlgorithmFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_accessright_getdigestmethod'), @FLib3MFAccessRight_GetDigestMethodFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_getencryptionalgorithm'), @FLib3MFContentEncryptionParams_GetEncryptionAlgorithmFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_getkey'), @FLib3MFContentEncryptionParams_GetKeyFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_getinitializationvector'), @FLib3MFContentEncryptionParams_GetInitializationVectorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_getauthenticationtag'), @FLib3MFContentEncryptionParams_GetAuthenticationTagFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_setauthenticationtag'), @FLib3MFContentEncryptionParams_SetAuthenticationTagFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_getadditionalauthenticationdata'), @FLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_getdescriptor'), @FLib3MFContentEncryptionParams_GetDescriptorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_contentencryptionparams_getkeyuuid'), @FLib3MFContentEncryptionParams_GetKeyUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedata_getpath'), @FLib3MFResourceData_GetPathFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedata_getencryptionalgorithm'), @FLib3MFResourceData_GetEncryptionAlgorithmFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedata_getcompression'), @FLib3MFResourceData_GetCompressionFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedata_getadditionalauthenticationdata'), @FLib3MFResourceData_GetAdditionalAuthenticationDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedatagroup_getkeyuuid'), @FLib3MFResourceDataGroup_GetKeyUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedatagroup_addaccessright'), @FLib3MFResourceDataGroup_AddAccessRightFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedatagroup_findaccessrightbyconsumer'), @FLib3MFResourceDataGroup_FindAccessRightByConsumerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_resourcedatagroup_removeaccessright'), @FLib3MFResourceDataGroup_RemoveAccessRightFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_addconsumer'), @FLib3MFKeyStore_AddConsumerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_getconsumercount'), @FLib3MFKeyStore_GetConsumerCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_getconsumer'), @FLib3MFKeyStore_GetConsumerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_removeconsumer'), @FLib3MFKeyStore_RemoveConsumerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_findconsumer'), @FLib3MFKeyStore_FindConsumerFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_getresourcedatagroupcount'), @FLib3MFKeyStore_GetResourceDataGroupCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_addresourcedatagroup'), @FLib3MFKeyStore_AddResourceDataGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_getresourcedatagroup'), @FLib3MFKeyStore_GetResourceDataGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_removeresourcedatagroup'), @FLib3MFKeyStore_RemoveResourceDataGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_findresourcedatagroup'), @FLib3MFKeyStore_FindResourceDataGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_addresourcedata'), @FLib3MFKeyStore_AddResourceDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_removeresourcedata'), @FLib3MFKeyStore_RemoveResourceDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_findresourcedata'), @FLib3MFKeyStore_FindResourceDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_getresourcedatacount'), @FLib3MFKeyStore_GetResourceDataCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_getresourcedata'), @FLib3MFKeyStore_GetResourceDataFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_getuuid'), @FLib3MFKeyStore_GetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_keystore_setuuid'), @FLib3MFKeyStore_SetUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_rootmodelpart'), @FLib3MFModel_RootModelPartFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_findorcreatepackagepart'), @FLib3MFModel_FindOrCreatePackagePartFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_setunit'), @FLib3MFModel_SetUnitFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getunit'), @FLib3MFModel_GetUnitFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getlanguage'), @FLib3MFModel_GetLanguageFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_setlanguage'), @FLib3MFModel_SetLanguageFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_querywriter'), @FLib3MFModel_QueryWriterFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_queryreader'), @FLib3MFModel_QueryReaderFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getresourcebyid'), @FLib3MFModel_GetResourceByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_gettexture2dbyid'), @FLib3MFModel_GetTexture2DByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getpropertytypebyid'), @FLib3MFModel_GetPropertyTypeByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getbasematerialgroupbyid'), @FLib3MFModel_GetBaseMaterialGroupByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_gettexture2dgroupbyid'), @FLib3MFModel_GetTexture2DGroupByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getcompositematerialsbyid'), @FLib3MFModel_GetCompositeMaterialsByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getmultipropertygroupbyid'), @FLib3MFModel_GetMultiPropertyGroupByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getmeshobjectbyid'), @FLib3MFModel_GetMeshObjectByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getcomponentsobjectbyid'), @FLib3MFModel_GetComponentsObjectByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getcolorgroupbyid'), @FLib3MFModel_GetColorGroupByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getslicestackbyid'), @FLib3MFModel_GetSliceStackByIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getbuilduuid'), @FLib3MFModel_GetBuildUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_setbuilduuid'), @FLib3MFModel_SetBuildUUIDFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getbuilditems'), @FLib3MFModel_GetBuildItemsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getoutbox'), @FLib3MFModel_GetOutboxFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getresources'), @FLib3MFModel_GetResourcesFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getobjects'), @FLib3MFModel_GetObjectsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getmeshobjects'), @FLib3MFModel_GetMeshObjectsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getcomponentsobjects'), @FLib3MFModel_GetComponentsObjectsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_gettexture2ds'), @FLib3MFModel_GetTexture2DsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getbasematerialgroups'), @FLib3MFModel_GetBaseMaterialGroupsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getcolorgroups'), @FLib3MFModel_GetColorGroupsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_gettexture2dgroups'), @FLib3MFModel_GetTexture2DGroupsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getcompositematerials'), @FLib3MFModel_GetCompositeMaterialsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getmultipropertygroups'), @FLib3MFModel_GetMultiPropertyGroupsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getslicestacks'), @FLib3MFModel_GetSliceStacksFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_mergetomodel'), @FLib3MFModel_MergeToModelFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addmeshobject'), @FLib3MFModel_AddMeshObjectFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addcomponentsobject'), @FLib3MFModel_AddComponentsObjectFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addslicestack'), @FLib3MFModel_AddSliceStackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addtexture2dfromattachment'), @FLib3MFModel_AddTexture2DFromAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addbasematerialgroup'), @FLib3MFModel_AddBaseMaterialGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addcolorgroup'), @FLib3MFModel_AddColorGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addtexture2dgroup'), @FLib3MFModel_AddTexture2DGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addcompositematerials'), @FLib3MFModel_AddCompositeMaterialsFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addmultipropertygroup'), @FLib3MFModel_AddMultiPropertyGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addbuilditem'), @FLib3MFModel_AddBuildItemFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_removebuilditem'), @FLib3MFModel_RemoveBuildItemFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getmetadatagroup'), @FLib3MFModel_GetMetaDataGroupFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addattachment'), @FLib3MFModel_AddAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_removeattachment'), @FLib3MFModel_RemoveAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getattachment'), @FLib3MFModel_GetAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_findattachment'), @FLib3MFModel_FindAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getattachmentcount'), @FLib3MFModel_GetAttachmentCountFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_haspackagethumbnailattachment'), @FLib3MFModel_HasPackageThumbnailAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_createpackagethumbnailattachment'), @FLib3MFModel_CreatePackageThumbnailAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getpackagethumbnailattachment'), @FLib3MFModel_GetPackageThumbnailAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_removepackagethumbnailattachment'), @FLib3MFModel_RemovePackageThumbnailAttachmentFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_addcustomcontenttype'), @FLib3MFModel_AddCustomContentTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_removecustomcontenttype'), @FLib3MFModel_RemoveCustomContentTypeFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_setrandomnumbercallback'), @FLib3MFModel_SetRandomNumberCallbackFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_model_getkeystore'), @FLib3MFModel_GetKeyStoreFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getlibraryversion'), @FLib3MFGetLibraryVersionFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getprereleaseinformation'), @FLib3MFGetPrereleaseInformationFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getbuildinformation'), @FLib3MFGetBuildInformationFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getspecificationversion'), @FLib3MFGetSpecificationVersionFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_createmodel'), @FLib3MFCreateModelFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_release'), @FLib3MFReleaseFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_acquire'), @FLib3MFAcquireFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_setjournal'), @FLib3MFSetJournalFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getlasterror'), @FLib3MFGetLastErrorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getsymbollookupmethod'), @FLib3MFGetSymbolLookupMethodFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_retrieveprogressmessage'), @FLib3MFRetrieveProgressMessageFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_rgbatocolor'), @FLib3MFRGBAToColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_floatrgbatocolor'), @FLib3MFFloatRGBAToColorFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colortorgba'), @FLib3MFColorToRGBAFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_colortofloatrgba'), @FLib3MFColorToFloatRGBAFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getidentitytransform'), @FLib3MFGetIdentityTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getuniformscaletransform'), @FLib3MFGetUniformScaleTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_getscaletransform'), @FLib3MFGetScaleTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		AResult := ALookupMethod(PAnsiChar('lib3mf_gettranslationtransform'), @FLib3MFGetTranslationTransformFunc);
		if AResult <> LIB3MF_SUCCESS then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTLOADLIBRARY, '');
		
		checkBinaryVersion();
	end;

	destructor TLib3MFWrapper.Destroy;
	begin
		{$IFDEF MSWINDOWS}
			if FModule <> 0 then
				FreeLibrary(FModule);
		{$ELSE}
			if FModule <> 0 then
				UnloadLibrary(FModule);
		{$ENDIF MSWINDOWS}
		inherited;
	end;

	procedure TLib3MFWrapper.CheckError(AInstance: TLib3MFBase; AErrorCode: TLib3MFResult);
	var
		AErrorMessage: String;
	begin
		if AInstance <> nil then begin
			if AInstance.FWrapper <> Self then
				raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDCAST, 'invalid wrapper call');
		end;
		if AErrorCode <> LIB3MF_SUCCESS then begin
			AErrorMessage := '';
			if Assigned(AInstance) then
				GetLastError(AInstance, AErrorMessage);
			raise ELib3MFException.Create(AErrorCode, AErrorMessage);
		end;
	end;

	{$IFDEF MSWINDOWS}
	function TLib3MFWrapper.LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean): FARPROC;
	begin
		Result := GetProcAddress(FModule, PAnsiChar(AFunctionName));
		if FailIfNotExistent and not Assigned(Result) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT, 'could not find function ' + AFunctionName);
	end;
	{$ELSE}
	function TLib3MFWrapper.LoadFunction(AFunctionName: AnsiString; FailIfNotExistent: Boolean): Pointer;
	begin
		Result := dynlibs.GetProcAddress(FModule, AFunctionName);
		if FailIfNotExistent and not Assigned(Result) then
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT, 'could not find function ' + AFunctionName);
	end;
	{$ENDIF MSWINDOWS}

	procedure TLib3MFWrapper.checkBinaryVersion();
	var
		AMajor, AMinor, AMicro: Cardinal;
	begin
		GetLibraryVersion(AMajor, AMinor, AMicro);
		if (AMajor <> LIB3MF_VERSION_MAJOR) or (AMinor < LIB3MF_VERSION_MINOR) then
			raise ELib3MFException.Create(LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION, '');
	end;
	
	procedure TLib3MFWrapper.GetLibraryVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
	begin
		CheckError(nil, Lib3MFGetLibraryVersionFunc(AMajor, AMinor, AMicro));
	end;

	function TLib3MFWrapper.GetPrereleaseInformation(out APrereleaseInfo: String): Boolean;
	var
		ResultHasPrereleaseInfo: Byte;
		bytesNeededPrereleaseInfo: Cardinal;
		bytesWrittenPrereleaseInfo: Cardinal;
		bufferPrereleaseInfo: array of Char;
	begin
		ResultHasPrereleaseInfo := 0;
		bytesNeededPrereleaseInfo:= 0;
		bytesWrittenPrereleaseInfo:= 0;
		CheckError(nil, Lib3MFGetPrereleaseInformationFunc(ResultHasPrereleaseInfo, 0, bytesNeededPrereleaseInfo, nil));
		SetLength(bufferPrereleaseInfo, bytesNeededPrereleaseInfo);
		CheckError(nil, Lib3MFGetPrereleaseInformationFunc(ResultHasPrereleaseInfo, bytesNeededPrereleaseInfo, bytesWrittenPrereleaseInfo, @bufferPrereleaseInfo[0]));
		Result := (ResultHasPrereleaseInfo <> 0);
		APrereleaseInfo := StrPas(@bufferPrereleaseInfo[0]);
	end;

	function TLib3MFWrapper.GetBuildInformation(out ABuildInformation: String): Boolean;
	var
		ResultHasBuildInfo: Byte;
		bytesNeededBuildInformation: Cardinal;
		bytesWrittenBuildInformation: Cardinal;
		bufferBuildInformation: array of Char;
	begin
		ResultHasBuildInfo := 0;
		bytesNeededBuildInformation:= 0;
		bytesWrittenBuildInformation:= 0;
		CheckError(nil, Lib3MFGetBuildInformationFunc(ResultHasBuildInfo, 0, bytesNeededBuildInformation, nil));
		SetLength(bufferBuildInformation, bytesNeededBuildInformation);
		CheckError(nil, Lib3MFGetBuildInformationFunc(ResultHasBuildInfo, bytesNeededBuildInformation, bytesWrittenBuildInformation, @bufferBuildInformation[0]));
		Result := (ResultHasBuildInfo <> 0);
		ABuildInformation := StrPas(@bufferBuildInformation[0]);
	end;

	procedure TLib3MFWrapper.GetSpecificationVersion(const ASpecificationURL: String; out AIsSupported: Boolean; out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
	var
		ResultIsSupported: Byte;
	begin
		ResultIsSupported := 0;
		CheckError(nil, Lib3MFGetSpecificationVersionFunc(PAnsiChar(ASpecificationURL), ResultIsSupported, AMajor, AMinor, AMicro));
		AIsSupported := ResultIsSupported <> 0;
	end;

	function TLib3MFWrapper.CreateModel(): TLib3MFModel;
	var
		HModel: TLib3MFHandle;
	begin
		Result := nil;
		HModel := nil;
		CheckError(nil, Lib3MFCreateModelFunc(HModel));
		if Assigned(HModel) then
			Result := TLib3MFPolymorphicFactory<TLib3MFModel, TLib3MFModel>.Make(Self, HModel);
	end;

	procedure TLib3MFWrapper.Release(const AInstance: TLib3MFBase);
	var
		AInstanceHandle: TLib3MFHandle;
	begin
		if Assigned(AInstance) then
		AInstanceHandle := AInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AInstance is a nil value.');
		CheckError(nil, Lib3MFReleaseFunc(AInstanceHandle));
	end;

	procedure TLib3MFWrapper.Acquire(const AInstance: TLib3MFBase);
	var
		AInstanceHandle: TLib3MFHandle;
	begin
		if Assigned(AInstance) then
		AInstanceHandle := AInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AInstance is a nil value.');
		CheckError(nil, Lib3MFAcquireFunc(AInstanceHandle));
	end;

	procedure TLib3MFWrapper.SetJournal(const AJournalPath: String);
	begin
		CheckError(nil, Lib3MFSetJournalFunc(PAnsiChar(AJournalPath)));
	end;

	function TLib3MFWrapper.GetLastError(const AInstance: TLib3MFBase; out ALastErrorString: String): Boolean;
	var
		AInstanceHandle: TLib3MFHandle;
		bytesNeededLastErrorString: Cardinal;
		bytesWrittenLastErrorString: Cardinal;
		bufferLastErrorString: array of Char;
		ResultHasLastError: Byte;
	begin
		if Assigned(AInstance) then
		AInstanceHandle := AInstance.TheHandle
		else
			raise ELib3MFException.CreateCustomMessage(LIB3MF_ERROR_INVALIDPARAM, 'AInstance is a nil value.');
		bytesNeededLastErrorString:= 0;
		bytesWrittenLastErrorString:= 0;
		ResultHasLastError := 0;
		CheckError(nil, Lib3MFGetLastErrorFunc(AInstanceHandle, 0, bytesNeededLastErrorString, nil, ResultHasLastError));
		SetLength(bufferLastErrorString, bytesNeededLastErrorString);
		CheckError(nil, Lib3MFGetLastErrorFunc(AInstanceHandle, bytesNeededLastErrorString, bytesWrittenLastErrorString, @bufferLastErrorString[0], ResultHasLastError));
		ALastErrorString := StrPas(@bufferLastErrorString[0]);
		Result := (ResultHasLastError <> 0);
	end;

	function TLib3MFWrapper.GetSymbolLookupMethod(): Pointer;
	begin
		CheckError(nil, Lib3MFGetSymbolLookupMethodFunc(Result));
	end;

	procedure TLib3MFWrapper.RetrieveProgressMessage(const ATheProgressIdentifier: TLib3MFProgressIdentifier; out AProgressMessage: String);
	var
		bytesNeededProgressMessage: Cardinal;
		bytesWrittenProgressMessage: Cardinal;
		bufferProgressMessage: array of Char;
	begin
		bytesNeededProgressMessage:= 0;
		bytesWrittenProgressMessage:= 0;
		CheckError(nil, Lib3MFRetrieveProgressMessageFunc(convertProgressIdentifierToConst(ATheProgressIdentifier), 0, bytesNeededProgressMessage, nil));
		SetLength(bufferProgressMessage, bytesNeededProgressMessage);
		CheckError(nil, Lib3MFRetrieveProgressMessageFunc(convertProgressIdentifierToConst(ATheProgressIdentifier), bytesNeededProgressMessage, bytesWrittenProgressMessage, @bufferProgressMessage[0]));
		AProgressMessage := StrPas(@bufferProgressMessage[0]);
	end;

	function TLib3MFWrapper.RGBAToColor(const ARed: Byte; const AGreen: Byte; const ABlue: Byte; const AAlpha: Byte): TLib3MFColor;
	begin
		CheckError(nil, Lib3MFRGBAToColorFunc(ARed, AGreen, ABlue, AAlpha, @Result));
	end;

	function TLib3MFWrapper.FloatRGBAToColor(const ARed: Single; const AGreen: Single; const ABlue: Single; const AAlpha: Single): TLib3MFColor;
	begin
		CheckError(nil, Lib3MFFloatRGBAToColorFunc(ARed, AGreen, ABlue, AAlpha, @Result));
	end;

	procedure TLib3MFWrapper.ColorToRGBA(const ATheColor: TLib3MFColor; out ARed: Byte; out AGreen: Byte; out ABlue: Byte; out AAlpha: Byte);
	begin
		CheckError(nil, Lib3MFColorToRGBAFunc(@ATheColor, ARed, AGreen, ABlue, AAlpha));
	end;

	procedure TLib3MFWrapper.ColorToFloatRGBA(const ATheColor: TLib3MFColor; out ARed: Single; out AGreen: Single; out ABlue: Single; out AAlpha: Single);
	begin
		CheckError(nil, Lib3MFColorToFloatRGBAFunc(@ATheColor, ARed, AGreen, ABlue, AAlpha));
	end;

	function TLib3MFWrapper.GetIdentityTransform(): TLib3MFTransform;
	begin
		CheckError(nil, Lib3MFGetIdentityTransformFunc(@Result));
	end;

	function TLib3MFWrapper.GetUniformScaleTransform(const AFactor: Single): TLib3MFTransform;
	begin
		CheckError(nil, Lib3MFGetUniformScaleTransformFunc(AFactor, @Result));
	end;

	function TLib3MFWrapper.GetScaleTransform(const AFactorX: Single; const AFactorY: Single; const AFactorZ: Single): TLib3MFTransform;
	begin
		CheckError(nil, Lib3MFGetScaleTransformFunc(AFactorX, AFactorY, AFactorZ, @Result));
	end;

	function TLib3MFWrapper.GetTranslationTransform(const AVectorX: Single; const AVectorY: Single; const AVectorZ: Single): TLib3MFTransform;
	begin
		CheckError(nil, Lib3MFGetTranslationTransformFunc(AVectorX, AVectorY, AVectorZ, @Result));
	end;


end.
