/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.metrics;

import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.neuralsearch.stats.common.StatSnapshot;
import org.opensearch.neuralsearch.stats.metrics.MetricStatName;

public class MemoryStatSnapshot
implements Writeable,
StatSnapshot<Double> {
    private final MetricStatName statName;
    private final boolean isAggregationMetric;
    private Double value;

    public MemoryStatSnapshot(StreamInput in) throws IOException {
        this.statName = (MetricStatName)in.readEnum(MetricStatName.class);
        this.isAggregationMetric = in.readBoolean();
        this.value = in.readDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.statName);
        out.writeBoolean(this.isAggregationMetric);
        out.writeDouble(this.value.doubleValue());
    }

    public static MemoryStatSnapshot aggregateMetricSnapshots(Collection<MemoryStatSnapshot> snapshots) throws IllegalArgumentException {
        if (snapshots == null || snapshots.isEmpty()) {
            return null;
        }
        MetricStatName name = null;
        double totalValue = 0.0;
        for (MemoryStatSnapshot stat : snapshots) {
            if (stat == null) continue;
            if (name == null) {
                name = stat.getStatName();
            } else if (name != stat.getStatName()) {
                throw new IllegalArgumentException("Should not aggregate snapshots across different stat names");
            }
            totalValue += stat.getValue().doubleValue();
        }
        return MemoryStatSnapshot.builder().statName(name).value(totalValue).build();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("value", this.value);
        builder.field("stat_type", this.statName == null ? null : this.statName.getStatType().getTypeString());
        builder.endObject();
        return builder;
    }

    @Generated
    public static MemoryStatSnapshotBuilder builder() {
        return new MemoryStatSnapshotBuilder();
    }

    @Generated
    public MetricStatName getStatName() {
        return this.statName;
    }

    @Generated
    public boolean isAggregationMetric() {
        return this.isAggregationMetric;
    }

    @Override
    @Generated
    public Double getValue() {
        return this.value;
    }

    @Generated
    public MemoryStatSnapshot(MetricStatName statName, boolean isAggregationMetric, Double value) {
        this.statName = statName;
        this.isAggregationMetric = isAggregationMetric;
        this.value = value;
    }

    @Generated
    public static class MemoryStatSnapshotBuilder {
        @Generated
        private MetricStatName statName;
        @Generated
        private boolean isAggregationMetric;
        @Generated
        private Double value;

        @Generated
        MemoryStatSnapshotBuilder() {
        }

        @Generated
        public MemoryStatSnapshotBuilder statName(MetricStatName statName) {
            this.statName = statName;
            return this;
        }

        @Generated
        public MemoryStatSnapshotBuilder isAggregationMetric(boolean isAggregationMetric) {
            this.isAggregationMetric = isAggregationMetric;
            return this;
        }

        @Generated
        public MemoryStatSnapshotBuilder value(Double value) {
            this.value = value;
            return this;
        }

        @Generated
        public MemoryStatSnapshot build() {
            return new MemoryStatSnapshot(this.statName, this.isAggregationMetric, this.value);
        }

        @Generated
        public String toString() {
            return "MemoryStatSnapshot.MemoryStatSnapshotBuilder(statName=" + String.valueOf(this.statName) + ", isAggregationMetric=" + this.isAggregationMetric + ", value=" + this.value + ")";
        }
    }
}

