/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.TestTrigger;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class AESNativeCBC
implements MultiBlockCipher {
    private static byte[] key = Hex.decode("000102030405060708090a0b0c0d0e0f");
    private static byte[] enc = Hex.decode("c6a13b37878f5b826f4f8162a1c8d879af9d9926f7dac87192b1c4143ad98958");
    private static TestTrigger trigger = new TestTrigger();
    private CBCRefWrapper referenceWrapper;
    byte[] IV = new byte[16];
    int keySize;
    private boolean encrypting;

    private AESNativeCBC() {
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        boolean bl2 = this.encrypting;
        this.encrypting = bl;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length != this.getBlockSize()) {
                throw new IllegalArgumentException("initialisation vector must be the same length as block size");
            }
            System.arraycopy(byArray, 0, this.IV, 0, byArray.length);
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.init((KeyParameter)parametersWithIV.getParameters());
            } else {
                if (bl2 != this.encrypting) {
                    throw new IllegalArgumentException("cannot change encrypting state without providing key");
                }
                if (this.referenceWrapper == null) {
                    throw new IllegalStateException("IV change attempted but not previously initialized with a key");
                }
                this.init(new KeyParameterImpl(this.referenceWrapper.oldKey));
            }
        } else {
            this.reset();
            if (cipherParameters != null) {
                this.init((KeyParameter)cipherParameters);
            } else {
                if (bl2 != this.encrypting) {
                    throw new IllegalArgumentException("cannot change encrypting state without providing key.");
                }
                if (this.referenceWrapper == null) {
                    throw new IllegalStateException("IV change attempted but not previously initialized with a key");
                }
                this.init(new KeyParameterImpl(this.referenceWrapper.oldKey));
            }
        }
    }

    private void init(KeyParameter keyParameter) {
        byte[] byArray = keyParameter.getKey();
        switch (byArray.length) {
            case 16: 
            case 24: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("key must be only 16,24,or 32 bytes long.");
            }
        }
        this.referenceWrapper = new CBCRefWrapper(AESNativeCBC.makeNative(byArray.length, this.encrypting), Arrays.clone(byArray));
        if (this.referenceWrapper.getReference() == 0L) {
            throw new IllegalStateException("Native CBC native instance returned a null pointer.");
        }
        AESNativeCBC.init(this.referenceWrapper.getReference(), byArray, this.IV);
        this.keySize = byArray.length * 8;
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CBC";
    }

    @Override
    public int getBlockSize() {
        return AESNativeCBC.getBlockSize(0L);
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCBC.process(this.referenceWrapper.getReference(), byArray, n, 1, byArray2, n2);
    }

    @Override
    public void reset() {
        if (this.referenceWrapper == null) {
            return;
        }
        AESNativeCBC.reset(this.referenceWrapper.getReference());
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCBC.getMultiBlockSize(0L);
    }

    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCBC.process(this.referenceWrapper.getReference(), byArray, n, n2, byArray2, n3);
    }

    private static native int process(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int getMultiBlockSize(long var0);

    private static native int getBlockSize(long var0);

    static native long makeNative(int var0, boolean var1);

    static native void init(long var0, byte[] var2, byte[] var3);

    static native void dispose(long var0);

    private static native void reset(long var0);

    public String toString() {
        return "CBC[Native](AES[Native](" + this.keySize + ")";
    }

    static AESNativeCBC newInstance() {
        AESNativeCBC aESNativeCBC = new AESNativeCBC();
        if (trigger.triggerTest()) {
            return SelfTestExecutor.validate(FipsAES.CBC.getAlgorithm(), aESNativeCBC, new BasicKatTest<AESNativeCBC>(){

                @Override
                public boolean hasTestPassed(AESNativeCBC aESNativeCBC) throws Exception {
                    byte[] byArray = new byte[32];
                    byte[] byArray2 = new byte[32];
                    byte[] byArray3 = new byte[16];
                    aESNativeCBC.init(true, new ParametersWithIV(new KeyParameterImpl(key), byArray3));
                    aESNativeCBC.processBlocks(byArray, 0, 2, byArray2, 0);
                    if (!Arrays.areEqual(enc, byArray2)) {
                        return false;
                    }
                    aESNativeCBC.init(false, new ParametersWithIV(new KeyParameterImpl(key), byArray3));
                    aESNativeCBC.processBlocks(enc, 0, 2, byArray2, 0);
                    return Arrays.areEqual(byArray, byArray2);
                }
            });
        }
        return aESNativeCBC;
    }

    private class CBCRefWrapper
    extends NativeReference {
        private final byte[] oldKey;

        public CBCRefWrapper(long l, byte[] byArray) {
            super(l);
            this.oldKey = byArray;
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference, this.oldKey);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        private final byte[] oldKey;

        Disposer(long l, byte[] byArray) {
            super(l);
            this.oldKey = byArray;
        }

        @Override
        protected void dispose(long l) {
            Arrays.clear(this.oldKey);
            AESNativeCBC.dispose(l);
        }
    }
}

