/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;
import java.util.Map;
import java.util.stream.Stream;

public interface PcodeExecutorStatePiece<A, T> {
    default public void checkRange(AddressSpace space, long offset, int size) {
        if (space.isConstantSpace()) {
            return;
        }
        try {
            new AddressRangeImpl(space.getAddress(offset), (long)size);
        }
        catch (AddressOutOfBoundsException | AddressOverflowException e) {
            throw new IllegalArgumentException("Given offset and length exceeds address space");
        }
    }

    public Language getLanguage();

    public PcodeArithmetic<A> getAddressArithmetic();

    public PcodeArithmetic<T> getArithmetic();

    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces();

    default public PcodeExecutorStatePiece<A, T> fork(PcodeStateCallbacks cb) {
        throw new UnsupportedOperationException();
    }

    default public void setVar(Register reg, T val) {
        Address address = reg.getAddress();
        this.setVar(address.getAddressSpace(), address.getOffset(), reg.getMinimumByteSize(), true, val);
    }

    default public void setVar(Varnode var, T val) {
        Address address = var.getAddress();
        this.setVar(address.getAddressSpace(), address.getOffset(), var.getSize(), true, val);
    }

    public void setVar(AddressSpace var1, A var2, int var3, boolean var4, T var5);

    public void setVarInternal(AddressSpace var1, A var2, int var3, T var4);

    default public void setVar(AddressSpace space, long offset, int size, boolean quantize, T val) {
        this.checkRange(space, offset, size);
        A aOffset = this.getAddressArithmetic().fromConst(offset, space.getPointerSize());
        this.setVar(space, aOffset, size, quantize, val);
    }

    default public void setVarInternal(AddressSpace space, long offset, int size, T val) {
        A aOffset = this.getAddressArithmetic().fromConst(offset, space.getPointerSize());
        this.setVarInternal(space, aOffset, size, val);
    }

    default public void setVar(Address address, int size, boolean quantize, T val) {
        this.setVar(address.getAddressSpace(), address.getOffset(), size, quantize, val);
    }

    default public T getVar(Register reg, Reason reason) {
        Address address = reg.getAddress();
        return this.getVar(address.getAddressSpace(), address.getOffset(), reg.getMinimumByteSize(), true, reason);
    }

    default public T getVar(Varnode var, Reason reason) {
        Address address = var.getAddress();
        return this.getVar(address.getAddressSpace(), address.getOffset(), var.getSize(), true, reason);
    }

    public T getVar(AddressSpace var1, A var2, int var3, boolean var4, Reason var5);

    public T getVarInternal(AddressSpace var1, A var2, int var3, Reason var4);

    default public Map.Entry<A, T> getNextEntryInternal(AddressSpace space, A offset) {
        throw new UnsupportedOperationException();
    }

    default public T getVar(AddressSpace space, long offset, int size, boolean quantize, Reason reason) {
        this.checkRange(space, offset, size);
        A aOffset = this.getAddressArithmetic().fromConst(offset, space.getPointerSize());
        return this.getVar(space, aOffset, size, quantize, reason);
    }

    default public T getVarInternal(AddressSpace space, long offset, int size, Reason reason) {
        A aOffset = this.getAddressArithmetic().fromConst(offset, space.getPointerSize());
        return this.getVarInternal(space, aOffset, size, reason);
    }

    default public Map.Entry<Long, T> getNextEntryInternal(AddressSpace space, long offset) {
        throw new UnsupportedOperationException();
    }

    default public T getVar(Address address, int size, boolean quantize, Reason reason) {
        return this.getVar(address.getAddressSpace(), address.getOffset(), size, quantize, reason);
    }

    public Map<Register, T> getRegisterValues();

    public MemBuffer getConcreteBuffer(Address var1, PcodeArithmetic.Purpose var2);

    default public long quantizeOffset(AddressSpace space, long offset) {
        return space.truncateAddressableWordOffset(offset) * (long)space.getAddressableUnitSize();
    }

    public void clear();

    default public void setConcrete(Address address, byte[] value) {
        this.setVar(address, value.length, false, this.getArithmetic().fromConst(value));
    }

    default public byte[] inspectConcrete(Address address, int size) {
        return this.getArithmetic().toConcrete(this.getVar(address, size, false, Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
    }

    default public void setBigInteger(Address address, int size, BigInteger value) {
        this.setVar(address, size, false, this.getArithmetic().fromConst(value, size));
    }

    default public BigInteger inspectBigInteger(Address address, int size) {
        return this.getArithmetic().toBigInteger(this.getVar(address, size, false, Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
    }

    default public void setLong(Address address, long value) {
        this.setVar(address, 8, false, this.getArithmetic().fromConst(value, 8));
    }

    default public long inspectLong(Address address) {
        return this.getArithmetic().toLong(this.getVar(address, 8, false, Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
    }

    default public void setInt(Address address, int value) {
        this.setVar(address, 4, false, this.getArithmetic().fromConst(value, 4));
    }

    default public int inspectInt(Address address) {
        return (int)this.getArithmetic().toLong(this.getVar(address, 4, false, Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
    }

    default public void setShort(Address address, short value) {
        this.setVar(address, 2, false, this.getArithmetic().fromConst(value, 2));
    }

    default public short inspectShort(Address address) {
        return (short)this.getArithmetic().toLong(this.getVar(address, 2, false, Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
    }

    default public void setByte(Address address, byte value) {
        this.setVar(address, 1, false, this.getArithmetic().fromConst(value, 1));
    }

    default public byte inspectByte(Address address) {
        return (byte)this.getArithmetic().toLong(this.getVar(address, 1, false, Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
    }

    default public void setRegisterValue(Register register, RegisterValue value) {
        this.setVar(register, this.getArithmetic().fromConst(value));
    }

    default public void setRegisterValue(RegisterValue value) {
        this.setRegisterValue(value.getRegister(), value);
    }

    default public RegisterValue inspectRegisterValue(Register register) {
        return this.getArithmetic().toRegisterValue(register, this.getVar(register, Reason.INSPECT), PcodeArithmetic.Purpose.INSPECT);
    }

    public static enum Reason {
        RE_INIT,
        EXECUTE_READ,
        EXECUTE_DECODE,
        INSPECT;

    }
}

