/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import mdemangler.MDCharacterIterator;
import mdemangler.MDContext;
import mdemangler.MDException;
import mdemangler.MDOutputOptions;
import mdemangler.MDParsableItem;
import mdemangler.MDString;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.naming.MDFragmentName;
import mdemangler.naming.MDQualification;
import mdemangler.object.MDMangObjectParser;
import mdemangler.object.MDObjectCPP;
import mdemangler.template.MDTemplateArgumentsList;
import org.apache.commons.lang3.StringUtils;

public class MDMang {
    public static final char DONE = '\uffff';
    private MDOutputOptions outputOptions = new MDOutputOptions();
    protected int architectureSize = 32;
    protected boolean isFunction = false;
    protected String mangled;
    protected MDCharacterIterator iter;
    protected String errorMessage;
    protected MDParsableItem item;
    protected List<MDContext> contextStack;
    protected boolean errorOnRemainingChars = false;
    private ProcessingMode processingMode;
    private static final char SPACE = ' ';
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset UTF16 = Charset.forName("UTF-16");

    public void setMangledSymbol(String mangledIn) {
        this.mangled = mangledIn;
    }

    public String getMangledSymbol() {
        return this.mangled;
    }

    public void setArchitectureSize(int size) {
        this.architectureSize = size;
    }

    public int getArchitectureSize() {
        return this.architectureSize;
    }

    public void setIsFunction(boolean isFunction) {
        this.isFunction = isFunction;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public MDOutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public void setErrorOnRemainingChars(boolean errorOnRemainingCharsArg) {
        this.errorOnRemainingChars = errorOnRemainingCharsArg;
    }

    public boolean errorOnRemainingChars() {
        return this.errorOnRemainingChars;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumCharsRemaining() {
        return this.iter.getLength() - this.iter.getIndex();
    }

    public MDParsableItem demangle() throws MDException {
        this.initState();
        this.item = MDMangObjectParser.determineItemAndParse(this);
        if (this.item instanceof MDObjectCPP) {
            this.item = this.getEmbeddedObject((MDObjectCPP)this.item);
        }
        int numCharsRemaining = this.getNumCharsRemaining();
        if (this.errorOnRemainingChars && numCharsRemaining > 0) {
            throw new MDException("MDMang: characters remain after demangling: " + numCharsRemaining + ".");
        }
        return this.item;
    }

    public MDDataType demangleType() throws MDException {
        this.initState();
        MDDataType mdDataType = MDDataTypeParser.determineAndParseDataType(this, false);
        this.item = mdDataType;
        int numCharsRemaining = this.getNumCharsRemaining();
        if (this.errorOnRemainingChars && numCharsRemaining > 0) {
            throw new MDException("MDMang: characters remain after demangling: " + numCharsRemaining + ".");
        }
        return mdDataType;
    }

    public void setProcessingMode(ProcessingMode processingMode) {
        this.processingMode = processingMode;
    }

    public ProcessingMode getProcessingMode() {
        return this.processingMode;
    }

    public boolean isLlvmProcessingModeIndex0() {
        return this.processingMode == ProcessingMode.LLVM && this.getIndex() == 0;
    }

    public boolean isLlvmProcessingMode() {
        return this.processingMode == ProcessingMode.LLVM;
    }

    protected void initState() throws MDException {
        if (StringUtils.isBlank((CharSequence)this.mangled)) {
            throw new MDException("MDMang: Mangled string is null or blank.");
        }
        this.errorMessage = "";
        this.processingMode = ProcessingMode.DEFAULT_STANDARD;
        this.iter = new MDCharacterIterator(this.mangled);
        this.resetState();
    }

    public void resetState() {
        this.contextStack = new ArrayList<MDContext>();
        this.setIndex(0);
    }

    protected int debugCheck(int lookAhead) {
        int a;
        int b = a = this.iter.getIndex() + lookAhead;
        if (a == 32) {
            ++b;
        }
        if (a == 179) {
            ++b;
        }
        if (a == 150) {
            ++b;
        }
        return b;
    }

    public int getIndex() {
        return this.iter.getIndex();
    }

    public void setIndex(int index) {
        this.iter.setIndex(index);
    }

    public boolean done() {
        return this.peek() == '\uffff';
    }

    public char peek() {
        this.debugCheck(0);
        return this.iter.peek();
    }

    public char peek(int lookAhead) {
        this.debugCheck(lookAhead);
        return this.iter.peek(lookAhead);
    }

    public char next() {
        this.debugCheck(1);
        return this.iter.next();
    }

    public char getAndIncrement() {
        this.debugCheck(0);
        return this.iter.getAndIncrement();
    }

    public void increment() {
        this.debugCheck(0);
        this.iter.increment();
    }

    public void increment(int count) {
        this.iter.increment(count);
    }

    public boolean positionStartsWith(String substring) {
        return this.iter.positionStartsWith(substring);
    }

    public MDContext getContext() {
        return this.contextStack.get(this.contextStack.size() - 1);
    }

    public void pushContext() {
        MDContext context = new MDContext();
        this.contextStack.add(context);
    }

    public void pushModifierContext() {
        this.contextStack.add(new MDContext(this.getContext(), MDContext.MDContextType.MODIFIER));
    }

    public void pushFunctionContext() {
        this.contextStack.add(new MDContext(this.getContext(), MDContext.MDContextType.FUNCTION));
    }

    public void pushTemplateContext() {
        this.contextStack.add(new MDContext(this.getContext(), MDContext.MDContextType.TEMPLATE));
    }

    public void popContext() {
        this.contextStack.remove(this.contextStack.size() - 1);
    }

    public void addBackrefName(String name) {
        MDContext context = this.getContext();
        context.addBackrefName(name);
    }

    public String getBackreferenceName(int index) throws MDException {
        MDContext context = this.getContext();
        return context.getBackrefName(index);
    }

    public void addBackrefFunctionParameterMDDataType(MDDataType dt) {
        MDContext context = this.getContext();
        context.addBackrefFunctionParameterMDDataType(dt);
    }

    public void addBackrefTemplateParameterMDDataType(MDDataType dt) {
        MDContext context = this.getContext();
        context.addBackrefTemplateParameterMDDataType(dt);
    }

    public MDDataType getBackreferenceFunctionParameterMDDataType(int index) throws MDException {
        MDContext context = this.getContext();
        return context.getBackrefFunctionParameterMDDataType(index);
    }

    public MDDataType getBackreferenceTemplateParameterMDDataType(int index) throws MDException {
        MDContext context = this.getContext();
        return context.getBackrefTemplateParameterMDDataType(index);
    }

    public void parseInfoPushPop(int startIndexOffset, String objectName) {
    }

    public void parseInfoPush(int startIndexOffset, String objectName) {
    }

    public void parseInfoPop() {
    }

    public void insertSpacedString(StringBuilder builder, String string) {
        if (builder.length() != 0 && string.length() != 0) {
            if (builder.charAt(0) == ' ') {
                if (string.charAt(string.length() - 1) == ' ') {
                    builder.deleteCharAt(0);
                }
            } else if (string.charAt(string.length() - 1) != ' ') {
                builder.insert(0, ' ');
            }
        }
        builder.insert(0, string);
    }

    public boolean isEffectivelyEmpty(StringBuilder builder) {
        return builder.length() == 0;
    }

    public void insertString(StringBuilder builder, String string) {
        if (builder.length() != 0 && string.length() != 0 && builder.charAt(0) == ' ' && string.charAt(string.length() - 1) == ' ') {
            builder.deleteCharAt(0);
        }
        builder.insert(0, string);
    }

    public void appendString(StringBuilder builder, String string) {
        if (builder.length() != 0 && string.length() != 0 && builder.charAt(builder.length() - 1) == ' ' && string.charAt(0) == ' ') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(string);
    }

    public void cleanOutput(StringBuilder builder) {
        if (builder != null) {
            for (int i = 0; i < builder.length(); ++i) {
                if (builder.charAt(i) != '\u0000') continue;
                builder.setLength(i);
                break;
            }
        }
    }

    public void insert(StringBuilder builder, MDString mdstring) {
        this.insertString(builder, mdstring.getString(UTF8, UTF16));
    }

    public void insert(StringBuilder builder, MDQualification qualification) {
        qualification.insert_MdVersion(builder);
    }

    public boolean emptyFirstArgComma(MDTemplateArgumentsList args) {
        return false;
    }

    public boolean templateBackrefComma(MDTemplateArgumentsList args) {
        return true;
    }

    public void insertManagedPropertiesSuffix(StringBuilder builder, MDCVMod cvMod) {
        cvMod.insertManagedPropertiesSuffix(builder);
    }

    public void parseEmbeddedObjectSuffix() {
        if (this.peek() == '@') {
            this.increment();
        }
    }

    public void insertCLIArrayRefSuffix(StringBuilder builder, StringBuilder refBuilder) {
        this.insertSpacedString(builder, refBuilder.toString());
    }

    public String parseFragmentName(MDFragmentName fn) throws MDException {
        return fn.parseFragmentName_Md();
    }

    public boolean allowMDTypeInfoParserDefault() {
        return false;
    }

    public boolean allowCVModLRefRRef() {
        return true;
    }

    public boolean processQualCAsSpecialFragment() {
        return false;
    }

    public MDObjectCPP getEmbeddedObject(MDObjectCPP obj) {
        return obj;
    }

    public void processHashedObject(MDObjectCPP obj) throws MDException {
        obj.processHashedObject();
    }

    public static enum ProcessingMode {
        DEFAULT_STANDARD,
        LLVM;

    }
}

