/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.ScoreCaching;
import ghidra.features.bsim.query.description.ExecutableRecord;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class TemporaryScoreCaching
implements ScoreCaching {
    private TreeMap<String, Float> cacheMap = null;
    private double simThreshold = -1.0;
    private double sigThreshold = -1.0;

    @Override
    public void prefetchScores(Set<ExecutableRecord> exeSet, List<ExecutableRecord> missing) throws LSHException {
        block4: {
            if (missing == null) break block4;
            if (this.cacheMap == null) {
                for (ExecutableRecord exeRec : exeSet) {
                    missing.add(exeRec);
                }
            } else {
                for (ExecutableRecord exeRec : exeSet) {
                    if (this.cacheMap.containsKey(exeRec.getMd5())) continue;
                    missing.add(exeRec);
                }
            }
        }
    }

    @Override
    public float getSelfScore(String md5) throws LSHException {
        Float val;
        if (this.cacheMap != null && (val = this.cacheMap.get(md5)) != null) {
            return val.floatValue();
        }
        throw new LSHException("Self-score not recorded for " + md5);
    }

    @Override
    public void commitSelfScore(String md5, float score) throws LSHException {
        if (this.cacheMap == null) {
            this.cacheMap = new TreeMap();
        }
        this.cacheMap.put(md5, Float.valueOf(score));
    }

    @Override
    public double getSimThreshold() throws LSHException {
        return this.simThreshold;
    }

    @Override
    public double getSigThreshold() throws LSHException {
        return this.sigThreshold;
    }

    @Override
    public void resetStorage(double simThresh, double sigThresh) throws LSHException {
        this.cacheMap = null;
        this.simThreshold = simThresh;
        this.sigThreshold = sigThresh;
    }
}

