/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.QueryInfo;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.ResponseError;
import ghidra.features.bsim.query.protocol.ResponseInfo;
import ghidra.framework.client.ClientUtil;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlPullParser;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FunctionDatabaseProxy
implements FunctionDatabase {
    private DatabaseInformation info;
    private LSHVectorFactory vectorFactory;
    private URL httpURL;
    private FunctionDatabase.BSimError lasterror;
    private FunctionDatabase.Status status;
    private boolean isinit;
    private XmlErrorHandler xmlErrorHandler;

    public FunctionDatabaseProxy(URL url) throws MalformedURLException {
        this.httpURL = new URL(url.toString());
        this.lasterror = null;
        this.info = null;
        this.vectorFactory = FunctionDatabase.generateLSHVectorFactory();
        this.status = FunctionDatabase.Status.Unconnected;
        this.isinit = false;
        this.xmlErrorHandler = new XmlErrorHandler();
    }

    @Override
    public FunctionDatabase.Status getStatus() {
        return this.status;
    }

    @Override
    public FunctionDatabase.ConnectionType getConnectionType() {
        return FunctionDatabase.ConnectionType.Unencrypted_No_Authentication;
    }

    @Override
    public String getUserName() {
        return ClientUtil.getUserName();
    }

    @Override
    public LSHVectorFactory getLSHVectorFactory() {
        return this.vectorFactory;
    }

    @Override
    public DatabaseInformation getInfo() {
        return this.info;
    }

    @Override
    public int compareLayout() {
        if (this.info.layout_version == 6) {
            return 0;
        }
        return this.info.layout_version < 6 ? -1 : 1;
    }

    @Override
    public String getURLString() {
        return this.httpURL.toString();
    }

    @Override
    public BSimServerInfo getServerInfo() {
        return new BSimServerInfo(this.httpURL);
    }

    @Override
    public boolean initialize() {
        if (this.isinit) {
            return true;
        }
        if (this.httpURL == null) {
            this.status = FunctionDatabase.Status.Error;
            this.lasterror = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Initialization, "MalformedURL");
            return false;
        }
        QueryInfo queryInfo = new QueryInfo();
        QueryResponseRecord response = this.query(queryInfo);
        if (response == null) {
            return false;
        }
        this.info = ((ResponseInfo)response).info;
        this.status = FunctionDatabase.Status.Ready;
        this.isinit = true;
        return true;
    }

    @Override
    public void close() {
        this.status = FunctionDatabase.Status.Unconnected;
        this.isinit = false;
        this.info = null;
    }

    @Override
    public FunctionDatabase.BSimError getLastError() {
        return this.lasterror;
    }

    @Override
    public QueryResponseRecord query(BSimQuery<?> query) {
        query.buildResponseTemplate();
        try {
            this.lasterror = null;
            HttpURLConnection connection = (HttpURLConnection)this.httpURL.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            query.saveXml(writer);
            writer.close();
            NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(connection.getInputStream(), "response", (ErrorHandler)this.xmlErrorHandler, false);
            if (parser.peek().getName().equals("error")) {
                ResponseError respError = new ResponseError();
                respError.restoreXml((XmlPullParser)parser, this.vectorFactory);
                parser.dispose();
                this.lasterror = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Fatal, respError.errorMessage);
                query.clearResponse();
                return null;
            }
            Object response = query.getResponse();
            ((QueryResponseRecord)response).restoreXml((XmlPullParser)parser, this.vectorFactory);
            parser.dispose();
            if (response instanceof ResponseInfo) {
                this.info = ((ResponseInfo)response).info;
                this.status = FunctionDatabase.Status.Ready;
                this.isinit = true;
            }
            return response;
        }
        catch (Exception ex) {
            this.lasterror = new FunctionDatabase.BSimError(FunctionDatabase.ErrorCategory.Connection, ex.getMessage());
            this.status = FunctionDatabase.Status.Error;
            query.clearResponse();
            return null;
        }
    }

    static class XmlErrorHandler
    implements ErrorHandler {
        XmlErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

