/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.ErrorDisplay;
import ghidra.util.ErrorLogger;
import ghidra.util.MessageType;
import java.awt.Component;

public class ConsoleErrorDisplay
implements ErrorDisplay {
    private void displayMessage(MessageType messageType, ErrorLogger logger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        if (title == null || message == null) {
            RuntimeException re = new RuntimeException("Please clean up Err log statement with null title or message; about the sixth line down from here");
            System.err.println("Found a null title or message; please find the source and add detail:");
            re.printStackTrace(System.err);
        }
        if (throwable != null) {
            switch (messageType) {
                case INFO: {
                    logger.info(originator, title + ": " + String.valueOf(message));
                    break;
                }
                case WARNING: 
                case ALERT: {
                    logger.warn(originator, title + ": " + String.valueOf(message), throwable);
                    break;
                }
                case ERROR: {
                    logger.error(originator, title + ": " + String.valueOf(message), throwable);
                }
            }
        } else {
            switch (messageType) {
                case INFO: {
                    logger.info(originator, title + ": " + String.valueOf(message));
                    break;
                }
                case WARNING: 
                case ALERT: {
                    logger.warn(originator, title + ": " + String.valueOf(message));
                    break;
                }
                case ERROR: {
                    logger.error(originator, title + ": " + String.valueOf(message));
                }
            }
        }
    }

    @Override
    public void displayInfoMessage(ErrorLogger logger, Object originator, Component parent, String title, Object message) {
        this.displayMessage(MessageType.INFO, logger, originator, parent, title, message, null);
    }

    @Override
    public void displayErrorMessage(ErrorLogger logger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        this.displayMessage(MessageType.ERROR, logger, originator, parent, title, message, throwable);
    }

    @Override
    public void displayWarningMessage(ErrorLogger logger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        this.displayMessage(MessageType.WARNING, logger, originator, parent, title, message, throwable);
    }
}

