/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.util.viewer.field.AbstractOpenCloseField;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.app.util.viewer.proxy.VariableProxy;
import ghidra.program.model.address.Address;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class VariableOpenCloseField
extends AbstractOpenCloseField {
    private static final Font HIDDEN_FONT = Gui.getFont((String)"font.listing.base.hidden.field");

    public VariableOpenCloseField(FieldFactory factory, ProxyObj<?> proxy, FontMetrics metrics, int x, int width) {
        super(factory, proxy, metrics, x, width);
        if (proxy instanceof VariableProxy) {
            VariableProxy variableProxy = (VariableProxy)proxy;
            Address functionAddress = variableProxy.getFunctionAddress();
            this.isOpen = proxy.getListingLayoutModel().areFunctionVariablesOpen(functionAddress);
        }
    }

    public int getWidth() {
        if (this.isOpen) {
            return this.fieldWidth;
        }
        return this.fieldWidth + 200;
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager map, RowColLocation cursorLoc, int rowHeight) {
        int toggleHandleStartY = -(this.heightAbove / 2 + this.toggleHandleSize / 2);
        int toggleHandleStartX = this.startX;
        if (!context.isPrinting()) {
            if (this.isOpen) {
                g.drawImage(OPEN_ICON.getImageIcon().getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            } else {
                g.drawImage(CLOSED_ICON.getImageIcon().getImage(), toggleHandleStartX, toggleHandleStartY, context.getBackground(), null);
            }
        }
        g.setColor((Color)GThemeDefaults.Colors.Palette.LIGHT_GRAY);
        if (!this.isOpen) {
            Font font = g.getFont();
            g.setFont(HIDDEN_FONT);
            g.drawString("Variables", this.startX + this.fieldWidth + 10, 0);
            g.setFont(font);
        }
        this.paintCursor(g, context.getCursorColor(), cursorLoc);
    }

    @Override
    public void toggleOpenCloseState() {
        ProxyObj proxyObj = this.proxy;
        if (proxyObj instanceof VariableProxy) {
            VariableProxy variableProxy = (VariableProxy)proxyObj;
            Address functionAddress = variableProxy.getFunctionAddress();
            this.proxy.getListingLayoutModel().setFunctionVariablesOpen(functionAddress, !this.isOpen);
        }
    }
}

