/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetContextDescriptor
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 8;
    private int flags;
    private int parent;

    public TargetContextDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = reader.readNextInt();
        this.parent = reader.readNextInt();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getParent() {
        return this.parent;
    }

    @Override
    public String getStructureName() {
        return this.getMyStructureName();
    }

    @Override
    public String getDescription() {
        return "context descriptor";
    }

    private final String getMyStructureName() {
        return TargetContextDescriptor.class.getSimpleName();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getMyStructureName(), 0);
        struct.add(DWORD, "Flags", "Flags describing the context, including its kind and format version");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Parent", "The parent context, or null if this is a top-level context");
        struct.setCategoryPath(new CategoryPath("/SwiftTypeMetadata"));
        return struct;
    }
}

