/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomShlibListEntry
implements StructConverter {
    public static final int SIZE = 8;
    private String shlibName;
    private int reserved1;
    private boolean internalName;
    private boolean dashLReference;
    private int bind;
    private short highwaterMark;

    public SomShlibListEntry(BinaryReader reader, long stringTableLoc) throws IOException {
        this.shlibName = reader.readAsciiString(stringTableLoc + (long)reader.readNextInt());
        int bitfield = reader.readNextUnsignedByte();
        this.dashLReference = (bitfield & 1) != 0;
        this.internalName = (bitfield >> 1 & 1) != 0;
        this.reserved1 = bitfield >> 2 & 0x3F;
        this.bind = reader.readNextUnsignedByte();
        this.highwaterMark = reader.readNextShort();
    }

    public String getShlibName() {
        return this.shlibName;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public boolean isInternalName() {
        return this.internalName;
    }

    public boolean getDashLReference() {
        return this.dashLReference;
    }

    public int getBind() {
        return this.bind;
    }

    public short getHighwaterMark() {
        return this.highwaterMark;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("shlib_list_entry", 8);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "shlib_name", "offset withing string table");
        try {
            struct.addBitField(BYTE, 6, "reserved1", "");
            struct.addBitField(BYTE, 1, "internal_name", "shlib entry is an internal name");
            struct.addBitField(BYTE, 1, "dash_l_reference", "referenced with -lc or absolute path");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(BYTE, "bind", "BIND_IMMEDIATE, BIND_DEFERRED or BIND_REFERENCE");
        struct.add(WORD, "highwater_mark", "highwater mark of the library");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

