/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public enum DWARFLineContentType {
    DW_LNCT_path(1),
    DW_LNCT_directory_index(2),
    DW_LNCT_timestamp(3),
    DW_LNCT_size(4),
    DW_LNCT_MD5(5),
    DW_LNCT_lo_user(8192),
    DW_LNCT_hi_user(16383),
    DW_LNCT_UNKNOWN(-1);

    private final int id;
    private static Map<Integer, DWARFLineContentType> lookupMap;

    private DWARFLineContentType(int id) {
        this.id = id;
    }

    public static DWARFLineContentType of(int id) {
        return lookupMap.getOrDefault(id, DW_LNCT_UNKNOWN);
    }

    private static Map<Integer, DWARFLineContentType> buildLookup() {
        HashMap<Integer, DWARFLineContentType> result = new HashMap<Integer, DWARFLineContentType>();
        for (DWARFLineContentType e : DWARFLineContentType.values()) {
            result.put(e.id, e);
        }
        return result;
    }

    static {
        lookupMap = DWARFLineContentType.buildLookup();
    }

    public static class Def
    extends DWARFAttributeDef<DWARFLineContentType> {
        public static Def read(BinaryReader reader) throws IOException {
            DWARFAttributeDef<DWARFLineContentType> tmp = DWARFAttributeDef.read(reader, DWARFLineContentType::of);
            if (tmp == null) {
                return null;
            }
            return new Def(tmp.getAttributeId(), tmp.getRawAttributeId(), tmp.getAttributeForm(), tmp.getImplicitValue());
        }

        public Def(DWARFLineContentType attributeId, int rawAttributeId, DWARFForm attributeForm, long implicitValue) {
            super(attributeId, rawAttributeId, attributeForm, implicitValue);
        }

        public DWARFLineContentType getId() {
            return (DWARFLineContentType)((Object)super.getAttributeId());
        }

        @Override
        protected String getRawAttributeIdDescription() {
            return "DW_LNCT_???? %d (0x%x)".formatted(this.attributeId, this.attributeId);
        }

        public Def withForm(DWARFForm newForm) {
            return new Def((DWARFLineContentType)this.attributeId, this.rawAttributeId, newForm, this.implicitValue);
        }
    }
}

