/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

public class QueryData {
    private static String ANY_STRING_WILDCARD = "*";
    private static String ANY_CHAR_WILDCARD = "?";
    private final String queryString;
    private final boolean caseSensitive;
    private final boolean includeDynamicLables;

    public QueryData(String queryString, boolean caseSensitive, boolean includeDynamicLables) {
        this.queryString = queryString;
        this.caseSensitive = caseSensitive;
        this.includeDynamicLables = includeDynamicLables;
    }

    public QueryData(String queryString, boolean caseSensitive) {
        this(queryString, caseSensitive, true);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isIncludeDynamicLables() {
        return this.includeDynamicLables;
    }

    public boolean isWildCard() {
        return QueryData.hasWildCards(this.queryString);
    }

    public static boolean hasWildCards(String query) {
        return query.contains(ANY_STRING_WILDCARD) || query.contains(ANY_CHAR_WILDCARD);
    }
}

