/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import generic.theme.GIcon;
import generic.util.image.ImageUtils;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.Icons;
import resources.MultiIconBuilder;
import resources.QUADRANT;

public class NextPreviousBookmarkAction
extends MultiStateDockingAction<String> {
    public static final String ALL_BOOKMARK_TYPES = "All Bookmark Types";
    private static final Icon INVERTED_OVERLAY_ICON = ImageUtils.makeTransparent((Icon)Icons.NOT_ALLOWED_ICON, (float)0.5f);
    private PluginTool tool;
    private boolean isForward = true;
    private boolean isInverted;
    private static final Icon BOOKMARK_ICON = new GIcon("icon.plugin.navigation.bookmark");
    private static final Icon BOOKMARK_ANALYSIS_ICON = new GIcon("icon.plugin.navigation.bookmark.analysis");
    private static final Icon BOOKMARK_ERROR_ICON = new GIcon("icon.plugin.navigation.bookmark.error");
    private static final Icon BOOKMARK_INFO_ICON = new GIcon("icon.plugin.navigation.bookmark.info");
    private static final Icon BOOKMARK_NOTE_ICON = new GIcon("icon.plugin.navigation.bookmark.note");
    private static final Icon BOOKMARK_WARNING_ICON = new GIcon("icon.plugin.navigation.bookmark.warning");
    private static final Icon BOOKMARK_UNKNOWN_ICON = new GIcon("icon.plugin.navigation.bookmark.unknown");

    public NextPreviousBookmarkAction(PluginTool tool, String owner, String subGroup) {
        super("Next Bookmark", owner);
        this.tool = tool;
        this.setContextClass(NavigatableActionContext.class, true);
        ToolBarData toolBarData = new ToolBarData(BOOKMARK_ICON, "4_Toolbar_Navigation_Group");
        toolBarData.setToolBarSubGroup(subGroup);
        this.setToolBarData(toolBarData);
        this.addToWindowWhen(CodeViewerActionContext.class);
        this.setKeyBindingData(new KeyBindingData(this.getKeyStroke()));
        this.setHelpLocation(new HelpLocation("Navigation", this.getName()));
        this.setDescription("Set bookmark options");
        ActionState allBookmarks = new ActionState("All Types", BOOKMARK_ICON, (Object)ALL_BOOKMARK_TYPES);
        ActionState analysis = new ActionState("Analysis", BOOKMARK_ANALYSIS_ICON, (Object)"Analysis");
        ActionState error = new ActionState("Error", BOOKMARK_ERROR_ICON, (Object)"Error");
        ActionState info = new ActionState("Info", BOOKMARK_INFO_ICON, (Object)"Info");
        ActionState note = new ActionState("Note", BOOKMARK_NOTE_ICON, (Object)"Note");
        ActionState warning = new ActionState("Warning", BOOKMARK_WARNING_ICON, (Object)"Warning");
        ActionState custom = new ActionState("Custom", BOOKMARK_UNKNOWN_ICON, (Object)"Custom");
        this.addActionState(allBookmarks);
        this.addActionState(analysis);
        this.addActionState(error);
        this.addActionState(info);
        this.addActionState(note);
        this.addActionState(warning);
        this.addActionState(custom);
        this.setCurrentActionState(allBookmarks);
    }

    public void setMenuBarData(MenuData newMenuData) {
        this.superSetMenuBarData(newMenuData);
    }

    public void actionPerformed(ActionContext context) {
        if (context instanceof NavigatableActionContext) {
            this.gotoNextPrevious((NavigatableActionContext)context, (String)this.getCurrentUserData());
        }
    }

    public void actionStateChanged(ActionState<String> newActionState, EventTrigger trigger) {
        Icon icon = newActionState.getIcon();
        ToolBarData tbData = this.getToolBarData();
        tbData.setIcon(this.isInverted ? this.invertIcon(icon) : icon);
    }

    private Address getNextAddress(Program program, Address address, String bookmarkType) {
        if (this.isInverted) {
            return this.getNextAddressOfNonBookmark(program, address, bookmarkType);
        }
        return this.getAddressOfNextBookmarkAfter(program, address, bookmarkType);
    }

    private Address getPreviousAddress(Program program, Address address, String bookmarkType) {
        if (this.isInverted) {
            return this.getPreviousAddressOfNonBookmark(program, address, bookmarkType);
        }
        return this.getAddressOfPreviousBookmarkBefore(program, address, bookmarkType);
    }

    private Address getNextAddressOfNonBookmark(Program program, Address address, String bookmarkType) {
        if (ALL_BOOKMARK_TYPES.equals(bookmarkType)) {
            address = this.getAddressOfNextBookmarkAfter(program, address, bookmarkType);
        }
        return this.getAdddressOfNextPreviousNonBookmark(program, address, bookmarkType, true);
    }

    private Address getPreviousAddressOfNonBookmark(Program program, Address address, String bookmarkType) {
        if (ALL_BOOKMARK_TYPES.equals(bookmarkType)) {
            address = this.getAddressOfPreviousBookmarkBefore(program, address, bookmarkType);
        }
        return this.getAdddressOfNextPreviousNonBookmark(program, address, bookmarkType, false);
    }

    private Address getAdddressOfNextPreviousNonBookmark(Program program, Address address, String bookmarkType, boolean forward) {
        if (address == null) {
            return null;
        }
        Address address2 = address = forward ? address.next() : address.previous();
        if (address == null) {
            return null;
        }
        if (bookmarkType.equals(ALL_BOOKMARK_TYPES)) {
            return this.getNextPreviousCuWithoutBookmarkAddress(program, address, forward);
        }
        BookmarkManager bm = program.getBookmarkManager();
        Iterator it = bm.getBookmarksIterator(address, forward);
        while (it.hasNext()) {
            Bookmark nextBookmark = (Bookmark)it.next();
            Address nextAddress = nextBookmark.getAddress();
            if (nextAddress.isExternalAddress() || nextBookmark.getTypeString().equals(bookmarkType)) continue;
            return nextBookmark.getAddress();
        }
        return null;
    }

    private Address getNextPreviousCuWithoutBookmarkAddress(Program program, Address address, boolean forward) {
        CodeUnitIterator it = program.getListing().getCodeUnits(address, forward);
        while (it.hasNext()) {
            CodeUnit cu = it.next();
            Address minAddress = cu.getMinAddress();
            BookmarkManager bm = program.getBookmarkManager();
            Bookmark[] bookmarks = bm.getBookmarks(minAddress);
            if (bookmarks.length != 0) continue;
            return minAddress;
        }
        return null;
    }

    private Address getAddressOfNextBookmarkAfter(Program program, Address address, String bookmarkType) {
        Address start = this.getNextAddressToBeginSearchingForward(program, address);
        Bookmark nextBookmark = this.getNextPreviousBookmark(program, start, true, bookmarkType);
        return nextBookmark == null ? null : nextBookmark.getAddress();
    }

    private Address getAddressOfPreviousBookmarkBefore(Program program, Address address, String bookmarkType) {
        Address start = this.getNextAddressToBeginSearchingBackward(program, address);
        Bookmark nextBookmark = this.getNextPreviousBookmark(program, start, false, bookmarkType);
        return nextBookmark == null ? null : nextBookmark.getAddress();
    }

    private Address getNextAddressToBeginSearchingForward(Program program, Address address) {
        CodeUnit cu = this.getMostPrimitiveCodeUnitContaining(program, address);
        return cu == null ? address : cu.getMaxAddress().next();
    }

    private Address getNextAddressToBeginSearchingBackward(Program program, Address address) {
        CodeUnit cu = this.getMostPrimitiveCodeUnitContaining(program, address);
        return cu == null ? address : cu.getMinAddress().previous();
    }

    private CodeUnit getMostPrimitiveCodeUnitContaining(Program program, Address address) {
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        if (cu == null) {
            return null;
        }
        if (cu instanceof Data) {
            Data data = (Data)cu;
            cu = data.getPrimitiveAt((int)address.subtract(data.getAddress()));
        }
        return cu;
    }

    private Bookmark getNextPreviousBookmark(Program program, Address address, boolean forward, String bookmarkType) {
        BookmarkManager bm = program.getBookmarkManager();
        Iterator it = bm.getBookmarksIterator(address, forward);
        while (it.hasNext()) {
            Bookmark nextBookmark = (Bookmark)it.next();
            Address nextAddress = nextBookmark.getAddress();
            if (nextAddress.isExternalAddress()) continue;
            if (bookmarkType.equals(ALL_BOOKMARK_TYPES)) {
                return nextBookmark;
            }
            if (bookmarkType.equals("Custom") && this.isNotBuiltInType(address, nextBookmark, nextAddress)) {
                return nextBookmark;
            }
            if (!nextBookmark.getTypeString().equals(bookmarkType)) continue;
            return nextBookmark;
        }
        return null;
    }

    private boolean isNotBuiltInType(Address address, Bookmark nextBookmark, Address nextAddress) {
        return !nextBookmark.getTypeString().equals("Analysis") && !nextBookmark.getTypeString().equals("Info") && !nextBookmark.getTypeString().equals("Note") && !nextBookmark.getTypeString().equals("Warning") && !nextBookmark.getTypeString().equals("Error") && !nextAddress.equals((Object)address);
    }

    private void gotoAddress(GoToService service, Navigatable navigatable, Address address) {
        service.goTo(navigatable, address);
    }

    private void gotoNextPrevious(NavigatableActionContext context, String bookmarkType) {
        boolean direction = this.isForward;
        if (context.hasAnyEventClickModifiers(1)) {
            direction = !direction;
        }
        Address address = direction ? this.getNextAddress(context.getProgram(), context.getAddress(), bookmarkType) : this.getPreviousAddress(context.getProgram(), context.getAddress(), bookmarkType);
        Swing.runLater(() -> this.gotoAddress(context, address));
    }

    private void gotoAddress(NavigatableActionContext listingActionContext, Address address) {
        if (address == null) {
            this.tool.setStatusInfo("Unable to locate another " + this.getNavigationTypeName() + " past the current range, in the current direction.");
            return;
        }
        this.tool.clearStatusInfo();
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            Navigatable navigatable = listingActionContext.getNavigatable();
            this.gotoAddress(service, navigatable, address);
        }
    }

    public void setDirection(boolean isForward) {
        this.isForward = isForward;
        this.setDescription(this.getToolTipText());
    }

    public void setInverted(boolean isInverted) {
        this.isInverted = isInverted;
        ActionState state = this.getCurrentState();
        Icon icon = state.getIcon();
        this.getToolBarData().setIcon(isInverted ? this.invertIcon(icon) : icon);
        this.setDescription(this.getToolTipText());
    }

    private Icon invertIcon(Icon icon) {
        MultiIconBuilder builder = new MultiIconBuilder(icon);
        builder.addIcon(INVERTED_OVERLAY_ICON, 10, 10, QUADRANT.LR);
        return builder.build();
    }

    public String getToolTipText() {
        String description = "Go To " + (this.isForward ? "Next" : "Previous");
        description = this.isInverted ? description + " Non-Bookmark: " : description + " Bookmark: ";
        description = description + this.getCurrentState().getName();
        description = description + " (shift-click inverts direction)";
        return description;
    }

    private String getNavigationTypeName() {
        return "Bookmark";
    }

    private KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(66, 640);
    }

    public boolean isValidContext(ActionContext context) {
        return context instanceof ListingActionContext;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof ListingActionContext;
    }
}

