/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functionwindow;

import docking.ComponentProvider;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.functionwindow.FunctionWindowProvider;
import ghidra.app.services.FunctionComparisonService;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.task.SwingUpdateManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Function Viewer", description="Provides a window that displays the list of functions in the program.", eventsConsumed={ProgramClosedPluginEvent.class})
public class FunctionWindowPlugin
extends ProgramPlugin {
    private FunctionWindowProvider provider;
    private SwingUpdateManager swingMgr = new SwingUpdateManager(1000, () -> this.provider.reload());
    private DomainObjectListener domainObjectListener;

    public FunctionWindowPlugin(PluginTool tool) {
        super(tool);
    }

    public void init() {
        super.init();
        this.provider = new FunctionWindowProvider(this);
        this.domainObjectListener = this.createDomainObjectListener();
        this.provider.getTable().getSelectionModel().addListSelectionListener(x -> this.tool.contextChanged((ComponentProvider)this.provider));
    }

    public void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener(this.domainObjectListener);
        }
        this.swingMgr.dispose();
        if (this.provider != null) {
            this.provider.dispose();
        }
        super.dispose();
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == FunctionComparisonService.class) {
            this.provider.createCompareAction();
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == FunctionComparisonService.class) {
            this.provider.removeCompareAction();
        }
    }

    private DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).ignoreWhen(() -> !this.provider.isVisible())).any(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.MEMORY_BLOCK_MOVED, ProgramEvent.MEMORY_BLOCK_REMOVED}).terminate(this.provider::reload)).any(new EventType[]{ProgramEvent.CODE_ADDED, ProgramEvent.CODE_REMOVED}).call(() -> ((SwingUpdateManager)this.swingMgr).update())).with(ProgramChangeRecord.class).each(new EventType[]{ProgramEvent.FUNCTION_ADDED}).call(this::functionAdded).each(new EventType[]{ProgramEvent.FUNCTION_REMOVED}).call(this::functionRemoved).each(new EventType[]{ProgramEvent.FUNCTION_CHANGED}).call(this::functionChanged).each(new EventType[]{ProgramEvent.SYMBOL_ADDED, ProgramEvent.SYMBOL_PRIMARY_STATE_CHANGED}).call(this::symbolChanged).each(new EventType[]{ProgramEvent.SYMBOL_RENAMED}).call(this::symbolRenamed).build();
    }

    private void functionAdded(ProgramChangeRecord rec) {
        Function function = (Function)rec.getObject();
        this.provider.functionAdded(function);
    }

    private void functionRemoved(ProgramChangeRecord rec) {
        Function function = (Function)rec.getObject();
        if (function != null) {
            this.provider.functionRemoved(function);
        }
    }

    private void functionChanged(ProgramChangeRecord rec) {
        Function function = (Function)rec.getObject();
        this.provider.update(function);
    }

    private void symbolChanged(ProgramChangeRecord rec) {
        Symbol sym = (Symbol)rec.getNewValue();
        Address addr = sym.getAddress();
        Function function = this.currentProgram.getListing().getFunctionAt(addr);
        if (function != null) {
            this.provider.update(function);
        }
    }

    private void symbolRenamed(ProgramChangeRecord rec) {
        Symbol sym = (Symbol)rec.getObject();
        Address addr = sym.getAddress();
        Function function = this.currentProgram.getListing().getFunctionAt(addr);
        if (function != null) {
            this.provider.update(function);
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener(this.domainObjectListener);
        this.provider.programOpened(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener(this.domainObjectListener);
        this.provider.programClosed();
    }

    Program getProgram() {
        return this.currentProgram;
    }

    void showFunctions() {
        this.provider.showFunctions();
    }
}

