/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.eclipse;

import docking.options.OptionsService;
import docking.widgets.OptionDialog;
import generic.jar.ResourceFile;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.eclipse.EclipseConnection;
import ghidra.app.plugin.core.eclipse.EclipseConnectorTask;
import ghidra.app.services.EclipseIntegrationService;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.main.AppInfo;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.SystemUtils;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Eclipse Integration", description="Allows Ghidra to integrate with Eclipse.", servicesRequired={OptionsService.class}, servicesProvided={EclipseIntegrationService.class})
public class EclipseIntegrationPlugin
extends ProgramPlugin
implements EclipseIntegrationService {
    private ToolOptions options;

    public EclipseIntegrationPlugin(PluginTool tool) {
        super(tool);
    }

    public void init() {
        super.init();
        this.options = AppInfo.getFrontEndTool().getOptions("Eclipse Integration");
    }

    @Override
    public ToolOptions getEclipseIntegrationOptions() {
        return this.options;
    }

    @Override
    public File getEclipseExecutableFile() throws FileNotFoundException {
        File eclipseInstallDir = this.getEclipseInstallDir();
        File eclipseExecutableFile = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X ? new File(eclipseInstallDir.getParentFile(), "MacOS/eclipse") : (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS ? new File(eclipseInstallDir, "eclipse.exe") : new File(eclipseInstallDir, "eclipse"));
        if (!eclipseExecutableFile.isFile()) {
            throw new FileNotFoundException("Eclipse installation executable file does not exist.");
        }
        return eclipseExecutableFile;
    }

    @Override
    public File getEclipseWorkspaceDir() {
        return this.options.getFile("Eclipse Workspace Directory (optional)", null);
    }

    @Override
    public boolean isEclipseFeatureInstalled(FilenameFilter filter) throws FileNotFoundException {
        File dropinsDir;
        File eclipseInstallDir = this.getEclipseInstallDir();
        ArrayList<File> featuresDirs = new ArrayList<File>();
        File mainFeaturesDir = new File(eclipseInstallDir, "features");
        if (mainFeaturesDir.isDirectory()) {
            featuresDirs.add(mainFeaturesDir);
        }
        if ((dropinsDir = this.getEclipseDropinsDir()).isDirectory()) {
            featuresDirs.add(dropinsDir);
            block0: for (File dir : dropinsDir.listFiles(File::isDirectory)) {
                for (File subdir : dir.listFiles(File::isDirectory)) {
                    if (!subdir.getName().equals("features")) continue;
                    featuresDirs.add(subdir);
                    continue block0;
                }
            }
        }
        for (File featuresDir : featuresDirs) {
            File[] matches = featuresDir.listFiles(filter);
            if (matches == null || matches.length <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public EclipseConnection connectToEclipse(int port) {
        return ((EclipseConnectorTask)TaskLauncher.launch((Task)new EclipseConnectorTask(this, port))).getConnection();
    }

    @Override
    public void offerGhidraDevInstallation(TaskMonitor monitor) {
        if (SystemUtilities.isInHeadlessMode()) {
            return;
        }
        SystemUtilities.runSwingNow(() -> {
            File dropinsDir;
            int choice;
            boolean autoGhidraDevInstall = this.options.getBoolean("Automatically install GhidraDev", false);
            String errorTitle = "Failed to install GhidraDev";
            if (!autoGhidraDevInstall && (choice = OptionDialog.showYesNoDialog(null, (String)"GhidraDev", (String)"GhidraDev has not been installed in Eclipse.\nWould you like it automatically installed in Eclipse's \"dropins\" directory?")) != 1) {
                return;
            }
            if (SystemUtilities.isInDevelopmentMode()) {
                Msg.showError((Object)this, null, (String)errorTitle, (Object)"Automatic installation of GhidraDev from development mode is not supported.\nPlease install it manually.");
                return;
            }
            try {
                dropinsDir = this.getEclipseDropinsDir();
            }
            catch (FileNotFoundException e) {
                Msg.showError((Object)this, null, (String)errorTitle, (Object)"Eclipse dropins directory does not exist.");
                return;
            }
            File ghidraDevDir = new ResourceFile(Application.getInstallationDirectory(), "Extensions/Eclipse/GhidraDev").getFile(false);
            if (ghidraDevDir == null || !ghidraDevDir.isDirectory()) {
                Msg.showError((Object)this, null, (String)errorTitle, (Object)("GhidraDev directory does not exist in Ghidra:\n" + String.valueOf(ghidraDevDir)));
                return;
            }
            File ghidraDevFile = null;
            for (File f : ghidraDevDir.listFiles(File::isFile)) {
                if (!f.getName().startsWith("GhidraDev") || !f.getName().endsWith(".zip")) continue;
                ghidraDevFile = f;
                break;
            }
            if (ghidraDevFile == null) {
                Msg.showError((Object)this, null, (String)errorTitle, (Object)("GhidraDev Eclipse extension does not exist:\n" + String.valueOf(ghidraDevFile)));
                return;
            }
            try (ZipFile ghidraDevZip = new ZipFile(ghidraDevFile);){
                Enumeration<? extends ZipEntry> entries = ghidraDevZip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryPath = entry.getName();
                    String entryName = new File(entryPath).getName();
                    if (!entryPath.startsWith("plugins") || !entryPath.contains("ghidradev")) continue;
                    FileUtilities.copyStreamToFile((InputStream)ghidraDevZip.getInputStream(entry), (File)new File(dropinsDir, entryName), (boolean)false, (TaskMonitor)monitor);
                    break;
                }
            }
            catch (IOException e) {
                Msg.showError((Object)this, null, (String)errorTitle, (Object)("Error installing GhidraDev to:\n" + String.valueOf(dropinsDir)), (Throwable)e);
                return;
            }
        });
    }

    @Override
    public void handleEclipseError(String error, boolean askAboutOptions, Throwable t) {
        if (askAboutOptions && !SystemUtilities.isInHeadlessMode()) {
            SystemUtilities.runSwingNow(() -> {
                int choice = OptionDialog.showYesNoDialog(null, (String)"Failed to launch Eclipse", (String)(error + "\nWould you like to verify your \"Eclipse Integration\" options now?"));
                if (choice == 1) {
                    ((OptionsService)AppInfo.getFrontEndTool().getService(OptionsService.class)).showOptionsDialog("Eclipse Integration", null);
                }
            });
        } else {
            Msg.showError(EclipseConnectorTask.class, null, (String)"Failed to launch Eclipse", (Object)error, (Throwable)t);
        }
    }

    private File getEclipseInstallDir() throws FileNotFoundException {
        File eclipseInstallDir = this.options.getFile("Eclipse Installation Directory", null);
        if (eclipseInstallDir == null) {
            throw new FileNotFoundException("Eclipse installation directory not defined.");
        }
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X) {
            if (eclipseInstallDir.getName().startsWith("Eclipse") && eclipseInstallDir.getName().endsWith(".app")) {
                eclipseInstallDir = new File(eclipseInstallDir, "Contents/Eclipse");
            } else if (eclipseInstallDir.getName().equals("Contents")) {
                eclipseInstallDir = new File(eclipseInstallDir, "Eclipse");
            } else if (eclipseInstallDir.getName().equals("MacOS") && eclipseInstallDir.getParentFile().getName().equals("Contents")) {
                eclipseInstallDir = new File(eclipseInstallDir.getParentFile(), "Eclipse");
            } else if (eclipseInstallDir.getName().equals("Resources") && eclipseInstallDir.getParentFile().getName().equals("Contents")) {
                eclipseInstallDir = new File(eclipseInstallDir.getParentFile(), "Eclipse");
            }
        }
        if (!eclipseInstallDir.isDirectory()) {
            throw new FileNotFoundException("Eclipse installation directory does not exist.");
        }
        return eclipseInstallDir;
    }

    @Override
    public File getEclipseDropinsDir() throws FileNotFoundException {
        File eclipseInstallDir = this.getEclipseInstallDir();
        File dropinsDir = eclipseInstallDir.getAbsolutePath().startsWith("/snap/eclipse") ? new File(SystemUtils.getUserHome(), "snap/eclipse/dropins") : new File(eclipseInstallDir, "dropins");
        FileUtilities.mkdirs((File)dropinsDir);
        if (!dropinsDir.isDirectory()) {
            throw new FileNotFoundException("Eclipse dropins directory does not exist.");
        }
        return dropinsDir;
    }
}

