/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import db.Transaction;
import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;

class SetLengthOverrideAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;

    public SetLengthOverrideAction(DisassemblerPlugin plugin, String groupName) {
        super("Modify Instruction Length", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Modify Instruction Length..."}, null, groupName));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        PluginTool tool = this.plugin.getTool();
        Address address = context.getAddress();
        if (address == null) {
            return;
        }
        Program program = context.getProgram();
        Listing listing = program.getListing();
        Instruction instr = listing.getInstructionAt(address);
        if (instr == null) {
            return;
        }
        int protoLen = instr.getPrototype().getLength();
        if (protoLen == 1) {
            Msg.showError((Object)((Object)this), null, (String)"Length Override Error", (Object)"Length override for 1-byte instruction not allowed");
            return;
        }
        String restoreTip = ", 0=restore";
        Object alignTip = "";
        int align = program.getLanguage().getInstructionAlignment();
        if (align != 1) {
            alignTip = ", must be multiple of " + align;
        }
        int minLength = 0;
        long maxLength = Math.min(7, protoLen - 1);
        if (maxLength == 0L) {
            Msg.showError((Object)((Object)this), null, (String)"Length Override Error", (Object)("The length of a " + protoLen + "-byte instruction may not be overridden!"));
            return;
        }
        int currentLengthOverride = this.getDefaultOffcutLength(program, instr);
        NumberInputDialog dialog = new NumberInputDialog("Override/Restore Instruction Length", "Enter byte-length [" + minLength + ".." + maxLength + restoreTip + (String)alignTip + "]", Integer.valueOf(currentLengthOverride), minLength, (int)maxLength, false);
        tool.showDialog((DialogComponentProvider)dialog);
        if (dialog.wasCancelled()) {
            return;
        }
        String kind = "Set";
        int lengthOverride = dialog.getIntValue();
        if (lengthOverride == 0) {
            if (!instr.isLengthOverridden()) {
                return;
            }
            kind = "Clear";
        }
        try (Transaction tx = instr.getProgram().openTransaction(kind + " Length Override");){
            if (lengthOverride == 0) {
                int trueLength = instr.getParsedLength();
                listing.clearCodeUnits(address.add((long)currentLengthOverride), address.add((long)(trueLength - 1)), false);
            }
            instr.setLengthOverride(lengthOverride);
            Address offcutStart = address.add((long)lengthOverride);
            if (lengthOverride != 0 && this.isOffcutFlowReference(program, offcutStart)) {
                tool.executeBackgroundCommand((BackgroundCommand)new DisassembleCommand(offcutStart, null, true), (DomainObject)program);
                this.removeErrorBookmark(program, offcutStart);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.showError((Object)((Object)this), null, (String)"Length Override Error", (Object)e.getMessage());
        }
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Program program = context.getProgram();
        Instruction instr = program.getListing().getInstructionAt(address);
        if (instr == null) {
            return false;
        }
        int alignment = program.getLanguage().getInstructionAlignment();
        return instr.getParsedLength() > alignment;
    }

    private int getDefaultOffcutLength(Program program, Instruction instr) {
        int offset;
        if (instr.isLengthOverridden()) {
            return instr.getLength();
        }
        AddressSet instrBody = new AddressSet(instr.getMinAddress().next(), instr.getMinAddress().add((long)(instr.getParsedLength() - 1)));
        Address addr = program.getReferenceManager().getReferenceDestinationIterator((AddressSetView)instrBody, true).next();
        if (addr != null && (offset = (int)addr.subtract(instr.getMinAddress())) % program.getLanguage().getInstructionAlignment() == 0) {
            return offset;
        }
        return 0;
    }

    private boolean isOffcutFlowReference(Program program, Address address) {
        for (Reference reference : program.getReferenceManager().getReferencesTo(address)) {
            if (!reference.getReferenceType().isFlow()) continue;
            return true;
        }
        return false;
    }

    private void removeErrorBookmark(Program program, Address at) {
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        Bookmark bookmark = bookmarkManager.getBookmark(at, "Error", "Bad Instruction");
        if (bookmark != null) {
            bookmarkManager.removeBookmark(bookmark);
        }
    }
}

