/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial.rtree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jungrapht.visualization.spatial.rtree.LeafNode;
import org.jungrapht.visualization.spatial.rtree.LeafSplitter;
import org.jungrapht.visualization.spatial.rtree.Node;
import org.jungrapht.visualization.spatial.rtree.Pair;

public class QuadraticLeafSplitter<T>
implements LeafSplitter<T> {
    @Override
    public Pair<LeafNode<T>> split(Collection<Map.Entry<T, Rectangle2D>> entries, Map.Entry<T, Rectangle2D> newEntry) {
        return this.quadraticSplit(entries, newEntry);
    }

    private Optional<Map.Entry<T, Rectangle2D>> pickNext(List<Map.Entry<T, Rectangle2D>> entries, Pair<LeafNode<T>> pickedSeeds) {
        double maxDifference = 0.0;
        Optional<Map.Entry<Map.Entry, Rectangle2D>> winner = Optional.empty();
        entries.removeAll(((LeafNode)pickedSeeds.left).map.entrySet());
        entries.removeAll(((LeafNode)pickedSeeds.right).map.entrySet());
        for (Map.Entry<T, Rectangle2D> entry : entries) {
            double rightAreaIncrease;
            if (((LeafNode)pickedSeeds.left).map.containsKey(entry.getKey()) || ((LeafNode)pickedSeeds.right).map.containsKey(entry.getKey())) continue;
            LeafNode leftVertex = (LeafNode)pickedSeeds.left;
            LeafNode rightVertex = (LeafNode)pickedSeeds.right;
            double leftArea = Node.area(leftVertex.getBounds());
            double rightArea = Node.area(rightVertex.getBounds());
            Rectangle2D leftUnion = leftVertex.getBounds().createUnion(entry.getValue());
            Rectangle2D rightUnion = rightVertex.getBounds().createUnion(entry.getValue());
            double leftAreaIncrease = Node.area(leftUnion) - leftArea;
            double difference = leftAreaIncrease - (rightAreaIncrease = Node.area(rightUnion) - rightArea);
            double d = difference = difference < 0.0 ? -difference : difference;
            if (winner.isEmpty()) {
                winner = Optional.of(entry);
                maxDifference = difference;
                continue;
            }
            if (!(difference > maxDifference)) continue;
            maxDifference = difference;
            winner = Optional.of(entry);
        }
        winner.ifPresent(entries::remove);
        return winner;
    }

    private Pair<LeafNode<T>> pickSeeds(List<Map.Entry<T, Rectangle2D>> entryList) {
        double largestArea = 0.0;
        Optional<Object> winningPair = Optional.empty();
        for (int i = 0; i < entryList.size(); ++i) {
            for (int j = i + 1; j < entryList.size(); ++j) {
                Pair<Map.Entry<T, Rectangle2D>> entryPair = new Pair<Map.Entry<T, Rectangle2D>>(entryList.get(i), entryList.get(j));
                Rectangle2D union = ((Rectangle2D)((Map.Entry)entryPair.left).getValue()).createUnion((Rectangle2D)((Map.Entry)entryPair.right).getValue());
                double area = Node.area(union) - Node.area((Rectangle2D)((Map.Entry)entryPair.left).getValue()) - Node.area((Rectangle2D)((Map.Entry)entryPair.right).getValue());
                if (winningPair.isEmpty()) {
                    winningPair = Optional.of(entryPair);
                    largestArea = area;
                    continue;
                }
                if (!(area > largestArea)) continue;
                winningPair = Optional.of(entryPair);
            }
        }
        if (!winningPair.isPresent()) {
            throw new RuntimeException("Winning pair not found");
        }
        Map.Entry leftEntry = (Map.Entry)((Pair)winningPair.get()).left;
        LeafNode leftVertex = LeafNode.create(leftEntry);
        Map.Entry rightEntry = (Map.Entry)((Pair)winningPair.get()).right;
        LeafNode rightVertex = LeafNode.create(rightEntry);
        return Pair.of(leftVertex, rightVertex);
    }

    private void distributeEntry(List<Map.Entry<T, Rectangle2D>> entries, Pair<LeafNode<T>> pickedSeeds) {
        Optional<Map.Entry<T, Rectangle2D>> nextOptional = this.pickNext(entries, pickedSeeds);
        if (nextOptional.isPresent()) {
            double rightEnlargement;
            Map.Entry<T, Rectangle2D> next = nextOptional.get();
            Rectangle2D leftBounds = ((LeafNode)pickedSeeds.left).getBounds();
            Rectangle2D rightBounds = ((LeafNode)pickedSeeds.right).getBounds();
            double leftArea = Node.area(leftBounds);
            double rightArea = Node.area(rightBounds);
            double leftEnlargement = Node.area(leftBounds.createUnion(next.getValue())) - leftArea;
            if (leftEnlargement == (rightEnlargement = Node.area(rightBounds.createUnion(next.getValue())) - rightArea)) {
                if (leftArea == rightArea) {
                    int rightKids;
                    int leftKids = ((LeafNode)pickedSeeds.left).size();
                    if (leftKids < (rightKids = ((LeafNode)pickedSeeds.right).size())) {
                        ((LeafNode)pickedSeeds.left).map.put(next.getKey(), next.getValue());
                    } else {
                        ((LeafNode)pickedSeeds.right).map.put(next.getKey(), next.getValue());
                    }
                } else if (leftArea < rightArea) {
                    ((LeafNode)pickedSeeds.left).map.put(next.getKey(), next.getValue());
                } else {
                    ((LeafNode)pickedSeeds.right).map.put(next.getKey(), next.getValue());
                }
            } else if (leftEnlargement < rightEnlargement) {
                ((LeafNode)pickedSeeds.left).map.put(next.getKey(), next.getValue());
            } else {
                ((LeafNode)pickedSeeds.right).map.put(next.getKey(), next.getValue());
            }
        }
    }

    private Pair<LeafNode<T>> quadraticSplit(Collection<Map.Entry<T, Rectangle2D>> entries, Map.Entry<T, Rectangle2D> newEntry) {
        Pair<LeafNode<T>> pickedSeeds;
        block5: {
            ArrayList<Map.Entry<T, Rectangle2D>> entryList = new ArrayList<Map.Entry<T, Rectangle2D>>(entries);
            entryList.add(newEntry);
            pickedSeeds = this.pickSeeds(entryList);
            while (entryList.size() > 0 && ((LeafNode)pickedSeeds.left).size() < 7 && ((LeafNode)pickedSeeds.right).size() < 7) {
                this.distributeEntry(entryList, pickedSeeds);
            }
            if (entryList.size() <= 0) break block5;
            if (((LeafNode)pickedSeeds.left).size() >= 7) {
                for (Map.Entry entry : entryList) {
                    ((LeafNode)pickedSeeds.right).map.put(entry.getKey(), (Rectangle2D)entry.getValue());
                }
            } else {
                for (Map.Entry entry : entryList) {
                    ((LeafNode)pickedSeeds.left).map.put(entry.getKey(), (Rectangle2D)entry.getValue());
                }
            }
        }
        return pickedSeeds;
    }
}

