/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.OldLanguageFactory;
import ghidra.program.util.TemporaryCompilerSpec;
import ghidra.util.Msg;
import ghidra.util.datastruct.RangeMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class LanguageTranslatorAdapter
implements LanguageTranslator {
    protected static final String DEFAULT_COMPILER_SPEC_ID = "default";
    private final LanguageID oldLanguageID;
    private final LanguageID newLanguageID;
    private final int oldLanguageVersion;
    private final int newLanguageVersion;
    private Language oldLanguage;
    private Language newLanguage;
    private HashMap<String, Register> newRegisterNameMap;
    private HashMap<String, AddressSpace> spaceMap;
    private RangeMap oldRegisterRangeMap;

    protected LanguageTranslatorAdapter(Language oldLanguage, Language newLanguage) {
        this.oldLanguage = oldLanguage;
        this.newLanguage = newLanguage;
        this.oldLanguageID = oldLanguage.getLanguageID();
        this.newLanguageID = newLanguage.getLanguageID();
        this.oldLanguageVersion = oldLanguage.getVersion();
        this.newLanguageVersion = newLanguage.getVersion();
        this.buildRegisterNameMap();
        this.buildRegisterRangeMap();
    }

    protected LanguageTranslatorAdapter(LanguageID oldLanguageID, int oldLanguageVersion, LanguageID newLanguageID, int newLanguageVersion) {
        this.oldLanguageID = oldLanguageID;
        this.oldLanguageVersion = oldLanguageVersion;
        this.newLanguageID = newLanguageID;
        this.newLanguageVersion = newLanguageVersion;
    }

    private void buildRegisterNameMap() {
        this.newRegisterNameMap = new HashMap();
        for (Register r : this.newLanguage.getRegisters()) {
            this.newRegisterNameMap.put(r.getName().toUpperCase(), r);
            for (String alias : r.getAliases()) {
                this.newRegisterNameMap.put(alias.toUpperCase(), r);
            }
        }
    }

    private void buildRegisterRangeMap() {
        this.oldRegisterRangeMap = new RangeMap();
        for (Register reg : this.oldLanguage.getRegisters()) {
            if (!reg.isBaseRegister()) continue;
            long min = reg.getAddress().getOffset();
            long max = min + (long)reg.getMinimumByteSize() - 1L;
            this.oldRegisterRangeMap.paintRange(min, max, (int)min);
        }
    }

    @Override
    public boolean isValid() {
        if (this.oldLanguage == null) {
            this.oldLanguage = LanguageTranslatorAdapter.findLanguage(this.oldLanguageID, this.oldLanguageVersion);
        }
        if (this.newLanguage == null) {
            this.newLanguage = LanguageTranslatorAdapter.findLanguage(this.newLanguageID, this.newLanguageVersion);
        }
        if (this.newRegisterNameMap == null && this.newLanguage != null) {
            this.buildRegisterNameMap();
        }
        if (this.oldRegisterRangeMap == null && this.oldLanguage != null) {
            this.buildRegisterRangeMap();
        }
        return this.oldLanguage != null && this.newLanguage != null;
    }

    private static Language findLanguage(LanguageID languageID, int languageVersion) {
        OldLanguageFactory oldLanguageFactory = OldLanguageFactory.getOldLanguageFactory();
        LanguageService languageService = DefaultLanguageService.getLanguageService();
        Language language = oldLanguageFactory.getOldLanguage(languageID, languageVersion);
        if (language == null) {
            try {
                language = languageService.getLanguage(languageID);
                if (language.getVersion() != languageVersion) {
                    language = null;
                }
            }
            catch (LanguageNotFoundException languageNotFoundException) {
                // empty catch block
            }
        }
        if (language == null) {
            Msg.error(LanguageTranslatorAdapter.class, (Object)("Old language version not found: " + String.valueOf(languageID) + " (Version " + languageVersion + ")"));
        }
        return language;
    }

    protected final void validateDefaultSpaceMap() throws IncompatibleLanguageException {
        if (this.spaceMap != null) {
            return;
        }
        AddressFactory oldFactory = this.oldLanguage.getAddressFactory();
        AddressFactory newFactory = this.newLanguage.getAddressFactory();
        ArrayList<AddressSpace> oldSpaces = new ArrayList<AddressSpace>(Arrays.asList(oldFactory.getAddressSpaces()));
        ArrayList<AddressSpace> newSpaces = new ArrayList<AddressSpace>(Arrays.asList(newFactory.getAddressSpaces()));
        AddressSpace oldDefaultSpace = oldFactory.getDefaultAddressSpace();
        AddressSpace newDefaultSpace = newFactory.getDefaultAddressSpace();
        if (oldDefaultSpace.getSize() > newDefaultSpace.getSize()) {
            throw new IncompatibleLanguageException("Old language has larger default address space (" + oldDefaultSpace.getSize() + "-bit vs. " + newDefaultSpace.getSize() + "-bit) than the new language");
        }
        this.spaceMap = new HashMap();
        this.spaceMap.put(oldDefaultSpace.getName(), newDefaultSpace);
        this.spaceMap.put(oldFactory.getRegisterSpace().getName(), newFactory.getRegisterSpace());
        oldSpaces.remove(oldDefaultSpace);
        newSpaces.remove(newDefaultSpace);
        Iterator<AddressSpace> spaceIt = oldSpaces.iterator();
        while (spaceIt.hasNext()) {
            AddressSpace oldSpace = spaceIt.next();
            if (!oldSpace.isLoadedMemorySpace() || oldSpace.getType() == 2) {
                spaceIt.remove();
                continue;
            }
            AddressSpace newSpace = LanguageTranslatorAdapter.findSpaceSameName(oldSpace, newSpaces);
            if (newSpace == null) continue;
            this.spaceMap.put(oldSpace.getName(), newSpace);
            newSpaces.remove(newSpace);
            spaceIt.remove();
        }
        if (!oldSpaces.isEmpty()) {
            throw new IncompatibleLanguageException("Failed to map one or more address spaces: " + String.valueOf(oldSpaces));
        }
    }

    protected static AddressSpace findSpaceSameName(AddressSpace oldSpace, ArrayList<AddressSpace> newSpaces) throws IncompatibleLanguageException {
        for (AddressSpace space : newSpaces) {
            if (!space.getName().equals(oldSpace.getName())) continue;
            if (oldSpace.getSize() > space.getSize()) {
                throw new IncompatibleLanguageException("Old language space (" + oldSpace.getName() + ") has larger address space than the new language");
            }
            return space;
        }
        return null;
    }

    @Override
    public Language getOldLanguage() {
        if (this.oldLanguage == null) {
            throw new IllegalStateException("Translator has not been validated");
        }
        return this.oldLanguage;
    }

    @Override
    public LanguageID getOldLanguageID() {
        return this.oldLanguageID;
    }

    @Override
    public int getOldVersion() {
        return this.oldLanguageVersion;
    }

    @Override
    public Language getNewLanguage() {
        if (this.newLanguage == null) {
            throw new IllegalStateException("Translator has not been validated");
        }
        return this.newLanguage;
    }

    @Override
    public LanguageID getNewLanguageID() {
        return this.newLanguageID;
    }

    @Override
    public int getNewVersion() {
        return this.newLanguageVersion;
    }

    @Override
    public Register getOldRegister(Address oldAddr, int size) {
        if (this.oldLanguage == null) {
            throw new IllegalStateException("Translator has not been validated");
        }
        return this.oldLanguage.getRegister(oldAddr, size);
    }

    @Override
    public Register getOldRegisterContaining(Address oldAddr) {
        long oldOffset;
        int value = this.oldRegisterRangeMap.getValue(oldAddr.getOffset());
        Register oldReg = this.oldLanguage.getRegister(oldAddr.getNewAddress(value), 0);
        if (value == 0 && oldReg != null && ((oldOffset = oldAddr.getOffset()) < 0L || oldOffset >= (long)(oldReg.getOffset() + oldReg.getMinimumByteSize()))) {
            return null;
        }
        return oldReg;
    }

    @Override
    public Register getOldContextRegister() {
        return this.oldLanguage.getContextBaseRegister();
    }

    @Override
    public Register getNewRegister(Register oldReg) {
        if (this.newRegisterNameMap == null) {
            throw new IllegalStateException("Translator has not been validated");
        }
        return this.newRegisterNameMap.get(oldReg.getName().toUpperCase());
    }

    @Override
    public Register getNewContextRegister() {
        return this.newLanguage.getContextBaseRegister();
    }

    @Override
    public AddressSpace getNewAddressSpace(String oldSpaceName) {
        if (this.spaceMap == null) {
            throw new IllegalStateException("Address space map has not been validated");
        }
        return this.spaceMap.get(oldSpaceName);
    }

    @Override
    public boolean isValueTranslationRequired(Register oldReg) {
        Register newReg = this.getNewRegister(oldReg);
        if (newReg == null || !oldReg.isBaseRegister()) {
            return false;
        }
        return !this.isSameRegisterConstruction(oldReg, newReg);
    }

    protected boolean isSameRegisterConstruction(Register oldReg, Register newReg) {
        if (oldReg.getLeastSignificantBitInBaseRegister() != newReg.getLeastSignificantBitInBaseRegister() || oldReg.getBitLength() != newReg.getBitLength()) {
            return false;
        }
        List<Register> oldChildren = oldReg.getChildRegisters();
        for (Register oldChild : oldChildren) {
            Register newChild = this.getNewRegister(oldChild);
            if (newChild != null && this.isSameRegisterConstruction(oldChild, newChild)) continue;
            return false;
        }
        return true;
    }

    private RegisterValue translateContextValue(Register newReg, RegisterValue oldValue) {
        Register reg = oldValue.getRegister();
        if (!reg.hasChildren()) {
            if (!oldValue.hasValue()) {
                return null;
            }
            return new RegisterValue(newReg, oldValue.getUnsignedValueIgnoreMask());
        }
        RegisterValue value = null;
        for (Register child : reg.getChildRegisters()) {
            RegisterValue childValue;
            RegisterValue oldChildValue = new RegisterValue(child, oldValue.toBytes());
            Register newChild = this.newLanguage.getRegister(child.getName());
            if (newChild != null && newChild.getParentRegister() == newReg) {
                childValue = this.translateContextValue(newChild, oldChildValue);
                if (childValue == null) continue;
                value = childValue.combineValues(value);
                continue;
            }
            newChild = this.newRegisterNameMap.get(child.getName());
            if (newChild == null || newChild.getParentRegister() != newReg || (childValue = this.translateContextValue(newChild, oldChildValue)) == null) continue;
            value = childValue.combineValues(value);
        }
        return value;
    }

    @Override
    public RegisterValue getNewRegisterValue(RegisterValue oldValue) {
        Register oldReg = oldValue.getRegister();
        if (!oldReg.isBaseRegister()) {
            throw new IllegalArgumentException("oldValue must correspond to an old base register");
        }
        Register newReg = this.getNewRegister(oldReg);
        if (newReg == null) {
            return null;
        }
        if (newReg.isProcessorContext()) {
            return this.translateContextValue(newReg, oldValue);
        }
        return new RegisterValue(newReg, oldValue.toBytes());
    }

    public String toString() {
        return "[" + String.valueOf(this.getOldLanguageID()) + " (Version " + this.getOldVersion() + ")] -> [" + String.valueOf(this.getNewLanguageID()) + " (Version " + this.getNewVersion() + " )] {" + this.getClass().getName() + "}";
    }

    @Override
    public CompilerSpecID getNewCompilerSpecID(CompilerSpecID oldCompilerSpecID) {
        Language newLang = this.getNewLanguage();
        List<CompilerSpecDescription> compilerSpecDescriptions = newLang.getCompatibleCompilerSpecDescriptions();
        for (CompilerSpecDescription descr : compilerSpecDescriptions) {
            if (!descr.getCompilerSpecID().equals(oldCompilerSpecID)) continue;
            return oldCompilerSpecID;
        }
        if (compilerSpecDescriptions.size() != 0) {
            return compilerSpecDescriptions.get(0).getCompilerSpecID();
        }
        return oldCompilerSpecID;
    }

    @Override
    public CompilerSpec getOldCompilerSpec(CompilerSpecID oldCompilerSpecID) throws CompilerSpecNotFoundException {
        return new TemporaryCompilerSpec(this, oldCompilerSpecID);
    }

    @Override
    public void fixupInstructions(Program program, Language oldLanguage, TaskMonitor monitor) throws Exception, CancelledException {
    }

    public static LanguageTranslator getDefaultLanguageTranslator(Language oldLanguage, Language newLanguage) {
        DefaultLanguageTranslator translator = new DefaultLanguageTranslator(oldLanguage, newLanguage);
        if (!translator.isValid()) {
            translator = null;
        }
        return translator;
    }

    static LanguageTranslator getDefaultLanguageTranslator(LanguageID languageID, int fromVersion, int toVersion) {
        Language toLanguage = LanguageTranslatorAdapter.findLanguage(languageID, toVersion);
        Language fromLanguage = LanguageTranslatorAdapter.findLanguage(languageID, fromVersion);
        if (toLanguage == null || fromLanguage == null) {
            return null;
        }
        return LanguageTranslatorAdapter.getDefaultLanguageTranslator(fromLanguage, toLanguage);
    }

    private static class DefaultLanguageTranslator
    extends LanguageTranslatorAdapter {
        DefaultLanguageTranslator(Language oldLanguage, Language newLanguage) {
            super(oldLanguage, newLanguage);
        }

        @Override
        public boolean isValid() {
            if (super.isValid()) {
                Register oldContextReg;
                try {
                    this.validateDefaultSpaceMap();
                }
                catch (IncompatibleLanguageException e) {
                    Msg.error((Object)this, (Object)("Translator can not map address spaces: " + String.valueOf(this)));
                    return false;
                }
                Register newContextReg = this.getNewLanguage().getContextBaseRegister();
                if (!(newContextReg == Register.NO_CONTEXT || (oldContextReg = this.getOldLanguage().getContextBaseRegister()) != Register.NO_CONTEXT && this.isSameRegisterConstruction(oldContextReg, newContextReg))) {
                    Msg.error((Object)this, (Object)("Translator can not map context register: " + String.valueOf(this)));
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return "[" + String.valueOf(this.getOldLanguageID()) + " (Version " + this.getOldVersion() + ")] -> [" + String.valueOf(this.getNewLanguageID()) + " (Version " + this.getNewVersion() + ")] {Default Translator}";
        }
    }
}

