/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import org.apache.commons.lang3.StringUtils;

public enum Endian {
    BIG("big", "BE"),
    LITTLE("little", "LE");

    private final String name;
    private final String shortName;

    private Endian(String name, String shortName) {
        this.name = name;
        this.shortName = shortName;
    }

    public static Endian toEndian(String endianness) {
        if (endianness != null) {
            if (BIG.toString().equalsIgnoreCase(endianness) || BIG.toShortString().equalsIgnoreCase(endianness)) {
                return BIG;
            }
            if (LITTLE.toString().equalsIgnoreCase(endianness) || LITTLE.toShortString().equalsIgnoreCase(endianness)) {
                return LITTLE;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String toShortString() {
        return this.shortName;
    }

    public boolean isBigEndian() {
        return this == BIG;
    }

    public String getDisplayName() {
        return StringUtils.capitalize((String)this.name);
    }
}

