/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBListener;
import db.DBRecord;
import db.Field;
import db.KeyToRecordIterator;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.sourcemap.SourceMapAdapter;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class SourceMapAdapterV0
extends SourceMapAdapter
implements DBListener {
    static final int SCHEMA_VERSION = 0;
    static final int V0_FILE_LINE_COL = 0;
    static final int V0_BASE_ADDR_COL = 1;
    static final int V0_LENGTH_COL = 2;
    private static final Schema V0_SCHEMA = new Schema(0, "ID", new Field[]{LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE}, new String[]{"fileAndLine", "baseAddress", "length"}, null);
    private static final int[] INDEXED_COLUMNS = new int[]{0, 1};
    private Table table;
    private final DBHandle dbHandle;
    private AddressMapDB addrMap;

    SourceMapAdapterV0(DBHandle dbh, AddressMapDB addrMap, OpenMode openMode) throws VersionException {
        this.dbHandle = dbh;
        this.addrMap = addrMap;
        this.dbHandle.addListener((DBListener)this);
        if (!openMode.equals((Object)OpenMode.CREATE)) {
            this.table = this.dbHandle.getTable("SourceMap");
            if (this.table == null) {
                return;
            }
            int version = this.table.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    public void dbRestored(DBHandle dbh) {
        this.table = dbh.getTable("SourceMap");
    }

    public void dbClosed(DBHandle dbh) {
    }

    public void tableDeleted(DBHandle dbh, Table t) {
    }

    public void tableAdded(DBHandle dbh, Table t) {
    }

    @Override
    boolean removeRecord(long key) throws IOException {
        if (this.table != null) {
            return this.table.deleteRecord(key);
        }
        return false;
    }

    @Override
    RecordIterator getSourceMapRecordIterator(Address addr, boolean before) throws IOException {
        if (this.table == null || addr == null) {
            return EmptyRecordIterator.INSTANCE;
        }
        AddressIndexPrimaryKeyIterator keyIter = new AddressIndexPrimaryKeyIterator(this.table, 1, (AddressMap)this.addrMap, addr, before);
        return new KeyToRecordIterator(this.table, (DBFieldIterator)keyIter);
    }

    @Override
    RecordIterator getRecordsForSourceFile(long fileId, int minLine, int maxLine) throws IOException {
        if (this.table == null) {
            return EmptyRecordIterator.INSTANCE;
        }
        LongField minField = new LongField((fileId <<= 32) | (long)minLine);
        LongField maxField = new LongField(fileId | (long)maxLine);
        return this.table.indexIterator(0, (Field)minField, (Field)maxField, true);
    }

    @Override
    DBRecord addMapEntry(long fileId, int lineNum, Address baseAddr, long length) throws IOException {
        DBRecord rec = V0_SCHEMA.createRecord(this.getTable().getKey());
        rec.setLongValue(0, fileId << 32 | (long)lineNum);
        rec.setLongValue(1, this.addrMap.getKey(baseAddr, true));
        rec.setLongValue(2, length);
        this.table.putRecord(rec);
        return rec;
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        if (this.table == null) {
            return;
        }
        DatabaseTableUtils.updateIndexedAddressField(this.table, 1, this.addrMap, fromAddr, toAddr, length, null, monitor);
    }

    private Table getTable() throws IOException {
        if (this.table == null) {
            this.table = this.dbHandle.createTable("SourceMap", V0_SCHEMA, INDEXED_COLUMNS);
        }
        return this.table;
    }
}

