/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.ios.dmg.DmgConstants;
import ghidra.file.formats.ios.dmg.DmgHeader;
import ghidra.file.formats.ios.dmg.DmgHeaderV2;
import ghidra.file.formats.ios.dmg.DmgUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;

public class DmgAnalyzer
extends FileFormatAnalyzer
implements AnalysisWorker {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, false, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        Address address = program.getMinAddress();
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, false);
        DmgHeaderV2 header = new DmgHeaderV2(reader);
        if (!Arrays.equals(((DmgHeader)header).getSignature(), DmgConstants.DMG_MAGIC_BYTES_v2)) {
            return false;
        }
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, address, headerDataType);
        this.createFragment(program, headerDataType.getName(), headerData.getMinAddress(), headerData.getMaxAddress().add(1L));
        return true;
    }

    public String getWorkerName() {
        return this.getName();
    }

    public boolean canAnalyze(Program program) {
        return DmgUtil.isDMG(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return DmgUtil.isDMG(program);
    }

    public String getDescription() {
        return "Annotates an DMG file.";
    }

    public String getName() {
        return "DMG";
    }

    public boolean isPrototype() {
        return true;
    }
}

