/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cramfs.CramFsBlock;
import ghidra.file.formats.cramfs.CramFsBlockFactory;
import ghidra.file.formats.cramfs.CramFsBlockReader;
import ghidra.file.formats.cramfs.CramFsInode;
import ghidra.file.formats.zlib.ZLIB;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class CramFsInputStream
extends InputStream {
    private CramFsInode iNode;
    private List<Integer> blockPointerList = new ArrayList<Integer>();
    private List<CramFsBlock> blockList;
    private List<ByteArrayOutputStream> decompressedBlockStreams = new ArrayList<ByteArrayOutputStream>();
    private List<Byte> decompressedOutputList = new ArrayList<Byte>();
    private ZLIB zlib = new ZLIB();
    private ByteProvider byteProvider;
    private CramFsBlockReader cramfsBlockReader;
    private int defaultBlockSize;
    private int currentByte = 0;
    private boolean blockExtensionEnabled;

    public CramFsInputStream(ByteProvider byteProvider, CramFsInode iNode, boolean blockExtensionEnabled) throws IOException {
        this.iNode = iNode;
        this.byteProvider = byteProvider;
        this.blockExtensionEnabled = blockExtensionEnabled;
        this.defaultBlockSize = 4096;
        this.blockList = this.getDataBlocks();
        this.decompressAllBlocks();
        this.combineDecompressedBlockStreams();
    }

    private List<CramFsBlock> getDataBlocks() {
        CramFsBlockFactory blockFactory = new CramFsBlockFactory(this.iNode, this.byteProvider, this.blockPointerList, this.blockExtensionEnabled);
        return blockFactory.produceBlocks();
    }

    public List<CramFsBlock> getBlockList() {
        return this.blockList;
    }

    private void decompressAllBlocks() throws IOException {
        for (int i = 0; i < this.cramfsBlockReader.getNumBlockPointers() - 1; ++i) {
            ByteArrayInputStream compressedIn = new ByteArrayInputStream(this.cramfsBlockReader.readDataBlock(i));
            this.decompressedBlockStreams.add(this.zlib.decompress(compressedIn, 4096));
        }
    }

    private void combineDecompressedBlockStreams() {
        for (int i = 0; i < this.decompressedBlockStreams.size(); ++i) {
            byte[] bytes = this.decompressedBlockStreams.get(i).toByteArray();
            List<Byte> bytesList = Arrays.asList(ArrayUtils.toObject((byte[])bytes));
            this.decompressedOutputList.addAll(bytesList);
        }
    }

    public ByteArrayOutputStream decompressBlock(int blockIndex) throws IOException {
        ByteArrayInputStream compressedIn = new ByteArrayInputStream(this.blockList.get(blockIndex).readBlock());
        return this.zlib.decompress(compressedIn, this.defaultBlockSize);
    }

    @Override
    public int read() throws IOException {
        if (this.currentByte < this.decompressedOutputList.size()) {
            byte readByte = this.decompressedOutputList.get(this.currentByte);
            ++this.currentByte;
            return Byte.toUnsignedInt(readByte);
        }
        return -1;
    }
}

