/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.utils.CommonUtils;

public class SQLResultsEditorInput
implements IEditorInput {
    private final IResultSetContainer container;

    public SQLResultsEditorInput(@NotNull IResultSetContainer container) {
        this.container = container;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.RS_GRID);
    }

    public String getName() {
        DBSDataContainer dataContainer = this.container.getDataContainer();
        if (dataContainer == null) {
            return "Data";
        }
        return CommonUtils.getSingleLineString((String)dataContainer.getName());
    }

    public String getToolTipText() {
        DBSDataContainer dataContainer = this.container.getDataContainer();
        if (dataContainer == null) {
            return "Data";
        }
        return dataContainer.getDescription();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.container)) {
            return adapter.cast(this.container);
        }
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean exists() {
        return false;
    }

    @NotNull
    public IResultSetContainer getContainer() {
        return this.container;
    }
}

